/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.PixmapPacker;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.util.Disposable;

public class MultiPacker
implements Disposable {
    private PixmapPacker[] packers = new PixmapPacker[PageType.all.length];

    public MultiPacker() {
        for (int i = 0; i < this.packers.length; ++i) {
            int pageSize = 2048;
            this.packers[i] = new PixmapPacker(pageSize, pageSize, Pixmap.Format.rgba8888, 2, true);
        }
    }

    public boolean has(PageType type, String name) {
        return this.packers[type.ordinal()].getRect(name) != null;
    }

    public void add(PageType type, String name, PixmapRegion region) {
        this.packers[type.ordinal()].pack(name, region);
    }

    public void add(PageType type, String name, Pixmap pix) {
        this.packers[type.ordinal()].pack(name, pix);
    }

    public TextureAtlas flush(Texture.TextureFilter filter, TextureAtlas atlas) {
        for (PixmapPacker p : this.packers) {
            p.updateTextureAtlas(atlas, filter, filter, false, false);
        }
        return atlas;
    }

    @Override
    public void dispose() {
        for (PixmapPacker packer : this.packers) {
            packer.dispose();
        }
    }

    public static enum PageType {
        main,
        environment,
        editor,
        ui;

        public static final PageType[] all;

        static {
            all = PageType.values();
        }
    }
}

