/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.ui.Cicon;
import mindustry.world.Tile;

public class OverlayRenderer {
    private static final float indicatorLength = 14.0f;
    private static final float spawnerMargin = 88.0f;
    private static final Rect rect = new Rect();
    private float buildFade;
    private float unitFade;
    private Unit lastSelect;

    public void drawBottom() {
        InputHandler input = Vars.control.input;
        if (Vars.player.dead()) {
            return;
        }
        if (Vars.player.isBuilder()) {
            Vars.player.unit().drawBuildPlans();
        }
        input.drawBottom();
    }

    public void drawTop() {
        Object build;
        LogicAI ai;
        Unit unit2;
        if (!Vars.player.dead() && Vars.ui.hudfrag.shown) {
            if (Core.settings.getBool("playerindicators")) {
                for (Player player : Groups.player) {
                    if (Vars.player == player || Vars.player.team() != player.team() || rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(player.x, player.y)) continue;
                    Tmp.v1.set(player).sub(Vars.player).setLength(14.0f);
                    Lines.stroke(2.0f, Vars.player.team().color);
                    Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 4.0f);
                    Draw.reset();
                }
            }
            if (Core.settings.getBool("indicators")) {
                Groups.unit.each(unit -> {
                    if (!unit.isLocal() && unit.team != Vars.player.team() && !rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(unit.x, unit.y)) {
                        Tmp.v1.set(unit.x, unit.y).sub(Vars.player).setLength(14.0f);
                        Lines.stroke(1.0f, unit.team().color);
                        Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 3.0f);
                        Draw.reset();
                    }
                });
            }
        }
        if (Vars.player.dead()) {
            return;
        }
        InputHandler input = Vars.control.input;
        Unit select = input.selectedUnit();
        if (!Core.input.keyDown(Binding.control)) {
            select = null;
        }
        this.unitFade = Mathf.lerpDelta(this.unitFade, Mathf.num(select != null), 0.1f);
        if (select != null) {
            this.lastSelect = select;
        }
        if (select == null) {
            select = this.lastSelect;
        }
        if (select != null && select.isAI()) {
            Draw.mixcol(Pal.accent, 1.0f);
            Draw.alpha(this.unitFade);
            if (select instanceof BlockUnitc) {
                Fill.square(select.x, select.y, (float)(((BlockUnitc)((Object)select)).tile().block.size * 8) / 2.0f);
            } else {
                Draw.rect(select.type.icon(Cicon.full), select.x(), select.y(), select.rotation() - 90.0f);
            }
            for (int i = 0; i < 4; ++i) {
                float rot = (float)i * 90.0f + 45.0f + -Time.time % 360.0f;
                float length = select.hitSize() * 1.5f + this.unitFade * 2.5f;
                Draw.rect("select-arrow", select.x + Angles.trnsx(rot, length), select.y + Angles.trnsy(rot, length), length / 1.9f, length / 1.9f, rot - 135.0f);
            }
            Draw.reset();
        }
        if (input.frag.config.isShown()) {
            Building tile = input.frag.config.getSelectedTile();
            tile.drawConfigure();
        }
        input.drawTop();
        this.buildFade = Mathf.lerpDelta(this.buildFade, input.isPlacing() || input.isUsingSchematic() ? 1.0f : 0.0f, 0.06f);
        Draw.reset();
        Lines.stroke(this.buildFade * 2.0f);
        if (this.buildFade > 0.005f) {
            Vars.state.teams.eachEnemyCore(Vars.player.team(), core -> {
                float dst = core.dst(Vars.player);
                if (dst < Vars.state.rules.enemyCoreBuildRadius * 2.2f) {
                    Draw.color(Color.darkGray);
                    Lines.circle(core.x, core.y - 2.0f, Vars.state.rules.enemyCoreBuildRadius);
                    Draw.color(Pal.accent, core.team.color, 0.5f + Mathf.absin(Time.time, 10.0f, 0.5f));
                    Lines.circle(core.x, core.y, Vars.state.rules.enemyCoreBuildRadius);
                }
            });
        }
        Lines.stroke(2.0f);
        Draw.color(Color.gray, Color.lightGray, Mathf.absin(Time.time, 8.0f, 1.0f));
        if (Vars.state.hasSpawns()) {
            for (Tile tile : Vars.spawner.getSpawns()) {
                if (!tile.within(Vars.player.x, Vars.player.y, Vars.state.rules.dropZoneRadius + 88.0f)) continue;
                Draw.alpha(Mathf.clamp(1.0f - (Vars.player.dst(tile) - Vars.state.rules.dropZoneRadius) / 88.0f));
                Lines.dashCircle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
            }
        }
        Draw.reset();
        if (input.block == null && !Core.scene.hasMouse()) {
            Vec2 vec = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            Building build2 = Vars.world.buildWorld(vec.x, vec.y);
            if (build2 != null && build2.team == Vars.player.team()) {
                build2.drawSelect();
                if (!build2.enabled && build2.block.drawDisabled) {
                    build2.drawDisabled();
                }
                if (Core.input.keyDown(Binding.rotateplaced) && build2.block.rotate && build2.block.quickRotate && build2.interactable(Vars.player.team())) {
                    Vars.control.input.drawArrow(build2.block, build2.tileX(), build2.tileY(), build2.rotation, true);
                    Draw.color(Pal.accent, 0.3f + Mathf.absin(4.0f, 0.2f));
                    Fill.square(build2.x, build2.y, (float)(build2.block.size * 8) / 2.0f);
                    Draw.color();
                }
            }
        }
        input.drawOverSelect();
        Object object = Vars.ui.hudfrag.blockfrag.hover();
        if (object instanceof Unit && (unit2 = (Unit)object) == (Unit)object && (object = unit2.controller()) instanceof LogicAI && (ai = (LogicAI)object) == (LogicAI)object && (object = ai.controller) instanceof Building && (build = object) == object && ((Building)build).isValid()) {
            Drawf.square(((Building)build).x, ((Building)build).y, (float)(((Building)build).block.size * 8) / 2.0f + 2.0f);
            if (!unit2.within((Position)build, unit2.hitSize * 2.0f)) {
                Drawf.arrow(unit2.x, unit2.y, ((Building)build).x, ((Building)build).y, unit2.hitSize * 2.0f, 4.0f);
            }
        }
        if (input.isDroppingItem()) {
            Vec2 v = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            float size = 8.0f;
            Draw.rect(Vars.player.unit().item().icon(Cicon.medium), v.x, v.y, size, size);
            Draw.color(Pal.accent);
            Lines.circle(v.x, v.y, 6.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
            Draw.reset();
            Building tile = Vars.world.buildWorld(v.x, v.y);
            if (input.canDropItem() && tile != null && tile.interactable(Vars.player.team()) && tile.acceptStack(Vars.player.unit().item(), Vars.player.unit().stack.amount, Vars.player.unit()) > 0 && Vars.player.within(tile, 220.0f)) {
                Lines.stroke(3.0f, Pal.gray);
                Lines.square(tile.x, tile.y, (float)(tile.block.size * 8) / 2.0f + 3.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
                Lines.stroke(1.0f, Pal.place);
                Lines.square(tile.x, tile.y, (float)(tile.block.size * 8) / 2.0f + 2.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
                Draw.reset();
            }
        }
    }
}

