/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.noise.Simplex;

public class ScorchGenerator {
    private static final Simplex sim = new Simplex();
    public int size = 80;
    public int seed = 0;
    public int color = Color.white.rgba();
    public double scale = 18.0;
    public double pow = 2.0;
    public double octaves = 4.0;
    public double pers = 0.4;
    public double add = 2.0;
    public double nscl = 4.5;

    public Pixmap generate() {
        Pixmap pix = new Pixmap(this.size, this.size);
        sim.setSeed(this.seed);
        pix.each((x, y) -> {
            double dst = Mathf.dst(x, y, this.size / 2, this.size / 2) / ((float)this.size / 2.0f);
            double scaled = Math.abs(dst - 0.5) * 5.0 + this.add;
            if ((scaled -= this.noise(Angles.angle(x, y, this.size / 2, this.size / 2)) * this.nscl) < 1.5) {
                pix.draw(x, y, this.color);
            }
        });
        return pix;
    }

    private double noise(float angle) {
        return Math.pow(sim.octaveNoise2D(this.octaves, this.pers, 1.0 / this.scale, Angles.trnsx(angle, (float)this.size / 2.0f) + (float)this.size / 2.0f, Angles.trnsy(angle, (float)this.size / 2.0f) + (float)this.size / 2.0f), this.pow);
    }
}

