/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.g3d.Camera3D;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.scene.ui.layout.Scl;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.type.Planet;

public class Shaders {
    public static BlockBuildShader blockbuild;
    @Nullable
    public static ShieldShader shield;
    public static BuildBeamShader buildBeam;
    public static UnitBuildShader build;
    public static DarknessShader darkness;
    public static LightShader light;
    public static SurfaceShader water;
    public static SurfaceShader mud;
    public static SurfaceShader tar;
    public static SurfaceShader slag;
    public static SurfaceShader space;
    public static PlanetShader planet;
    public static PlanetGridShader planetGrid;
    public static AtmosphereShader atmosphere;
    public static MeshShader mesh;
    public static Shader unlit;
    public static Shader screenspace;

    public static void init() {
        mesh = new MeshShader();
        blockbuild = new BlockBuildShader();
        try {
            shield = new ShieldShader();
        }
        catch (Throwable t) {
            shield = null;
            t.printStackTrace();
        }
        buildBeam = new BuildBeamShader();
        build = new UnitBuildShader();
        darkness = new DarknessShader();
        light = new LightShader();
        water = new SurfaceShader("water");
        mud = new SurfaceShader("mud");
        tar = new SurfaceShader("tar");
        slag = new SurfaceShader("slag");
        space = new SpaceShader("space");
        planet = new PlanetShader();
        planetGrid = new PlanetGridShader();
        atmosphere = new AtmosphereShader();
        unlit = new LoadShader("planet", "unlit");
        screenspace = new LoadShader("screenspace", "screenspace");
    }

    public static Fi getShaderFi(String file) {
        return Core.files.internal("shaders/" + file);
    }

    public static class MeshShader
    extends LoadShader {
        public MeshShader() {
            super("planet", "mesh");
        }
    }

    public static class BlockBuildShader
    extends LoadShader {
        public float progress;
        public TextureRegion region = new TextureRegion();

        public BlockBuildShader() {
            super("blockbuild", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_time", Time.time);
            this.setUniformf("u_texsize", (float)this.region.texture.width, (float)this.region.texture.height);
        }
    }

    public static class ShieldShader
    extends LoadShader {
        public ShieldShader() {
            super("shield", "screenspace");
        }

        @Override
        public void apply() {
            this.setUniformf("u_dp", Scl.scl(1.0f));
            this.setUniformf("u_time", Time.time / Scl.scl(1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
        }
    }

    public static class BuildBeamShader
    extends LoadShader {
        public BuildBeamShader() {
            super("buildbeam", "screenspace");
        }

        @Override
        public void apply() {
            this.setUniformf("u_dp", Scl.scl(1.0f));
            this.setUniformf("u_time", Time.time / Scl.scl(1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
        }
    }

    public static class UnitBuildShader
    extends LoadShader {
        public float progress;
        public float time;
        public Color color = new Color();
        public TextureRegion region;

        public UnitBuildShader() {
            super("unitbuild", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_texsize", (float)this.region.texture.width, (float)this.region.texture.height);
        }
    }

    public static class DarknessShader
    extends LoadShader {
        public DarknessShader() {
            super("darkness", "default");
        }
    }

    public static class LightShader
    extends LoadShader {
        public Color ambient = new Color(0.01f, 0.01f, 0.04f, 0.99f);

        public LightShader() {
            super("light", "screenspace");
        }

        @Override
        public void apply() {
            this.setUniformf("u_ambient", this.ambient);
        }
    }

    public static class SurfaceShader
    extends Shader {
        public SurfaceShader(String frag) {
            super(Shaders.getShaderFi("screenspace.vert"), Shaders.getShaderFi(frag + ".frag"));
            this.loadNoise();
        }

        public SurfaceShader(String vertRaw, String fragRaw) {
            super(vertRaw, fragRaw);
            this.loadNoise();
        }

        public void loadNoise() {
            Core.assets.load((String)"sprites/noise.png", Texture.class).loaded = t -> {
                ((Texture)t).setFilter(Texture.TextureFilter.linear);
                ((Texture)t).setWrap(Texture.TextureWrap.repeat);
            };
        }

        @Override
        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformf("u_time", Time.time);
            if (this.hasUniform("u_noise")) {
                Core.assets.get("sprites/noise.png", Texture.class).bind(1);
                ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                this.setUniformi("u_noise", 1);
            }
        }
    }

    public static class SpaceShader
    extends SurfaceShader {
        Texture texture;

        public SpaceShader(String frag) {
            super(frag);
            Core.assets.load((String)"sprites/space.png", Texture.class).loaded = t -> {
                this.texture = (Texture)t;
                this.texture.setFilter(Texture.TextureFilter.linear);
                this.texture.setWrap(Texture.TextureWrap.mirroredRepeat);
            };
        }

        @Override
        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x, Core.camera.position.y);
            this.setUniformf("u_ccampos", Core.camera.position);
            this.setUniformf("u_resolution", (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            this.setUniformf("u_time", Time.time);
            this.texture.bind(1);
            ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
            this.setUniformi("u_stars", 1);
        }
    }

    public static class PlanetShader
    extends LoadShader {
        public Vec3 lightDir = new Vec3(1.0f, 1.0f, 1.0f).nor();
        public Color ambientColor = Color.white.cpy();
        public Vec3 camDir = new Vec3();

        public PlanetShader() {
            super("planet", "planet");
        }

        @Override
        public void apply() {
            this.camDir.set(Vars.renderer.planets.cam.direction).rotate(Vec3.Y, Vars.renderer.planets.planet.getRotation());
            this.setUniformf("u_lightdir", this.lightDir);
            this.setUniformf("u_ambientColor", this.ambientColor.r, this.ambientColor.g, this.ambientColor.b);
            this.setUniformf("u_camdir", this.camDir);
        }
    }

    public static class PlanetGridShader
    extends LoadShader {
        public Vec3 mouse = new Vec3();

        public PlanetGridShader() {
            super("planetgrid", "planetgrid");
        }

        @Override
        public void apply() {
            this.setUniformf("u_mouse", this.mouse);
        }
    }

    public static class AtmosphereShader
    extends LoadShader {
        public Camera3D camera;
        public Planet planet;
        Mat3D mat = new Mat3D();

        public AtmosphereShader() {
            super("atmosphere", "atmosphere");
        }

        @Override
        public void apply() {
            this.setUniformf("u_resolution", (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            this.setUniformf("u_time", Time.globalTime / 10.0f);
            this.setUniformf("u_campos", this.camera.position);
            this.setUniformf("u_rcampos", Tmp.v31.set(this.camera.position).sub(this.planet.position));
            this.setUniformf("u_light", this.planet.getLightNormal());
            this.setUniformf("u_color", this.planet.atmosphereColor.r, this.planet.atmosphereColor.g, this.planet.atmosphereColor.b);
            this.setUniformf("u_innerRadius", this.planet.radius + this.planet.atmosphereRadIn);
            this.setUniformf("u_outerRadius", this.planet.radius + this.planet.atmosphereRadOut);
            this.setUniformMatrix4("u_model", this.planet.getTransform((Mat3D)this.mat).val);
            this.setUniformMatrix4("u_projection", this.camera.combined.val);
            this.setUniformMatrix4("u_invproj", this.camera.invProjectionView.val);
        }
    }

    public static class LoadShader
    extends Shader {
        public LoadShader(String frag, String vert) {
            super(Shaders.getShaderFi(vert + ".vert"), Shaders.getShaderFi(frag + ".frag"));
        }
    }

    @Deprecated
    public static class UnitBuild
    extends UnitBuildShader {
    }
}

