/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.pooling.Pools;

public class Trail {
    public int length;
    private final Seq<Vec3> points;
    private float lastX = -1.0f;
    private float lastY = -1.0f;

    public Trail(int length) {
        this.length = length;
        this.points = new Seq(length);
    }

    public void clear() {
        this.points.clear();
    }

    public void draw(Color color, float width) {
        Draw.color(color);
        for (int i = 0; i < this.points.size - 1; ++i) {
            Vec3 c = this.points.get(i);
            Vec3 n = this.points.get(i + 1);
            float size = width / (float)this.length;
            float cx = Mathf.sin(c.z) * (float)i * size;
            float cy = Mathf.cos(c.z) * (float)i * size;
            float nx = Mathf.sin(n.z) * (float)(i + 1) * size;
            float ny = Mathf.cos(n.z) * (float)(i + 1) * size;
            Fill.quad(c.x - cx, c.y - cy, c.x + cx, c.y + cy, n.x + nx, n.y + ny, n.x - nx, n.y - ny);
        }
        Draw.reset();
    }

    public void update(float x, float y) {
        if (this.points.size > this.length) {
            Pools.free(this.points.first());
            this.points.remove(0);
        }
        float angle = -Angles.angle(x, y, this.lastX, this.lastY);
        this.points.add(Pools.obtain(Vec3.class, Vec3::new).set(x, y, angle * ((float)Math.PI / 180)));
        this.lastX = x;
        this.lastY = y;
    }
}

