/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.Color;
import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.math.geom.Icosphere;
import arc.math.geom.MeshResult;
import arc.math.geom.Vec3;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.PlanetGrid;

public class MeshBuilder {
    private static final Vec3 v1 = new Vec3();
    private static final Vec3 v2 = new Vec3();
    private static final Vec3 v3 = new Vec3();
    private static final Vec3 v4 = new Vec3();
    private static final float[] floats = new float[7];
    private static Mesh mesh;

    public static Mesh buildIcosphere(int divisions, float radius, Color color) {
        MeshBuilder.begin(20 * (2 << 2 * divisions - 1) * 7 * 3);
        MeshResult result = Icosphere.create(divisions);
        for (int i = 0; i < result.indices.size; i += 3) {
            v1.set(result.vertices.items, result.indices.items[i] * 3).setLength(radius);
            v2.set(result.vertices.items, result.indices.items[i + 1] * 3).setLength(radius);
            v3.set(result.vertices.items, result.indices.items[i + 2] * 3).setLength(radius);
            MeshBuilder.verts(v1, v3, v2, MeshBuilder.normal(v1, v2, v3).scl(-1.0f), color);
        }
        return MeshBuilder.end();
    }

    public static Mesh buildIcosphere(int divisions, float radius) {
        return MeshBuilder.buildIcosphere(divisions, radius, Color.white);
    }

    public static Mesh buildHex(final Color color, int divisions, boolean lines, float radius) {
        return MeshBuilder.buildHex(new HexMesher(){

            @Override
            public float getHeight(Vec3 position) {
                return 0.0f;
            }

            @Override
            public Color getColor(Vec3 position) {
                return color;
            }
        }, divisions, lines, radius, 0.0f);
    }

    public static Mesh buildHex(HexMesher mesher, int divisions, boolean lines, float radius, float intensity) {
        PlanetGrid grid = PlanetGrid.create(divisions);
        MeshBuilder.begin(grid.tiles.length * 12 * 7);
        for (PlanetGrid.Ptile tile : grid.tiles) {
            PlanetGrid.Corner[] c;
            for (PlanetGrid.Corner corner : c = tile.corners) {
                corner.v.setLength((1.0f + mesher.getHeight(v2.set(corner.v)) * intensity) * radius);
            }
            Vec3 nor = MeshBuilder.normal(c[0].v, c[2].v, c[4].v);
            Color color = mesher.getColor(v2.set(tile.v));
            if (lines) {
                nor.set(1.0f, 1.0f, 1.0f);
                for (int i = 0; i < c.length; ++i) {
                    Vec3 v1 = c[i].v;
                    Vec3 v2 = c[(i + 1) % c.length].v;
                    MeshBuilder.vert(v1, nor, color);
                    MeshBuilder.vert(v2, nor, color);
                }
            } else {
                MeshBuilder.verts(c[0].v, c[1].v, c[2].v, nor, color);
                MeshBuilder.verts(c[0].v, c[2].v, c[3].v, nor, color);
                MeshBuilder.verts(c[0].v, c[3].v, c[4].v, nor, color);
                if (c.length > 5) {
                    MeshBuilder.verts(c[0].v, c[4].v, c[5].v, nor, color);
                }
            }
            for (PlanetGrid.Corner corner : c) {
                corner.v.nor();
            }
        }
        return MeshBuilder.end();
    }

    private static void begin(int count) {
        mesh = new Mesh(true, count, 0, VertexAttribute.position3, VertexAttribute.normal, VertexAttribute.color);
        mesh.getVerticesBuffer().limit(mesh.getMaxVertices());
        mesh.getVerticesBuffer().position(0);
    }

    private static Mesh end() {
        Mesh last = mesh;
        last.getVerticesBuffer().limit(last.getVerticesBuffer().position());
        mesh = null;
        return last;
    }

    private static Vec3 normal(Vec3 v1, Vec3 v2, Vec3 v3) {
        return v4.set(v2).sub(v1).crs(v3.x - v1.x, v3.y - v1.y, v3.z - v1.z).nor();
    }

    private static void verts(Vec3 a, Vec3 b, Vec3 c, Vec3 normal, Color color) {
        MeshBuilder.vert(a, normal, color);
        MeshBuilder.vert(b, normal, color);
        MeshBuilder.vert(c, normal, color);
    }

    private static void vert(Vec3 a, Vec3 normal, Color color) {
        MeshBuilder.floats[0] = a.x;
        MeshBuilder.floats[1] = a.y;
        MeshBuilder.floats[2] = a.z;
        MeshBuilder.floats[3] = normal.x;
        MeshBuilder.floats[4] = normal.y;
        MeshBuilder.floats[5] = normal.z;
        MeshBuilder.floats[6] = color.toFloatBits();
        mesh.getVerticesBuffer().put(floats);
    }
}

