/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.Mesh;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.util.Disposable;
import mindustry.type.Planet;

public abstract class PlanetMesh
implements Disposable {
    protected final Mesh mesh;
    protected final Planet planet;
    protected final Shader shader;

    public PlanetMesh(Planet planet, Mesh mesh, Shader shader) {
        this.planet = planet;
        this.mesh = mesh;
        this.shader = shader;
    }

    public abstract void preRender();

    public void render(Mat3D projection, Mat3D transform) {
        this.preRender();
        this.shader.bind();
        this.shader.setUniformMatrix4("u_proj", projection.val);
        this.shader.setUniformMatrix4("u_trans", transform.val);
        this.shader.apply();
        this.mesh.render(this.shader, 4);
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
    }
}

