/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.Core;
import arc.Events;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Cubemap;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.g3d.Camera3D;
import arc.graphics.g3d.PlaneBatch3D;
import arc.graphics.g3d.VertexBatch3D;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Planets;
import mindustry.game.EventType;
import mindustry.graphics.CubemapMesh;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.type.Planet;
import mindustry.type.Sector;

public class PlanetRenderer
implements Disposable {
    public static final float outlineRad = 1.17f;
    public static final float camLength = 4.0f;
    public static final Color outlineColor = Pal.accent.cpy().a(1.0f);
    public static final Color hoverColor = Pal.accent.cpy().a(0.5f);
    public static final Color borderColor = Pal.accent.cpy().a(0.3f);
    public static final Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.7f);
    private static final Seq<Vec3> points = new Seq();
    public final Vec3 camPos = new Vec3();
    public final Planet solarSystem = Planets.sun;
    public Planet planet = Planets.serpulo;
    public Camera3D cam = new Camera3D();
    public final VertexBatch3D batch = new VertexBatch3D(20000, false, true, 0);
    public float zoom = 1.0f;
    public float orbitAlpha = 1.0f;
    private final Mesh[] outlines = new Mesh[10];
    public final PlaneBatch3D projector = new PlaneBatch3D();
    public final Mat3D mat = new Mat3D();
    public final FrameBuffer buffer = new FrameBuffer(2, 2, true);
    public PlanetInterfaceRenderer irenderer;
    public final Bloom bloom = new Bloom(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4, true, false){
        {
            this.setThreshold(0.8f);
            this.blurPasses = 6;
        }
    };
    public final Mesh atmosphere = MeshBuilder.buildHex(Color.white, 2, false, 1.5f);
    public final CubemapMesh skybox = new CubemapMesh(new Cubemap("cubemaps/stars/"));

    public PlanetRenderer() {
        this.camPos.set(0.0f, 0.0f, 4.0f);
        this.projector.setScaling(0.006666667f);
        this.cam.fov = 60.0f;
        this.cam.far = 150.0f;
    }

    public void render(PlanetInterfaceRenderer irenderer) {
        this.irenderer = irenderer;
        Draw.flush();
        Gl.clear(256);
        Gl.enable(2929);
        Gl.depthMask(true);
        Gl.enable(2884);
        Gl.cullFace(1029);
        this.cam.up.set(Vec3.Y);
        this.cam.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        this.camPos.setLength(this.planet.radius * 4.0f + (this.zoom - 1.0f) * this.planet.radius * 2.0f);
        this.cam.position.set(this.planet.position).add(this.camPos);
        this.cam.lookAt(this.planet.position);
        this.cam.update();
        this.projector.proj(this.cam.combined);
        this.batch.proj(this.cam.combined);
        Events.fire(EventType.Trigger.universeDrawBegin);
        this.beginBloom();
        Vec3 lastPos = Tmp.v31.set(this.cam.position);
        this.cam.position.setZero();
        this.cam.update();
        this.skybox.render(this.cam.combined);
        this.cam.position.set(lastPos);
        this.cam.update();
        Events.fire(EventType.Trigger.universeDraw);
        this.renderPlanet(this.solarSystem);
        this.renderTransparent(this.solarSystem);
        this.endBloom();
        Events.fire(EventType.Trigger.universeDrawEnd);
        Gl.enable(3042);
        irenderer.renderProjections(this.planet);
        Gl.disable(2884);
        Gl.disable(2929);
        this.cam.update();
    }

    public void beginBloom() {
        this.bloom.resize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4);
        this.bloom.capture();
    }

    public void endBloom() {
        this.bloom.render();
    }

    public void renderPlanet(Planet planet) {
        if (!planet.visible()) {
            return;
        }
        planet.draw(this.cam.combined, planet.getTransform(this.mat));
        this.renderOrbit(planet);
        for (Planet child : planet.children) {
            this.renderPlanet(child);
        }
    }

    public void renderTransparent(Planet planet) {
        if (!planet.visible()) {
            return;
        }
        if (planet.isLandable() && planet == this.planet) {
            this.renderSectors(planet);
        }
        if (planet.parent != null && planet.hasAtmosphere && Core.settings.getBool("atmosphere")) {
            Gl.depthMask(false);
            Blending.additive.apply();
            Shaders.atmosphere.camera = this.cam;
            Shaders.atmosphere.planet = planet;
            Shaders.atmosphere.bind();
            Shaders.atmosphere.apply();
            this.atmosphere.render(Shaders.atmosphere, 4);
            Blending.normal.apply();
            Gl.depthMask(true);
        }
        for (Planet child : planet.children) {
            this.renderTransparent(child);
        }
    }

    public void renderOrbit(Planet planet) {
        if (planet.parent == null || !planet.visible()) {
            return;
        }
        Vec3 center = planet.parent.position;
        float radius = planet.orbitRadius;
        int points = (int)(radius * 10.0f);
        Angles.circleVectors(points, radius, (cx, cy) -> this.batch.vertex(Tmp.v32.set(center).add(cx, 0.0f, cy), Pal.gray.write(Tmp.c1).a(this.orbitAlpha)));
        this.batch.flush(2);
    }

    public void renderSectors(Planet planet) {
        this.batch.proj().mul(planet.getTransform(this.mat));
        this.irenderer.renderSectors(planet);
        Mesh mesh = this.outline(planet.grid.size);
        Shaders.PlanetGridShader shader = Shaders.planetGrid;
        Vec3 tile = planet.intersect(this.cam.getMouseRay(), 1.17f);
        Shaders.planetGrid.mouse.lerp(tile == null ? Vec3.Zero : tile.sub(planet.position).rotate(Vec3.Y, planet.getRotation()), 0.2f);
        shader.bind();
        shader.setUniformMatrix4("u_proj", this.cam.combined.val);
        shader.setUniformMatrix4("u_trans", planet.getTransform((Mat3D)this.mat).val);
        ((Shader)shader).apply();
        mesh.render(shader, 1);
    }

    public void drawArc(Planet planet, Vec3 a, Vec3 b) {
        this.drawArc(planet, a, b, Pal.accent, Color.clear, 1.0f);
    }

    public void drawArc(Planet planet, Vec3 a, Vec3 b, Color from, Color to, float length) {
        this.drawArc(planet, a, b, from, to, length, 80.0f, 25);
    }

    public void drawArc(Planet planet, Vec3 a, Vec3 b, Color from, Color to, float length, float timeScale, int pointCount) {
        Vec3 avg = Tmp.v31.set(b).add(a).scl(0.5f);
        avg.setLength(planet.radius * (1.0f + length));
        points.clear();
        points.addAll((Vec3[])new Vec3[]{Tmp.v33.set(b).setLength(1.17f), Tmp.v31, Tmp.v34.set(a).setLength(1.17f)});
        Tmp.bz3.set(points);
        for (int i = 0; i < pointCount + 1; ++i) {
            float f = (float)i / (float)pointCount;
            Tmp.c1.set(from).lerp(to, (f + Time.globalTime / timeScale) % 1.0f);
            this.batch.color(Tmp.c1);
            this.batch.vertex(Tmp.bz3.valueAt(Tmp.v32, f));
        }
        this.batch.flush(3);
    }

    public void drawBorders(Sector sector, Color base) {
        Color color = Tmp.c1.set(base).a(base.a + 0.3f + Mathf.absin(Time.globalTime, 5.0f, 0.3f));
        float r1 = 1.0f;
        float r2 = 1.171f;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner c = sector.tile.corners[i];
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            Tmp.v31.set(c.v).setLength(r2);
            Tmp.v32.set(next.v).setLength(r2);
            Tmp.v33.set(c.v).setLength(r1);
            this.batch.tri2(Tmp.v31, Tmp.v32, Tmp.v33, color);
            Tmp.v31.set(next.v).setLength(r2);
            Tmp.v32.set(next.v).setLength(r1);
            Tmp.v33.set(c.v).setLength(r1);
            this.batch.tri2(Tmp.v31, Tmp.v32, Tmp.v33, color);
        }
        if (this.batch.getNumVertices() >= this.batch.getMaxVertices() - 36) {
            this.batch.flush(4);
        }
    }

    public void drawPlane(Sector sector, Runnable run) {
        Draw.batch(this.projector, () -> {
            this.setPlane(sector);
            run.run();
        });
    }

    public void setPlane(Sector sector) {
        float rotation = -this.planet.getRotation();
        float length = 0.01f;
        this.projector.setPlane(Tmp.v33.set(sector.tile.v).setLength(1.17f + length).rotate(Vec3.Y, rotation).add(this.planet.position), sector.plane.project(Tmp.v32.set(sector.tile.v).add(Vec3.Y)).sub(sector.tile.v).rotate(Vec3.Y, rotation).nor(), Tmp.v31.set(Tmp.v32).rotate(Vec3.Y, -rotation).add(sector.tile.v).rotate(sector.tile.v, 90.0f).sub(sector.tile.v).rotate(Vec3.Y, rotation).nor());
    }

    public void fill(Sector sector, Color color, float offset) {
        float rr = 1.17f + offset;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner c = sector.tile.corners[i];
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            this.batch.tri(Tmp.v31.set(c.v).setLength(rr), Tmp.v32.set(next.v).setLength(rr), Tmp.v33.set(sector.tile.v).setLength(rr), color);
        }
    }

    public void drawSelection(Sector sector) {
        this.drawSelection(sector, Pal.accent, 0.04f, 0.001f);
    }

    public void drawSelection(Sector sector, Color color, float stroke, float length) {
        float arad = 1.17f + length;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            PlanetGrid.Corner curr = sector.tile.corners[i];
            next.v.scl(arad);
            curr.v.scl(arad);
            sector.tile.v.scl(arad);
            Tmp.v31.set(curr.v).sub(sector.tile.v).setLength(curr.v.dst(sector.tile.v) - stroke).add(sector.tile.v);
            Tmp.v32.set(next.v).sub(sector.tile.v).setLength(next.v.dst(sector.tile.v) - stroke).add(sector.tile.v);
            this.batch.tri(curr.v, next.v, Tmp.v31, color);
            this.batch.tri(Tmp.v31, next.v, Tmp.v32, color);
            sector.tile.v.scl(1.0f / arad);
            next.v.scl(1.0f / arad);
            curr.v.scl(1.0f / arad);
        }
    }

    public Mesh outline(int size) {
        if (this.outlines[size] == null) {
            this.outlines[size] = MeshBuilder.buildHex(new HexMesher(){

                @Override
                public float getHeight(Vec3 position) {
                    return 0.0f;
                }

                @Override
                public Color getColor(Vec3 position) {
                    return outlineColor;
                }
            }, size, true, 1.17f, 0.2f);
        }
        return this.outlines[size];
    }

    @Override
    public void dispose() {
        this.skybox.dispose();
        this.batch.dispose();
        this.projector.dispose();
        this.atmosphere.dispose();
        this.buffer.dispose();
        this.bloom.dispose();
        for (Mesh m : this.outlines) {
            if (m == null) continue;
            m.dispose();
        }
    }

    public static interface PlanetInterfaceRenderer {
        public void renderSectors(Planet var1);

        public void renderProjections(Planet var1);
    }
}

