/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.util.Tmp;
import arc.util.noise.Simplex;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesh;
import mindustry.graphics.g3d.HexMesher;
import mindustry.type.Planet;

public class SunMesh
extends HexMesh {
    public SunMesh(Planet planet, int divisions, final double octaves, final double persistence, final double scl, final double pow, final double mag, final float colorScale, final Color ... colors) {
        super(planet, new HexMesher(){
            Simplex sim = new Simplex();

            @Override
            public float getHeight(Vec3 position) {
                return 0.0f;
            }

            @Override
            public Color getColor(Vec3 position) {
                double height = Math.pow(this.sim.octaveNoise3D(octaves, persistence, scl, position.x, position.y, position.z), pow) * mag;
                return Tmp.c1.set(colors[Mathf.clamp((int)(height * (double)colors.length), 0, colors.length - 1)]).mul(colorScale);
            }
        }, divisions, Shaders.unlit);
    }

    @Override
    public void preRender() {
    }
}

