/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.KeyBinds;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Group;
import arc.scene.style.Drawable;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.input.PlaceMode;
import mindustry.ui.Styles;
import mindustry.world.Tile;

public class DesktopInput
extends InputHandler {
    public Vec2 movement = new Vec2();
    public Graphics.Cursor cursorType = Graphics.Cursor.SystemCursor.arrow;
    public int selectX = -1;
    public int selectY = -1;
    public int schemX = -1;
    public int schemY = -1;
    public int lastLineX;
    public int lastLineY;
    public int schematicX;
    public int schematicY;
    public PlaceMode mode;
    public float selectScale;
    @Nullable
    public BuildPlan sreq;
    public boolean deleting = false;
    public boolean shouldShoot = false;
    public boolean panning = false;
    public float panScale = 0.005f;
    public float panSpeed = 4.5f;
    public float panBoostSpeed = 11.0f;
    public long selectMillis = 0L;
    public Tile prevSelected;

    boolean showHint() {
        return Vars.ui.hudfrag.shown && Core.settings.getBool("hints") && this.selectRequests.isEmpty() && (!this.isBuilding && !Core.settings.getBool("buildautopause") || Vars.player.unit().isBuilding() || !Vars.player.dead() && !Vars.player.unit().spawnedByCore());
    }

    @Override
    public void buildUI(Group group) {
        group.fill(t -> {
            t.color.a = 0.0f;
            t.visible(() -> {
                float f;
                t.color.a = Mathf.lerpDelta(t.color.a, Mathf.num(this.showHint()), 0.15f);
                return f > 0.001f;
            });
            t.bottom();
            t.table(Styles.black6, b -> {
                StringBuilder str = new StringBuilder();
                b.defaults().left();
                b.label(() -> {
                    if (!this.showHint()) {
                        return str;
                    }
                    str.setLength(0);
                    if (!(this.isBuilding || Core.settings.getBool("buildautopause") || Vars.player.unit().isBuilding())) {
                        str.append(Core.bundle.format("enablebuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.pause_building).key.toString()));
                    } else if (Vars.player.unit().isBuilding()) {
                        str.append(Core.bundle.format(this.isBuilding ? "pausebuilding" : "resumebuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.pause_building).key.toString())).append("\n").append(Core.bundle.format("cancelbuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.clear_building).key.toString())).append("\n").append(Core.bundle.format("selectschematic", Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_select).key.toString()));
                    }
                    if (!Vars.player.dead() && !Vars.player.unit().spawnedByCore()) {
                        str.append(str.length() != 0 ? "\n" : "").append(Core.bundle.format("respawn", Core.keybinds.get((KeyBinds.KeyBind)Binding.respawn).key.toString()));
                    }
                    return str;
                }).style(Styles.outlineLabel);
            }).margin(10.0f);
        });
        group.fill(t -> {
            t.visible(() -> Vars.ui.hudfrag.shown && this.lastSchematic != null && !this.selectRequests.isEmpty());
            t.bottom();
            t.table(Styles.black6, b -> {
                b.defaults().left();
                b.label(() -> Core.bundle.format("schematic.flip", Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_flip_x).key.toString(), Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_flip_y).key.toString())).style(Styles.outlineLabel).visible(() -> Core.settings.getBool("hints"));
                b.row();
                b.table(a -> a.button("@schematic.add", Icon.save, this::showSchematicSave).colspan(2).size(250.0f, 50.0f).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null));
            }).margin(6.0f);
        });
    }

    @Override
    public void drawTop() {
        Lines.stroke(1.0f);
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.mode == PlaceMode.breaking) {
            this.drawBreakSelection(this.selectX, this.selectY, cursorX, cursorY, !Core.input.keyDown(Binding.schematic_select) ? 100 : 32);
        }
        if (Core.input.keyDown(Binding.schematic_select) && !Core.scene.hasKeyboard() && this.mode != PlaceMode.breaking) {
            this.drawSelection(this.schemX, this.schemY, cursorX, cursorY, 32);
        }
        Draw.reset();
    }

    @Override
    public void drawBottom() {
        BuildPlan req2;
        boolean valid;
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.sreq != null) {
            valid = this.validPlace(this.sreq.x, this.sreq.y, this.sreq.block, this.sreq.rotation, this.sreq);
            if (this.sreq.block.rotate) {
                this.drawArrow(this.sreq.block, this.sreq.x, this.sreq.y, this.sreq.rotation, valid);
            }
            this.sreq.block.drawPlan(this.sreq, this.allRequests(), valid);
            this.drawSelected(this.sreq.x, this.sreq.y, this.sreq.block, this.getRequest(this.sreq.x, this.sreq.y, this.sreq.block.size, this.sreq) != null ? Pal.remove : Pal.accent);
        }
        if (this.mode == PlaceMode.none && !this.isPlacing() && (req2 = this.getRequest(cursorX, cursorY)) != null) {
            this.drawSelected(req2.x, req2.y, req2.breaking ? req2.tile().block() : req2.block, Pal.accent);
        }
        this.selectRequests.each(req -> {
            req.animScale = 1.0f;
            this.drawRequest((BuildPlan)req);
        });
        this.selectRequests.each(this::drawOverRequest);
        if (Vars.player.isBuilder()) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                for (int i = 0; i < this.lineRequests.size; ++i) {
                    BuildPlan req3 = (BuildPlan)this.lineRequests.get(i);
                    if (i == this.lineRequests.size - 1 && req3.block.rotate) {
                        this.drawArrow(this.block, req3.x, req3.y, req3.rotation);
                    }
                    this.drawRequest((BuildPlan)this.lineRequests.get(i));
                }
                this.lineRequests.each(this::drawOverRequest);
            } else if (this.isPlacing()) {
                if (this.block.rotate) {
                    this.drawArrow(this.block, cursorX, cursorY, this.rotation);
                }
                Draw.color();
                valid = this.validPlace(cursorX, cursorY, this.block, this.rotation);
                this.drawRequest(cursorX, cursorY, this.block, this.rotation);
                this.block.drawPlace(cursorX, cursorY, this.rotation, valid);
                if (this.block.saveConfig) {
                    Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
                    this.brequest.set(cursorX, cursorY, this.rotation, this.block);
                    this.brequest.config = this.block.lastConfig;
                    this.block.drawRequestConfig(this.brequest, this.allRequests());
                    this.brequest.config = null;
                    Draw.reset();
                }
            }
        }
        Draw.reset();
    }

    @Override
    public void update() {
        Tile cursor;
        Tile selected;
        Unit on;
        super.update();
        if (Vars.net.active() && Core.input.keyTap(Binding.player_list) && (Core.scene.getKeyboardFocus() == null || Core.scene.getKeyboardFocus().isDescendantOf(Vars.ui.listfrag.content) || Core.scene.getKeyboardFocus().isDescendantOf(Vars.ui.minimapfrag.elem))) {
            Vars.ui.listfrag.toggle();
        }
        boolean panCam = false;
        float camSpeed = (!Core.input.keyDown(Binding.boost) ? this.panSpeed : this.panBoostSpeed) * Time.delta;
        if (Core.input.keyDown(Binding.pan) && !Core.scene.hasField() && !Core.scene.hasDialog()) {
            panCam = true;
            this.panning = true;
        }
        if ((Math.abs(Core.input.axis(Binding.move_x)) > 0.0f || Math.abs(Core.input.axis(Binding.move_y)) > 0.0f || Core.input.keyDown(Binding.mouse_move)) && !Core.scene.hasField()) {
            this.panning = false;
        }
        if (!(!Vars.player.dead() && !Vars.state.isPaused() || Vars.ui.chatfrag.shown() || Core.scene.hasField() || Core.scene.hasDialog())) {
            if (Core.input.keyDown(Binding.mouse_move)) {
                panCam = true;
            }
            Core.camera.position.add(Tmp.v1.setZero().add(Core.input.axis(Binding.move_x), Core.input.axis(Binding.move_y)).nor().scl(camSpeed));
        } else if (!Vars.player.dead() && !this.panning) {
            Core.camera.position.lerpDelta(Vars.player, Core.settings.getBool("smoothcamera") ? 0.08f : 1.0f);
        }
        if (panCam) {
            Core.camera.position.x += Mathf.clamp(((float)Core.input.mouseX() - (float)Core.graphics.getWidth() / 2.0f) * this.panScale, -1.0f, 1.0f) * camSpeed;
            Core.camera.position.y += Mathf.clamp(((float)Core.input.mouseY() - (float)Core.graphics.getHeight() / 2.0f) * this.panScale, -1.0f, 1.0f) * camSpeed;
        }
        boolean bl = this.shouldShoot = !Core.scene.hasMouse();
        if (!Core.scene.hasMouse() && Core.input.keyDown(Binding.control) && Core.input.keyTap(Binding.select) && (on = this.selectedUnit()) != null) {
            Call.unitControl(Vars.player, on);
            this.shouldShoot = false;
        }
        if (!(Vars.player.dead() || Vars.state.isPaused() || Core.scene.getKeyboardFocus() instanceof TextField)) {
            this.updateMovement(Vars.player.unit());
            if (Core.input.keyDown(Binding.respawn) && !Vars.player.unit().spawnedByCore() && !Core.scene.hasField()) {
                Call.unitClear(Vars.player);
                this.controlledType = null;
            }
        }
        if (Core.input.keyRelease(Binding.select)) {
            Vars.player.shooting = false;
        }
        if (Vars.state.isGame() && !Core.scene.hasDialog() && !(Core.scene.getKeyboardFocus() instanceof TextField)) {
            if (Core.input.keyTap(Binding.minimap)) {
                Vars.ui.minimapfrag.toggle();
            }
            if (Core.input.keyTap(Binding.planet_map) && Vars.state.isCampaign()) {
                Vars.ui.planet.toggle();
            }
            if (Core.input.keyTap(Binding.research) && Vars.state.isCampaign()) {
                Vars.ui.research.toggle();
            }
        }
        if (Vars.state.isMenu() || Core.scene.hasDialog()) {
            return;
        }
        if (!(Core.scene.hasScroll() && !Core.input.keyDown(Binding.diagonal_placement) || Vars.ui.chatfrag.shown() || !(Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f) || Core.input.keyDown(Binding.rotateplaced) || !Core.input.keyDown(Binding.diagonal_placement) && (Vars.player.isBuilder() && this.isPlacing() && this.block.rotate || !this.selectRequests.isEmpty()))) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse() && (selected = Vars.world.tileWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null) {
            Call.tileTap(Vars.player, selected);
        }
        if (Vars.player.dead()) {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            return;
        }
        this.pollInput();
        if (!this.isPlacing() && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (Vars.player.shooting && !this.canShoot()) {
            Vars.player.shooting = false;
        }
        if (this.isPlacing() && Vars.player.isBuilder()) {
            this.cursorType = Graphics.Cursor.SystemCursor.hand;
            this.selectScale = Mathf.lerpDelta(this.selectScale, 1.0f, 0.2f);
        } else {
            this.selectScale = 0.0f;
        }
        if (!Core.input.keyDown(Binding.diagonal_placement) && Math.abs((int)Core.input.axisTap(Binding.rotate)) > 0) {
            this.rotation = Mathf.mod(this.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
            if (this.sreq != null) {
                this.sreq.rotation = Mathf.mod(this.sreq.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
            }
            if (this.isPlacing() && this.mode == PlaceMode.placing) {
                this.updateLine(this.selectX, this.selectY);
            } else if (!this.selectRequests.isEmpty() && !Vars.ui.chatfrag.shown()) {
                this.rotateRequests(this.selectRequests, Mathf.sign(Core.input.axisTap(Binding.rotate)));
            }
        }
        if ((cursor = this.tileAt(Core.input.mouseX(), Core.input.mouseY())) != null) {
            if (cursor.build != null) {
                this.cursorType = cursor.build.getCursor();
            }
            if (this.isPlacing() && Vars.player.isBuilder() || !this.selectRequests.isEmpty()) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (!this.isPlacing() && this.canMine(cursor)) {
                this.cursorType = Vars.ui.drillCursor;
            }
            if (this.getRequest(cursor.x, cursor.y) != null && this.mode == PlaceMode.none) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (this.canTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) {
                this.cursorType = Vars.ui.unloadCursor;
            }
            if (cursor.build != null && cursor.interactable(Vars.player.team()) && !this.isPlacing() && Math.abs(Core.input.axisTap(Binding.rotate)) > 0.0f && Core.input.keyDown(Binding.rotateplaced) && cursor.block().rotate && cursor.block().quickRotate) {
                Call.rotateBlock(Vars.player, cursor.build, Core.input.axisTap(Binding.rotate) > 0.0f);
            }
        }
        if (!Core.scene.hasMouse()) {
            Core.graphics.cursor(this.cursorType);
        }
        this.cursorType = Graphics.Cursor.SystemCursor.arrow;
    }

    @Override
    public void useSchematic(Schematic schem) {
        this.block = null;
        this.schematicX = this.tileX(this.getMouseX());
        this.schematicY = this.tileY(this.getMouseY());
        this.selectRequests.clear();
        this.selectRequests.addAll(Vars.schematics.toRequests(schem, this.schematicX, this.schematicY));
        this.mode = PlaceMode.none;
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public void buildPlacementUI(Table table) {
        table.image().color(Pal.gray).height(4.0f).colspan(4).growX();
        table.row();
        table.left().margin(0.0f).defaults().size(48.0f).left();
        table.button((Drawable)Icon.paste, Styles.clearPartiali, () -> Vars.ui.schematics.show()).tooltip("@schematics");
        table.button((Drawable)Icon.book, Styles.clearPartiali, () -> Vars.ui.database.show()).tooltip("@database");
        table.button((Drawable)Icon.tree, Styles.clearPartiali, () -> Vars.ui.research.show()).visible(() -> Vars.state.isCampaign()).tooltip("@research");
        table.button((Drawable)Icon.map, Styles.clearPartiali, () -> Vars.ui.planet.show()).visible(() -> Vars.state.isCampaign()).tooltip("@planetmap");
    }

    void pollInput() {
        if (Core.scene.getKeyboardFocus() instanceof TextField) {
            return;
        }
        Tile selected = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        int rawCursorX = World.toTile(Core.input.mouseWorld().x);
        int rawCursorY = World.toTile(Core.input.mouseWorld().y);
        if (Core.settings.getBool("buildautopause") && this.isBuilding && !Vars.player.unit().isBuilding()) {
            this.isBuilding = false;
            this.buildWasAutoPaused = true;
        }
        if (!this.selectRequests.isEmpty()) {
            int shiftX = rawCursorX - this.schematicX;
            int shiftY = rawCursorY - this.schematicY;
            this.selectRequests.each(s -> {
                s.x += shiftX;
                s.y += shiftY;
            });
            this.schematicX += shiftX;
            this.schematicY += shiftY;
        }
        if (Core.input.keyTap(Binding.deselect) && !this.isPlacing()) {
            Vars.player.unit().mineTile = null;
        }
        if (Core.input.keyTap(Binding.clear_building)) {
            Vars.player.unit().clearBuilding();
        }
        if (Core.input.keyTap(Binding.schematic_select) && !Core.scene.hasKeyboard() && this.mode != PlaceMode.breaking) {
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (Core.input.keyTap(Binding.schematic_menu) && !Core.scene.hasKeyboard()) {
            if (Vars.ui.schematics.isShown()) {
                Vars.ui.schematics.hide();
            } else {
                Vars.ui.schematics.show();
            }
        }
        if (Core.input.keyTap(Binding.clear_building) || this.isPlacing()) {
            this.lastSchematic = null;
            this.selectRequests.clear();
        }
        if (Core.input.keyRelease(Binding.schematic_select) && !Core.scene.hasKeyboard() && this.selectX == -1 && this.selectY == -1 && this.schemX != -1 && this.schemY != -1) {
            this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
            this.useSchematic(this.lastSchematic);
            if (this.selectRequests.isEmpty()) {
                this.lastSchematic = null;
            }
            this.schemX = -1;
            this.schemY = -1;
        }
        if (!this.selectRequests.isEmpty()) {
            if (Core.input.keyTap(Binding.schematic_flip_x)) {
                this.flipRequests(this.selectRequests, true);
            }
            if (Core.input.keyTap(Binding.schematic_flip_y)) {
                this.flipRequests(this.selectRequests, false);
            }
        }
        if (this.sreq != null) {
            float offset = (float)((this.sreq.block.size + 2) % 2 * 8) / 2.0f;
            float x = Core.input.mouseWorld().x + offset;
            float y = Core.input.mouseWorld().y + offset;
            this.sreq.x = (int)(x / 8.0f);
            this.sreq.y = (int)(y / 8.0f);
        }
        if (this.block == null || this.mode != PlaceMode.placing) {
            this.lineRequests.clear();
        }
        if (Core.input.keyTap(Binding.pause_building)) {
            this.isBuilding = !this.isBuilding;
            this.buildWasAutoPaused = false;
            if (this.isBuilding) {
                Vars.player.shooting = false;
            }
        }
        if ((cursorX != this.lastLineX || cursorY != this.lastLineY) && this.isPlacing() && this.mode == PlaceMode.placing) {
            this.updateLine(this.selectX, this.selectY);
            this.lastLineX = cursorX;
            this.lastLineY = cursorY;
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse()) {
            BuildPlan req = this.getRequest(cursorX, cursorY);
            if (Core.input.keyDown(Binding.break_block)) {
                this.mode = PlaceMode.none;
            } else if (!this.selectRequests.isEmpty()) {
                this.flushRequests(this.selectRequests);
            } else if (this.isPlacing()) {
                this.selectX = cursorX;
                this.selectY = cursorY;
                this.lastLineX = cursorX;
                this.lastLineY = cursorY;
                this.mode = PlaceMode.placing;
                this.updateLine(this.selectX, this.selectY);
            } else if (req != null && !req.breaking && this.mode == PlaceMode.none && !req.initialized) {
                this.sreq = req;
            } else if (req != null && req.breaking) {
                this.deleting = true;
            } else if (selected != null) {
                if (!(this.tryTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y) || this.tileTapped(selected.build) || Vars.player.unit().activelyBuilding() || this.droppingItem || this.tryStopMine(selected) || (!Core.settings.getBool("doubletapmine") || selected == this.prevSelected && Time.timeSinceMillis(this.selectMillis) < 500L) && this.tryBeginMine(selected) || Core.scene.hasKeyboard())) {
                    Vars.player.shooting = this.shouldShoot;
                }
            } else if (!Core.scene.hasKeyboard()) {
                Vars.player.shooting = this.shouldShoot;
            }
            this.selectMillis = Time.millis();
            this.prevSelected = selected;
        } else if (Core.input.keyTap(Binding.deselect) && this.isPlacing()) {
            this.block = null;
            this.mode = PlaceMode.none;
        } else if (Core.input.keyTap(Binding.deselect) && !this.selectRequests.isEmpty()) {
            this.selectRequests.clear();
            this.lastSchematic = null;
        } else if (Core.input.keyTap(Binding.break_block) && !Core.scene.hasMouse() && Vars.player.isBuilder()) {
            this.deleting = false;
            this.mode = PlaceMode.breaking;
            this.selectX = this.tileX(Core.input.mouseX());
            this.selectY = this.tileY(Core.input.mouseY());
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (Core.input.keyDown(Binding.select) && this.mode == PlaceMode.none && !this.isPlacing() && this.deleting) {
            BuildPlan req = this.getRequest(cursorX, cursorY);
            if (req != null && req.breaking) {
                Vars.player.unit().plans().remove(req);
            }
        } else {
            this.deleting = false;
        }
        if (this.mode == PlaceMode.placing && this.block != null) {
            if (!(this.overrideLineRotation || Core.input.keyDown(Binding.diagonal_placement) || this.selectX == cursorX && this.selectY == cursorY || (int)Core.input.axisTap(Binding.rotate) == 0)) {
                this.rotation = (int)((Angles.angle(this.selectX, this.selectY, cursorX, cursorY) + 45.0f) / 90.0f) % 4;
                this.overrideLineRotation = true;
            }
        } else {
            this.overrideLineRotation = false;
        }
        if (Core.input.keyRelease(Binding.break_block) && Core.input.keyDown(Binding.schematic_select) && this.mode == PlaceMode.breaking) {
            this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
            this.schemX = -1;
            this.schemY = -1;
        }
        if (Core.input.keyRelease(Binding.break_block) || Core.input.keyRelease(Binding.select)) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                this.flushRequests(this.lineRequests);
                this.lineRequests.clear();
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.selectX, this.selectY, cursorX, cursorY, !Core.input.keyDown(Binding.schematic_select) ? 100 : 32);
                if (this.lastSchematic != null) {
                    this.useSchematic(this.lastSchematic);
                    this.lastSchematic = null;
                }
            }
            this.selectX = -1;
            this.selectY = -1;
            this.tryDropItems(selected == null ? null : selected.build, Core.input.mouseWorld().x, Core.input.mouseWorld().y);
            if (this.sreq != null) {
                if (this.getRequest(this.sreq.x, this.sreq.y, this.sreq.block.size, this.sreq) != null) {
                    Vars.player.unit().plans().remove(this.sreq, true);
                }
                this.sreq = null;
            }
            this.mode = PlaceMode.none;
        }
        if (Core.input.keyTap(Binding.toggle_block_status)) {
            Core.settings.put("blockstatus", !Core.settings.getBool("blockstatus"));
        }
        if (Core.input.keyTap(Binding.toggle_power_lines)) {
            if (Core.settings.getInt("lasersopacity") == 0) {
                Core.settings.put("lasersopacity", Core.settings.getInt("preferredlaseropacity", 100));
            } else {
                Core.settings.put("preferredlaseropacity", Core.settings.getInt("lasersopacity"));
                Core.settings.put("lasersopacity", 0);
            }
        }
    }

    @Override
    public boolean selectedBlock() {
        return this.isPlacing() && this.mode != PlaceMode.breaking;
    }

    @Override
    public float getMouseX() {
        return Core.input.mouseX();
    }

    @Override
    public float getMouseY() {
        return Core.input.mouseY();
    }

    @Override
    public void updateState() {
        super.updateState();
        if (Vars.state.isMenu()) {
            this.droppingItem = false;
            this.mode = PlaceMode.none;
            this.block = null;
            this.sreq = null;
            this.selectRequests.clear();
        }
    }

    protected void updateMovement(Unit unit) {
        boolean aimCursor;
        boolean omni = unit.type.omniMovement;
        float speed = unit.realSpeed();
        float xa = Core.input.axis(Binding.move_x);
        float ya = Core.input.axis(Binding.move_y);
        boolean boosted = unit instanceof Mechc && unit.isFlying();
        this.movement.set(xa, ya).nor().scl(speed);
        if (Core.input.keyDown(Binding.mouse_move)) {
            this.movement.add(Core.input.mouseWorld().sub(Vars.player).scl(0.04f * speed)).limit(speed);
        }
        float mouseAngle = Angles.mouseAngle(unit.x, unit.y);
        boolean bl = aimCursor = omni && Vars.player.shooting && unit.type.hasWeapons() && unit.type.faceTarget && !boosted && unit.type.rotateShooting;
        if (aimCursor) {
            unit.lookAt(mouseAngle);
        } else {
            unit.lookAt(unit.prefRotation());
        }
        if (omni) {
            unit.moveAt(this.movement);
        } else {
            unit.moveAt(Tmp.v2.trns(unit.rotation, this.movement.len()));
            if (!this.movement.isZero()) {
                unit.vel.rotateTo(this.movement.angle(), unit.type.rotateSpeed * Math.max(Time.delta, 1.0f));
            }
        }
        unit.aim(unit.type.faceTarget ? Core.input.mouseWorld() : Tmp.v1.trns(unit.rotation, Core.input.mouseWorld().dst(unit)).add(unit.x, unit.y));
        unit.controlWeapons(true, Vars.player.shooting && !boosted);
        Vars.player.boosting = Core.input.keyDown(Binding.boost) && !this.movement.isZero();
        Vars.player.mouseX = unit.aimX();
        Vars.player.mouseY = unit.aimY();
        if (unit instanceof Payloadc) {
            if (Core.input.keyTap(Binding.pickupCargo)) {
                this.tryPickupPayload();
            }
            if (Core.input.keyTap(Binding.dropCargo)) {
                this.tryDropPayload();
            }
        }
        if (Core.input.keyTap(Binding.command) && unit.type.commandLimit > 0) {
            Call.unitCommand(Vars.player);
        }
    }
}

