/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.GestureDetector;
import arc.input.InputProcessor;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Group;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.formations.patterns.CircleFormation;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Commanderc;
import mindustry.gen.Itemsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.Placement;
import mindustry.net.Administration;
import mindustry.net.ValidateException;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.fragments.OverlayFragment;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;

public abstract class InputHandler
implements InputProcessor,
GestureDetector.GestureListener {
    static final float playerSelectRange = Vars.mobile ? 17.0f : 11.0f;
    static final int maxLength = 100;
    static final Rect r1 = new Rect();
    static final Rect r2 = new Rect();
    public final OverlayFragment frag = new OverlayFragment();
    public Interval controlInterval = new Interval();
    @Nullable
    public Block block;
    public boolean overrideLineRotation;
    public int rotation;
    public boolean droppingItem;
    public Group uiGroup;
    public boolean isBuilding = true;
    public boolean buildWasAutoPaused = false;
    public boolean wasShooting = false;
    @Nullable
    public UnitType controlledType;
    @Nullable
    public Schematic lastSchematic;
    public GestureDetector detector;
    public PlaceLine line = new PlaceLine();
    public BuildPlan resultreq;
    public BuildPlan brequest = new BuildPlan();
    public Seq<BuildPlan> lineRequests = new Seq();
    public Seq<BuildPlan> selectRequests = new Seq();

    public InputHandler() {
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit != null && e.unit.isPlayer() && e.unit.getPlayer().isLocal() && e.unit.type.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.killShooter)))) {
                Vars.player.shooting = false;
            }
        });
    }

    public static void transferItemEffect(Item item, float x, float y, Itemsc to) {
        if (to == null) {
            return;
        }
        InputHandler.createItemTransfer(item, 1, x, y, to, null);
    }

    public static void takeItems(Building build, Item item, int amount, Unit to) {
        if (to == null || build == null) {
            return;
        }
        int removed = build.removeStack(item, Math.min(to.maxAccepted(item), amount));
        if (removed == 0) {
            return;
        }
        to.addItem(item, removed);
        for (int j = 0; j < Mathf.clamp(removed / 3, 1, 8); ++j) {
            Time.run((float)j * 3.0f, () -> InputHandler.transferItemEffect(item, build.x, build.y, to));
        }
    }

    public static void transferItemToUnit(Item item, float x, float y, Itemsc to) {
        if (to == null) {
            return;
        }
        InputHandler.createItemTransfer(item, 1, x, y, to, () -> to.addItem(item));
    }

    public static void setItem(Building build, Item item, int amount) {
        if (build == null || build.items == null) {
            return;
        }
        build.items.set(item, amount);
    }

    public static void clearItems(Building build) {
        if (build == null || build.items == null) {
            return;
        }
        build.items.clear();
    }

    public static void transferItemTo(@Nullable Unit unit, Item item, int amount, float x, float y, Building build) {
        if (build == null || build.items == null) {
            return;
        }
        if (unit != null && unit.item() == item) {
            unit.stack.amount = Math.max(unit.stack.amount - amount, 0);
        }
        for (int i = 0; i < Mathf.clamp(amount / 3, 1, 8); ++i) {
            Time.run(i * 3, () -> InputHandler.createItemTransfer(item, amount, x, y, build, () -> {}));
        }
        if (amount > 0) {
            build.handleStack(item, amount, unit);
        }
    }

    public static void createItemTransfer(Item item, int amount, float x, float y, Position to, Runnable done) {
        Fx.itemTransfer.at(x, y, amount, item.color, to);
        if (done != null) {
            Time.run(Fx.itemTransfer.lifetime, done);
        }
    }

    public static void requestItem(Player player, Building build, Item item, int amount) {
        if (player == null || build == null || !build.interactable(player.team()) || !player.within(build, 220.0f) || player.dead()) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.withdrawItem, build.tile(), action -> {
            action.item = item;
            action.itemAmount = amount;
        }))) {
            throw new ValidateException(player, "Player cannot request items.");
        }
        player.unit().eachGroup(unit -> {
            Call.takeItems(build, item, unit.maxAccepted(item), unit);
            if (unit == player.unit()) {
                Events.fire(new EventType.WithdrawEvent(build, player, item, amount));
            }
        });
    }

    public static void transferInventory(Player player, Building build) {
        if (player == null || build == null || !player.within(build, 220.0f) || build.items == null || player.dead()) {
            return;
        }
        if (!(!Vars.net.server() || player.unit().stack.amount > 0 && Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.depositItem, build.tile, action -> {
            action.itemAmount = player.unit().stack.amount;
            action.item = player.unit().item();
        }))) {
            throw new ValidateException(player, "Player cannot transfer an item.");
        }
        player.unit().eachGroup(unit -> {
            Item item = unit.item();
            int accepted = build.acceptStack(item, unit.stack.amount, (Teamc)unit);
            Call.transferItemTo(unit, item, accepted, unit.x, unit.y, build);
            if (unit == player.unit()) {
                Events.fire(new EventType.DepositEvent(build, player, item, accepted));
            }
        });
    }

    public static void removeQueueBlock(int x, int y, boolean breaking) {
        Vars.player.unit().removeBuild(x, y, breaking);
    }

    public static void requestUnitPayload(Player player, Unit target) {
        Payloadc pay;
        Unit unit;
        if (player == null || !((unit = player.unit()) instanceof Payloadc) || (pay = (Payloadc)((Object)unit)) != (Payloadc)((Object)unit)) {
            return;
        }
        Unit unit2 = player.unit();
        if (target.isAI() && target.isGrounded() && pay.canPickup(target) && target.within(unit2, unit2.type.hitSize * 2.0f + target.type.hitSize * 2.0f)) {
            Call.pickedUnitPayload(unit2, target);
        }
    }

    public static void requestBuildPayload(Player player, Building build) {
        Payloadc pay;
        Unit unit;
        if (player == null || !((unit = player.unit()) instanceof Payloadc) || (pay = (Payloadc)((Object)unit)) != (Payloadc)((Object)unit)) {
            return;
        }
        Unit unit2 = player.unit();
        if (build != null && build.team == unit2.team && unit2.within(build, (float)(8 * build.block.size) * 1.2f + 40.0f)) {
            Payload current = build.getPayload();
            if (current != null && pay.canPickupPayload(current)) {
                Call.pickedBuildPayload(unit2, build, false);
            } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                Call.pickedBuildPayload(unit2, build, true);
            }
        }
    }

    public static void pickedUnitPayload(Unit unit, Unit target) {
        Payloadc pay;
        Unit unit2;
        if (target != null && (unit2 = unit) instanceof Payloadc && (pay = (Payloadc)((Object)unit2)) == (Payloadc)((Object)unit2)) {
            pay.pickup(target);
        } else if (target != null) {
            target.remove();
        }
    }

    public static void pickedBuildPayload(Unit unit, Building build, boolean onGround) {
        Payloadc pay;
        Unit unit2;
        if (build != null && (unit2 = unit) instanceof Payloadc && (pay = (Payloadc)((Object)unit2)) == (Payloadc)((Object)unit2)) {
            if (onGround) {
                if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                    pay.pickup(build);
                } else {
                    Fx.unitPickup.at(build);
                    build.tile.remove();
                }
            } else {
                Payload taken;
                Payload current = build.getPayload();
                if (current != null && pay.canPickupPayload(current) && (taken = build.takePayload()) != null) {
                    pay.addPayload(taken);
                    Fx.unitPickup.at(build);
                }
            }
        } else if (build != null && onGround) {
            Fx.unitPickup.at(build);
            build.tile.remove();
        }
    }

    public static void requestDropPayload(Player player, float x, float y) {
        if (player == null || Vars.net.client()) {
            return;
        }
        Payloadc pay = (Payloadc)((Object)player.unit());
        Tmp.v1.set(x, y).sub(pay).limit(32.0f).add(pay);
        float cx = Tmp.v1.x;
        float cy = Tmp.v1.y;
        Call.payloadDropped(player.unit(), cx, cy);
    }

    public static void payloadDropped(Unit unit, float x, float y) {
        Payloadc pay;
        Unit unit2 = unit;
        if (unit2 instanceof Payloadc && (pay = (Payloadc)((Object)unit2)) == (Payloadc)((Object)unit2)) {
            float prevx = pay.x();
            float prevy = pay.y();
            pay.set(x, y);
            pay.dropLastPayload();
            pay.set(prevx, prevy);
            pay.controlling().each(u -> {
                if (u instanceof Payloadc) {
                    Call.payloadDropped(u, u.x, u.y);
                }
            });
        }
    }

    public static void dropItem(Player player, float angle) {
        if (player == null) {
            return;
        }
        if (Vars.net.server() && player.unit().stack.amount <= 0) {
            throw new ValidateException(player, "Player cannot drop an item.");
        }
        player.unit().eachGroup(unit -> {
            Fx.dropItem.at(unit.x, unit.y, angle, Color.white, unit.item());
            unit.clearItem();
        });
    }

    public static void rotateBlock(@Nullable Player player, Building build, boolean direction) {
        if (build == null) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.rotate, build.tile(), action -> {
            action.rotation = Mathf.mod(build.rotation + Mathf.sign(direction), 4);
        }))) {
            throw new ValidateException(player, "Player cannot rotate a block.");
        }
        if (player != null) {
            build.lastAccessed = player.name;
        }
        build.rotation = Mathf.mod(build.rotation + Mathf.sign(direction), 4);
        build.updateProximity();
        build.noSleep();
        Fx.rotateBlock.at(build.x, build.y, build.block.size);
    }

    public static void tileConfig(@Nullable Player player, Building build, @Nullable Object value) {
        if (build == null) {
            return;
        }
        if (!(!Vars.net.server() || Units.canInteract(player, build) && Vars.netServer.admins.allowAction(player, Administration.ActionType.configure, build.tile, action -> {
            action.config = value;
        }))) {
            throw new ValidateException(player, "Player cannot configure a tile.");
        }
        build.configured(player == null || player.dead() ? null : player.unit(), value);
        Core.app.post(() -> Events.fire(new EventType.ConfigEvent(build, player, value)));
    }

    public static void tileTap(@Nullable Player player, Tile tile) {
        if (tile == null) {
            return;
        }
        Events.fire(new EventType.TapEvent(player, tile));
    }

    public static void unitControl(Player player, @Nullable Unit unit) {
        CoreBlock.CoreBuild build;
        BlockUnitc block;
        if (player == null) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.control, action -> {
            action.unit = unit;
        })) {
            throw new ValidateException(player, "Player cannot control a unit.");
        }
        Teamc teamc = unit;
        if (teamc instanceof BlockUnitc && (block = (BlockUnitc)teamc) == (BlockUnitc)teamc && (teamc = block.tile()) instanceof CoreBlock.CoreBuild && (build = (CoreBlock.CoreBuild)teamc) == (CoreBlock.CoreBuild)teamc) {
            Fx.spawn.at(player);
            if (Vars.net.client()) {
                Vars.control.input.controlledType = null;
            }
            player.clearUnit();
            player.deathTimer = 61.0f;
            build.requestSpawn(player);
        } else if (unit == null) {
            player.clearUnit();
        } else if (unit.isAI() && unit.team == player.team() && !unit.dead) {
            if (!Vars.net.client()) {
                player.unit(unit);
            }
            Time.run(Fx.unitSpirit.lifetime, () -> Fx.unitControl.at(unit.x, unit.y, 0.0f, unit));
            if (!player.dead()) {
                Fx.unitSpirit.at(player.x, player.y, 0.0f, unit);
            }
        }
        Events.fire(new EventType.UnitControlEvent(player, unit));
    }

    public static void unitClear(Player player) {
        if (player == null || !player.dead() && player.unit().spawnedByCore) {
            return;
        }
        Fx.spawn.at(player);
        player.clearUnit();
        player.deathTimer = 61.0f;
    }

    public static void unitCommand(Player player) {
        Unit commander;
        Unit unit;
        if (player == null || player.dead() || !((unit = player.unit()) instanceof Commanderc) || (commander = unit) != unit) {
            return;
        }
        if (Vars.net.server() && !Vars.netServer.admins.allowAction(player, Administration.ActionType.command, action -> {})) {
            throw new ValidateException(player, "Player cannot command a unit.");
        }
        if (commander.isCommanding()) {
            commander.clearCommand();
        } else if (player.unit().type.commandLimit > 0) {
            commander.commandNearby(new CircleFormation());
            Fx.commandSend.at(player);
        }
    }

    public Eachable<BuildPlan> allRequests() {
        return cons -> {
            for (BuildPlan request : Vars.player.unit().plans()) {
                cons.get(request);
            }
            for (BuildPlan request : this.selectRequests) {
                cons.get(request);
            }
            for (BuildPlan request : this.lineRequests) {
                cons.get(request);
            }
        };
    }

    public boolean isUsingSchematic() {
        return !this.selectRequests.isEmpty();
    }

    public OverlayFragment getFrag() {
        return this.frag;
    }

    public void update() {
        Unit unit;
        Vars.player.typing = Vars.ui.chatfrag.shown();
        if (Vars.player.isBuilder()) {
            Vars.player.unit().updateBuilding(this.isBuilding);
        }
        if (Vars.player.shooting && !this.wasShooting && Vars.player.unit().hasWeapons() && Vars.state.rules.unitAmmo && Vars.player.unit().ammo <= 0.0f) {
            Vars.player.unit().type.weapons.first().noAmmoSound.at(Vars.player.unit());
        }
        this.wasShooting = Vars.player.shooting;
        if (!Vars.player.dead()) {
            this.controlledType = Vars.player.unit().type;
        }
        if (this.controlledType != null && Vars.player.dead() && (unit = Units.closest(Vars.player.team(), Vars.player.x, Vars.player.y, u -> !u.isPlayer() && u.type == this.controlledType && !u.dead)) != null && (!Vars.net.client() || this.controlInterval.get(0, 70.0f))) {
            Call.unitControl(Vars.player, unit);
        }
    }

    public void checkUnit() {
        if (this.controlledType != null) {
            Unit unit = Units.closest(Vars.player.team(), Vars.player.x, Vars.player.y, u -> !u.isPlayer() && u.type == this.controlledType && !u.dead);
            if (unit == null && this.controlledType == UnitTypes.block) {
                ControlBlock cont;
                Building building = Vars.world.buildWorld(Vars.player.x, Vars.player.y);
                Unit unit2 = unit = building instanceof ControlBlock && (cont = (ControlBlock)((Object)building)) == (ControlBlock)((Object)building) && cont.canControl() ? cont.unit() : null;
            }
            if (unit != null) {
                if (Vars.net.client()) {
                    Call.unitControl(Vars.player, unit);
                } else {
                    unit.controller(Vars.player);
                }
            }
        }
    }

    public void tryPickupPayload() {
        Payloadc pay;
        Unit unit = Vars.player.unit();
        Unit unit2 = unit;
        if (!(unit2 instanceof Payloadc) || (pay = (Payloadc)((Object)unit2)) != (Payloadc)((Object)unit2)) {
            return;
        }
        Unit target = Units.closest(Vars.player.team(), pay.x(), pay.y(), unit.type.hitSize * 2.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(unit, u.hitSize + unit.hitSize));
        if (target != null) {
            Call.requestUnitPayload(Vars.player, target);
        } else {
            Building build = Vars.world.buildWorld(pay.x(), pay.y());
            if (build != null && build.team == unit.team) {
                Call.requestBuildPayload(Vars.player, build);
            }
        }
    }

    public void tryDropPayload() {
        Unit unit = Vars.player.unit();
        if (!(unit instanceof Payloadc)) {
            return;
        }
        Call.requestDropPayload(Vars.player, Vars.player.x, Vars.player.y);
    }

    public float getMouseX() {
        return Core.input.mouseX();
    }

    public float getMouseY() {
        return Core.input.mouseY();
    }

    public void buildPlacementUI(Table table) {
    }

    public void buildUI(Group group) {
    }

    public void updateState() {
        if (Vars.state.isMenu()) {
            this.controlledType = null;
        }
    }

    public void drawBottom() {
    }

    public void drawTop() {
    }

    public void drawOverSelect() {
    }

    public void drawSelected(int x, int y, Block block, Color color) {
        Drawf.selected(x, y, block, color);
    }

    public void drawBreaking(BuildPlan request) {
        if (request.breaking) {
            this.drawBreaking(request.x, request.y);
        } else {
            this.drawSelected(request.x, request.y, request.block, Pal.remove);
        }
    }

    public boolean requestMatches(BuildPlan request) {
        ConstructBlock.ConstructBuild cons;
        Building building;
        Tile tile = Vars.world.tile(request.x, request.y);
        return tile != null && (building = tile.build) instanceof ConstructBlock.ConstructBuild && (cons = (ConstructBlock.ConstructBuild)building) == (ConstructBlock.ConstructBuild)building && cons.cblock == request.block;
    }

    public void drawBreaking(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Block block = tile.block();
        this.drawSelected(x, y, block, Pal.remove);
    }

    public void useSchematic(Schematic schem) {
        this.selectRequests.addAll(Vars.schematics.toRequests(schem, Vars.player.tileX(), Vars.player.tileY()));
    }

    protected void showSchematicSave() {
        if (this.lastSchematic == null) {
            return;
        }
        Vars.ui.showTextInput("@schematic.add", "@name", "", text -> {
            Schematic replacement = Vars.schematics.all().find(s -> s.name().equals(text));
            if (replacement != null) {
                Vars.ui.showConfirm("@confirm", "@schematic.replace", () -> {
                    Vars.schematics.overwrite(replacement, this.lastSchematic);
                    Vars.ui.showInfoFade("@schematic.saved");
                    Vars.ui.schematics.showInfo(replacement);
                });
            } else {
                this.lastSchematic.tags.put("name", text);
                this.lastSchematic.tags.put("description", "");
                Vars.schematics.add(this.lastSchematic);
                Vars.ui.showInfoFade("@schematic.saved");
                Vars.ui.schematics.showInfo(this.lastSchematic);
                Events.fire(new EventType.SchematicCreateEvent(this.lastSchematic));
            }
        });
    }

    public void rotateRequests(Seq<BuildPlan> requests, int direction) {
        int ox = this.schemOriginX();
        int oy = this.schemOriginY();
        requests.each(req -> {
            req.pointConfig(p -> {
                int cx = p.x;
                int cy = p.y;
                int lx = cx;
                if (direction >= 0) {
                    cx = -cy;
                    cy = lx;
                } else {
                    cx = cy;
                    cy = -lx;
                }
                p.set(cx, cy);
            });
            float wx = (float)((req.x - ox) * 8) + req.block.offset;
            float wy = (float)((req.y - oy) * 8) + req.block.offset;
            float x = wx;
            if (direction >= 0) {
                wx = -wy;
                wy = x;
            } else {
                wx = wy;
                wy = -x;
            }
            req.x = World.toTile(wx - req.block.offset) + ox;
            req.y = World.toTile(wy - req.block.offset) + oy;
            req.rotation = Mathf.mod(req.rotation + direction, 4);
        });
    }

    public void flipRequests(Seq<BuildPlan> requests, boolean x) {
        int origin = (x ? this.schemOriginX() : this.schemOriginY()) * 8;
        requests.each(req -> {
            float value = -((float)((x ? req.x : req.y) * 8 - origin) + req.block.offset) + (float)origin;
            if (x) {
                req.x = (int)((value - req.block.offset) / 8.0f);
            } else {
                req.y = (int)((value - req.block.offset) / 8.0f);
            }
            req.pointConfig(p -> {
                int corigin = x ? req.originalWidth / 2 : req.originalHeight / 2;
                int nvalue = -(x ? p.x : p.y);
                if (x) {
                    req.originalX = -(req.originalX - corigin) + corigin;
                    p.x = nvalue;
                } else {
                    req.originalY = -(req.originalY - corigin) + corigin;
                    p.y = nvalue;
                }
            });
            if (x == (req.rotation % 2 == 0)) {
                req.rotation = Mathf.mod(req.rotation + 2, 4);
            }
        });
    }

    protected int schemOriginX() {
        return this.rawTileX();
    }

    protected int schemOriginY() {
        return this.rawTileY();
    }

    protected BuildPlan getRequest(int x, int y) {
        return this.getRequest(x, y, 1, null);
    }

    protected BuildPlan getRequest(int x, int y, int size, BuildPlan skip) {
        float offset = (float)((size + 1) % 2 * 8) / 2.0f;
        r2.setSize(8 * size);
        r2.setCenter((float)(x * 8) + offset, (float)(y * 8) + offset);
        this.resultreq = null;
        Boolf<BuildPlan> test = req -> {
            if (req == skip) {
                return false;
            }
            Tile other = req.tile();
            if (other == null) {
                return false;
            }
            if (!req.breaking) {
                r1.setSize(req.block.size * 8);
                r1.setCenter(other.worldx() + req.block.offset, other.worldy() + req.block.offset);
            } else {
                r1.setSize(other.block().size * 8);
                r1.setCenter(other.worldx() + other.block().offset, other.worldy() + other.block().offset);
            }
            return r2.overlaps(r1);
        };
        for (BuildPlan req2 : Vars.player.unit().plans()) {
            if (!test.get(req2)) continue;
            return req2;
        }
        return this.selectRequests.find(test);
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2, int maxLength) {
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea(Blocks.air, x1, y1, x2, y2, false, maxLength, 1.0f);
        Placement.NormalizeResult dresult = Placement.normalizeArea(x1, y1, x2, y2, this.rotation, false, maxLength);
        for (int x = dresult.x; x <= dresult.x2; ++x) {
            for (int y = dresult.y; y <= dresult.y2; ++y) {
                Tile tile = Vars.world.tileBuilding(x, y);
                if (tile == null || !this.validBreak(tile.x, tile.y)) continue;
                this.drawBreaking(tile.x, tile.y);
            }
        }
        Tmp.r1.set(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.remove);
        Lines.stroke(1.0f);
        for (BuildPlan req : Vars.player.unit().plans()) {
            if (req.breaking || !req.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawBreaking(req);
        }
        for (BuildPlan req : this.selectRequests) {
            if (req.breaking || !req.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawBreaking(req);
        }
        for (Teams.BlockPlan req : Vars.player.team().data().blocks) {
            Block block = Vars.content.block(req.block);
            if (!block.bounds(req.x, req.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawSelected(req.x, req.y, Vars.content.block(req.block), Pal.remove);
        }
        Lines.stroke(2.0f);
        Draw.color(Pal.removeBack);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.remove);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2) {
        this.drawBreakSelection(x1, y1, x2, y2, 100);
    }

    protected void drawSelection(int x1, int y1, int x2, int y2, int maxLength) {
        Placement.NormalizeDrawResult result = Placement.normalizeDrawArea(Blocks.air, x1, y1, x2, y2, false, maxLength, 1.0f);
        Lines.stroke(2.0f);
        Draw.color(Pal.accentBack);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.accent);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void flushSelectRequests(Seq<BuildPlan> requests) {
        for (BuildPlan req : requests) {
            if (req.block == null || !this.validPlace(req.x, req.y, req.block, req.rotation)) continue;
            BuildPlan other = this.getRequest(req.x, req.y, req.block.size, null);
            if (other == null) {
                this.selectRequests.add(req.copy());
                continue;
            }
            if (other.breaking || other.x != req.x || other.y != req.y || other.block.size != req.block.size) continue;
            this.selectRequests.remove(other);
            this.selectRequests.add(req.copy());
        }
    }

    protected void flushRequests(Seq<BuildPlan> requests) {
        for (BuildPlan req : requests) {
            if (req.block == null || !this.validPlace(req.x, req.y, req.block, req.rotation)) continue;
            BuildPlan copy = req.copy();
            req.block.onNewPlan(copy);
            Vars.player.unit().addBuild(copy);
        }
    }

    protected void drawOverRequest(BuildPlan request) {
        boolean valid = this.validPlace(request.x, request.y, request.block, request.rotation);
        Draw.reset();
        Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
        Draw.alpha(1.0f);
        request.block.drawRequestConfigTop(request, cons -> {
            this.selectRequests.each(cons);
            this.lineRequests.each(cons);
        });
        Draw.reset();
    }

    protected void drawRequest(BuildPlan request) {
        request.block.drawPlan(request, this.allRequests(), this.validPlace(request.x, request.y, request.block, request.rotation));
    }

    protected void drawRequest(int x, int y, Block block, int rotation) {
        this.brequest.set(x, y, rotation, block);
        this.brequest.animScale = 1.0f;
        block.drawPlan(this.brequest, this.allRequests(), this.validPlace(x, y, block, rotation));
    }

    protected void removeSelection(int x1, int y1, int x2, int y2) {
        this.removeSelection(x1, y1, x2, y2, false);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, int maxLength) {
        this.removeSelection(x1, y1, x2, y2, false, maxLength);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush) {
        this.removeSelection(x1, y1, x2, y2, flush, 100);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush, int maxLength) {
        Placement.NormalizeResult result = Placement.normalizeArea(x1, y1, x2, y2, this.rotation, false, maxLength);
        for (int x = 0; x <= Math.abs(result.x2 - result.x); ++x) {
            for (int y = 0; y <= Math.abs(result.y2 - result.y); ++y) {
                int wy;
                int wx = x1 + x * Mathf.sign(x2 - x1);
                Tile tile = Vars.world.tileBuilding(wx, wy = y1 + y * Mathf.sign(y2 - y1));
                if (tile == null) continue;
                if (!flush) {
                    this.tryBreakBlock(wx, wy);
                    continue;
                }
                if (!this.validBreak(tile.x, tile.y) || this.selectRequests.contains((BuildPlan)((Object)((Boolf<BuildPlan>)r -> r.tile() != null && r.tile() == tile)))) continue;
                this.selectRequests.add(new BuildPlan(tile.x, tile.y));
            }
        }
        Tmp.r1.set(result.x * 8, result.y * 8, (result.x2 - result.x) * 8, (result.y2 - result.y) * 8);
        Iterator<BuildPlan> it = Vars.player.unit().plans().iterator();
        while (it.hasNext()) {
            BuildPlan req = it.next();
            if (req.breaking || !req.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            it.remove();
        }
        it = this.selectRequests.iterator();
        while (it.hasNext()) {
            BuildPlan req = it.next();
            if (req.breaking || !req.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            it.remove();
        }
        Iterator<Teams.BlockPlan> broken = Vars.state.teams.get((Team)Vars.player.team()).blocks.iterator();
        while (broken.hasNext()) {
            Teams.BlockPlan req = broken.next();
            Block block = Vars.content.block(req.block);
            if (!block.bounds(req.x, req.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            broken.remove();
        }
    }

    protected void updateLine(int x1, int y1, int x2, int y2) {
        this.lineRequests.clear();
        this.iterateLine(x1, y1, x2, y2, l -> {
            this.rotation = l.rotation;
            BuildPlan req = new BuildPlan(l.x, l.y, l.rotation, this.block, this.block.nextConfig());
            req.animScale = 1.0f;
            this.lineRequests.add(req);
        });
        if (Core.settings.getBool("blockreplace")) {
            this.lineRequests.each(req -> {
                Block replace = req.block.getReplacement((BuildPlan)req, this.lineRequests);
                if (replace.unlockedNow()) {
                    req.block = replace;
                }
            });
            this.block.handlePlacementLine(this.lineRequests);
        }
    }

    protected void updateLine(int x1, int y1) {
        this.updateLine(x1, y1, this.tileX(this.getMouseX()), this.tileY(this.getMouseY()));
    }

    boolean tileTapped(@Nullable Building build) {
        if (build == null) {
            this.frag.inv.hide();
            this.frag.config.hideConfig();
            return false;
        }
        boolean consumed = false;
        boolean showedInventory = false;
        if (build.block.configurable && build.interactable(Vars.player.team())) {
            consumed = true;
            if (!this.frag.config.isShown() && build.shouldShowConfigure(Vars.player) || this.frag.config.isShown() && this.frag.config.getSelectedTile().onConfigureTileTapped(build)) {
                Sounds.click.at(build);
                this.frag.config.showConfig(build);
            }
        } else if (!this.frag.config.hasConfigMouse()) {
            if (this.frag.config.isShown() && this.frag.config.getSelectedTile().onConfigureTileTapped(build)) {
                consumed = true;
                this.frag.config.hideConfig();
            }
            if (this.frag.config.isShown()) {
                consumed = true;
            }
        }
        if (!consumed && build.interactable(Vars.player.team())) {
            build.tapped();
        }
        if (build.interactable(Vars.player.team()) && build.block.consumesTap) {
            consumed = true;
        } else if (build.interactable(Vars.player.team()) && build.block.synthetic() && !consumed && build.block.hasItems && build.items.total() > 0) {
            this.frag.inv.showFor(build);
            consumed = true;
            showedInventory = true;
        }
        if (!showedInventory) {
            this.frag.inv.hide();
        }
        return consumed;
    }

    boolean tryTapPlayer(float x, float y) {
        if (this.canTapPlayer(x, y)) {
            this.droppingItem = true;
            return true;
        }
        return false;
    }

    boolean canTapPlayer(float x, float y) {
        return Vars.player.within(x, y, playerSelectRange) && Vars.player.unit().stack.amount > 0;
    }

    boolean tryBeginMine(Tile tile) {
        if (this.canMine(tile)) {
            Vars.player.unit().mineTile = tile;
            return true;
        }
        return false;
    }

    boolean tryStopMine() {
        if (Vars.player.unit().mining()) {
            Vars.player.unit().mineTile = null;
            return true;
        }
        return false;
    }

    boolean tryStopMine(Tile tile) {
        if (Vars.player.unit().mineTile == tile) {
            Vars.player.unit().mineTile = null;
            return true;
        }
        return false;
    }

    boolean canMine(Tile tile) {
        return !Core.scene.hasMouse() && tile.drop() != null && Vars.player.unit().validMine(tile) && (!tile.floor().playerUnmineable || tile.overlay().itemDrop != null) && Vars.player.unit().acceptsItem(tile.drop()) && tile.block() == Blocks.air;
    }

    Tile tileAt(float x, float y) {
        return Vars.world.tile(this.tileX(x), this.tileY(y));
    }

    int rawTileX() {
        return World.toTile(Core.input.mouseWorld().x);
    }

    int rawTileY() {
        return World.toTile(Core.input.mouseWorld().y);
    }

    int tileX(float cursorX) {
        Vec2 vec = Core.input.mouseWorld(cursorX, 0.0f);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset, this.block.offset);
        }
        return World.toTile(vec.x);
    }

    int tileY(float cursorY) {
        Vec2 vec = Core.input.mouseWorld(0.0f, cursorY);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset, this.block.offset);
        }
        return World.toTile(vec.y);
    }

    public boolean selectedBlock() {
        return this.isPlacing();
    }

    public boolean isPlacing() {
        return this.block != null;
    }

    public boolean isBreaking() {
        return false;
    }

    public float mouseAngle(float x, float y) {
        return Core.input.mouseWorld(this.getMouseX(), this.getMouseY()).sub(x, y).angle();
    }

    @Nullable
    public Unit selectedUnit() {
        ControlBlock cont;
        Building build;
        Building building;
        Unit unit = Units.closest(Vars.player.team(), Core.input.mouseWorld().x, Core.input.mouseWorld().y, 40.0f, Unitc::isAI);
        if (unit != null) {
            unit.hitbox(Tmp.r1);
            Tmp.r1.grow(6.0f);
            if (Tmp.r1.contains(Core.input.mouseWorld())) {
                return unit;
            }
        }
        if ((building = (build = Vars.world.buildWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y))) instanceof ControlBlock && (cont = (ControlBlock)((Object)building)) == (ControlBlock)((Object)building) && cont.canControl() && build.team == Vars.player.team()) {
            return cont.unit();
        }
        return null;
    }

    public void remove() {
        Table table;
        Core.input.removeProcessor(this);
        this.frag.remove();
        if (Core.scene != null && (table = (Table)Core.scene.find("inputTable")) != null) {
            table.clear();
        }
        if (this.detector != null) {
            Core.input.removeProcessor(this.detector);
        }
        if (this.uiGroup != null) {
            this.uiGroup.remove();
            this.uiGroup = null;
        }
    }

    public void add() {
        Core.input.getInputProcessors().remove(i -> i instanceof InputHandler || i instanceof GestureDetector && ((GestureDetector)i).getListener() instanceof InputHandler);
        this.detector = new GestureDetector(20.0f, 0.5f, 0.3f, 0.15f, this);
        Core.input.addProcessor(this.detector);
        Core.input.addProcessor(this);
        if (Core.scene != null) {
            Table table = (Table)Core.scene.find("inputTable");
            if (table != null) {
                table.clear();
                this.buildPlacementUI(table);
            }
            this.uiGroup = new WidgetGroup();
            this.uiGroup.touchable = Touchable.childrenOnly;
            this.uiGroup.setFillParent(true);
            Vars.ui.hudGroup.addChild(this.uiGroup);
            this.uiGroup.toBack();
            this.buildUI(this.uiGroup);
            this.frag.add();
        }
    }

    public boolean canShoot() {
        return this.block == null && !this.onConfigurable() && !this.isDroppingItem() && !Vars.player.unit().activelyBuilding() && (!(Vars.player.unit() instanceof Mechc) || !Vars.player.unit().isFlying()) && !Vars.player.unit().mining();
    }

    public boolean onConfigurable() {
        return false;
    }

    public boolean isDroppingItem() {
        return this.droppingItem;
    }

    public boolean canDropItem() {
        return this.droppingItem && !this.canTapPlayer(Core.input.mouseWorldX(), Core.input.mouseWorldY());
    }

    public void tryDropItems(@Nullable Building build, float x, float y) {
        if (!this.droppingItem || Vars.player.unit().stack.amount <= 0 || this.canTapPlayer(x, y) || Vars.state.isPaused()) {
            this.droppingItem = false;
            return;
        }
        this.droppingItem = false;
        ItemStack stack = Vars.player.unit().stack;
        if (build != null && build.acceptStack(stack.item, stack.amount, Vars.player.unit()) > 0 && build.interactable(Vars.player.team()) && build.block.hasItems && Vars.player.unit().stack().amount > 0 && build.interactable(Vars.player.team())) {
            Call.transferInventory(Vars.player, build);
        } else {
            Call.dropItem(Vars.player.angleTo(x, y));
        }
    }

    public void tryBreakBlock(int x, int y) {
        if (this.validBreak(x, y)) {
            this.breakBlock(x, y);
        }
    }

    public boolean validPlace(int x, int y, Block type, int rotation) {
        return this.validPlace(x, y, type, rotation, null);
    }

    public boolean validPlace(int x, int y, Block type, int rotation, BuildPlan ignore) {
        for (BuildPlan req : Vars.player.unit().plans()) {
            if (req == ignore || req.breaking || !req.block.bounds(req.x, req.y, Tmp.r1).overlaps(type.bounds(x, y, Tmp.r2)) || type.canReplace(req.block) && Tmp.r1.equals(Tmp.r2)) continue;
            return false;
        }
        return Build.validPlace(type, Vars.player.team(), x, y, rotation);
    }

    public boolean validBreak(int x, int y) {
        return Build.validBreak(Vars.player.team(), x, y);
    }

    public void breakBlock(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && tile.build != null) {
            tile = tile.build.tile;
        }
        Vars.player.unit().addBuild(new BuildPlan(tile.x, tile.y));
    }

    public void drawArrow(Block block, int x, int y, int rotation) {
        this.drawArrow(block, x, y, rotation, this.validPlace(x, y, block, rotation));
    }

    public void drawArrow(Block block, int x, int y, int rotation, boolean valid) {
        float trns = block.size / 2 * 8;
        int dx = Geometry.d4((int)rotation).x;
        int dy = Geometry.d4((int)rotation).y;
        Draw.color(!valid ? Pal.removeBack : Pal.accentBack);
        Draw.rect(Core.atlas.find("place-arrow"), (float)(x * 8) + block.offset + (float)dx * trns, (float)(y * 8) + block.offset - 1.0f + (float)dy * trns, (float)Core.atlas.find((String)"place-arrow").width * Draw.scl, (float)Core.atlas.find((String)"place-arrow").height * Draw.scl, (float)(rotation * 90 - 90));
        Draw.color(!valid ? Pal.remove : Pal.accent);
        Draw.rect(Core.atlas.find("place-arrow"), (float)(x * 8) + block.offset + (float)dx * trns, (float)(y * 8) + block.offset + (float)dy * trns, (float)Core.atlas.find((String)"place-arrow").width * Draw.scl, (float)Core.atlas.find((String)"place-arrow").height * Draw.scl, (float)(rotation * 90 - 90));
    }

    void iterateLine(int startX, int startY, int endX, int endY, Cons<PlaceLine> cons) {
        Seq<Point2> points;
        boolean diagonal = Core.input.keyDown(Binding.diagonal_placement);
        if (Core.settings.getBool("swapdiagonal") && Vars.mobile) {
            boolean bl = diagonal = !diagonal;
        }
        if (this.block != null && this.block.swapDiagonalPlacement) {
            boolean bl = diagonal = !diagonal;
        }
        if (diagonal) {
            Building start = Vars.world.build(startX, startY);
            Building end = Vars.world.build(endX, endY);
            points = this.block != null && start instanceof ChainedBuilding && end instanceof ChainedBuilding && this.block.canReplace(end.block) && this.block.canReplace(start.block) ? Placement.upgradeLine(startX, startY, endX, endY) : Placement.pathfindLine(this.block != null && this.block.conveyorPlacement, startX, startY, endX, endY);
        } else {
            points = Placement.normalizeLine(startX, startY, endX, endY);
        }
        if (this.block != null) {
            this.block.changePlacementPath(points, this.rotation);
        }
        float angle = Angles.angle(startX, startY, endX, endY);
        int baseRotation = this.rotation;
        if (!this.overrideLineRotation || diagonal) {
            baseRotation = startX == endX && startY == endY ? this.rotation : (int)((angle + 45.0f) / 90.0f) % 4;
        }
        Tmp.r3.set(-1.0f, -1.0f, 0.0f, 0.0f);
        for (int i = 0; i < points.size; ++i) {
            Point2 point = points.get(i);
            if (this.block != null && Tmp.r2.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset, (float)(point.y * 8) + this.block.offset).overlaps(Tmp.r3)) continue;
            Point2 next = i == points.size - 1 ? null : points.get(i + 1);
            this.line.x = point.x;
            this.line.y = point.y;
            if (!this.overrideLineRotation || diagonal) {
                if (next != null) {
                    this.line.rotation = Tile.relativeTo(point.x, point.y, next.x, next.y);
                } else if (this.block.conveyorPlacement && i > 0) {
                    Point2 prev = points.get(i - 1);
                    this.line.rotation = Tile.relativeTo(prev.x, prev.y, point.x, point.y);
                } else {
                    this.line.rotation = baseRotation;
                }
            } else {
                this.line.rotation = this.rotation;
            }
            this.line.last = next == null;
            cons.get(this.line);
            Tmp.r3.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset, (float)(point.y * 8) + this.block.offset);
        }
    }

    static class PlaceLine {
        public int x;
        public int y;
        public int rotation;
        public boolean last;

        PlaceLine() {
        }
    }
}

