/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.func.Boolp;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.GestureDetector;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Group;
import arc.scene.style.Drawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.BlockUnitUnit;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.input.PlaceMode;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;

public class MobileInput
extends InputHandler
implements GestureDetector.GestureListener {
    private static final float maxPanSpeed = 1.3f;
    public final float edgePan = Scl.scl(60.0f);
    public Vec2 vector = new Vec2();
    public Vec2 movement = new Vec2();
    public Vec2 targetPos = new Vec2();
    public float lastZoom = -1.0f;
    public int lineStartX;
    public int lineStartY;
    public int lastLineX;
    public int lastLineY;
    public float lineScale;
    public float crosshairScale;
    public Teamc lastTarget;
    public float shiftDeltaX;
    public float shiftDeltaY;
    public Seq<BuildPlan> removals = new Seq();
    public boolean selecting;
    public boolean lineMode;
    public boolean schematicMode;
    public PlaceMode mode = PlaceMode.none;
    public Block lastBlock;
    public BuildPlan lastPlaced;
    public boolean down = false;
    public boolean manualShooting = false;
    public Teamc target;
    public Position payloadTarget;
    public Unit unitTapped;

    void checkTargets(float x, float y) {
        Unit unit = Units.closestEnemy(Vars.player.team(), x, y, 20.0f, u -> !u.dead);
        if (unit != null) {
            Vars.player.unit().mineTile = null;
            this.target = unit;
        } else {
            Building tile = Vars.world.buildWorld(x, y);
            if (tile != null && Vars.player.team().isEnemy(tile.team) && tile.team != Team.derelict || tile != null && Vars.player.unit().type.canHeal && tile.team == Vars.player.team() && tile.damaged()) {
                Vars.player.unit().mineTile = null;
                this.target = tile;
            }
        }
    }

    boolean hasRequest(Tile tile) {
        return this.getRequest(tile) != null;
    }

    boolean checkOverlapPlacement(int x, int y, Block block) {
        Tile other;
        r2.setSize(block.size * 8);
        r2.setCenter((float)(x * 8) + block.offset, (float)(y * 8) + block.offset);
        for (BuildPlan req : this.selectRequests) {
            other = req.tile();
            if (other == null || req.breaking) continue;
            r1.setSize(req.block.size * 8);
            r1.setCenter(other.worldx() + req.block.offset, other.worldy() + req.block.offset);
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        for (BuildPlan req : Vars.player.unit().plans()) {
            other = Vars.world.tile(req.x, req.y);
            if (other == null || req.breaking) continue;
            r1.setSize(req.block.size * 8);
            r1.setCenter(other.worldx() + req.block.offset, other.worldy() + req.block.offset);
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        return false;
    }

    BuildPlan getRequest(Tile tile) {
        r2.setSize(8.0f);
        r2.setCenter(tile.worldx(), tile.worldy());
        for (BuildPlan req : this.selectRequests) {
            Tile other = req.tile();
            if (other == null) continue;
            if (!req.breaking) {
                r1.setSize(req.block.size * 8);
                r1.setCenter(other.worldx() + req.block.offset, other.worldy() + req.block.offset);
            } else {
                r1.setSize(other.block().size * 8);
                r1.setCenter(other.worldx() + other.block().offset, other.worldy() + other.block().offset);
            }
            if (!r2.overlaps(r1)) continue;
            return req;
        }
        return null;
    }

    void removeRequest(BuildPlan request) {
        this.selectRequests.remove(request, true);
        if (!request.breaking) {
            this.removals.add(request);
        }
    }

    boolean isLinePlacing() {
        return this.mode == PlaceMode.placing && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 24.0f;
    }

    boolean isAreaBreaking() {
        return this.mode == PlaceMode.breaking && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 16.0f;
    }

    @Override
    public void buildPlacementUI(Table table) {
        table.image().color(Pal.gray).height(4.0f).colspan(4).growX();
        table.row();
        table.left().margin(0.0f).defaults().size(48.0f);
        table.button((Drawable)Icon.hammer, Styles.clearTogglePartiali, () -> {
            this.mode = this.mode == PlaceMode.breaking ? (this.block == null ? PlaceMode.none : PlaceMode.placing) : PlaceMode.breaking;
            this.lastBlock = this.block;
        }).update(l -> l.setChecked(this.mode == PlaceMode.breaking)).name("breakmode");
        table.button((Drawable)Icon.diagonal, Styles.clearTogglePartiali, () -> Core.settings.put("swapdiagonal", !Core.settings.getBool("swapdiagonal"))).update(l -> l.setChecked(Core.settings.getBool("swapdiagonal")));
        table.button((Drawable)Icon.right, Styles.clearTogglePartiali, () -> {
            if (this.block != null && this.block.rotate) {
                this.rotation = Mathf.mod(this.rotation + 1, 4);
            } else {
                boolean bl = this.schematicMode = !this.schematicMode;
                if (this.schematicMode) {
                    this.block = null;
                    this.mode = PlaceMode.none;
                }
            }
        }).update(i -> {
            boolean arrow = this.block != null && this.block.rotate;
            i.getImage().setRotationOrigin(!arrow ? 0.0f : (float)(this.rotation * 90), 1);
            i.getStyle().imageUp = arrow ? Icon.right : Icon.copy;
            i.setChecked(!arrow && this.schematicMode);
        });
        table.button((Drawable)Icon.ok, Styles.clearPartiali, () -> {
            for (BuildPlan request : this.selectRequests) {
                Tile tile = request.tile();
                if (tile == null) continue;
                if (!request.breaking) {
                    if (this.validPlace(request.x, request.y, request.block, request.rotation)) {
                        BuildPlan other = this.getRequest(request.x, request.y, request.block.size, null);
                        BuildPlan copy = request.copy();
                        if (other == null) {
                            Vars.player.unit().addBuild(copy);
                        } else if (!other.breaking && other.x == request.x && other.y == request.y && other.block.size == request.block.size) {
                            Vars.player.unit().plans().remove(other);
                            Vars.player.unit().addBuild(copy);
                        }
                    }
                    this.rotation = request.rotation;
                    continue;
                }
                this.tryBreakBlock(tile.x, tile.y);
            }
            this.removals.addAll(this.selectRequests.select(r -> !r.breaking));
            this.selectRequests.clear();
            this.selecting = false;
        }).visible(() -> !this.selectRequests.isEmpty()).name("confirmplace");
    }

    @Override
    public void buildUI(Group group) {
        Boolp schem = () -> this.lastSchematic != null && !this.selectRequests.isEmpty();
        group.fill(t -> {
            t.visible(() -> (Vars.player.unit().isBuilding() || this.block != null || this.mode == PlaceMode.breaking || !this.selectRequests.isEmpty()) && !schem.get());
            t.bottom().left();
            t.button("@cancel", Icon.cancel, () -> {
                Vars.player.unit().clearBuilding();
                this.selectRequests.clear();
                this.mode = PlaceMode.none;
                this.block = null;
            }).width(155.0f).height(50.0f).margin(12.0f);
        });
        group.fill(t -> {
            t.visible(schem);
            t.bottom().left();
            t.table(Tex.pane, b -> {
                b.defaults().size(50.0f);
                ImageButton.ImageButtonStyle style = Styles.clearPartiali;
                b.button((Drawable)Icon.save, style, this::showSchematicSave).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null);
                b.button((Drawable)Icon.cancel, style, () -> this.selectRequests.clear());
                b.row();
                b.button((Drawable)Icon.flipX, style, () -> this.flipRequests(this.selectRequests, true));
                b.button((Drawable)Icon.flipY, style, () -> this.flipRequests(this.selectRequests, false));
                b.row();
                b.button((Drawable)Icon.rotate, style, () -> this.rotateRequests(this.selectRequests, 1));
            }).margin(4.0f);
        });
    }

    @Override
    public void drawBottom() {
        Lines.stroke(1.0f);
        for (BuildPlan request : this.removals) {
            Tile tile = request.tile();
            if (tile == null) continue;
            request.animScale = Mathf.lerpDelta(request.animScale, 0.0f, 0.2f);
            if (request.breaking) {
                this.drawSelected(request.x, request.y, tile.block(), Pal.remove);
                continue;
            }
            request.block.drawPlan(request, this.allRequests(), true);
        }
        Draw.mixcol();
        Draw.color(Pal.accent);
        if (this.lineMode) {
            int tileX = this.tileX(Core.input.mouseX());
            int tileY = this.tileY(Core.input.mouseY());
            if (this.mode == PlaceMode.placing && this.block != null) {
                for (int i = 0; i < this.lineRequests.size; ++i) {
                    BuildPlan request = (BuildPlan)this.lineRequests.get(i);
                    if (i == this.lineRequests.size - 1 && request.block.rotate) {
                        this.drawArrow(this.block, request.x, request.y, request.rotation);
                    }
                    request.block.drawPlan(request, this.allRequests(), this.validPlace(request.x, request.y, request.block, request.rotation) && this.getRequest(request.x, request.y, request.block.size, null) == null);
                    this.drawSelected(request.x, request.y, request.block, Pal.accent);
                }
                this.lineRequests.each(this::drawOverRequest);
            } else if (this.mode == PlaceMode.breaking) {
                this.drawBreakSelection(this.lineStartX, this.lineStartY, tileX, tileY);
            }
        }
        Draw.reset();
    }

    @Override
    public void drawTop() {
        if (this.mode == PlaceMode.schematicSelect) {
            this.drawSelection(this.lineStartX, this.lineStartY, this.lastLineX, this.lastLineY, 32);
        }
    }

    @Override
    public void drawOverSelect() {
        for (BuildPlan request : this.selectRequests) {
            Tile tile = request.tile();
            if (tile == null) continue;
            request.animScale = !request.breaking && this.validPlace(tile.x, tile.y, request.block, request.rotation) || request.breaking && this.validBreak(tile.x, tile.y) ? Mathf.lerpDelta(request.animScale, 1.0f, 0.2f) : Mathf.lerpDelta(request.animScale, 0.6f, 0.1f);
            Tmp.c1.set(Draw.getMixColor());
            if (!request.breaking && request == this.lastPlaced && request.block != null) {
                Draw.mixcol();
                if (request.block.rotate) {
                    this.drawArrow(request.block, tile.x, tile.y, request.rotation);
                }
            }
            Draw.reset();
            this.drawRequest(request);
            if (!request.breaking) {
                this.drawOverRequest(request);
            }
            if (request.breaking || request != this.lastPlaced || request.block == null) continue;
            Draw.mixcol();
            request.block.drawPlace(tile.x, tile.y, this.rotation, this.validPlace(tile.x, tile.y, request.block, this.rotation));
        }
        if (this.target != null && !Vars.state.isEditor() && !this.manualShooting) {
            if (this.target != this.lastTarget) {
                this.crosshairScale = 0.0f;
                this.lastTarget = this.target;
            }
            this.crosshairScale = Mathf.lerpDelta(this.crosshairScale, 1.0f, 0.2f);
            Drawf.target(this.target.getX(), this.target.getY(), 7.0f * Interp.swingIn.apply(this.crosshairScale), Pal.remove);
        }
        Draw.reset();
    }

    @Override
    protected void drawRequest(BuildPlan request) {
        if (request.tile() == null) {
            return;
        }
        this.brequest.animScale = request.animScale = Mathf.lerpDelta(request.animScale, 1.0f, 0.1f);
        if (request.breaking) {
            this.drawSelected(request.x, request.y, request.tile().block(), Pal.remove);
        } else {
            request.block.drawPlan(request, this.allRequests(), this.validPlace(request.x, request.y, request.block, request.rotation));
            this.drawSelected(request.x, request.y, request.block, Pal.accent);
        }
    }

    @Override
    protected int schemOriginX() {
        Tmp.v1.setZero();
        this.selectRequests.each(r -> Tmp.v1.add(r.drawx(), r.drawy()));
        return World.toTile(Tmp.v1.scl((float)(1.0f / (float)this.selectRequests.size)).x);
    }

    @Override
    protected int schemOriginY() {
        Tmp.v1.setZero();
        this.selectRequests.each(r -> Tmp.v1.add(r.drawx(), r.drawy()));
        return World.toTile(Tmp.v1.scl((float)(1.0f / (float)this.selectRequests.size)).y);
    }

    @Override
    public boolean isPlacing() {
        return super.isPlacing() && this.mode == PlaceMode.placing;
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public void useSchematic(Schematic schem) {
        this.selectRequests.clear();
        this.selectRequests.addAll(Vars.schematics.toRequests(schem, World.toTile(Core.camera.position.x), World.toTile(Core.camera.position.y)));
        this.lastSchematic = schem;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        if (Vars.state.isMenu()) {
            return false;
        }
        this.down = true;
        if (Vars.player.dead()) {
            return false;
        }
        Tile cursor = this.tileAt(screenX, screenY);
        float worldx = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x;
        float worldy = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y;
        if (cursor == null || Core.scene.hasMouse(screenX, screenY)) {
            return false;
        }
        this.selecting = this.hasRequest(cursor);
        if (pointer == 0 && !this.selecting) {
            if (this.schematicMode && this.block == null) {
                this.mode = PlaceMode.schematicSelect;
                int tileX = this.tileX(screenX);
                int tileY = this.tileY(screenY);
                this.lineStartX = tileX;
                this.lineStartY = tileY;
                this.lastLineX = tileX;
                this.lastLineY = tileY;
            } else if (!this.tryTapPlayer(worldx, worldy) && Core.settings.getBool("keyboard")) {
                Vars.player.shooting = true;
            }
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        this.lastZoom = Vars.renderer.getScale();
        if (!Core.input.isTouched()) {
            this.down = false;
        }
        this.manualShooting = false;
        this.selecting = false;
        if (this.lineMode) {
            int tileX = this.tileX(screenX);
            int tileY = this.tileY(screenY);
            if (this.mode == PlaceMode.placing && this.isPlacing()) {
                this.flushSelectRequests(this.lineRequests);
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.lineStartX, this.lineStartY, tileX, tileY, true);
            }
            this.lineMode = false;
        } else if (this.mode == PlaceMode.schematicSelect) {
            this.selectRequests.clear();
            this.lastSchematic = Vars.schematics.create(this.lineStartX, this.lineStartY, this.lastLineX, this.lastLineY);
            this.useSchematic(this.lastSchematic);
            if (this.selectRequests.isEmpty()) {
                this.lastSchematic = null;
            }
            this.schematicMode = false;
            this.mode = PlaceMode.none;
        } else {
            Tile tile = this.tileAt(screenX, screenY);
            this.tryDropItems(tile == null ? null : tile.build, Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x, Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y);
        }
        return false;
    }

    @Override
    public boolean longPress(float x, float y) {
        if (Vars.state.isMenu() || Vars.player.dead()) {
            return false;
        }
        Tile cursor = this.tileAt(x, y);
        if (Core.scene.hasMouse(x, y) || this.schematicMode) {
            return false;
        }
        if (this.mode == PlaceMode.none) {
            Payloadc pay;
            Vec2 pos = Core.input.mouseWorld(x, y);
            Unit unit = Vars.player.unit();
            if (unit instanceof Payloadc && (pay = (Payloadc)((Object)unit)) == (Payloadc)((Object)unit)) {
                Unit target = Units.closest(Vars.player.team(), pos.x, pos.y, 8.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(pos, u.hitSize + 8.0f));
                if (target != null) {
                    this.payloadTarget = target;
                } else {
                    Building build = Vars.world.buildWorld(pos.x, pos.y);
                    if (build != null && build.team == Vars.player.team() && pay.canPickup(build)) {
                        this.payloadTarget = build;
                    } else if (pay.hasPayload()) {
                        this.payloadTarget = new Vec2(pos);
                    } else {
                        this.manualShooting = true;
                        this.target = null;
                    }
                }
            } else {
                this.manualShooting = true;
                this.target = null;
            }
            if (!Vars.state.isPaused()) {
                Fx.select.at(pos);
            }
        } else {
            if (cursor == null) {
                return false;
            }
            this.lineStartX = cursor.x;
            this.lineStartY = cursor.y;
            this.lastLineX = cursor.x;
            this.lastLineY = cursor.y;
            this.lineMode = true;
            if (this.mode == PlaceMode.breaking) {
                if (!Vars.state.isPaused()) {
                    Fx.tapBlock.at(cursor.worldx(), cursor.worldy(), 1.0f);
                }
            } else if (this.block != null) {
                this.updateLine(this.lineStartX, this.lineStartY, cursor.x, cursor.y);
                if (!Vars.state.isPaused()) {
                    Fx.tapBlock.at(cursor.worldx() + this.block.offset, cursor.worldy() + this.block.offset, this.block.size);
                }
            }
        }
        return false;
    }

    @Override
    public boolean tap(float x, float y, int count, KeyCode button) {
        Tile linked;
        if (Vars.state.isMenu() || this.lineMode) {
            return false;
        }
        float worldx = Core.input.mouseWorld((float)x, (float)y).x;
        float worldy = Core.input.mouseWorld((float)x, (float)y).y;
        Tile cursor = this.tileAt(x, y);
        if (cursor == null || Core.scene.hasMouse(x, y)) {
            return false;
        }
        Call.tileTap(Vars.player, cursor);
        Tile tile = linked = cursor.build == null ? cursor : cursor.build.tile;
        if (!Vars.player.dead()) {
            this.checkTargets(worldx, worldy);
        }
        if (this.hasRequest(cursor)) {
            this.removeRequest(this.getRequest(cursor));
        } else if (this.mode == PlaceMode.placing && this.isPlacing() && this.validPlace(cursor.x, cursor.y, this.block, this.rotation) && !this.checkOverlapPlacement(cursor.x, cursor.y, this.block)) {
            this.lastPlaced = new BuildPlan(cursor.x, cursor.y, this.rotation, this.block, this.block.nextConfig());
            this.selectRequests.add(this.lastPlaced);
            this.block.onNewPlan(this.lastPlaced);
        } else if (this.mode == PlaceMode.breaking && this.validBreak(linked.x, linked.y) && !this.hasRequest(linked)) {
            this.selectRequests.add(new BuildPlan(linked.x, linked.y));
        } else {
            if (count == 2) {
                this.payloadTarget = null;
                if (!Vars.player.dead() && Mathf.within(worldx, worldy, Vars.player.unit().x, Vars.player.unit().y, Vars.player.unit().hitSize * 0.6f + 8.0f) && Vars.player.unit().type.commandLimit > 0) {
                    Call.unitCommand(Vars.player);
                } else if (this.unitTapped != null) {
                    Call.unitControl(Vars.player, this.unitTapped);
                } else if (!this.tryBeginMine(cursor)) {
                    this.tileTapped(linked.build);
                }
                return false;
            }
            this.unitTapped = this.selectedUnit();
            if (!(this.tryStopMine() || this.canTapPlayer(worldx, worldy) || this.tileTapped(linked.build) || this.mode != PlaceMode.none || Core.settings.getBool("doubletapmine"))) {
                this.tryBeginMine(cursor);
            }
        }
        return false;
    }

    @Override
    public void updateState() {
        super.updateState();
        if (Vars.state.isMenu()) {
            this.selectRequests.clear();
            this.removals.clear();
            this.mode = PlaceMode.none;
            this.manualShooting = false;
            this.payloadTarget = null;
        }
    }

    @Override
    public void update() {
        super.update();
        if (Vars.player.dead()) {
            this.mode = PlaceMode.none;
            this.manualShooting = false;
            this.payloadTarget = null;
        }
        if (!(!(Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f) || Core.input.keyDown(Binding.rotateplaced) || !Core.input.keyDown(Binding.diagonal_placement) && (Vars.player.isBuilder() && this.isPlacing() && this.block.rotate || !this.selectRequests.isEmpty()))) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (!Core.settings.getBool("keyboard")) {
            float camSpeed = 6.0f;
            Core.camera.position.add(Tmp.v1.setZero().add(Core.input.axis(Binding.move_x), Core.input.axis(Binding.move_y)).nor().scl(Time.delta * camSpeed));
        }
        if (Core.settings.getBool("keyboard")) {
            if (Core.input.keyRelease(Binding.select)) {
                Vars.player.shooting = false;
            }
            if (Vars.player.shooting && !this.canShoot()) {
                Vars.player.shooting = false;
            }
        }
        if (!Vars.player.dead() && !Vars.state.isPaused()) {
            this.updateMovement(Vars.player.unit());
        }
        if (this.mode == PlaceMode.none) {
            this.lineMode = false;
        }
        if (this.lineMode && this.mode == PlaceMode.placing && this.block == null) {
            this.lineMode = false;
        }
        if (this.block != null && this.mode == PlaceMode.none) {
            this.mode = PlaceMode.placing;
        }
        if (this.block == null && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (this.block != null) {
            this.schematicMode = false;
        }
        if (!this.schematicMode && this.mode == PlaceMode.schematicSelect) {
            this.mode = PlaceMode.none;
        }
        if (this.mode == PlaceMode.schematicSelect) {
            this.lastLineX = this.rawTileX();
            this.lastLineY = this.rawTileY();
            this.autoPan();
        }
        if (this.lastBlock != this.block && this.mode == PlaceMode.breaking && this.block != null) {
            this.mode = PlaceMode.placing;
            this.lastBlock = this.block;
        }
        if (this.lineMode) {
            this.lineScale = Mathf.lerpDelta(this.lineScale, 1.0f, 0.1f);
            if (Core.input.isTouched(0)) {
                this.autoPan();
            }
            int lx = this.tileX(Core.input.mouseX());
            int ly = this.tileY(Core.input.mouseY());
            if ((this.lastLineX != lx || this.lastLineY != ly) && this.isPlacing()) {
                this.lastLineX = lx;
                this.lastLineY = ly;
                this.updateLine(this.lineStartX, this.lineStartY, lx, ly);
            }
        } else {
            this.lineRequests.clear();
            this.lineScale = 0.0f;
        }
        for (int i = this.removals.size - 1; i >= 0; --i) {
            BuildPlan request = this.removals.get(i);
            if (!(request.animScale <= 1.0E-4f)) continue;
            this.removals.remove(i);
            --i;
        }
        if (Vars.player.shooting && (Vars.player.unit().activelyBuilding() || Vars.player.unit().mining())) {
            Vars.player.shooting = false;
        }
    }

    protected void autoPan() {
        float screenX = Core.input.mouseX();
        float screenY = Core.input.mouseY();
        float panX = 0.0f;
        float panY = 0.0f;
        if (screenX <= this.edgePan) {
            panX = -(this.edgePan - screenX);
        }
        if (screenX >= (float)Core.graphics.getWidth() - this.edgePan) {
            panX = screenX - (float)Core.graphics.getWidth() + this.edgePan;
        }
        if (screenY <= this.edgePan) {
            panY = -(this.edgePan - screenY);
        }
        if (screenY >= (float)Core.graphics.getHeight() - this.edgePan) {
            panY = screenY - (float)Core.graphics.getHeight() + this.edgePan;
        }
        this.vector.set(panX, panY).scl(Core.camera.width / (float)Core.graphics.getWidth());
        this.vector.limit(1.3f);
        Core.camera.position.x += this.vector.x;
        Core.camera.position.y += this.vector.y;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (Core.scene == null || Core.scene.hasDialog() || Core.settings.getBool("keyboard")) {
            return false;
        }
        float scale = Core.camera.width / (float)Core.graphics.getWidth();
        deltaX *= scale;
        deltaY *= scale;
        if (this.lineMode && !Core.input.isTouched(1) || this.droppingItem || this.schematicMode) {
            return false;
        }
        if (!this.down || this.manualShooting) {
            return false;
        }
        if (this.selecting) {
            this.shiftDeltaX += deltaX;
            this.shiftDeltaY += deltaY;
            int shiftedX = (int)(this.shiftDeltaX / 8.0f);
            int shiftedY = (int)(this.shiftDeltaY / 8.0f);
            if (Math.abs(shiftedX) > 0 || Math.abs(shiftedY) > 0) {
                for (BuildPlan req : this.selectRequests) {
                    if (req.breaking) continue;
                    req.x += shiftedX;
                    req.y += shiftedY;
                }
                this.shiftDeltaX %= 8.0f;
                this.shiftDeltaY %= 8.0f;
            }
        } else if (!Vars.renderer.isLanding()) {
            Core.camera.position.x -= deltaX;
            Core.camera.position.y -= deltaY;
        }
        return false;
    }

    @Override
    public boolean panStop(float x, float y, int pointer, KeyCode button) {
        this.shiftDeltaY = 0.0f;
        this.shiftDeltaX = 0.0f;
        return false;
    }

    @Override
    public boolean zoom(float initialDistance, float distance) {
        if (Core.settings.getBool("keyboard")) {
            return false;
        }
        if (this.lastZoom < 0.0f) {
            this.lastZoom = Vars.renderer.getScale();
        }
        Vars.renderer.setScale(distance / initialDistance * this.lastZoom);
        return true;
    }

    protected void updateMovement(Unit unit) {
        Position position;
        Payloadc pay;
        Unit unit2;
        boolean aimCursor;
        boolean boosted;
        Rect rect = Tmp.r3;
        UnitType type = unit.type;
        if (type == null) {
            return;
        }
        boolean omni = unit.type.omniMovement;
        boolean allowHealing = type.canHeal;
        boolean validHealTarget = allowHealing && this.target instanceof Building && ((Building)this.target).isValid() && this.target.team() == unit.team && ((Building)this.target).damaged() && this.target.within(unit, type.range);
        boolean bl = boosted = unit instanceof Mechc && unit.isFlying();
        if (Units.invalidateTarget(this.target, unit, type.range) && !validHealTarget || Vars.state.isEditor()) {
            this.target = null;
        }
        this.targetPos.set(Core.camera.position);
        float attractDst = 15.0f;
        float speed = unit.realSpeed();
        float range = unit.hasWeapons() ? unit.range() : 0.0f;
        float bulletSpeed = unit.hasWeapons() ? type.weapons.first().bullet.speed : 0.0f;
        float mouseAngle = unit.angleTo(unit.aimX(), unit.aimY());
        boolean bl2 = aimCursor = omni && Vars.player.shooting && type.hasWeapons() && type.faceTarget && !boosted && type.rotateShooting;
        if (aimCursor) {
            unit.lookAt(mouseAngle);
        } else {
            unit.lookAt(unit.prefRotation());
        }
        if (this.payloadTarget != null && (unit2 = unit) instanceof Payloadc && (pay = (Payloadc)((Object)unit2)) == (Payloadc)((Object)unit2)) {
            this.targetPos.set(this.payloadTarget);
            attractDst = 0.0f;
            if (unit.within(this.payloadTarget, 3.0f * Time.delta)) {
                if (this.payloadTarget instanceof Vec2 && pay.hasPayload()) {
                    this.tryDropPayload();
                } else {
                    Building build;
                    position = this.payloadTarget;
                    if (position instanceof Building && (build = (Building)position) == (Building)position && pay.canPickup(build)) {
                        Call.requestBuildPayload(Vars.player, build);
                    } else {
                        Unit other;
                        position = this.payloadTarget;
                        if (position instanceof Unit && (other = (Unit)position) == (Unit)position && pay.canPickup(other)) {
                            Call.requestUnitPayload(Vars.player, other);
                        }
                    }
                }
                this.payloadTarget = null;
            }
        } else {
            this.payloadTarget = null;
        }
        this.movement.set(this.targetPos).sub(Vars.player).limit(speed);
        this.movement.setAngle(Mathf.slerp(this.movement.angle(), unit.vel.angle(), 0.05f));
        if (Vars.player.within(this.targetPos, attractDst)) {
            this.movement.setZero();
            unit.vel.approachDelta(Vec2.ZERO, unit.speed() * type.accel / 2.0f);
        }
        float expansion = 3.0f;
        unit.hitbox(rect);
        rect.x -= expansion;
        rect.y -= expansion;
        rect.width += expansion * 2.0f;
        rect.height += expansion * 2.0f;
        boolean bl3 = Vars.player.boosting = Vars.collisions.overlapsTile(rect) || !unit.within(this.targetPos, 85.0f);
        if (omni) {
            unit.moveAt(this.movement);
        } else {
            unit.moveAt(Tmp.v2.trns(unit.rotation, this.movement.len()));
            if (!this.movement.isZero()) {
                unit.vel.rotateTo(this.movement.angle(), unit.type.rotateSpeed * Math.max(Time.delta, 1.0f));
            }
        }
        if (!Vars.player.unit().activelyBuilding() && Vars.player.unit().mineTile == null) {
            if (this.manualShooting) {
                Vars.player.shooting = !boosted;
                Vars.player.mouseX = Core.input.mouseWorldX();
                Vars.player.mouseY = Core.input.mouseWorldY();
                unit.aim(Vars.player.mouseX, Vars.player.mouseY);
            } else if (this.target == null) {
                ControlBlock c;
                BlockUnitUnit u2;
                Vars.player.shooting = false;
                if (Core.settings.getBool("autotarget") && (!((position = Vars.player.unit()) instanceof BlockUnitUnit) || (u2 = (BlockUnitUnit)position) != (BlockUnitUnit)position || !((position = u2.tile()) instanceof ControlBlock) || (c = (ControlBlock)((Object)position)) != (ControlBlock)((Object)position) || c.shouldAutoTarget())) {
                    this.target = Units.closestTarget(unit.team, unit.x, unit.y, range, u -> u.team != Team.derelict, u -> u.team != Team.derelict);
                    if (allowHealing && this.target == null) {
                        this.target = Geometry.findClosest(unit.x, unit.y, Vars.indexer.getDamaged(Team.sharded));
                        if (this.target != null && !unit.within(this.target, range)) {
                            this.target = null;
                        }
                    }
                }
                unit.aim(Core.input.mouseWorldX(), Core.input.mouseWorldY());
            } else {
                Vec2 intercept = Predict.intercept((Position)unit, this.target, bulletSpeed);
                Vars.player.mouseX = intercept.x;
                Vars.player.mouseY = intercept.y;
                Vars.player.shooting = !boosted;
                unit.aim(Vars.player.mouseX, Vars.player.mouseY);
            }
        }
        unit.controlWeapons(Vars.player.shooting && !boosted);
    }
}

