/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.util.serialization.Json;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import java.io.IOException;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Rules;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.world.Block;

public class JsonIO {
    private static final CustomJson jsonBase = new CustomJson();
    public static final Json json = new Json(){
        {
            JsonIO.apply(this);
        }

        @Override
        public void writeValue(Object value, Class knownType, Class elementType) {
            if (value instanceof MappableContent) {
                try {
                    this.getWriter().value(((MappableContent)value).name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                super.writeValue(value, knownType, elementType);
            }
        }

        @Override
        protected String convertToString(Object object) {
            if (object instanceof MappableContent) {
                return ((MappableContent)object).name;
            }
            return super.convertToString(object);
        }
    };

    public static String write(Object object) {
        return json.toJson(object, object.getClass());
    }

    public static <T> T copy(T object, T dest) {
        json.copyFields(object, dest);
        return dest;
    }

    public static <T> T copy(T object) {
        return (T)JsonIO.read(object.getClass(), JsonIO.write(object));
    }

    public static <T> T read(Class<T> type, String string) {
        return json.fromJson(type, string.replace("io.anuke.", ""));
    }

    public static <T> T read(Class<T> type, T base, String string) {
        return jsonBase.fromBaseJson(type, base, string.replace("io.anuke.", ""));
    }

    public static String print(String in) {
        return json.prettyPrint(in);
    }

    static void apply(Json json) {
        json.setElementType(Rules.class, "spawns", SpawnGroup.class);
        json.setElementType(Rules.class, "loadout", ItemStack.class);
        json.setSerializer(Sector.class, new Json.Serializer<Sector>(){

            @Override
            public void write(Json json, Sector object, Class knownType) {
                json.writeValue(object.planet.name + "-" + object.id);
            }

            @Override
            public Sector read(Json json, JsonValue jsonData, Class type) {
                String name = jsonData.asString();
                int idx = name.lastIndexOf(45);
                return ((Planet)Vars.content.getByName((ContentType)ContentType.planet, (String)name.substring((int)0, (int)idx))).sectors.get(Integer.parseInt(name.substring(idx + 1)));
            }
        });
        json.setSerializer(SectorPreset.class, new Json.Serializer<SectorPreset>(){

            @Override
            public void write(Json json, SectorPreset object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public SectorPreset read(Json json, JsonValue jsonData, Class type) {
                return (SectorPreset)Vars.content.getByName(ContentType.sector, jsonData.asString());
            }
        });
        json.setSerializer(Liquid.class, new Json.Serializer<Liquid>(){

            @Override
            public void write(Json json, Liquid object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Liquid read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.asString() == null) {
                    return Liquids.water;
                }
                Liquid i = (Liquid)Vars.content.getByName(ContentType.liquid, jsonData.asString());
                return i == null ? Liquids.water : i;
            }
        });
        json.setSerializer(Item.class, new Json.Serializer<Item>(){

            @Override
            public void write(Json json, Item object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Item read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.asString() == null) {
                    return Items.copper;
                }
                Item i = (Item)Vars.content.getByName(ContentType.item, jsonData.asString());
                return i == null ? Items.copper : i;
            }
        });
        json.setSerializer(Team.class, new Json.Serializer<Team>(){

            @Override
            public void write(Json json, Team object, Class knownType) {
                json.writeValue(object.id);
            }

            @Override
            public Team read(Json json, JsonValue jsonData, Class type) {
                return Team.get(jsonData.asInt());
            }
        });
        json.setSerializer(Block.class, new Json.Serializer<Block>(){

            @Override
            public void write(Json json, Block object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Block read(Json json, JsonValue jsonData, Class type) {
                Block block = (Block)Vars.content.getByName(ContentType.block, jsonData.asString());
                return block == null ? Blocks.air : block;
            }
        });
        json.setSerializer(Weather.class, new Json.Serializer<Weather>(){

            @Override
            public void write(Json json, Weather object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Weather read(Json json, JsonValue jsonData, Class type) {
                return (Weather)Vars.content.getByName(ContentType.weather, jsonData.asString());
            }
        });
        json.setSerializer(UnitType.class, new Json.Serializer<UnitType>(){

            @Override
            public void write(Json json, UnitType object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public UnitType read(Json json, JsonValue jsonData, Class type) {
                return (UnitType)Vars.content.getByName(ContentType.unit, jsonData.asString());
            }
        });
        json.setSerializer(ItemStack.class, new Json.Serializer<ItemStack>(){

            @Override
            public void write(Json json, ItemStack object, Class knownType) {
                json.writeObjectStart();
                json.writeValue("item", object.item);
                json.writeValue("amount", object.amount);
                json.writeObjectEnd();
            }

            @Override
            public ItemStack read(Json json, JsonValue jsonData, Class type) {
                return new ItemStack(json.getSerializer(Item.class).read(json, jsonData.get("item"), Item.class), jsonData.getInt("amount"));
            }
        });
        json.setSerializer(UnlockableContent.class, new Json.Serializer<UnlockableContent>(){

            @Override
            public void write(Json json, UnlockableContent object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public UnlockableContent read(Json json, JsonValue jsonData, Class type) {
                String str = jsonData.asString();
                Item item = (Item)Vars.content.getByName(ContentType.item, str);
                Liquid liquid = (Liquid)Vars.content.getByName(ContentType.liquid, str);
                return item != null ? item : liquid;
            }
        });
    }

    static class CustomJson
    extends Json {
        private Object baseObject;

        CustomJson() {
            JsonIO.apply(this);
        }

        @Override
        public <T> T fromJson(Class<T> type, String json) {
            return this.fromBaseJson(type, null, json);
        }

        public <T> T fromBaseJson(Class<T> type, T base, String json) {
            this.baseObject = base;
            return this.readValue(type, null, new JsonReader().parse(json));
        }

        @Override
        protected Object newInstance(Class type) {
            if (this.baseObject == null || this.baseObject.getClass() != type) {
                return super.newInstance(type);
            }
            return this.baseObject;
        }
    }
}

