/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.StringMap;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.io.SaveIO;
import mindustry.io.SaveVersion;
import mindustry.maps.Map;
import mindustry.world.Block;
import mindustry.world.CachedTile;
import mindustry.world.ColorMapper;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;

public class MapIO {
    private static final int[] pngHeader = new int[]{137, 80, 78, 71, 13, 10, 26, 10};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImage(Fi file) {
        try (BufferedInputStream stream = file.read(32);){
            for (int i1 : pngHeader) {
                if (((InputStream)stream).read() == i1) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static Map createMap(Fi file, boolean custom) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeMap(Fi file, Map map) throws IOException {
        try {
            SaveIO.write(file, map.tags);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void loadMap(Map map) {
        SaveIO.load(map.file);
    }

    public static void loadMap(Map map, WorldContext cons) {
        SaveIO.load(map.file, cons);
    }

    /*
     * Exception decompiling
     */
    public static Pixmap generatePreview(Map map) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Pixmap generatePreview(Tiles tiles) {
        Pixmap pixmap = new Pixmap(tiles.width, tiles.height, Pixmap.Format.rgba8888);
        for (int x = 0; x < pixmap.getWidth(); ++x) {
            for (int y = 0; y < pixmap.getHeight(); ++y) {
                Tile tile = tiles.getn(x, y);
                pixmap.draw(x, pixmap.getHeight() - 1 - y, MapIO.colorFor(tile.block(), tile.floor(), tile.overlay(), tile.team()));
            }
        }
        return pixmap;
    }

    public static int colorFor(Block wall, Block floor, Block overlay, Team team) {
        if (wall.synthetic()) {
            return team.color.rgba();
        }
        return (wall.solid ? wall.mapColor : (!overlay.useColor ? floor.mapColor : overlay.mapColor)).rgba();
    }

    public static Pixmap writeImage(Tiles tiles) {
        Pixmap pix = new Pixmap(tiles.width, tiles.height);
        for (Tile tile : tiles) {
            int color = tile.block().hasColor && !tile.block().synthetic() ? tile.block().mapColor.rgba() : tile.floor().mapColor.rgba();
            pix.draw((int)tile.x, tiles.height - 1 - tile.y, color);
        }
        return pix;
    }

    public static void readImage(Pixmap pixmap, Tiles tiles) {
        for (Tile tile : tiles) {
            int color = pixmap.getPixel(tile.x, pixmap.getHeight() - 1 - tile.y);
            Block block = ColorMapper.get(color);
            if (block.isFloor()) {
                tile.setFloor(block.asFloor());
                continue;
            }
            if (block.isMultiblock()) {
                tile.setBlock(block, Team.derelict, 0);
                continue;
            }
            tile.setBlock(block);
        }
        for (Tile tile : tiles) {
            if (tile.floor() == Blocks.air && tile.block() != Blocks.air) {
                for (Point2 p : Geometry.d4) {
                    Tile other = tiles.get(tile.x + p.x, tile.y + p.y);
                    if (other == null || other.floor() == Blocks.air) continue;
                    tile.setFloorUnder(other.floor());
                    break;
                }
            }
            if (tile.floor() != Blocks.air) continue;
            tile.setFloorUnder((Floor)Blocks.stone);
        }
    }

    private static /* synthetic */ void lambda$generatePreview$1(SaveVersion ver, final CachedTile tile, final Pixmap walls, final Pixmap floors, final Map map, DataInput in) throws IOException {
        ver.readMap(in, new WorldContext(){

            @Override
            public void resize(int width, int height) {
            }

            @Override
            public boolean isGenerating() {
                return false;
            }

            @Override
            public void begin() {
                Vars.world.setGenerating(true);
            }

            @Override
            public void end() {
                Vars.world.setGenerating(false);
            }

            @Override
            public void onReadBuilding() {
                if (tile.build != null) {
                    int c = tile.build.team.color.rgba8888();
                    int size = tile.block().size;
                    int offsetx = -(size - 1) / 2;
                    int offsety = -(size - 1) / 2;
                    for (int dx = 0; dx < size; ++dx) {
                        for (int dy = 0; dy < size; ++dy) {
                            int drawx = tile.x + dx + offsetx;
                            int drawy = tile.y + dy + offsety;
                            walls.draw(drawx, floors.getHeight() - 1 - drawy, c);
                        }
                    }
                    if (tile.build.block instanceof CoreBlock) {
                        map.teams.add(tile.build.team.id);
                    }
                }
            }

            @Override
            public Tile tile(int index) {
                tile.x = (short)(index % map.width);
                tile.y = (short)(index / map.width);
                return tile;
            }

            @Override
            public Tile create(int x, int y, int floorID, int overlayID, int wallID) {
                if (overlayID != 0) {
                    floors.draw(x, floors.getHeight() - 1 - y, MapIO.colorFor(Blocks.air, Blocks.air, Vars.content.block(overlayID), Team.derelict));
                } else {
                    floors.draw(x, floors.getHeight() - 1 - y, MapIO.colorFor(Blocks.air, Vars.content.block(floorID), Blocks.air, Team.derelict));
                }
                if (Vars.content.block(overlayID) == Blocks.spawn) {
                    ++map.spawns;
                }
                return tile;
            }
        });
    }

    private static /* synthetic */ void lambda$createMap$0(StringMap tags, SaveVersion ver, DataInput in) throws IOException {
        tags.putAll(ver.readStringMap(in));
    }
}

