/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.Events;
import arc.files.Fi;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.io.CounterInputStream;
import arc.util.io.FastDeflaterOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.io.SaveMeta;
import mindustry.io.SaveVersion;
import mindustry.io.legacy.Save1;
import mindustry.io.legacy.Save2;
import mindustry.io.legacy.Save3;
import mindustry.io.versions.Save4;
import mindustry.world.WorldContext;

public class SaveIO {
    public static final byte[] header = new byte[]{77, 83, 65, 86};
    public static final IntMap<SaveVersion> versions = new IntMap();
    public static final Seq<SaveVersion> versionArray = Seq.with(new Save1(), new Save2(), new Save3(), new Save4());

    public static SaveVersion getSaveWriter() {
        return versionArray.peek();
    }

    public static SaveVersion getSaveWriter(int version) {
        return versions.get(version);
    }

    public static void save(Fi file) {
        boolean exists = file.exists();
        if (exists) {
            file.moveTo(SaveIO.backupFileFor(file));
        }
        try {
            SaveIO.write(file);
        }
        catch (Throwable e) {
            if (exists) {
                SaveIO.backupFileFor(file).moveTo(file);
            }
            throw new RuntimeException(e);
        }
    }

    public static DataInputStream getStream(Fi file) {
        return new DataInputStream(new InflaterInputStream(file.read(8192)));
    }

    public static DataInputStream getBackupStream(Fi file) {
        return new DataInputStream(new InflaterInputStream(SaveIO.backupFileFor(file).read(8192)));
    }

    public static boolean isSaveValid(Fi file) {
        boolean bl;
        DataInputStream stream = new DataInputStream(new InflaterInputStream(file.read(8192)));
        try {
            bl = SaveIO.isSaveValid(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                return false;
            }
        }
        stream.close();
        return bl;
    }

    public static boolean isSaveValid(DataInputStream stream) {
        try {
            SaveIO.getMeta(stream);
            return true;
        }
        catch (Throwable e) {
            Log.err(e);
            return false;
        }
    }

    public static SaveMeta getMeta(Fi file) {
        try {
            return SaveIO.getMeta(SaveIO.getStream(file));
        }
        catch (Throwable e) {
            Log.err(e);
            return SaveIO.getMeta(SaveIO.getBackupStream(file));
        }
    }

    public static SaveMeta getMeta(DataInputStream stream) {
        try {
            SaveIO.readHeader(stream);
            int version = stream.readInt();
            SaveMeta meta = versions.get(version).getMeta(stream);
            stream.close();
            return meta;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Fi fileFor(int slot) {
        return Vars.saveDirectory.child(slot + "." + "msav");
    }

    public static Fi backupFileFor(Fi file) {
        return file.sibling(file.name() + "-backup." + file.extension());
    }

    public static void write(Fi file, StringMap tags) {
        SaveIO.write(new FastDeflaterOutputStream(file.write(false, 8192)), tags);
    }

    public static void write(Fi file) {
        SaveIO.write(file, null);
    }

    public static void write(OutputStream os, StringMap tags) {
        try (DataOutputStream stream = new DataOutputStream(os);){
            stream.write(header);
            stream.writeInt(SaveIO.getVersion().version);
            if (tags == null) {
                SaveIO.getVersion().write(stream);
            } else {
                SaveIO.getVersion().write(stream, tags);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void load(String saveName) throws SaveException {
        SaveIO.load(Vars.saveDirectory.child(saveName + ".msav"));
    }

    public static void load(Fi file) throws SaveException {
        SaveIO.load(file, (WorldContext)Vars.world.context);
    }

    public static void load(Fi file, WorldContext context) throws SaveException {
        try {
            SaveIO.load(new InflaterInputStream(file.read(8192)), context);
        }
        catch (SaveException e) {
            Log.err(e);
            Fi backup = file.sibling(file.name() + "-backup." + file.extension());
            if (backup.exists()) {
                SaveIO.load(new InflaterInputStream(backup.read(8192)), context);
            }
            throw new SaveException(e.getCause());
        }
    }

    public static void load(InputStream is, WorldContext context) throws SaveException {
        try (CounterInputStream counter = new CounterInputStream(is);
             DataInputStream stream = new DataInputStream(counter);){
            Vars.logic.reset();
            SaveIO.readHeader(stream);
            int version = stream.readInt();
            SaveVersion ver = versions.get(version);
            ver.read(stream, counter, context);
            Events.fire(new EventType.SaveLoadEvent());
        }
        catch (Throwable e) {
            throw new SaveException(e);
        }
        finally {
            Vars.world.setGenerating(false);
            Vars.content.setTemporaryMapper(null);
        }
    }

    public static SaveVersion getVersion() {
        return versionArray.peek();
    }

    public static void readHeader(DataInput input) throws IOException {
        byte[] bytes = new byte[header.length];
        input.readFully(bytes);
        if (!Arrays.equals(bytes, header)) {
            throw new IOException("Incorrect header! Expecting: " + Arrays.toString(header) + "; Actual: " + Arrays.toString(bytes));
        }
    }

    static {
        for (SaveVersion version : versionArray) {
            versions.put(version.version, version);
        }
    }

    public static class SaveException
    extends RuntimeException {
        public SaveException(Throwable throwable) {
            super(throwable);
        }
    }
}

