/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.graphics.Color;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import mindustry.Vars;
import mindustry.ai.types.FormationAI;
import mindustry.ai.types.GroundAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.TechTree;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitCommand;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Nulls;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.io.JsonIO;
import mindustry.logic.LAccess;
import mindustry.net.Administration;
import mindustry.net.Packets;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.payloads.Payload;

public class TypeIO {
    static final WeaponMount[] noMounts = new WeaponMount[0];

    public static void writeObject(Writes write, Object object) {
        if (object == null) {
            write.b(0);
        } else {
            Integer i;
            Point2[] point2Array = object;
            if (point2Array instanceof Integer && (i = (Integer)point2Array) == (Integer)point2Array) {
                write.b(1);
                write.i(i);
            } else {
                Long l;
                point2Array = object;
                if (point2Array instanceof Long && (l = (Long)point2Array) == (Long)point2Array) {
                    write.b(2);
                    write.l(l);
                } else {
                    Float f;
                    point2Array = object;
                    if (point2Array instanceof Float && (f = (Float)point2Array) == (Float)point2Array) {
                        write.b(3);
                        write.f(f.floatValue());
                    } else {
                        String s;
                        point2Array = object;
                        if (point2Array instanceof String && (s = (String)point2Array) == (String)point2Array) {
                            write.b(4);
                            TypeIO.writeString(write, s);
                        } else {
                            Content map;
                            point2Array = object;
                            if (point2Array instanceof Content && (map = (Content)point2Array) == (Content)point2Array) {
                                write.b(5);
                                write.b((byte)map.getContentType().ordinal());
                                write.s(map.id);
                            } else {
                                IntSeq arr;
                                point2Array = object;
                                if (point2Array instanceof IntSeq && (arr = (IntSeq)point2Array) == (IntSeq)point2Array) {
                                    write.b(6);
                                    write.s((short)arr.size);
                                    for (int i2 = 0; i2 < arr.size; ++i2) {
                                        write.i(arr.items[i2]);
                                    }
                                } else {
                                    Point2 p;
                                    point2Array = object;
                                    if (point2Array instanceof Point2 && (p = (Point2)point2Array) == (Point2)point2Array) {
                                        write.b(7);
                                        write.i(p.x);
                                        write.i(p.y);
                                    } else {
                                        Point2[] p2;
                                        point2Array = object;
                                        if (point2Array instanceof Point2[] && (p2 = (Point2[])point2Array) == (Point2[])point2Array) {
                                            write.b(8);
                                            write.b(p2.length);
                                            for (Point2 point2 : p2) {
                                                write.i(point2.pack());
                                            }
                                        } else {
                                            TechTree.TechNode map2;
                                            point2Array = object;
                                            if (point2Array instanceof TechTree.TechNode && (map2 = (TechTree.TechNode)point2Array) == (TechTree.TechNode)point2Array) {
                                                write.b(9);
                                                write.b((byte)map2.content.getContentType().ordinal());
                                                write.s(map2.content.id);
                                            } else {
                                                Boolean b;
                                                point2Array = object;
                                                if (point2Array instanceof Boolean && (b = (Boolean)point2Array) == (Boolean)point2Array) {
                                                    write.b(10);
                                                    write.bool(b);
                                                } else {
                                                    Double d;
                                                    point2Array = object;
                                                    if (point2Array instanceof Double && (d = (Double)point2Array) == (Double)point2Array) {
                                                        write.b(11);
                                                        write.d(d);
                                                    } else {
                                                        Building b2;
                                                        point2Array = object;
                                                        if (point2Array instanceof Building && (b2 = (Building)point2Array) == (Building)point2Array) {
                                                            write.b(12);
                                                            write.i(b2.pos());
                                                        } else {
                                                            LAccess l2;
                                                            point2Array = object;
                                                            if (point2Array instanceof LAccess && (l2 = (LAccess)point2Array) == (LAccess)point2Array) {
                                                                write.b(13);
                                                                write.s(l2.ordinal());
                                                            } else {
                                                                byte[] b3;
                                                                point2Array = object;
                                                                if (point2Array instanceof byte[] && (b3 = (byte[])point2Array) == (byte[])point2Array) {
                                                                    write.b(14);
                                                                    write.i(b3.length);
                                                                    write.b(b3);
                                                                } else {
                                                                    UnitCommand c;
                                                                    point2Array = object;
                                                                    if (point2Array instanceof UnitCommand && (c = (UnitCommand)point2Array) == (UnitCommand)point2Array) {
                                                                        write.b(15);
                                                                        write.b(c.ordinal());
                                                                    } else {
                                                                        BuildingBox b4;
                                                                        point2Array = object;
                                                                        if (point2Array instanceof BuildingBox && (b4 = (BuildingBox)point2Array) == (BuildingBox)point2Array) {
                                                                            write.b(12);
                                                                            write.i(b4.pos);
                                                                        } else {
                                                                            throw new IllegalArgumentException("Unknown object type: " + object.getClass());
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public static Object readObject(Reads read) {
        return TypeIO.readObjectBoxed(read, false);
    }

    @Nullable
    public static Object readObjectBoxed(Reads read, boolean box) {
        byte type = read.b();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return read.i();
            }
            case 2: {
                return read.l();
            }
            case 3: {
                return Float.valueOf(read.f());
            }
            case 4: {
                return TypeIO.readString(read);
            }
            case 5: {
                return Vars.content.getByID(ContentType.all[read.b()], read.s());
            }
            case 6: {
                int length = read.s();
                IntSeq arr = new IntSeq();
                for (int i = 0; i < length; ++i) {
                    arr.add(read.i());
                }
                return arr;
            }
            case 7: {
                return new Point2(read.i(), read.i());
            }
            case 8: {
                int len = read.b();
                Point2[] out = new Point2[len];
                for (int i = 0; i < len; ++i) {
                    out[i] = Point2.unpack(read.i());
                }
                return out;
            }
            case 9: {
                return TechTree.getNotNull((UnlockableContent)Vars.content.getByID(ContentType.all[read.b()], read.s()));
            }
            case 10: {
                return read.bool();
            }
            case 11: {
                return read.d();
            }
            case 12: {
                return !box ? Vars.world.build(read.i()) : new BuildingBox(read.i());
            }
            case 13: {
                return LAccess.all[read.s()];
            }
            case 14: {
                int blen = read.i();
                byte[] bytes = new byte[blen];
                read.b(bytes);
                return bytes;
            }
            case 15: {
                return UnitCommand.all[read.b()];
            }
        }
        throw new IllegalArgumentException("Unknown object type: " + type);
    }

    public static void writePayload(Writes writes, Payload payload) {
        Payload.write(payload, writes);
    }

    public static Payload readPayload(Reads read) {
        return Payload.read(read);
    }

    public static void writeMounts(Writes writes, WeaponMount[] mounts) {
        writes.b(mounts.length);
        for (WeaponMount m : mounts) {
            writes.b((m.shoot ? 1 : 0) | (m.rotate ? 2 : 0));
            writes.f(m.aimX);
            writes.f(m.aimY);
        }
    }

    public static WeaponMount[] readMounts(Reads read, WeaponMount[] mounts) {
        int len = read.b();
        for (int i = 0; i < len; ++i) {
            byte state = read.b();
            float ax = read.f();
            float ay = read.f();
            if (i > mounts.length - 1) continue;
            WeaponMount m = mounts[i];
            m.aimX = ax;
            m.aimY = ay;
            m.shoot = (state & 1) != 0;
            m.rotate = (state & 2) != 0;
        }
        return mounts;
    }

    public static WeaponMount[] readMounts(Reads read) {
        read.skip(read.b() * 9);
        return noMounts;
    }

    public static void writeUnit(Writes write, Unit unit) {
        write.b(unit == null || unit.isNull() ? 0 : (unit instanceof BlockUnitc ? 1 : 2));
        if (unit instanceof BlockUnitc) {
            write.i(((BlockUnitc)((Object)unit)).tile().pos());
        } else if (unit == null) {
            write.i(0);
        } else {
            write.i(unit.id);
        }
    }

    public static Unit readUnit(Reads read) {
        byte type = read.b();
        int id = read.i();
        if (type == 0) {
            return Nulls.unit;
        }
        if (type == 2) {
            Unit unit = Groups.unit.getByID(id);
            return unit == null ? Nulls.unit : unit;
        }
        if (type == 1) {
            ControlBlock cont;
            Building tile = Vars.world.build(id);
            Building building = tile;
            return building instanceof ControlBlock && (cont = (ControlBlock)((Object)building)) == (ControlBlock)((Object)building) ? cont.unit() : Nulls.unit;
        }
        return Nulls.unit;
    }

    public static void writeEntity(Writes write, Entityc entity) {
        write.i(entity == null ? -1 : entity.id());
    }

    public static <T extends Entityc> T readEntity(Reads read) {
        return (T)Groups.sync.getByID(read.i());
    }

    public static void writeBuilding(Writes write, Building tile) {
        write.i(tile == null ? -1 : tile.pos());
    }

    public static Building readBuilding(Reads read) {
        return Vars.world.build(read.i());
    }

    public static void writeTile(Writes write, Tile tile) {
        write.i(tile == null ? Point2.pack(-1, -1) : tile.pos());
    }

    public static Tile readTile(Reads read) {
        return Vars.world.tile(read.i());
    }

    public static void writeBlock(Writes write, Block block) {
        write.s(block.id);
    }

    public static Block readBlock(Reads read) {
        return Vars.content.block(read.s());
    }

    public static void writeRequest(Writes write, BuildPlan request) {
        write.b(request.breaking ? 1 : 0);
        write.i(Point2.pack(request.x, request.y));
        if (!request.breaking) {
            write.s(request.block.id);
            write.b((byte)request.rotation);
            write.b(1);
            TypeIO.writeObject(write, request.config);
        }
    }

    public static BuildPlan readRequest(Reads read) {
        BuildPlan currentRequest;
        byte type = read.b();
        int position = read.i();
        if (Vars.world.tile(position) == null) {
            return null;
        }
        if (type == 1) {
            currentRequest = new BuildPlan(Point2.x(position), Point2.y(position));
        } else {
            short block = read.s();
            byte rotation = read.b();
            boolean hasConfig = read.b() == 1;
            Object config = TypeIO.readObject(read);
            currentRequest = new BuildPlan(Point2.x(position), Point2.y(position), rotation, Vars.content.block(block));
            if (hasConfig) {
                currentRequest.config = config;
            }
        }
        return currentRequest;
    }

    public static void writeRequests(Writes write, BuildPlan[] requests) {
        if (requests == null) {
            write.s(-1);
            return;
        }
        write.s((short)requests.length);
        for (BuildPlan request : requests) {
            TypeIO.writeRequest(write, request);
        }
    }

    public static BuildPlan[] readRequests(Reads read) {
        int reqamount = read.s();
        if (reqamount == -1) {
            return null;
        }
        BuildPlan[] reqs = new BuildPlan[reqamount];
        for (int i = 0; i < reqamount; ++i) {
            BuildPlan request = TypeIO.readRequest(read);
            if (request == null) continue;
            reqs[i] = request;
        }
        return reqs;
    }

    public static void writeController(Writes write, UnitController control) {
        Player p;
        UnitController unitController = control;
        if (unitController instanceof Player && (p = (Player)unitController) == (Player)unitController) {
            write.b(0);
            write.i(p.id);
        } else {
            FormationAI form;
            unitController = control;
            if (unitController instanceof FormationAI && (form = (FormationAI)unitController) == (FormationAI)unitController && form.leader != null) {
                write.b(1);
                write.i(form.leader.id);
            } else {
                LogicAI logic;
                unitController = control;
                if (unitController instanceof LogicAI && (logic = (LogicAI)unitController) == (LogicAI)unitController && logic.controller != null) {
                    write.b(3);
                    write.i(logic.controller.pos());
                } else {
                    write.b(2);
                }
            }
        }
    }

    public static UnitController readController(Reads read, UnitController prev) {
        byte type = read.b();
        if (type == 0) {
            int id = read.i();
            Player player = Groups.player.getByID(id);
            if (player == null) {
                return prev;
            }
            return player;
        }
        if (type == 1) {
            FormationAI f;
            int id = read.i();
            UnitController unitController = prev;
            if (unitController instanceof FormationAI && (f = (FormationAI)unitController) == (FormationAI)unitController) {
                f.leader = Groups.unit.getByID(id);
                return f;
            }
            return new FormationAI(Groups.unit.getByID(id), null);
        }
        if (type == 3) {
            LogicAI pai;
            int pos = read.i();
            UnitController unitController = prev;
            if (unitController instanceof LogicAI && (pai = (LogicAI)unitController) == (LogicAI)unitController) {
                pai.controller = Vars.world.build(pos);
                return pai;
            }
            LogicAI out = new LogicAI();
            out.controlTimer = 600.0f;
            out.controller = Vars.world.build(pos);
            return out;
        }
        return !(prev instanceof AIController) || prev instanceof FormationAI || prev instanceof LogicAI ? new GroundAI() : prev;
    }

    public static void writeKick(Writes write, Packets.KickReason reason) {
        write.b((byte)reason.ordinal());
    }

    public static Packets.KickReason readKick(Reads read) {
        return Packets.KickReason.values()[read.b()];
    }

    public static void writeRules(Writes write, Rules rules) {
        String string = JsonIO.write(rules);
        byte[] bytes = string.getBytes(Vars.charset);
        write.i(bytes.length);
        write.b(bytes);
    }

    public static Rules readRules(Reads read) {
        int length = read.i();
        String string = new String(read.b(new byte[length]), Vars.charset);
        return JsonIO.read(Rules.class, string);
    }

    public static void writeVec2(Writes write, Vec2 v) {
        if (v == null) {
            write.f(0.0f);
            write.f(0.0f);
        } else {
            write.f(v.x);
            write.f(v.y);
        }
    }

    public static Vec2 readVec2(Reads read, Vec2 base) {
        return base.set(read.f(), read.f());
    }

    public static Vec2 readVec2(Reads read) {
        return new Vec2(read.f(), read.f());
    }

    public static void writeStatuse(Writes write, StatusEntry entry) {
        write.s(entry.effect.id);
        write.f(entry.time);
    }

    public static StatusEntry readStatuse(Reads read) {
        return Pools.obtain(StatusEntry.class, StatusEntry::new).set((StatusEffect)Vars.content.getByID(ContentType.status, read.s()), read.f());
    }

    public static void writeItems(Writes write, ItemStack stack) {
        TypeIO.writeItem(write, stack.item);
        write.i(stack.amount);
    }

    public static ItemStack readItems(Reads read, ItemStack stack) {
        return stack.set(TypeIO.readItem(read), read.i());
    }

    public static ItemStack readItems(Reads read) {
        return new ItemStack(TypeIO.readItem(read), read.i());
    }

    public static void writeTeam(Writes write, Team reason) {
        write.b(reason.id);
    }

    public static Team readTeam(Reads read) {
        return Team.get(read.b());
    }

    public static void writeUnitCommand(Writes write, UnitCommand reason) {
        write.b((byte)reason.ordinal());
    }

    public static UnitCommand readUnitCommand(Reads read) {
        return UnitCommand.all[read.b()];
    }

    public static void writeAction(Writes write, Packets.AdminAction reason) {
        write.b((byte)reason.ordinal());
    }

    public static Packets.AdminAction readAction(Reads read) {
        return Packets.AdminAction.values()[read.b()];
    }

    public static void writeUnitType(Writes write, UnitType effect) {
        write.s(effect.id);
    }

    public static UnitType readUnitType(Reads read) {
        return (UnitType)Vars.content.getByID(ContentType.unit, read.s());
    }

    public static void writeEffect(Writes write, Effect effect) {
        write.s(effect.id);
    }

    public static Effect readEffect(Reads read) {
        return Effect.get(read.us());
    }

    public static void writeColor(Writes write, Color color) {
        write.i(color.rgba());
    }

    public static Color readColor(Reads read) {
        return new Color(read.i());
    }

    public static Color readColor(Reads read, Color color) {
        return color.set(read.i());
    }

    public static void writeContent(Writes write, Content cont) {
        write.b(cont.getContentType().ordinal());
        write.s(cont.id);
    }

    public static Content readContent(Reads read) {
        byte id = read.b();
        return Vars.content.getByID(ContentType.all[id], read.s());
    }

    public static void writeLiquid(Writes write, Liquid liquid) {
        write.s(liquid == null ? -1 : (int)liquid.id);
    }

    public static Liquid readLiquid(Reads read) {
        short id = read.s();
        return id == -1 ? null : Vars.content.liquid(id);
    }

    public static void writeBulletType(Writes write, BulletType type) {
        write.s(type.id);
    }

    public static BulletType readBulletType(Reads read) {
        return (BulletType)Vars.content.getByID(ContentType.bullet, read.s());
    }

    public static void writeItem(Writes write, Item item) {
        write.s(item == null ? -1 : (int)item.id);
    }

    public static Item readItem(Reads read) {
        short id = read.s();
        return id == -1 ? null : Vars.content.item(id);
    }

    public static void writeWeather(Writes write, Weather item) {
        write.s(item == null ? -1 : (int)item.id);
    }

    public static Weather readWeather(Reads read) {
        short id = read.s();
        return id == -1 ? null : (Weather)Vars.content.getByID(ContentType.weather, id);
    }

    public static void writeString(Writes write, String string) {
        if (string != null) {
            write.b(1);
            write.str(string);
        } else {
            write.b(0);
        }
    }

    public static String readString(Reads read) {
        byte exists = read.b();
        if (exists != 0) {
            return read.str();
        }
        return null;
    }

    public static void writeString(ByteBuffer write, String string) {
        if (string != null) {
            byte[] bytes = string.getBytes(Vars.charset);
            write.putShort((short)bytes.length);
            write.put(bytes);
        } else {
            write.putShort((short)-1);
        }
    }

    public static String readString(ByteBuffer read) {
        short slength = read.getShort();
        if (slength != -1) {
            byte[] bytes = new byte[slength];
            read.get(bytes);
            return new String(bytes, Vars.charset);
        }
        return null;
    }

    public static void writeBytes(Writes write, byte[] bytes) {
        write.s((short)bytes.length);
        write.b(bytes);
    }

    public static byte[] readBytes(Reads read) {
        short length = read.s();
        return read.b(new byte[length]);
    }

    public static void writeInts(Writes write, int[] ints) {
        write.s((short)ints.length);
        for (int i : ints) {
            write.i(i);
        }
    }

    public static int[] readInts(Reads read) {
        int length = read.s();
        int[] out = new int[length];
        for (int i = 0; i < length; ++i) {
            out[i] = read.i();
        }
        return out;
    }

    public static void writeTraceInfo(Writes write, Administration.TraceInfo trace) {
        TypeIO.writeString(write, trace.ip);
        TypeIO.writeString(write, trace.uuid);
        write.b(trace.modded ? 1 : 0);
        write.b(trace.mobile ? 1 : 0);
        write.i(trace.timesJoined);
        write.i(trace.timesKicked);
    }

    public static Administration.TraceInfo readTraceInfo(Reads read) {
        return new Administration.TraceInfo(TypeIO.readString(read), TypeIO.readString(read), read.b() == 1, read.b() == 1, read.i(), read.i());
    }

    public static void writeStringData(DataOutput buffer, String string) throws IOException {
        if (string != null) {
            byte[] bytes = string.getBytes(Vars.charset);
            buffer.writeShort((short)bytes.length);
            buffer.write(bytes);
        } else {
            buffer.writeShort(-1);
        }
    }

    public static String readStringData(DataInput buffer) throws IOException {
        short slength = buffer.readShort();
        if (slength != -1) {
            byte[] bytes = new byte[slength];
            buffer.readFully(bytes);
            return new String(bytes, Vars.charset);
        }
        return null;
    }

    public static class BuildingBox {
        public int pos;

        public BuildingBox(int pos) {
            this.pos = pos;
        }
    }
}

