/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io.legacy;

import arc.Core;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.ui.dialogs.JoinDialog;

public class LegacyIO {
    public static final StringMap unitMap = StringMap.of("titan", "mace", "chaos-array", "scepter", "eradicator", "reign", "eruptor", "atrax", "wraith", "flare", "ghoul", "horizon", "revenant", "zenith", "lich", "antumbra", "reaper", "eclipse", "draug", "mono", "phantom", "poly", "spirit", "poly");

    public static Seq<JoinDialog.Server> readServers() {
        Seq<JoinDialog.Server> arr = new Seq<JoinDialog.Server>();
        try {
            byte[] bytes = Core.settings.getBytes("server-list");
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            int length = stream.readInt();
            if (length > 0) {
                stream.readUTF();
                for (int i = 0; i < length; ++i) {
                    JoinDialog.Server server = new JoinDialog.Server();
                    server.ip = stream.readUTF();
                    server.port = stream.readInt();
                    arr.add(server);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arr;
    }

    public static void readResearch() {
        try {
            byte[] bytes = Core.settings.getBytes("unlocks");
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            int length = stream.readInt();
            if (length > 0) {
                stream.readUTF();
                stream.readUTF();
                for (int i = 0; i < length; ++i) {
                    ContentType type = ContentType.all[stream.readInt()];
                    int arrLength = stream.readInt();
                    if (arrLength <= 0) continue;
                    stream.readUTF();
                    for (int j = 0; j < arrLength; ++j) {
                        UnlockableContent u;
                        String name = stream.readUTF();
                        Object out = Vars.content.getByName(type, name);
                        Object t = out;
                        if (!(t instanceof UnlockableContent) || (u = (UnlockableContent)t) != (UnlockableContent)t) continue;
                        u.quietUnlock();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.err(e);
        }
    }
}

