/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.ctype.UnlockableContent;
import mindustry.logic.LAccess;
import mindustry.logic.LExecutor;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.world.Block;

public class GlobalConstants {
    public static final int ctrlProcessor = 1;
    public static final int ctrlPlayer = 2;
    public static final int ctrlFormation = 3;
    private ObjectIntMap<String> namesToIds = new ObjectIntMap();
    private Seq<LExecutor.Var> vars = new Seq(LExecutor.Var.class);

    public void init() {
        this.put("the end", null);
        this.put("false", 0);
        this.put("true", 1);
        this.put("null", null);
        this.put("@ctrlProcessor", 1);
        this.put("@ctrlPlayer", 2);
        this.put("@ctrlFormation", 3);
        for (Item item : Vars.content.items()) {
            this.put("@" + item.name, item);
        }
        for (Liquid liquid : Vars.content.liquids()) {
            this.put("@" + liquid.name, liquid);
        }
        for (Block block : Vars.content.blocks()) {
            if (!block.synthetic()) continue;
            this.put("@" + block.name, block);
        }
        this.put("@solid", Blocks.stoneWall);
        this.put("@air", Blocks.air);
        for (UnitType type : Vars.content.units()) {
            this.put("@" + type.name, type);
        }
        for (Iterator<UnlockableContent> iterator : LAccess.all) {
            this.put("@" + ((Enum)((Object)iterator)).name(), iterator);
        }
    }

    public int get(String name) {
        return this.namesToIds.get(name, -1);
    }

    public LExecutor.Var get(int id) {
        return ((LExecutor.Var[])this.vars.items)[id];
    }

    public LExecutor.Var put(String name, Object value) {
        Number num;
        LExecutor.Var var = new LExecutor.Var(name);
        var.constant = true;
        Object object = value;
        if (object instanceof Number && (num = (Number)object) == (Number)object) {
            var.numval = num.doubleValue();
        } else {
            var.isobj = true;
            var.objval = value;
        }
        int index = this.vars.size;
        this.namesToIds.put(name, index);
        this.vars.add(var);
        return var;
    }
}

