/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.func.Func;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.logic.LExecutor;
import mindustry.logic.LParser;
import mindustry.logic.LStatement;

public class LAssembler {
    public static ObjectMap<String, Func<String[], LStatement>> customParsers = new ObjectMap();
    public static final int maxTokenLength = 36;
    private static final int invalidNum = Integer.MIN_VALUE;
    private int lastVar;
    public ObjectMap<String, BVar> vars = new ObjectMap();
    public LExecutor.LInstruction[] instructions;

    public LAssembler() {
        this.putVar((String)"@counter").value = 0;
        this.putConst("@time", 0);
        this.putConst("@unit", null);
        this.putConst("@this", null);
        this.putConst("@tick", 0);
    }

    public static LAssembler assemble(String data) {
        LAssembler asm = new LAssembler();
        Seq<LStatement> st = LAssembler.read(data);
        asm.instructions = (LExecutor.LInstruction[])st.map(l -> l.build(asm)).filter(l -> l != null).toArray(LExecutor.LInstruction.class);
        return asm;
    }

    public static String write(Seq<LStatement> statements) {
        StringBuilder out = new StringBuilder();
        for (LStatement s : statements) {
            s.write(out);
            out.append("\n");
        }
        return out.toString();
    }

    public static Seq<LStatement> read(String data) {
        return LParser.parse(data);
    }

    public int var(String symbol) {
        int constId = Vars.constants.get(symbol);
        if (constId > 0) {
            return -constId;
        }
        if (!(symbol = symbol.trim()).isEmpty() && symbol.charAt(0) == '\"' && symbol.charAt(symbol.length() - 1) == '\"') {
            return this.putConst((String)new StringBuilder().append((String)"___").append((String)symbol).toString(), (Object)symbol.substring((int)1, (int)(symbol.length() - 1)).replace((CharSequence)"\\n", (CharSequence)"\n")).id;
        }
        double value = this.parseDouble(symbol = symbol.replace(' ', '_'));
        if (value == -2.147483648E9) {
            return this.putVar((String)symbol).id;
        }
        return this.putConst((String)new StringBuilder().append((String)"___").append((double)value).toString(), (Object)Double.valueOf((double)value)).id;
    }

    double parseDouble(String symbol) {
        if (symbol.startsWith("0b")) {
            return Strings.parseLong(symbol, 2, 2, symbol.length(), Integer.MIN_VALUE);
        }
        if (symbol.startsWith("0x")) {
            return Strings.parseLong(symbol, 16, 2, symbol.length(), Integer.MIN_VALUE);
        }
        return Strings.parseDouble(symbol, -2.147483648E9);
    }

    public BVar putConst(String name, Object value) {
        BVar var = this.putVar(name);
        var.constant = true;
        var.value = value;
        return var;
    }

    public BVar putVar(String name) {
        if (this.vars.containsKey(name)) {
            return this.vars.get(name);
        }
        BVar var = new BVar(this.lastVar++);
        this.vars.put(name, var);
        return var;
    }

    @Nullable
    public BVar getVar(String name) {
        return this.vars.get(name);
    }

    public static class BVar {
        public int id;
        public boolean constant;
        public Object value;

        public BVar(int id) {
            this.id = id;
        }

        BVar() {
        }

        public String toString() {
            return "BVar{id=" + this.id + ", constant=" + this.constant + ", value=" + this.value + '}';
        }
    }
}

