/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.math.geom.Geometry;
import arc.struct.IntSet;
import arc.struct.LongSeq;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.ai.types.FormationAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.entities.units.UnitController;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.DisplayCmd;
import mindustry.gen.Healthc;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.ConditionOp;
import mindustry.logic.LAccess;
import mindustry.logic.LAssembler;
import mindustry.logic.LLocate;
import mindustry.logic.LUnitControl;
import mindustry.logic.LogicOp;
import mindustry.logic.RadarSort;
import mindustry.logic.RadarTarget;
import mindustry.logic.Ranged;
import mindustry.logic.Senseable;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.blocks.logic.MemoryBlock;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BuildVisibility;

public class LExecutor {
    public static final int maxInstructions = 1000;
    public static final Simplex noise = new Simplex();
    public static final int varCounter = 0;
    public static final int varTime = 1;
    public static final int varUnit = 2;
    public static final int varThis = 3;
    public static final int varTick = 4;
    public static final int maxGraphicsBuffer = 256;
    public static final int maxDisplayBuffer = 1024;
    public static final int maxTextBuffer = 256;
    public LInstruction[] instructions = new LInstruction[0];
    public Var[] vars = new Var[0];
    public int[] binds;
    public LongSeq graphicsBuffer = new LongSeq();
    public StringBuilder textBuffer = new StringBuilder();
    public Building[] links = new Building[0];
    public IntSet linkIds = new IntSet();
    public Team team = Team.derelict;

    public boolean initialized() {
        return this.instructions != null && this.vars != null && this.instructions.length > 0;
    }

    public void runOnce() {
        this.vars[1].numval = Time.millis();
        this.vars[4].numval = Time.time;
        if (this.vars[0].numval >= (double)this.instructions.length || this.vars[0].numval < 0.0) {
            this.vars[0].numval = 0.0;
        }
        if (this.vars[0].numval < (double)this.instructions.length) {
            double d = this.vars[0].numval;
            this.vars[0].numval = d + 1.0;
            this.instructions[(int)d].run(this);
        }
    }

    public void load(String data) {
        this.load(LAssembler.assemble(data));
    }

    public void load(LAssembler builder) {
        this.vars = new Var[builder.vars.size];
        this.instructions = builder.instructions;
        builder.vars.each((name, var) -> {
            Number number;
            Var dest;
            this.vars[var.id] = dest = new Var((String)name);
            dest.constant = var.constant;
            Object number$temp = var.value;
            if (number$temp instanceof Number && (number = (Number)number$temp) == (Number)number$temp) {
                dest.isobj = false;
                dest.numval = number.doubleValue();
            } else {
                dest.isobj = true;
                dest.objval = var.value;
            }
        });
    }

    private static boolean invalid(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public Var var(int index) {
        return index < 0 ? Vars.constants.get(-index) : this.vars[index];
    }

    @Nullable
    public Building building(int index) {
        Building building;
        Object object;
        Object o = this.var((int)index).objval;
        return this.var((int)index).isobj && (object = o) instanceof Building && (building = (Building)object) == (Building)object ? building : null;
    }

    @Nullable
    public Object obj(int index) {
        Object o = this.var((int)index).objval;
        return this.var((int)index).isobj ? o : null;
    }

    public boolean bool(int index) {
        Var v = this.var(index);
        return v.isobj ? v.objval != null : Math.abs(v.numval) >= 1.0E-5;
    }

    public double num(int index) {
        Var v = this.var(index);
        return v.isobj ? (v.objval != null ? 1.0 : 0.0) : (LExecutor.invalid(v.numval) ? 0.0 : v.numval);
    }

    public float numf(int index) {
        Var v = this.var(index);
        return v.isobj ? (v.objval != null ? 1.0f : 0.0f) : (LExecutor.invalid(v.numval) ? 0.0f : (float)v.numval);
    }

    public int numi(int index) {
        return (int)this.num(index);
    }

    public void setbool(int index, boolean value) {
        this.setnum(index, value ? 1.0 : 0.0);
    }

    public void setnum(int index, double value) {
        Var v = this.var(index);
        if (v.constant) {
            return;
        }
        if (LExecutor.invalid(value)) {
            v.objval = null;
            v.isobj = true;
        } else {
            v.numval = value;
            v.objval = null;
            v.isobj = false;
        }
    }

    public void setobj(int index, Object value) {
        Var v = this.var(index);
        if (v.constant) {
            return;
        }
        v.objval = value;
        v.isobj = true;
    }

    public void setconst(int index, Object value) {
        Var v = this.var(index);
        v.objval = value;
        v.isobj = true;
    }

    public static interface LInstruction {
        public void run(LExecutor var1);
    }

    public static class Var {
        public final String name;
        public boolean isobj;
        public boolean constant;
        public Object objval;
        public double numval;

        public Var(String name) {
            this.name = name;
        }
    }

    public static class WaitI
    implements LInstruction {
        public int value;
        public float curTime;
        public double wait;
        public long frameId;

        public WaitI(int value) {
            this.value = value;
        }

        public WaitI() {
        }

        @Override
        public void run(LExecutor exec) {
            if ((double)this.curTime >= exec.num(this.value)) {
                this.curTime = 0.0f;
            } else {
                exec.var((int)0).numval -= 1.0;
            }
            if (Core.graphics.getFrameId() != this.frameId) {
                this.curTime += Time.delta / 60.0f;
                this.frameId = Core.graphics.getFrameId();
            }
        }
    }

    public static class JumpI
    implements LInstruction {
        public ConditionOp op = ConditionOp.notEqual;
        public int value;
        public int compare;
        public int address;

        public JumpI(ConditionOp op, int value, int compare, int address) {
            this.op = op;
            this.value = value;
            this.compare = compare;
            this.address = address;
        }

        public JumpI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (this.address != -1) {
                Var va = exec.var(this.value);
                Var vb = exec.var(this.compare);
                boolean cmp = this.op == ConditionOp.strictEqual ? va.isobj == vb.isobj && (va.isobj && va.objval == vb.objval || !va.isobj && va.numval == vb.numval) : (this.op.objFunction != null && va.isobj && vb.isobj ? this.op.objFunction.get(exec.obj(this.value), exec.obj(this.compare)) : this.op.function.get(exec.num(this.value), exec.num(this.compare)));
                if (cmp) {
                    exec.var((int)0).numval = this.address;
                }
            }
        }
    }

    public static class PrintFlushI
    implements LInstruction {
        public int target;

        public PrintFlushI(int target) {
            this.target = target;
        }

        public PrintFlushI() {
        }

        @Override
        public void run(LExecutor exec) {
            MessageBlock.MessageBuild d;
            Building building = exec.building(this.target);
            if (building instanceof MessageBlock.MessageBuild && (d = (MessageBlock.MessageBuild)building) == (MessageBlock.MessageBuild)building && d.team == exec.team) {
                d.message.setLength(0);
                d.message.append(exec.textBuffer, 0, Math.min(exec.textBuffer.length(), 256));
                exec.textBuffer.setLength(0);
            }
        }
    }

    public static class PrintI
    implements LInstruction {
        public int value;

        public PrintI(int value) {
            this.value = value;
        }

        PrintI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (exec.textBuffer.length() >= 256) {
                return;
            }
            Var v = exec.var(this.value);
            if (v.isobj && this.value != 0) {
                Unit unit;
                Building build;
                MappableContent content;
                String s;
                Object object;
                String strValue = v.objval == null ? "null" : ((object = v.objval) instanceof String && (s = (String)object) == (String)object ? s : (v.objval == Blocks.stoneWall ? "solid" : ((object = v.objval) instanceof MappableContent && (content = (MappableContent)object) == (MappableContent)object ? content.name : (v.objval instanceof Content ? "[content]" : ((object = v.objval) instanceof Building && (build = (Building)object) == (Building)object ? build.block.name : ((object = v.objval) instanceof Unit && (unit = (Unit)object) == (Unit)object ? unit.type.name : "[object]"))))));
                exec.textBuffer.append(strValue);
            } else if (Math.abs(v.numval - (double)((long)v.numval)) < 1.0E-6) {
                exec.textBuffer.append((long)v.numval);
            } else {
                exec.textBuffer.append(v.numval);
            }
        }
    }

    public static class DrawFlushI
    implements LInstruction {
        public int target;

        public DrawFlushI(int target) {
            this.target = target;
        }

        public DrawFlushI() {
        }

        @Override
        public void run(LExecutor exec) {
            LogicDisplay.LogicDisplayBuild d;
            if (Vars.headless) {
                return;
            }
            Building building = exec.building(this.target);
            if (building instanceof LogicDisplay.LogicDisplayBuild && (d = (LogicDisplay.LogicDisplayBuild)building) == (LogicDisplay.LogicDisplayBuild)building && d.team == exec.team) {
                if (d.commands.size + exec.graphicsBuffer.size < 1024) {
                    for (int i = 0; i < exec.graphicsBuffer.size; ++i) {
                        d.commands.addLast(exec.graphicsBuffer.items[i]);
                    }
                }
                exec.graphicsBuffer.clear();
            }
        }
    }

    public static class DrawI
    implements LInstruction {
        public byte type;
        public int target;
        public int x;
        public int y;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public DrawI(byte type, int target, int x, int y, int p1, int p2, int p3, int p4) {
            this.type = type;
            this.target = target;
            this.x = x;
            this.y = y;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public DrawI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.headless) {
                return;
            }
            int num1 = exec.numi(this.p1);
            if (this.type == 9) {
                UnlockableContent u;
                Object object = exec.obj(this.p1);
                int n = num1 = object instanceof UnlockableContent && (u = (UnlockableContent)object) == (UnlockableContent)object ? u.iconId : 0;
            }
            if (exec.graphicsBuffer.size < 256) {
                exec.graphicsBuffer.add(DisplayCmd.get(this.type, DrawI.packSign(exec.numi(this.x)), DrawI.packSign(exec.numi(this.y)), DrawI.packSign(num1), DrawI.packSign(exec.numi(this.p2)), DrawI.packSign(exec.numi(this.p3)), DrawI.packSign(exec.numi(this.p4))));
            }
        }

        static int packSign(int value) {
            return Math.abs(value) & 0xFF | (value < 0 ? 512 : 0);
        }
    }

    public static class NoopI
    implements LInstruction {
        @Override
        public void run(LExecutor exec) {
        }
    }

    public static class EndI
    implements LInstruction {
        @Override
        public void run(LExecutor exec) {
            exec.var((int)0).numval = exec.instructions.length;
        }
    }

    public static class OpI
    implements LInstruction {
        public LogicOp op = LogicOp.add;
        public int a;
        public int b;
        public int dest;

        public OpI(LogicOp op, int a, int b, int dest) {
            this.op = op;
            this.a = a;
            this.b = b;
            this.dest = dest;
        }

        OpI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (this.op == LogicOp.strictEqual) {
                Var v = exec.var(this.a);
                Var v2 = exec.var(this.b);
                exec.setnum(this.dest, v.isobj == v2.isobj && (v.isobj && v.objval == v2.objval || !v.isobj && v.numval == v2.numval) ? 1.0 : 0.0);
            } else if (this.op.unary) {
                exec.setnum(this.dest, this.op.function1.get(exec.num(this.a)));
            } else {
                Var va = exec.var(this.a);
                Var vb = exec.var(this.b);
                if (this.op.objFunction2 != null && va.isobj && vb.isobj) {
                    exec.setnum(this.dest, this.op.objFunction2.get(exec.obj(this.a), exec.obj(this.b)));
                } else {
                    exec.setnum(this.dest, this.op.function2.get(exec.num(this.a), exec.num(this.b)));
                }
            }
        }
    }

    public static class SetI
    implements LInstruction {
        public int from;
        public int to;

        public SetI(int from, int to) {
            this.from = from;
            this.to = to;
        }

        SetI() {
        }

        @Override
        public void run(LExecutor exec) {
            Var v = exec.var(this.to);
            Var f = exec.var(this.from);
            if (!v.constant) {
                if (f.isobj) {
                    v.objval = f.objval;
                    v.isobj = true;
                } else {
                    v.numval = LExecutor.invalid(f.numval) ? 0.0 : f.numval;
                    v.isobj = false;
                }
            }
        }
    }

    public static class RadarI
    implements LInstruction {
        public RadarTarget target1 = RadarTarget.enemy;
        public RadarTarget target2 = RadarTarget.any;
        public RadarTarget target3 = RadarTarget.any;
        public RadarSort sort = RadarSort.distance;
        public int radar;
        public int sortOrder;
        public int output;
        public Healthc lastTarget;
        public Interval timer = new Interval();
        static float bestValue = 0.0f;
        static Unit best = null;

        public RadarI(RadarTarget target1, RadarTarget target2, RadarTarget target3, RadarSort sort, int radar, int sortOrder, int output) {
            this.target1 = target1;
            this.target2 = target2;
            this.target3 = target3;
            this.sort = sort;
            this.radar = radar;
            this.sortOrder = sortOrder;
            this.output = output;
        }

        public RadarI() {
        }

        @Override
        public void run(LExecutor exec) {
            Ranged r;
            Object base = exec.obj(this.radar);
            int sortDir = exec.bool(this.sortOrder) ? 1 : -1;
            LogicAI ai = null;
            Object object = base;
            if (object instanceof Ranged && (r = (Ranged)object) == (Ranged)object && r.team() == exec.team && (base instanceof Building || (ai = UnitControlI.checkLogicAI(exec, base)) != null)) {
                Healthc targeted;
                float range = r.range();
                if (base instanceof Building && this.timer.get(30.0f) || ai != null && ai.checkTargetTimer(this)) {
                    boolean enemies = this.target1 == RadarTarget.enemy || this.target2 == RadarTarget.enemy || this.target3 == RadarTarget.enemy;
                    best = null;
                    bestValue = 0.0f;
                    if (enemies) {
                        Seq<Teams.TeamData> data = Vars.state.teams.present;
                        for (int i = 0; i < data.size; ++i) {
                            if (((Teams.TeamData[])data.items)[i].team == r.team()) continue;
                            this.find(r, range, sortDir, ((Teams.TeamData[])data.items)[i].team);
                        }
                    } else {
                        this.find(r, range, sortDir, r.team());
                    }
                    this.lastTarget = targeted = best;
                } else {
                    targeted = this.lastTarget;
                }
                exec.setobj(this.output, targeted);
            } else {
                exec.setobj(this.output, null);
            }
        }

        void find(Ranged b, float range, int sortDir, Team team) {
            Units.nearby(team, b.x(), b.y(), range, u -> {
                boolean valid;
                if (!u.within(b, range)) {
                    return;
                }
                boolean bl = valid = this.target1.func.get(b.team(), (Unit)u) && this.target2.func.get(b.team(), (Unit)u) && this.target3.func.get(b.team(), (Unit)u);
                if (!valid) {
                    return;
                }
                float val = this.sort.func.get(b, (Unit)u) * (float)sortDir;
                if (val > bestValue || best == null) {
                    bestValue = val;
                    best = u;
                }
            });
        }
    }

    public static class SenseI
    implements LInstruction {
        public int from;
        public int to;
        public int type;

        public SenseI(int from, int to, int type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public SenseI() {
        }

        @Override
        public void run(LExecutor exec) {
            Senseable se;
            Object target = exec.obj(this.from);
            Object sense = exec.obj(this.type);
            if (target == null && sense == LAccess.dead) {
                exec.setnum(this.to, 1.0);
                return;
            }
            Object object = target;
            if (object instanceof Senseable && (se = (Senseable)object) == (Senseable)object) {
                Content co;
                Object object2 = sense;
                if (object2 instanceof Content && (co = (Content)object2) == (Content)object2) {
                    exec.setnum(this.to, se.sense(co));
                } else {
                    LAccess la;
                    object2 = sense;
                    if (object2 instanceof LAccess && (la = (LAccess)((Object)object2)) == (LAccess)((Object)object2)) {
                        Object objOut = se.senseObject(la);
                        if (objOut == Senseable.noSensed) {
                            exec.setnum(this.to, se.sense(la));
                        } else {
                            exec.setobj(this.to, objOut);
                        }
                    }
                }
            } else {
                exec.setobj(this.to, null);
            }
        }
    }

    public static class WriteI
    implements LInstruction {
        public int target;
        public int position;
        public int value;

        public WriteI(int target, int position, int value) {
            this.target = target;
            this.position = position;
            this.value = value;
        }

        public WriteI() {
        }

        @Override
        public void run(LExecutor exec) {
            MemoryBlock.MemoryBuild mem;
            int address = exec.numi(this.position);
            Building from = exec.building(this.target);
            Building building = from;
            if (building instanceof MemoryBlock.MemoryBuild && (mem = (MemoryBlock.MemoryBuild)building) == (MemoryBlock.MemoryBuild)building && from.team == exec.team && address >= 0 && address < mem.memory.length) {
                mem.memory[address] = exec.num(this.value);
            }
        }
    }

    public static class ReadI
    implements LInstruction {
        public int target;
        public int position;
        public int output;

        public ReadI(int target, int position, int output) {
            this.target = target;
            this.position = position;
            this.output = output;
        }

        public ReadI() {
        }

        @Override
        public void run(LExecutor exec) {
            MemoryBlock.MemoryBuild mem;
            int address = exec.numi(this.position);
            Building from = exec.building(this.target);
            Building building = from;
            if (building instanceof MemoryBlock.MemoryBuild && (mem = (MemoryBlock.MemoryBuild)building) == (MemoryBlock.MemoryBuild)building && from.team == exec.team) {
                exec.setnum(this.output, address < 0 || address >= mem.memory.length ? 0.0 : mem.memory[address]);
            }
        }
    }

    public static class GetLinkI
    implements LInstruction {
        public int output;
        public int index;

        public GetLinkI(int output, int index) {
            this.index = index;
            this.output = output;
        }

        public GetLinkI() {
        }

        @Override
        public void run(LExecutor exec) {
            int address = exec.numi(this.index);
            exec.setobj(this.output, address >= 0 && address < exec.links.length ? exec.links[address] : null);
        }
    }

    public static class ControlI
    implements LInstruction {
        public int target;
        public LAccess type = LAccess.enabled;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public ControlI(LAccess type, int target, int p1, int p2, int p3, int p4) {
            this.type = type;
            this.target = target;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        ControlI() {
        }

        @Override
        public void run(LExecutor exec) {
            Building b;
            Object obj = exec.obj(this.target);
            Object object = obj;
            if (object instanceof Building && (b = (Building)object) == (Building)object && b.team == exec.team && exec.linkIds.contains(b.id)) {
                if (this.type.isObj) {
                    b.control(this.type, exec.obj(this.p1), exec.num(this.p2), exec.num(this.p3), exec.num(this.p4));
                } else {
                    b.control(this.type, exec.num(this.p1), exec.num(this.p2), exec.num(this.p3), exec.num(this.p4));
                }
            }
        }
    }

    public static class UnitControlI
    implements LInstruction {
        public LUnitControl type = LUnitControl.move;
        public int p1;
        public int p2;
        public int p3;
        public int p4;
        public int p5;

        public UnitControlI(LUnitControl type, int p1, int p2, int p3, int p4, int p5) {
            this.type = type;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
            this.p5 = p5;
        }

        public UnitControlI() {
        }

        @Nullable
        public static LogicAI checkLogicAI(LExecutor exec, Object unitObj) {
            Unit unit;
            Object object = unitObj;
            if (object instanceof Unit && (unit = (Unit)object) == (Unit)object && exec.obj(2) == unit && unit.team == exec.team && !unit.isPlayer() && !(unit.controller() instanceof FormationAI)) {
                LogicAI la;
                UnitController unitController = unit.controller();
                if (unitController instanceof LogicAI && (la = (LogicAI)unitController) == (LogicAI)unitController) {
                    return la;
                }
                LogicAI la2 = new LogicAI();
                la2.controller = exec.building(3);
                unit.controller(la2);
                unit.mineTile = null;
                unit.clearBuilding();
                return la2;
            }
            return null;
        }

        @Override
        public void run(LExecutor exec) {
            Unit unit;
            Object unitObj = exec.obj(2);
            LogicAI ai = UnitControlI.checkLogicAI(exec, unitObj);
            Object object = unitObj;
            if (object instanceof Unit && (unit = (Unit)object) == (Unit)object && ai != null) {
                ai.controlTimer = 600.0f;
                float x1 = World.unconv(exec.numf(this.p1));
                float y1 = World.unconv(exec.numf(this.p2));
                float d1 = World.unconv(exec.numf(this.p3));
                switch (this.type) {
                    case move: 
                    case stop: 
                    case approach: {
                        ai.control = this.type;
                        ai.moveX = x1;
                        ai.moveY = y1;
                        if (this.type == LUnitControl.approach) {
                            ai.moveRad = d1;
                        }
                        if (this.type != LUnitControl.stop) break;
                        unit.mineTile = null;
                        unit.clearBuilding();
                        break;
                    }
                    case within: {
                        exec.setnum(this.p4, unit.within(x1, y1, d1) ? 1.0 : 0.0);
                        break;
                    }
                    case pathfind: {
                        ai.control = this.type;
                        break;
                    }
                    case target: {
                        ai.posTarget.set(x1, y1);
                        ai.aimControl = this.type;
                        ai.mainTarget = null;
                        ai.shoot = exec.bool(this.p3);
                        break;
                    }
                    case targetp: {
                        Teamc t;
                        ai.aimControl = this.type;
                        Object object2 = exec.obj(this.p1);
                        ai.mainTarget = object2 instanceof Teamc && (t = (Teamc)object2) == (Teamc)object2 ? t : null;
                        ai.shoot = exec.bool(this.p2);
                        break;
                    }
                    case boost: {
                        ai.boost = exec.bool(this.p1);
                        break;
                    }
                    case flag: {
                        unit.flag = exec.num(this.p1);
                        break;
                    }
                    case mine: {
                        Tile tile = Vars.world.tileWorld(x1, y1);
                        if (!unit.canMine()) break;
                        unit.mineTile = unit.validMine(tile) ? tile : null;
                        break;
                    }
                    case payDrop: {
                        Payloadc pay;
                        if (ai.payTimer > 0.0f) {
                            return;
                        }
                        Unit unit2 = unit;
                        if (!(unit2 instanceof Payloadc) || (pay = (Payloadc)((Object)unit2)) != (Payloadc)((Object)unit2) || !pay.hasPayload()) break;
                        Call.payloadDropped(unit, unit.x, unit.y);
                        ai.payTimer = 120.0f;
                        break;
                    }
                    case payTake: {
                        Payloadc pay;
                        if (ai.payTimer > 0.0f) {
                            return;
                        }
                        Unit unit3 = unit;
                        if (!(unit3 instanceof Payloadc) || (pay = (Payloadc)((Object)unit3)) != (Payloadc)((Object)unit3)) break;
                        if (exec.bool(this.p1)) {
                            Unit result = Units.closest(unit.team, unit.x, unit.y, unit.type.hitSize * 2.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(unit, u.hitSize + unit.hitSize * 1.2f));
                            if (result != null) {
                                Call.pickedUnitPayload(unit, result);
                            }
                        } else {
                            Building tile = Vars.world.buildWorld(unit.x, unit.y);
                            if (tile != null && tile.team == unit.team) {
                                if (tile.block.buildVisibility != BuildVisibility.hidden && tile.canPickup() && pay.canPickup(tile)) {
                                    Call.pickedBuildPayload(unit, tile, true);
                                } else {
                                    Payload current = tile.getPayload();
                                    if (current != null && pay.canPickupPayload(current)) {
                                        Call.pickedBuildPayload(unit, tile, false);
                                    }
                                }
                            }
                        }
                        ai.payTimer = 120.0f;
                        break;
                    }
                    case build: {
                        Building b;
                        Content c;
                        Block block;
                        Object tile;
                        if (!Vars.state.rules.logicUnitBuild || !unit.canBuild() || !((tile = exec.obj(this.p3)) instanceof Block) || (block = (Block)tile) != (Block)tile) break;
                        int x = World.toTile(x1 - block.offset / 8.0f);
                        int y = World.toTile(y1 - block.offset / 8.0f);
                        int rot = exec.numi(this.p4);
                        if (ai.plan.x != x || ai.plan.y != y || ai.plan.block != block || unit.plans.isEmpty()) {
                            ai.plan.progress = 0.0f;
                            ai.plan.initialized = false;
                            ai.plan.stuck = false;
                        }
                        Object conf = exec.obj(this.p5);
                        ai.plan.set(x, y, rot, block);
                        Object object3 = conf;
                        ai.plan.config = object3 instanceof Content && (c = (Content)object3) == (Content)object3 ? c : ((object3 = conf) instanceof Building && (b = (Building)object3) == (Building)object3 ? b : null);
                        unit.clearBuilding();
                        Tile tile2 = ai.plan.tile();
                        if (tile2 == null || tile2.block() == block && tile2.build != null && tile2.build.rotation == rot) break;
                        unit.updateBuilding = true;
                        unit.addBuild(ai.plan);
                        break;
                    }
                    case getBlock: {
                        float range = Math.max(unit.range(), 220.0f);
                        if (!unit.within(x1, y1, range)) {
                            exec.setobj(this.p3, null);
                            exec.setobj(this.p4, null);
                            break;
                        }
                        Tile tile = Vars.world.tileWorld(x1, y1);
                        Block block = tile == null ? null : (!tile.synthetic() ? (tile.solid() ? Blocks.stoneWall : Blocks.air) : tile.block());
                        exec.setobj(this.p3, block);
                        exec.setobj(this.p4, tile != null && tile.build != null ? tile.build : null);
                        break;
                    }
                    case itemDrop: {
                        int accepted;
                        if (ai.itemTimer > 0.0f) {
                            return;
                        }
                        Building build = exec.building(this.p1);
                        int dropped = Math.min(unit.stack.amount, exec.numi(this.p2));
                        if (build == null || build.team != unit.team || !build.isValid() || dropped <= 0 || !unit.within(build, 45.0f + (float)(build.block.size * 8) / 2.0f) || (accepted = build.acceptStack(unit.item(), dropped, unit)) <= 0) break;
                        Call.transferItemTo(unit, unit.item(), accepted, unit.x, unit.y, build);
                        ai.itemTimer = 120.0f;
                        break;
                    }
                    case itemTake: {
                        int taken;
                        Item item;
                        Object rot;
                        if (ai.itemTimer > 0.0f) {
                            return;
                        }
                        Building build = exec.building(this.p1);
                        int amount = exec.numi(this.p3);
                        if (build == null || build.team != unit.team || !build.isValid() || build.items == null || !((rot = exec.obj(this.p2)) instanceof Item) || (item = (Item)rot) != (Item)rot || !unit.within(build, 45.0f + (float)(build.block.size * 8) / 2.0f) || (taken = Math.min(build.items.get(item), Math.min(amount, unit.maxAccepted(item)))) <= 0) break;
                        Call.takeItems(build, item, taken, unit);
                        ai.itemTimer = 120.0f;
                        break;
                    }
                }
            }
        }
    }

    public static class UnitLocateI
    implements LInstruction {
        public LLocate locate = LLocate.building;
        public BlockFlag flag = BlockFlag.core;
        public int enemy;
        public int ore;
        public int outX;
        public int outY;
        public int outFound;
        public int outBuild;

        public UnitLocateI(LLocate locate, BlockFlag flag, int enemy, int ore, int outX, int outY, int outFound, int outBuild) {
            this.locate = locate;
            this.flag = flag;
            this.enemy = enemy;
            this.ore = ore;
            this.outX = outX;
            this.outY = outY;
            this.outFound = outFound;
            this.outBuild = outBuild;
        }

        public UnitLocateI() {
        }

        @Override
        public void run(LExecutor exec) {
            Unit unit;
            Object unitObj = exec.obj(2);
            LogicAI ai = UnitControlI.checkLogicAI(exec, unitObj);
            Object object = unitObj;
            if (object instanceof Unit && (unit = (Unit)object) == (Unit)object && ai != null) {
                ai.controlTimer = 600.0f;
                Cache cache = (Cache)((Object)ai.execCache.get((Object)this, Cache::new));
                if (ai.checkTargetTimer(this)) {
                    Tile res = null;
                    boolean build = false;
                    switch (this.locate) {
                        case ore: {
                            Item item;
                            Object object2 = exec.obj(this.ore);
                            if (!(object2 instanceof Item) || (item = (Item)object2) != (Item)object2) break;
                            res = Vars.indexer.findClosestOre(unit, item);
                            break;
                        }
                        case building: {
                            res = Geometry.findClosest(unit.x, unit.y, exec.bool(this.enemy) ? Vars.indexer.getEnemy(unit.team, this.flag) : Vars.indexer.getAllied(unit.team, this.flag));
                            build = true;
                            break;
                        }
                        case spawn: {
                            res = Geometry.findClosest(unit.x, unit.y, Vars.spawner.getSpawns());
                            break;
                        }
                        case damaged: {
                            Building b = Units.findDamagedTile(unit.team, unit.x, unit.y);
                            res = b == null ? null : b.tile;
                            build = true;
                        }
                    }
                    if (!(res == null || build && res.build == null)) {
                        cache.found = true;
                        cache.x = World.conv(build ? res.build.x : res.worldx());
                        exec.setnum(this.outX, cache.x);
                        cache.y = World.conv(build ? res.build.y : res.worldy());
                        exec.setnum(this.outY, cache.y);
                        exec.setnum(this.outFound, 1.0);
                    } else {
                        cache.found = false;
                        exec.setnum(this.outFound, 0.0);
                    }
                    exec.setobj(this.outBuild, res != null && res.build != null && res.build.team == exec.team ? (cache.build = res.build) : null);
                } else {
                    exec.setobj(this.outBuild, cache.build);
                    exec.setbool(this.outFound, cache.found);
                    exec.setnum(this.outX, cache.x);
                    exec.setnum(this.outY, cache.y);
                }
            } else {
                exec.setbool(this.outFound, false);
            }
        }

        static class Cache {
            float x;
            float y;
            boolean found;
            Building build;

            Cache() {
            }
        }
    }

    public static class UnitBindI
    implements LInstruction {
        public int type;

        public UnitBindI(int type) {
            this.type = type;
        }

        public UnitBindI() {
        }

        @Override
        public void run(LExecutor exec) {
            UnitType type;
            Object object;
            if (exec.binds == null || exec.binds.length != Vars.content.units().size) {
                exec.binds = new int[Vars.content.units().size];
            }
            if ((object = exec.obj(this.type)) instanceof UnitType && (type = (UnitType)object) == (UnitType)object) {
                Seq<Unit> seq = exec.team.data().unitCache(type);
                if (seq != null && seq.any()) {
                    short s = type.id;
                    exec.binds[s] = exec.binds[s] % seq.size;
                    if (exec.binds[type.id] < seq.size) {
                        exec.setconst(2, seq.get(exec.binds[type.id]));
                    }
                    short s2 = type.id;
                    exec.binds[s2] = exec.binds[s2] + 1;
                } else {
                    exec.setconst(2, null);
                }
            } else {
                Unit u;
                object = exec.obj(this.type);
                if (object instanceof Unit && (u = (Unit)object) == (Unit)object && u.team == exec.team) {
                    exec.setconst(2, u);
                } else {
                    exec.setconst(2, null);
                }
            }
        }
    }
}

