/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.Strings;
import mindustry.gen.LogicIO;
import mindustry.logic.LAssembler;
import mindustry.logic.LStatement;
import mindustry.logic.LStatements;

public class LParser {
    private static final String[] tokens = new String[16];
    private static final int maxJumps = 500;
    private static final StringMap opNameChanges = StringMap.of("atan2", "angle", "dst", "len");
    private static final Seq<JumpIndex> jumps = new Seq();
    private static final ObjectIntMap<String> jumpLocations = new ObjectIntMap();
    Seq<LStatement> statements = new Seq();
    char[] chars;
    int pos;
    int line;
    int tok;

    LParser(String text) {
        this.chars = text.toCharArray();
    }

    public static Seq<LStatement> parse(String text) {
        if (text == null || text.isEmpty()) {
            return new Seq<LStatement>();
        }
        return new LParser(text).parse();
    }

    void comment() {
        while (this.pos < this.chars.length && this.chars[this.pos++] != '\n') {
        }
    }

    void error(String message) {
        throw new RuntimeException("Invalid code. " + message);
    }

    String string() {
        int from = this.pos;
        while (this.pos++ < this.chars.length) {
            char c = this.chars[this.pos];
            if (c == '\n') {
                this.error("Missing closing quote \" before end of line.");
                continue;
            }
            if (c != '\"') continue;
            break;
        }
        if (this.chars[this.pos] != '\"') {
            this.error("Missing closing quote \" before end of file.");
        }
        return new String(this.chars, from, ++this.pos - from);
    }

    String token() {
        char c;
        int from = this.pos;
        while (this.pos < this.chars.length && (c = this.chars[this.pos]) != '\n' && c != ' ' && c != '#' && c != '\t' && c != ';') {
            ++this.pos;
        }
        return new String(this.chars, from, this.pos - from);
    }

    void checkRead() {
        if (tokens[0].equals("op")) {
            LParser.tokens[1] = opNameChanges.get(tokens[1], tokens[1]);
        }
    }

    void statement() {
        boolean expectNext = false;
        this.tok = 0;
        while (this.pos < this.chars.length) {
            char c = this.chars[this.pos];
            if (this.tok >= tokens.length) {
                this.error("Line too long; may only contain " + tokens.length + " tokens");
            }
            if (c == '\n' || c == ';') break;
            if (expectNext && c != ' ' && c != '#' && c != '\t') {
                this.error("Expected space after string/token.");
            }
            expectNext = false;
            if (c == '#') {
                this.comment();
                break;
            }
            if (c == '\"') {
                LParser.tokens[this.tok++] = this.string();
                expectNext = true;
                continue;
            }
            if (c != ' ' && c != '\t') {
                LParser.tokens[this.tok++] = this.token();
                expectNext = true;
                continue;
            }
            ++this.pos;
        }
        if (this.tok > 0) {
            this.checkRead();
            if (this.tok == 1 && tokens[0].charAt(tokens[0].length() - 1) == ':') {
                if (LParser.jumpLocations.size >= 500) {
                    this.error("Too many jump locations. Max jumps: 500");
                }
                jumpLocations.put(tokens[0].substring(0, tokens[0].length() - 1), this.line);
            } else {
                LStatements.JumpStatement jump;
                LStatement st;
                String jumpLoc = null;
                boolean wasJump = tokens[0].equals("jump") && this.tok > 1 && !Strings.canParseInt(tokens[1]);
                if (wasJump) {
                    jumpLoc = tokens[1];
                    LParser.tokens[1] = "-1";
                }
                try {
                    st = LogicIO.read(tokens, this.tok);
                }
                catch (Exception e) {
                    Log.err(e);
                    st = new LStatements.InvalidStatement();
                }
                LStatement lStatement = st;
                if (lStatement instanceof LStatements.JumpStatement && (jump = (LStatements.JumpStatement)lStatement) == (LStatements.JumpStatement)lStatement && wasJump) {
                    jumps.add(new JumpIndex(jump, jumpLoc));
                }
                if (st != null) {
                    this.statements.add(st);
                } else if (LAssembler.customParsers.containsKey(tokens[0])) {
                    this.statements.add(LAssembler.customParsers.get(tokens[0]).get(tokens));
                } else {
                    this.statements.add(new LStatements.InvalidStatement());
                }
                ++this.line;
            }
        }
    }

    Seq<LStatement> parse() {
        jumps.clear();
        jumpLocations.clear();
        block4: while (this.pos < this.chars.length && this.line < 1000) {
            switch (this.chars[this.pos]) {
                case '\n': 
                case ' ': {
                    ++this.pos;
                    continue block4;
                }
                case '\r': {
                    this.pos += 2;
                    continue block4;
                }
            }
            this.statement();
        }
        for (JumpIndex i : jumps) {
            if (!jumpLocations.containsKey(i.location)) {
                this.error("Undefined jump location: \"" + i.location + "\". Make sure the jump label exists and is typed correctly.");
            }
            i.jump.destIndex = jumpLocations.get(i.location, -1);
        }
        return this.statements;
    }

    static class JumpIndex {
        LStatements.JumpStatement jump;
        String location;

        public JumpIndex(LStatements.JumpStatement jump, String location) {
            this.jump = jump;
            this.location = location;
        }
    }
}

