/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.func.Prov;
import arc.graphics.Color;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.logic.ConditionOp;
import mindustry.logic.LAccess;
import mindustry.logic.LAssembler;
import mindustry.logic.LCanvas;
import mindustry.logic.LExecutor;
import mindustry.logic.LLocate;
import mindustry.logic.LStatement;
import mindustry.logic.LUnitControl;
import mindustry.logic.LogicOp;
import mindustry.logic.RadarSort;
import mindustry.logic.RadarTarget;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.meta.BlockFlag;

public class LStatements {

    public static class UnitLocateStatement
    extends LStatement {
        public LLocate locate = LLocate.building;
        public BlockFlag flag = BlockFlag.core;
        public String enemy = "true";
        public String ore = "@copper";
        public String outX = "outx";
        public String outY = "outy";
        public String outFound = "found";
        public String outBuild = "building";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.add(" find ").left().self(this::param);
            table.button(b -> {
                b.label(() -> this.locate.name());
                b.clicked(() -> this.showSelect((Button)b, LLocate.all, this.locate, t -> {
                    this.locate = t;
                    this.rebuild(table);
                }, 2, cell -> cell.size(110.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(110.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            switch (this.locate) {
                case building: {
                    this.row(table);
                    table.add(" group ").left().self(this::param);
                    table.button(b -> {
                        b.label(() -> this.flag.name());
                        b.clicked(() -> this.showSelect((Button)b, BlockFlag.allLogic, this.flag, t -> {
                            this.flag = t;
                        }, 2, cell -> cell.size(110.0f, 50.0f)));
                    }, (Button.ButtonStyle)Styles.logict, () -> {}).size(110.0f, 40.0f).color(table.color).left().padLeft(2.0f);
                    this.row(table);
                    table.add(" enemy ").left().self(this::param);
                    this.fields(table, this.enemy, str -> {
                        this.enemy = str;
                    });
                    table.row();
                    break;
                }
                case ore: {
                    table.add(" ore ").left().self(this::param);
                    table.table(ts -> {
                        ts.color.set(table.color);
                        this.fields((Table)ts, this.ore, str -> {
                            this.ore = str;
                        });
                        ts.button(b -> {
                            b.image(Icon.pencilSmall);
                            b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                                t.row();
                                t.table(i -> {
                                    i.left();
                                    int c = 0;
                                    for (Item item : Vars.content.items()) {
                                        if (!item.unlockedNow()) continue;
                                        i.button((Drawable)new TextureRegionDrawable(item.icon(Cicon.small)), Styles.cleari, () -> {
                                            this.ore = "@" + item.name;
                                            this.rebuild(table);
                                            hide.run();
                                        }).size(40.0f).get().resizeImage(Cicon.small.size);
                                        if (++c % 6 != 0) continue;
                                        i.row();
                                    }
                                }).colspan(3).width(240.0f).left();
                            }));
                        }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table.color);
                    });
                    table.row();
                    break;
                }
                case spawn: 
                case damaged: {
                    table.row();
                }
            }
            table.add(" outX ").left().self(this::param);
            this.fields(table, this.outX, str -> {
                this.outX = str;
            });
            table.add(" outY ").left().self(this::param);
            this.fields(table, this.outY, str -> {
                this.outY = str;
            });
            this.row(table);
            table.add(" found ").left().self(this::param);
            this.fields(table, this.outFound, str -> {
                this.outFound = str;
            });
            if (this.locate != LLocate.ore) {
                table.add(" building ").left().self(this::param);
                this.fields(table, this.outBuild, str -> {
                    this.outBuild = str;
                });
            }
        }

        @Override
        public Color color() {
            return Pal.logicUnits;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitLocateI(this.locate, this.flag, builder.var(this.enemy), builder.var(this.ore), builder.var(this.outX), builder.var(this.outY), builder.var(this.outFound), builder.var(this.outBuild));
        }
    }

    public static class UnitRadarStatement
    extends RadarStatement {
        public UnitRadarStatement() {
            this.radar = "0";
        }

        @Override
        public boolean buildFrom() {
            return false;
        }

        @Override
        public Color color() {
            return Pal.logicUnits;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.RadarI(this.target1, this.target2, this.target3, this.sort, 2, builder.var(this.sortOrder), builder.var(this.output));
        }
    }

    public static class UnitControlStatement
    extends LStatement {
        public LUnitControl type = LUnitControl.move;
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";
        public String p5 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.left();
            table.add(" ");
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, LUnitControl.all, this.type, t -> {
                    if (t == LUnitControl.build && !Vars.state.rules.logicUnitBuild) {
                        Vars.ui.showInfo("@logic.nounitbuild");
                    } else {
                        this.type = t;
                    }
                    this.rebuild(table);
                }, 2, cell -> cell.size(120.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(120.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            this.row(table);
            int c = 0;
            for (int i = 0; i < this.type.params.length; ++i) {
                this.fields(table, this.type.params[i], i == 0 ? this.p1 : (i == 1 ? this.p2 : (i == 2 ? this.p3 : (i == 3 ? this.p4 : this.p5))), i == 0 ? v -> {
                    this.p1 = v;
                } : (i == 1 ? v -> {
                    this.p2 = v;
                } : (i == 2 ? v -> {
                    this.p3 = v;
                } : (i == 3 ? v -> {
                    this.p4 = v;
                } : v -> {
                    this.p5 = v;
                })))).width(100.0f);
                if (++c % 2 == 0) {
                    this.row(table);
                }
                if (i != 3) continue;
                table.row();
            }
        }

        @Override
        public Color color() {
            return Pal.logicUnits;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitControlI(this.type, builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4), builder.var(this.p5));
        }
    }

    public static class UnitBindStatement
    extends LStatement {
        public String type = "@poly";

        @Override
        public void build(Table table) {
            table.add(" type ");
            TextField field = this.field(table, this.type, str -> {
                this.type = str;
            }).get();
            table.button(b -> {
                b.image(Icon.pencilSmall);
                b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                    t.row();
                    t.table(i -> {
                        i.left();
                        int c = 0;
                        for (UnitType item : Vars.content.units()) {
                            if (!item.unlockedNow() || item.isHidden()) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.icon(Cicon.small)), Styles.cleari, () -> {
                                this.type = "@" + item.name;
                                field.setText(this.type);
                                hide.run();
                            }).size(40.0f).get().resizeImage(Cicon.small.size);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table.color);
        }

        @Override
        public Color color() {
            return Pal.logicUnits;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitBindI(builder.var(this.type));
        }
    }

    public static class JumpStatement
    extends LStatement {
        private static Color last = new Color();
        public transient LCanvas.StatementElem dest;
        public int destIndex;
        public ConditionOp op = ConditionOp.notEqual;
        public String value = "x";
        public String compare = "false";

        @Override
        public void build(Table table) {
            table.add("if ").padLeft(4.0f);
            last = table.color;
            table.table(this::rebuild);
            table.add().growX();
            table.add(new LCanvas.JumpButton(() -> this.dest, s -> {
                this.dest = s;
            })).size(30.0f).right().padLeft(-8.0f);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.setColor(last);
            if (this.op != ConditionOp.always) {
                this.field(table, this.value, str -> {
                    this.value = str;
                });
            }
            table.button(b -> {
                b.label(() -> this.op.symbol);
                b.clicked(() -> this.showSelect((Button)b, ConditionOp.all, this.op, o -> {
                    this.op = o;
                    this.rebuild(table);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(this.op == ConditionOp.always ? 80.0f : 48.0f, 40.0f).pad(4.0f).color(table.color);
            if (this.op != ConditionOp.always) {
                this.field(table, this.compare, str -> {
                    this.compare = str;
                });
            }
        }

        @Override
        public void setupUI() {
            if (this.elem != null && this.destIndex >= 0 && this.destIndex < this.elem.parent.getChildren().size) {
                this.dest = (LCanvas.StatementElem)this.elem.parent.getChildren().get(this.destIndex);
            }
        }

        @Override
        public void saveUI() {
            if (this.elem != null) {
                this.destIndex = this.dest == null ? -1 : this.dest.parent.getChildren().indexOf(this.dest);
            }
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.JumpI(this.op, builder.var(this.value), builder.var(this.compare), this.destIndex);
        }

        @Override
        public Color color() {
            return Pal.logicControl;
        }
    }

    public static class EndStatement
    extends LStatement {
        @Override
        public void build(Table table) {
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.EndI();
        }

        @Override
        public Color color() {
            return Pal.logicControl;
        }
    }

    public static class WaitStatement
    extends LStatement {
        public String value = "0.5";

        @Override
        public void build(Table table) {
            this.field(table, this.value, str -> {
                this.value = str;
            });
            table.add(" sec");
        }

        @Override
        public Color color() {
            return Pal.logicOperations;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.WaitI(builder.var(this.value));
        }
    }

    public static class OperationStatement
    extends LStatement {
        public LogicOp op = LogicOp.add;
        public String dest = "result";
        public String a = "a";
        public String b = "b";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            this.field(table, this.dest, str -> {
                this.dest = str;
            });
            table.add(" = ");
            if (this.op.unary) {
                this.opButton(table, table);
                this.field(table, this.a, str -> {
                    this.a = str;
                });
            } else {
                this.row(table);
                if (this.op.func) {
                    if (LCanvas.useRows()) {
                        table.left();
                        table.row();
                        table.table(c -> {
                            c.color.set(this.color());
                            c.left();
                            this.funcs((Table)c, table);
                        }).colspan(2).left();
                    } else {
                        this.funcs(table, table);
                    }
                } else {
                    this.field(table, this.a, str -> {
                        this.a = str;
                    });
                    this.opButton(table, table);
                    this.field(table, this.b, str -> {
                        this.b = str;
                    });
                }
            }
        }

        void funcs(Table table, Table parent) {
            this.opButton(table, parent);
            this.field(table, this.a, str -> {
                this.a = str;
            });
            this.field(table, this.b, str -> {
                this.b = str;
            });
        }

        void opButton(Table table, Table parent) {
            table.button(b -> {
                b.label(() -> this.op.symbol);
                b.clicked(() -> this.showSelect((Button)b, LogicOp.all, this.op, o -> {
                    this.op = o;
                    this.rebuild(parent);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table.color);
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.OpI(this.op, builder.var(this.a), builder.var(this.b), builder.var(this.dest));
        }

        @Override
        public Color color() {
            return Pal.logicOperations;
        }
    }

    public static class SetStatement
    extends LStatement {
        public String to = "result";
        public String from = "0";

        @Override
        public void build(Table table) {
            this.field(table, this.to, str -> {
                this.to = str;
            });
            table.add(" = ");
            this.field(table, this.from, str -> {
                this.from = str;
            });
        }

        @Override
        public Color color() {
            return Pal.logicOperations;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetI(builder.var(this.from), builder.var(this.to));
        }
    }

    public static class SensorStatement
    extends LStatement {
        public String to = "result";
        public String from = "block1";
        public String type = "@copper";
        private transient int selected = 0;
        private transient TextField tfield;

        @Override
        public void build(Table table) {
            this.field(table, this.to, str -> {
                this.to = str;
            });
            table.add(" = ");
            this.row(table);
            this.tfield = this.field(table, this.type, str -> {
                this.type = str;
            }).padRight(0.0f).get();
            table.button(b -> {
                b.image(Icon.pencilSmall);
                b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                    Table[] tables = new Table[]{new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Item item : Vars.content.items()) {
                            if (!item.unlockedNow()) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.icon(Cicon.small)), Styles.cleari, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Liquid item : Vars.content.liquids()) {
                            if (!item.unlockedNow()) continue;
                            i.button((Drawable)new TextureRegionDrawable(item.icon(Cicon.small)), Styles.cleari, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        for (LAccess sensor : LAccess.senseable) {
                            i.button(sensor.name(), Styles.cleart, () -> {
                                this.stype("@" + sensor.name());
                                hide.run();
                            }).size(240.0f, 40.0f).self(c -> LCanvas.tooltip(c, sensor)).row();
                        }
                    })};
                    Drawable[] icons = new Drawable[]{Icon.box, Icon.liquid, Icon.tree};
                    Stack stack = new Stack(tables[this.selected]);
                    ButtonGroup group = new ButtonGroup();
                    for (int i2 = 0; i2 < tables.length; ++i2) {
                        int fi = i2;
                        t.button(icons[i2], Styles.clearTogglei, () -> {
                            this.selected = fi;
                            stack.clearChildren();
                            stack.addChild(tables[this.selected]);
                            t.parent.parent.pack();
                            t.parent.parent.invalidateHierarchy();
                        }).height(50.0f).growX().checked(this.selected == fi).group(group);
                    }
                    t.row();
                    t.add(stack).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table.color);
            table.add(" in ").self(this::param);
            this.field(table, this.from, str -> {
                this.from = str;
            });
        }

        private void stype(String text) {
            this.tfield.setText(text);
            this.type = text;
        }

        @Override
        public Color color() {
            return Pal.logicBlocks;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SenseI(builder.var(this.from), builder.var(this.to), builder.var(this.type));
        }
    }

    public static class RadarStatement
    extends LStatement {
        public RadarTarget target1 = RadarTarget.enemy;
        public RadarTarget target2 = RadarTarget.any;
        public RadarTarget target3 = RadarTarget.any;
        public RadarSort sort = RadarSort.distance;
        public String radar = "turret1";
        public String sortOrder = "1";
        public String output = "result";

        @Override
        public void build(Table table) {
            table.defaults().left();
            if (this.buildFrom()) {
                table.add(" from ").self(this::param);
                this.fields(table, this.radar, v -> {
                    this.radar = v;
                });
                this.row(table);
            }
            for (int i = 0; i < 3; ++i) {
                int fi = i;
                Prov<RadarTarget> get = () -> fi == 0 ? this.target1 : (fi == 1 ? this.target2 : this.target3);
                table.add(i == 0 ? " target " : " and ").self(this::param);
                table.button(b -> {
                    b.label(() -> ((RadarTarget)((Object)((Object)((Object)get.get())))).name());
                    b.clicked(() -> this.showSelect((Button)b, RadarTarget.all, (RadarTarget)((Object)((Object)((Object)get.get()))), t -> {
                        if (fi == 0) {
                            this.target1 = t;
                        } else if (fi == 1) {
                            this.target2 = t;
                        } else {
                            this.target3 = t;
                        }
                    }, 2, cell -> cell.size(100.0f, 50.0f)));
                }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
                if (i != 1) continue;
                this.row(table);
            }
            table.add(" order ").self(this::param);
            this.fields(table, this.sortOrder, v -> {
                this.sortOrder = v;
            });
            table.row();
            table.add(" sort ").self(this::param);
            table.button(b -> {
                b.label(() -> this.sort.name());
                b.clicked(() -> this.showSelect((Button)b, RadarSort.all, this.sort, t -> {
                    this.sort = t;
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            table.add(" output ").self(this::param);
            this.fields(table, this.output, v -> {
                this.output = v;
            });
        }

        public boolean buildFrom() {
            return true;
        }

        @Override
        public Color color() {
            return Pal.logicBlocks;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.RadarI(this.target1, this.target2, this.target3, this.sort, builder.var(this.radar), builder.var(this.sortOrder), builder.var(this.output));
        }
    }

    public static class ControlStatement
    extends LStatement {
        public LAccess type = LAccess.enabled;
        public String target = "block1";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.left();
            table.add(" set ");
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, LAccess.controls, this.type, t -> {
                    this.type = t;
                    this.rebuild(table);
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            table.add(" of ").self(this::param);
            this.field(table, this.target, v -> {
                this.target = v;
            });
            this.row(table);
            int c = 0;
            for (int i = 0; i < this.type.params.length; ++i) {
                this.fields(table, this.type.params[i], i == 0 ? this.p1 : (i == 1 ? this.p2 : (i == 2 ? this.p3 : this.p4)), i == 0 ? v -> {
                    this.p1 = v;
                } : (i == 1 ? v -> {
                    this.p2 = v;
                } : (i == 2 ? v -> {
                    this.p3 = v;
                } : v -> {
                    this.p4 = v;
                })));
                if (++c % 2 != 0) continue;
                this.row(table);
            }
        }

        @Override
        public Color color() {
            return Pal.logicBlocks;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ControlI(this.type, builder.var(this.target), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }
    }

    public static class GetLinkStatement
    extends LStatement {
        public String output = "result";
        public String address = "0";

        @Override
        public void build(Table table) {
            this.field(table, this.output, str -> {
                this.output = str;
            });
            table.add(" = link# ");
            this.field(table, this.address, str -> {
                this.address = str;
            });
        }

        @Override
        public Color color() {
            return Pal.logicBlocks;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetLinkI(builder.var(this.output), builder.var(this.address));
        }
    }

    public static class PrintFlushStatement
    extends LStatement {
        public String target = "message1";

        @Override
        public void build(Table table) {
            table.add(" to ");
            this.field(table, this.target, str -> {
                this.target = str;
            });
        }

        @Override
        public Color color() {
            return Pal.logicBlocks;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintFlushI(builder.var(this.target));
        }
    }

    public static class DrawFlushStatement
    extends LStatement {
        public String target = "display1";

        @Override
        public void build(Table table) {
            table.add(" to ");
            this.field(table, this.target, str -> {
                this.target = str;
            });
        }

        @Override
        public Color color() {
            return Pal.logicBlocks;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.DrawFlushI(builder.var(this.target));
        }
    }

    public static class PrintStatement
    extends LStatement {
        public String value = "\"frog\"";

        @Override
        public void build(Table table) {
            this.field(table, this.value, str -> {
                this.value = str;
            }).width(0.0f).growX().padRight(3.0f);
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintI(builder.var(this.value));
        }

        @Override
        public Color color() {
            return Pal.logicIo;
        }
    }

    public static class DrawStatement
    extends LStatement {
        public LogicDisplay.GraphicsType type = LogicDisplay.GraphicsType.clear;
        public String x = "0";
        public String y = "0";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.left();
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, LogicDisplay.GraphicsType.all, this.type, t -> {
                    this.type = t;
                    if (this.type == LogicDisplay.GraphicsType.color) {
                        this.p2 = "255";
                    }
                    if (this.type == LogicDisplay.GraphicsType.image) {
                        this.p1 = "@copper";
                        this.p2 = "32";
                        this.p3 = "0";
                    }
                    this.rebuild(table);
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            if (this.type != LogicDisplay.GraphicsType.stroke) {
                this.row(table);
            }
            table.table(s -> {
                s.left();
                s.setColor(table.color);
                switch (this.type) {
                    case clear: {
                        this.fields((Table)s, "r", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "g", this.y, v -> {
                            this.y = v;
                        });
                        this.fields((Table)s, "b", this.p1, v -> {
                            this.p1 = v;
                        });
                        break;
                    }
                    case color: {
                        this.fields((Table)s, "r", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "g", this.y, v -> {
                            this.y = v;
                        });
                        this.fields((Table)s, "b", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "a", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case stroke: {
                        s.add().width(4.0f);
                        this.fields((Table)s, this.x, v -> {
                            this.x = v;
                        });
                        break;
                    }
                    case line: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x2", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "y2", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case rect: 
                    case lineRect: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "width", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "height", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case poly: 
                    case linePoly: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "sides", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "radius", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "rotation", this.p3, v -> {
                            this.p3 = v;
                        });
                        break;
                    }
                    case triangle: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x2", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "y2", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x3", this.p3, v -> {
                            this.p3 = v;
                        });
                        this.fields((Table)s, "y3", this.p4, v -> {
                            this.p4 = v;
                        });
                        break;
                    }
                    case image: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "image", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "size", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "rotation", this.p3, v -> {
                            this.p3 = v;
                        });
                    }
                }
            }).expand().left();
        }

        @Override
        public void afterRead() {
            if (this.type == LogicDisplay.GraphicsType.color && this.p2.equals("0")) {
                this.p2 = "255";
            }
        }

        @Override
        public Color color() {
            return Pal.logicIo;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.DrawI((byte)this.type.ordinal(), 0, builder.var(this.x), builder.var(this.y), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }
    }

    public static class WriteStatement
    extends LStatement {
        public String input = "result";
        public String target = "cell1";
        public String address = "0";

        @Override
        public void build(Table table) {
            table.add(" write ");
            this.field(table, this.input, str -> {
                this.input = str;
            });
            table.add(" to ");
            this.fields(table, this.target, str -> {
                this.target = str;
            });
            this.row(table);
            table.add(" at ");
            this.field(table, this.address, str -> {
                this.address = str;
            });
        }

        @Override
        public Color color() {
            return Pal.logicIo;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.WriteI(builder.var(this.target), builder.var(this.address), builder.var(this.input));
        }
    }

    public static class ReadStatement
    extends LStatement {
        public String output = "result";
        public String target = "cell1";
        public String address = "0";

        @Override
        public void build(Table table) {
            table.add(" read ");
            this.field(table, this.output, str -> {
                this.output = str;
            });
            table.add(" = ");
            this.fields(table, this.target, str -> {
                this.target = str;
            });
            this.row(table);
            table.add(" at ");
            this.field(table, this.address, str -> {
                this.address = str;
            });
        }

        @Override
        public Color color() {
            return Pal.logicIo;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ReadI(builder.var(this.target), builder.var(this.address), builder.var(this.output));
        }
    }

    public static class InvalidStatement
    extends LStatement {
        @Override
        public void build(Table table) {
        }

        @Override
        public Color color() {
            return Pal.logicOperations;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.NoopI();
        }
    }

    public static class CommentStatement
    extends LStatement {
        public String comment = "";

        @Override
        public void build(Table table) {
            table.area(this.comment, Styles.nodeArea, v -> {
                this.comment = v;
            }).growX().height(90.0f).padLeft(2.0f).padRight(6.0f).color(table.color);
        }

        @Override
        public Color color() {
            return Pal.logicControl;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return null;
        }
    }
}

