/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.scene.style.Drawable;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.LogicIO;
import mindustry.gen.Tex;
import mindustry.logic.LCanvas;
import mindustry.logic.LStatement;
import mindustry.logic.LStatements;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class LogicDialog
extends BaseDialog {
    public LCanvas canvas;
    Cons<String> consumer = s -> {};

    public LogicDialog() {
        super("logic");
        this.clearChildren();
        this.canvas = new LCanvas();
        this.shouldPause = true;
        this.addCloseListener();
        this.buttons.defaults().size(160.0f, 64.0f);
        this.buttons.button("@back", Icon.left, this::hide).name("back");
        this.buttons.button("@edit", Icon.edit, () -> {
            BaseDialog dialog = new BaseDialog("@editor.export");
            dialog.cont.pane((Table p) -> {
                p.margin(10.0f);
                p.table(Tex.button, t -> {
                    TextButton.TextButtonStyle style = Styles.cleart;
                    t.defaults().size(280.0f, 60.0f).left();
                    t.button("@schematic.copy", (Drawable)Icon.copy, style, () -> {
                        dialog.hide();
                        Core.app.setClipboardText(this.canvas.save());
                    }).marginLeft(12.0f);
                    t.row();
                    t.button("@schematic.copy.import", (Drawable)Icon.download, style, () -> {
                        dialog.hide();
                        try {
                            this.canvas.load(Core.app.getClipboardText().replace("\r\n", "\n"));
                        }
                        catch (Throwable e) {
                            Vars.ui.showException(e);
                        }
                    }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null);
                });
            });
            dialog.addCloseButton();
            dialog.show();
        }).name("edit");
        this.buttons.button("@add", Icon.add, () -> {
            BaseDialog dialog = new BaseDialog("@add");
            dialog.cont.pane((Table t) -> {
                t.background(Tex.button);
                int i = 0;
                for (Prov<LStatement> prov : LogicIO.allStatements) {
                    LStatement example = prov.get();
                    if (example instanceof LStatements.InvalidStatement || example.hidden()) continue;
                    TextButton.TextButtonStyle style = new TextButton.TextButtonStyle(Styles.cleart);
                    style.fontColor = example.color();
                    style.font = Fonts.outline;
                    t.button(example.name(), style, () -> {
                        this.canvas.add((LStatement)prov.get());
                        dialog.hide();
                    }).size(140.0f, 50.0f).self(c -> LCanvas.tooltip(c, "lst." + example.name()));
                    if (++i % 2 != 0) continue;
                    t.row();
                }
            });
            dialog.addCloseButton();
            dialog.show();
        }).disabled(t -> this.canvas.statements.getChildren().size >= 1000);
        this.add(this.canvas).grow().name("canvas");
        this.row();
        this.add(this.buttons).growX().name("canvas");
        this.hidden(() -> this.consumer.get(this.canvas.save()));
        this.onResize(() -> this.canvas.rebuild());
    }

    public void show(String code, Cons<String> modified) {
        this.canvas.statements.clearChildren();
        this.canvas.rebuild();
        try {
            this.canvas.load(code);
        }
        catch (Throwable t) {
            Log.err(t);
            this.canvas.load("");
        }
        this.consumer = result -> {
            if (!result.equals(code)) {
                modified.get((String)result);
            }
        };
        this.show();
    }
}

