/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Structs;
import mindustry.logic.LExecutor;

public enum LogicOp {
    add("+", (a, b) -> a + b),
    sub("-", (a, b) -> a - b),
    mul("*", (a, b) -> a * b),
    div("/", (a, b) -> a / b),
    idiv("//", (a, b) -> Math.floor(a / b)),
    mod("%", (a, b) -> a % b),
    pow("^", Math::pow),
    equal("==", (a, b) -> Math.abs(a - b) < 1.0E-6 ? 1.0 : 0.0, (a, b) -> Structs.eq(a, b) ? 1.0 : 0.0),
    notEqual("not", (a, b) -> Math.abs(a - b) < 1.0E-6 ? 0.0 : 1.0, (a, b) -> !Structs.eq(a, b) ? 1.0 : 0.0),
    land("and", (a, b) -> a != 0.0 && b != 0.0 ? 1.0 : 0.0),
    lessThan("<", (a, b) -> a < b ? 1.0 : 0.0),
    lessThanEq("<=", (a, b) -> a <= b ? 1.0 : 0.0),
    greaterThan(">", (a, b) -> a > b ? 1.0 : 0.0),
    greaterThanEq(">=", (a, b) -> a >= b ? 1.0 : 0.0),
    strictEqual("===", (a, b) -> 0.0),
    shl("<<", (a, b) -> (long)a << (int)b),
    shr(">>", (a, b) -> (long)a >> (int)b),
    or("or", (a, b) -> (long)a | (long)b),
    and("b-and", (a, b) -> (long)a & (long)b),
    xor("xor", (a, b) -> (long)a ^ (long)b),
    not("flip", a -> (long)a ^ 0xFFFFFFFFFFFFFFFFL),
    max("max", true, Math::max),
    min("min", true, Math::min),
    angle("angle", true, (x, y) -> Angles.angle((float)x, (float)y)),
    len("len", true, (x, y) -> Mathf.dst((float)x, (float)y)),
    noise("noise", true, LExecutor.noise::rawNoise2D),
    abs("abs", a -> Math.abs(a)),
    log("log", Math::log),
    log10("log10", Math::log10),
    sin("sin", d -> Math.sin(d * (Math.PI / 180))),
    cos("cos", d -> Math.cos(d * (Math.PI / 180))),
    tan("tan", d -> Math.tan(d * (Math.PI / 180))),
    floor("floor", Math::floor),
    ceil("ceil", Math::ceil),
    sqrt("sqrt", Math::sqrt),
    rand("rand", d -> Mathf.rand.nextDouble() * d);

    public static final LogicOp[] all;
    public final OpObjLambda2 objFunction2;
    public final OpLambda2 function2;
    public final OpLambda1 function1;
    public final boolean unary;
    public final boolean func;
    public final String symbol;

    private LogicOp(String symbol, OpLambda2 function) {
        this(symbol, function, null);
    }

    private LogicOp(String symbol, boolean func, OpLambda2 function) {
        this.symbol = symbol;
        this.function2 = function;
        this.function1 = null;
        this.unary = false;
        this.objFunction2 = null;
        this.func = func;
    }

    private LogicOp(String symbol, OpLambda2 function, OpObjLambda2 objFunction) {
        this.symbol = symbol;
        this.function2 = function;
        this.function1 = null;
        this.unary = false;
        this.objFunction2 = objFunction;
        this.func = false;
    }

    private LogicOp(String symbol, OpLambda1 function) {
        this.symbol = symbol;
        this.function1 = function;
        this.function2 = null;
        this.unary = true;
        this.objFunction2 = null;
        this.func = false;
    }

    public String toString() {
        return this.symbol;
    }

    static {
        all = LogicOp.values();
    }

    static interface OpLambda2 {
        public double get(double var1, double var3);
    }

    static interface OpObjLambda2 {
        public double get(Object var1, Object var2);
    }

    static interface OpLambda1 {
        public double get(double var1);
    }
}

