/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps;

import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.assets.loaders.CustomLoader;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.UnsafeRunnable;
import arc.util.async.AsyncExecutor;
import arc.util.serialization.Json;
import arc.util.serialization.JsonWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.ContentLoader;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.SpawnGroup;
import mindustry.io.JsonIO;
import mindustry.io.MapIO;
import mindustry.maps.Map;
import mindustry.maps.MapPreviewLoader;
import mindustry.maps.filters.GenerateFilter;
import mindustry.maps.filters.OreFilter;
import mindustry.maps.filters.ScatterFilter;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class Maps {
    private static String[] defaultMapNames = new String[]{"maze", "fortress", "labyrinth", "islands", "tendrils", "caldera", "wasteland", "shattered", "fork", "triad", "mudFlats", "moltenLake", "archipelago", "debrisField", "veins", "glacier"};
    static final String[] pvpMaps = new String[]{"veins", "glacier"};
    private Seq<Map> maps = new Seq();
    private Json json = new Json();
    private ShuffleMode shuffleMode = ShuffleMode.all;
    @Nullable
    private MapProvider shuffler;
    private AsyncExecutor executor = new AsyncExecutor(2);
    private ObjectSet<Map> previewList = new ObjectSet();

    public ShuffleMode getShuffleMode() {
        return this.shuffleMode;
    }

    public void setShuffleMode(ShuffleMode mode) {
        this.shuffleMode = mode;
    }

    public void setMapProvider(MapProvider provider) {
        this.shuffler = provider;
    }

    @Nullable
    public Map getNextMap(Gamemode mode, @Nullable Map previous) {
        if (this.shuffler != null) {
            return this.shuffler.next(mode, previous);
        }
        return this.shuffleMode.next(mode, previous);
    }

    public Seq<Map> all() {
        return this.maps;
    }

    public Seq<Map> customMaps() {
        return this.maps.select(m -> m.custom);
    }

    public Seq<Map> defaultMaps() {
        return this.maps.select(m -> !m.custom);
    }

    public Map byName(String name) {
        return this.maps.find(m -> m.name().equals(name));
    }

    public Maps() {
        Events.on(EventType.ClientLoadEvent.class, event -> this.maps.sort());
        if (Core.assets != null) {
            ((CustomLoader)Core.assets.getLoader(ContentLoader.class)).loaded = this::createAllPreviews;
        }
    }

    public Map loadInternalMap(String name) {
        Fi file = Vars.tree.get("maps/" + name + "." + "msav");
        try {
            return MapIO.createMap(file, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load() {
        try {
            for (String name : defaultMapNames) {
                Fi file2 = Core.files.internal("maps/" + name + "." + "msav");
                this.loadMap(file2, false);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Fi file3 : Vars.customMapDirectory.list()) {
            try {
                if (!file3.extension().equalsIgnoreCase("msav")) continue;
                this.loadMap(file3, true);
            }
            catch (Exception e) {
                Log.err("Failed to load custom map file '@'!", file3);
                Log.err(e);
            }
        }
        for (Fi file4 : Vars.platform.getWorkshopContent(Map.class)) {
            try {
                Map map = this.loadMap(file4, false);
                map.workshop = true;
                map.tags.put("steamid", file4.parent().name());
            }
            catch (Exception e) {
                Log.err("Failed to load workshop map file '@'!", file4);
                Log.err(e);
            }
        }
        Vars.mods.listFiles("maps", (mod, file) -> {
            try {
                Map map = this.loadMap((Fi)file, false);
                map.mod = mod;
            }
            catch (Exception e) {
                Log.err("Failed to load mod map file '@'!", file);
                Log.err(e);
            }
        });
    }

    public void reload() {
        for (Map map : this.maps) {
            if (map.texture == null) continue;
            map.texture.dispose();
            map.texture = null;
        }
        this.maps.clear();
        this.load();
    }

    public Map saveMap(ObjectMap<String, String> baseTags) {
        try {
            Fi file;
            StringMap tags = new StringMap((ObjectMap<? extends String, ? extends String>)baseTags);
            String name = (String)tags.get("name");
            if (name == null) {
                throw new IllegalArgumentException("Can't save a map with no name. How did this happen?");
            }
            Map other = this.maps.find(m -> m.name().equals(name));
            if (other != null) {
                if (other.texture != null) {
                    other.texture.dispose();
                    other.texture = null;
                }
                this.maps.remove(other);
                file = other.file;
            } else {
                file = this.findFile();
            }
            Map map = new Map(file, Vars.world.width(), Vars.world.height(), tags, true);
            MapIO.writeMap(file, map);
            if (!Vars.headless) {
                map.teams.clear();
                map.spawns = 0;
                for (int x = 0; x < map.width; ++x) {
                    for (int y = 0; y < map.height; ++y) {
                        Tile tile = Vars.world.rawTile(x, y);
                        if (tile.block() instanceof CoreBlock) {
                            map.teams.add(tile.getTeamID());
                        }
                        if (tile.overlay() != Blocks.spawn) continue;
                        ++map.spawns;
                    }
                }
                if (Core.assets.isLoaded(map.previewFile().path() + "." + "msav")) {
                    Core.assets.unload(map.previewFile().path() + "." + "msav");
                }
                Pixmap pix = MapIO.generatePreview(Vars.world.tiles);
                this.executor.submit(() -> map.previewFile().writePNG(pix));
                this.writeCache(map);
                map.texture = new Texture(pix);
            }
            this.maps.add(map);
            this.maps.sort();
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void importMap(Fi file) throws IOException {
        Fi dest = this.findFile();
        file.copyTo(dest);
        Map map = this.loadMap(dest, true);
        Exception[] error = new Exception[]{null};
        this.createNewPreview(map, e -> {
            this.maps.remove(map);
            try {
                map.file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            error[0] = e;
        });
        if (error[0] != null) {
            throw new IOException(error[0]);
        }
    }

    public void tryCatchMapError(UnsafeRunnable run) {
        try {
            run.run();
        }
        catch (Throwable e) {
            Log.err(e);
            if ("Outdated legacy map format".equals(e.getMessage())) {
                Vars.ui.showErrorMessage("@editor.errornot");
            }
            if (e.getMessage() != null && e.getMessage().contains("Incorrect header!")) {
                Vars.ui.showErrorMessage("@editor.errorheader");
            }
            Vars.ui.showException("@editor.errorload", e);
        }
    }

    public void removeMap(Map map) {
        if (map.texture != null) {
            map.texture.dispose();
            map.texture = null;
        }
        this.maps.remove(map);
        map.file.delete();
    }

    public Seq<GenerateFilter> readFilters(String str) {
        if (str == null || str.isEmpty()) {
            Seq<GenerateFilter> filters = Seq.with(new ScatterFilter(){
                {
                    this.flooronto = Blocks.snow;
                    this.block = Blocks.snowBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.ice;
                    this.block = Blocks.snowBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.sand;
                    this.block = Blocks.sandBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.darksand;
                    this.block = Blocks.basaltBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.basalt;
                    this.block = Blocks.basaltBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.dacite;
                    this.block = Blocks.daciteBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.stone;
                    this.block = Blocks.boulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.shale;
                    this.block = Blocks.shaleBoulder;
                }
            });
            this.addDefaultOres(filters);
            return filters;
        }
        try {
            return JsonIO.read(Seq.class, str);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return this.readFilters("");
        }
    }

    public void addDefaultOres(Seq<GenerateFilter> filters) {
        Seq<Block> ores = Vars.content.blocks().select(b -> b.isOverlay() && b.asFloor().oreDefault);
        for (Block block : ores) {
            OreFilter filter = new OreFilter();
            filter.threshold = block.asFloor().oreThreshold;
            filter.scl = block.asFloor().oreScale;
            filter.ore = block;
            filters.add(filter);
        }
    }

    public String writeWaves(Seq<SpawnGroup> groups) {
        if (groups == null) {
            return "[]";
        }
        StringWriter buffer = new StringWriter();
        this.json.setWriter(new JsonWriter(buffer));
        this.json.writeArrayStart();
        for (int i = 0; i < groups.size; ++i) {
            this.json.writeObjectStart(SpawnGroup.class, SpawnGroup.class);
            groups.get(i).write(this.json);
            this.json.writeObjectEnd();
        }
        this.json.writeArrayEnd();
        return buffer.toString();
    }

    public Seq<SpawnGroup> readWaves(String str) {
        return str == null ? null : (str.equals("[]") ? new Seq() : Seq.with(this.json.fromJson(SpawnGroup[].class, str)));
    }

    public void loadPreviews() {
        for (Map map : this.maps) {
            if (map.previewFile().exists()) {
                Core.assets.load(new AssetDescriptor<Texture>((String)new StringBuilder().append((String)map.previewFile().path()).append((String)".").append((String)"msav").toString(), Texture.class, new MapPreviewLoader.MapPreviewParameter((Map)map))).loaded = t -> {
                    map.texture = (Texture)t;
                };
                try {
                    this.readCache(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.queueNewPreview(map);
                }
                continue;
            }
            this.queueNewPreview(map);
        }
    }

    private void createAllPreviews() {
        Core.app.post(() -> {
            for (Map map : this.previewList) {
                this.createNewPreview(map, e -> Core.app.post(() -> {
                    map.texture = (Texture)Core.assets.get("sprites/error.png");
                }));
            }
            this.previewList.clear();
        });
    }

    public void queueNewPreview(Map map) {
        Core.app.post(() -> this.previewList.add(map));
    }

    private void createNewPreview(Map map, Cons<Exception> failed) {
        try {
            Pixmap pix = MapIO.generatePreview(map);
            map.texture = new Texture(pix);
            this.executor.submit(() -> {
                try {
                    map.previewFile().writePNG(pix);
                    this.writeCache(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            failed.get(e);
            Log.err("Failed to generate preview!", e);
        }
    }

    private void writeCache(Map map) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(map.cacheFile().write(false, 4096));){
            stream.write(0);
            stream.writeInt(map.spawns);
            stream.write(map.teams.size);
            IntSet.IntSetIterator iter = map.teams.iterator();
            while (iter.hasNext) {
                stream.write(iter.next());
            }
        }
    }

    private void readCache(Map map) throws IOException {
        try (DataInputStream stream = new DataInputStream(map.cacheFile().read(4096));){
            stream.read();
            map.spawns = stream.readInt();
            int teamsize = stream.readByte();
            for (int i = 0; i < teamsize; ++i) {
                map.teams.add(stream.read());
            }
        }
    }

    private Fi findFile() {
        int i = this.maps.size;
        while (Vars.customMapDirectory.child("map_" + i + "." + "msav").exists()) {
            ++i;
        }
        return Vars.customMapDirectory.child("map_" + i + "." + "msav");
    }

    private Map loadMap(Fi file, boolean custom) throws IOException {
        Map map = MapIO.createMap(file, custom);
        if (map.name() == null) {
            throw new IOException("Map name cannot be empty! File: " + file);
        }
        this.maps.add(map);
        this.maps.sort();
        return map;
    }

    public static enum ShuffleMode implements MapProvider
    {
        none((mode, map) -> null),
        all((mode, prev) -> ShuffleMode.next(mode, prev, Vars.maps.defaultMaps(), Vars.maps.customMaps())),
        custom((mode, prev) -> ShuffleMode.next(mode, prev, Vars.maps.customMaps().isEmpty() ? Vars.maps.defaultMaps() : Vars.maps.customMaps())),
        builtin((mode, prev) -> ShuffleMode.next(mode, prev, Vars.maps.defaultMaps()));

        private final MapProvider provider;

        private ShuffleMode(MapProvider provider) {
            this.provider = provider;
        }

        @SafeVarargs
        private static Map next(Gamemode mode, Map prev, Seq<Map> ... mapArray) {
            Seq<Map> maps = Seq.withArrays(mapArray);
            maps.shuffle();
            return maps.find(m -> (m != prev || maps.size == 1) && ShuffleMode.valid(mode, m));
        }

        private static boolean valid(Gamemode mode, Map map) {
            boolean pvp;
            boolean bl = pvp = !map.custom && Structs.contains(pvpMaps, map.file.nameWithoutExtension());
            if (mode == Gamemode.survival || mode == Gamemode.attack || mode == Gamemode.sandbox) {
                return !pvp;
            }
            if (mode == Gamemode.pvp) {
                return map.custom || pvp;
            }
            return true;
        }

        @Override
        public Map next(Gamemode mode, @Nullable Map previous) {
            return this.provider.next(mode, previous);
        }
    }

    public static interface MapProvider {
        @Nullable
        public Map next(Gamemode var1, @Nullable Map var2);
    }
}

