/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.struct.IntSeq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.storage.CoreBlock;

public class CoreSpawnFilter
extends GenerateFilter {
    int amount = 1;

    @Override
    public FilterOption[] options() {
        return Structs.arr(new FilterOption[0]);
    }

    @Override
    public void apply(Tiles tiles, GenerateFilter.GenerateInput in) {
        int used;
        IntSeq spawns = new IntSeq();
        for (Tile tile : tiles) {
            if (tile.team() != Vars.state.rules.defaultTeam || !(tile.block() instanceof CoreBlock) || !tile.isCenter()) continue;
            spawns.add(tile.pos());
        }
        spawns.shuffle();
        for (int i = used = Math.min(spawns.size, this.amount); i < spawns.size; ++i) {
            tiles.getp(spawns.get(i)).remove();
        }
    }

    @Override
    public boolean isPost() {
        return true;
    }
}

