/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.util.Structs;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class DistortFilter
extends GenerateFilter {
    float scl = 40.0f;
    float mag = 5.0f;

    @Override
    public FilterOption[] options() {
        return Structs.arr(new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 200.0f), new FilterOption.SliderOption("mag", () -> this.mag, f -> {
            this.mag = f;
        }, 0.5f, 100.0f));
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public void apply() {
        Tile tile = this.in.tile((float)this.in.x + this.noise(this.in.x, this.in.y, this.scl, this.mag) - this.mag / 2.0f, (float)this.in.y + this.noise(this.in.x, (float)this.in.y + this.o, this.scl, this.mag) - this.mag / 2.0f);
        this.in.floor = tile.floor();
        if (!tile.block().synthetic() && !this.in.block.synthetic()) {
            this.in.block = tile.block();
        }
        this.in.overlay = tile.overlay();
    }
}

