/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Floatp;
import arc.func.Prov;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Slider;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.gen.Icon;
import mindustry.ui.Cicon;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;

public abstract class FilterOption {
    public static final Boolf<Block> floorsOnly = b -> b instanceof Floor && !(b instanceof OverlayFloor) && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full));
    public static final Boolf<Block> wallsOnly = b -> !b.synthetic() && !(b instanceof Floor) && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full)) && b.inEditor;
    public static final Boolf<Block> floorsOptional = b -> b == Blocks.air || b instanceof Floor && !(b instanceof OverlayFloor) && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full));
    public static final Boolf<Block> wallsOptional = b -> (b == Blocks.air || !b.synthetic() && !(b instanceof Floor) && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full))) && b.inEditor;
    public static final Boolf<Block> wallsOresOptional = b -> b == Blocks.air || (!b.synthetic() && !(b instanceof Floor) || b instanceof OverlayFloor) && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full)) && b.inEditor;
    public static final Boolf<Block> oresOnly = b -> b instanceof OverlayFloor && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full));
    public static final Boolf<Block> oresFloorsOptional = b -> b instanceof Floor && !Vars.headless && Core.atlas.isFound(b.icon(Cicon.full));
    public static final Boolf<Block> anyOptional = b -> (floorsOnly.get((Block)b) || wallsOnly.get((Block)b) || oresOnly.get((Block)b) || b == Blocks.air) && b.inEditor;
    public Runnable changed = () -> {};

    public abstract void build(Table var1);

    static class BlockOption
    extends FilterOption {
        final String name;
        final Prov<Block> supplier;
        final Cons<Block> consumer;
        final Boolf<Block> filter;

        BlockOption(String name, Prov<Block> supplier, Cons<Block> consumer, Boolf<Block> filter) {
            this.name = name;
            this.supplier = supplier;
            this.consumer = consumer;
            this.filter = filter;
        }

        @Override
        public void build(Table table) {
            table.button(b -> b.image(this.supplier.get().icon(Cicon.small)).update(i -> ((TextureRegionDrawable)i.getDrawable()).setRegion(this.supplier.get() == Blocks.air ? Icon.none.getRegion() : this.supplier.get().icon(Cicon.small))).size(24.0f), () -> {
                BaseDialog dialog = new BaseDialog("");
                dialog.setFillParent(false);
                int i = 0;
                for (Block block : Vars.content.blocks()) {
                    if (!this.filter.get(block)) continue;
                    dialog.cont.image(block == Blocks.air ? Icon.none.getRegion() : block.icon(Cicon.medium)).size(32.0f).pad(3.0f).get().clicked(() -> {
                        this.consumer.get(block);
                        dialog.hide();
                        this.changed.run();
                    });
                    if (++i % 10 != 0) continue;
                    dialog.cont.row();
                }
                dialog.show();
            }).pad(4.0f).margin(12.0f);
            table.add("@filter.option." + this.name);
        }
    }

    static class SliderOption
    extends FilterOption {
        final String name;
        final Floatp getter;
        final Floatc setter;
        final float min;
        final float max;
        final float step;
        boolean display;

        SliderOption(String name, Floatp getter, Floatc setter, float min, float max) {
            this(name, getter, setter, min, max, (max - min) / 200.0f);
        }

        SliderOption(String name, Floatp getter, Floatc setter, float min, float max, float step) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public SliderOption display() {
            this.display = true;
            return this;
        }

        @Override
        public void build(Table table) {
            if (!this.display) {
                table.add("@filter.option." + this.name);
            } else {
                table.label(() -> Core.bundle.get("filter.option." + this.name) + ": " + (int)this.getter.get());
            }
            table.row();
            Slider slider = table.slider(this.min, this.max, this.step, this.setter).growX().get();
            slider.setValue(this.getter.get());
            if (Vars.updateEditorOnChange) {
                slider.changed(this.changed);
            } else {
                slider.released(this.changed);
            }
        }
    }
}

