/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.Core;
import arc.math.Mathf;
import arc.scene.ui.Image;
import arc.util.Pack;
import arc.util.noise.RidgedPerlin;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.gen.PackTile;
import mindustry.maps.filters.FilterOption;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;

public abstract class GenerateFilter {
    protected transient float o = (float)(Math.random() * 1.0E7);
    protected transient long seed;
    protected transient GenerateInput in;

    public void apply(Tiles tiles, GenerateInput in) {
        this.in = in;
        if (this.isBuffered()) {
            Tile tile;
            int i;
            long[] buffer = new long[tiles.width * tiles.height];
            for (i = 0; i < tiles.width * tiles.height; ++i) {
                tile = tiles.geti(i);
                in.apply(tile.x, tile.y, tile.block(), tile.floor(), tile.overlay());
                this.apply();
                buffer[i] = PackTile.get(in.block.id, in.floor.id, in.overlay.id);
            }
            for (i = 0; i < tiles.width * tiles.height; ++i) {
                tile = tiles.geti(i);
                long b = buffer[i];
                Block block = Vars.content.block(PackTile.block(b));
                Block floor = Vars.content.block(PackTile.floor(b));
                Block overlay = Vars.content.block(PackTile.overlay(b));
                tile.setFloor(floor.asFloor());
                tile.setOverlay(!floor.asFloor().hasSurface() && overlay.asFloor().needsSurface ? Blocks.air : overlay);
                if (tile.block().synthetic() || block.synthetic()) continue;
                tile.setBlock(block);
            }
        } else {
            for (Tile tile : tiles) {
                in.apply(tile.x, tile.y, tile.block(), tile.floor(), tile.overlay());
                this.apply();
                tile.setFloor(in.floor.asFloor());
                tile.setOverlay(!in.floor.asFloor().hasSurface() && in.overlay.asFloor().needsSurface ? Blocks.air : in.overlay);
                if (tile.block().synthetic() || in.block.synthetic()) continue;
                tile.setBlock(in.block);
            }
        }
    }

    public final void apply(GenerateInput in) {
        this.in = in;
        this.apply();
    }

    public abstract FilterOption[] options();

    protected void apply() {
    }

    public void draw(Image image) {
    }

    public String name() {
        Class<?> c = this.getClass();
        if (c.isAnonymousClass()) {
            c = c.getSuperclass();
        }
        return Core.bundle.get("filter." + c.getSimpleName().toLowerCase().replace("filter", ""), c.getSimpleName().replace("Filter", ""));
    }

    public void randomize() {
        this.seed = Mathf.random(99999999);
    }

    public boolean isBuffered() {
        return false;
    }

    public boolean isPost() {
        return false;
    }

    protected float noise(float x, float y, float scl, float mag) {
        return (float)this.in.noise.octaveNoise2D(1.0, 0.0, 1.0f / scl, x + this.o, y + this.o) * mag;
    }

    protected float noise(float x, float y, float scl, float mag, float octaves, float persistence) {
        return (float)this.in.noise.octaveNoise2D(octaves, persistence, 1.0f / scl, x + this.o, y + this.o) * mag;
    }

    protected float rnoise(float x, float y, float scl, float mag) {
        return this.in.pnoise.getValue((int)(x + this.o), (int)(y + this.o), 1.0f / scl) * mag;
    }

    protected float chance() {
        return Mathf.randomSeed(Pack.longInt(this.in.x, this.in.y + (int)this.seed));
    }

    public static class GenerateInput {
        public int x;
        public int y;
        public int width;
        public int height;
        public Block floor;
        public Block block;
        public Block overlay;
        Simplex noise = new Simplex();
        RidgedPerlin pnoise = new RidgedPerlin(0, 1);
        TileProvider buffer;

        public void apply(int x, int y, Block block, Block floor, Block overlay) {
            this.floor = floor;
            this.block = block;
            this.overlay = overlay;
            this.x = x;
            this.y = y;
        }

        public void begin(GenerateFilter filter, int width, int height, TileProvider buffer) {
            this.buffer = buffer;
            this.width = width;
            this.height = height;
            this.noise.setSeed(filter.seed);
            this.pnoise.setSeed((int)(filter.seed + 1L));
        }

        Tile tile(float x, float y) {
            return this.buffer.get(Mathf.clamp((int)x, 0, this.width - 1), Mathf.clamp((int)y, 0, this.height - 1));
        }

        public static interface TileProvider {
            public Tile get(int var1, int var2);
        }
    }

    class PackTileStruct {
        short block;
        short floor;
        short overlay;

        PackTileStruct() {
        }
    }
}

