/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class MedianFilter
extends GenerateFilter {
    float radius = 2.0f;
    float percentile = 0.5f;
    IntSeq blocks = new IntSeq();
    IntSeq floors = new IntSeq();

    @Override
    public FilterOption[] options() {
        return Structs.arr(new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 12.0f), new FilterOption.SliderOption("percentile", () -> this.percentile, f -> {
            this.percentile = f;
        }, 0.0f, 1.0f));
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public void apply() {
        int rad = (int)this.radius;
        this.blocks.clear();
        this.floors.clear();
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                if (Mathf.dst2(x, y) > (float)(rad * rad)) continue;
                Tile tile = this.in.tile(this.in.x + x, this.in.y + y);
                this.blocks.add(tile.block().id);
                this.floors.add(tile.floor().id);
            }
        }
        this.floors.sort();
        this.blocks.sort();
        int index = Math.min((int)((float)this.floors.size * this.percentile), this.floors.size - 1);
        int floor = this.floors.get(index);
        int block = this.blocks.get(index);
        this.in.floor = Vars.content.block(floor);
        if (!Vars.content.block(block).synthetic() && !this.in.block.synthetic()) {
            this.in.block = Vars.content.block(block);
        }
    }
}

