/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.geom.Vec2;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.util.Scaling;
import arc.util.Structs;
import arc.util.Tmp;
import mindustry.graphics.Pal;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class MirrorFilter
extends GenerateFilter {
    private final Vec2 v1 = new Vec2();
    private final Vec2 v2 = new Vec2();
    private final Vec2 v3 = new Vec2();
    int angle = 45;

    @Override
    public FilterOption[] options() {
        return Structs.arr(new FilterOption.SliderOption("angle", () -> this.angle, f -> {
            this.angle = (int)f;
        }, 0.0f, 360.0f, 45.0f));
    }

    @Override
    protected void apply() {
        this.v1.trnsExact(this.angle - 90, 1.0f);
        this.v2.set(this.v1).scl(-1.0f);
        this.v1.add((float)this.in.width / 2.0f - 0.5f, (float)this.in.height / 2.0f - 0.5f);
        this.v2.add((float)this.in.width / 2.0f - 0.5f, (float)this.in.height / 2.0f - 0.5f);
        this.v3.set(this.in.x, this.in.y);
        if (!this.left(this.v1, this.v2, this.v3)) {
            this.mirror(this.v3, this.v1.x, this.v1.y, this.v2.x, this.v2.y);
            Tile tile = this.in.tile(this.v3.x, this.v3.y);
            this.in.floor = tile.floor();
            if (!tile.block().synthetic()) {
                this.in.block = tile.block();
            }
            this.in.overlay = tile.overlay();
        }
    }

    @Override
    public void draw(Image image) {
        super.draw(image);
        Vec2 vsize = Scaling.fit.apply(image.getDrawable().getMinWidth(), image.getDrawable().getMinHeight(), image.getWidth(), image.getHeight());
        float imageWidth = Math.max(vsize.x, vsize.y);
        float imageHeight = Math.max(vsize.y, vsize.x);
        float size = Math.max(image.getWidth() * 2.0f, image.getHeight() * 2.0f);
        Cons<Vec2> clamper = v -> v.clamp(image.x + image.getWidth() / 2.0f - imageWidth / 2.0f, image.y + image.getHeight() / 2.0f - imageHeight / 2.0f, image.y + image.getHeight() / 2.0f + imageHeight / 2.0f, image.x + image.getWidth() / 2.0f + imageWidth / 2.0f);
        clamper.get(Tmp.v1.trns(this.angle - 90, size).add(image.getWidth() / 2.0f + image.x, image.getHeight() / 2.0f + image.y));
        clamper.get(Tmp.v2.set(Tmp.v1).sub(image.getWidth() / 2.0f + image.x, image.getHeight() / 2.0f + image.y).rotate(180.0f).add(image.getWidth() / 2.0f + image.x, image.getHeight() / 2.0f + image.y));
        Lines.stroke(Scl.scl(3.0f), Pal.accent);
        Lines.line(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y);
        Draw.reset();
    }

    void mirror(Vec2 p, float x0, float y0, float x1, float y1) {
        if (this.in.width != this.in.height && this.angle % 90 != 0) {
            p.x = (float)this.in.width - p.x - 1.0f;
            p.y = (float)this.in.height - p.y - 1.0f;
        } else {
            float dx = x1 - x0;
            float dy = y1 - y0;
            float a = (dx * dx - dy * dy) / (dx * dx + dy * dy);
            float b = 2.0f * dx * dy / (dx * dx + dy * dy);
            p.set(a * (p.x - x0) + b * (p.y - y0) + x0, b * (p.x - x0) - a * (p.y - y0) + y0);
        }
    }

    boolean left(Vec2 a, Vec2 b, Vec2 c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0f;
    }
}

