/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.util.Structs;
import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;

public class NoiseFilter
extends GenerateFilter {
    float scl = 40.0f;
    float threshold = 0.5f;
    float octaves = 3.0f;
    float falloff = 0.5f;
    Block floor = Blocks.stone;
    Block block = Blocks.stoneWall;
    Block target = Blocks.air;

    @Override
    public FilterOption[] options() {
        return Structs.arr(new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 500.0f), new FilterOption.SliderOption("threshold", () -> this.threshold, f -> {
            this.threshold = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("octaves", () -> this.octaves, f -> {
            this.octaves = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("falloff", () -> this.falloff, f -> {
            this.falloff = f;
        }, 0.0f, 1.0f), new FilterOption.BlockOption("target", () -> this.target, b -> {
            this.target = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOptional), new FilterOption.BlockOption("wall", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOptional));
    }

    @Override
    public void apply() {
        float noise = this.noise(this.in.x, this.in.y, this.scl, 1.0f, this.octaves, this.falloff);
        if (noise > this.threshold && (this.target == Blocks.air || this.in.floor == this.target || this.in.block == this.target)) {
            if (this.floor != Blocks.air) {
                this.in.floor = this.floor;
            }
            if (this.block != Blocks.air && this.in.block != Blocks.air) {
                this.in.block = this.block;
            }
        }
    }
}

