/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.math.Mathf;
import arc.struct.IntSeq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class OreMedianFilter
extends GenerateFilter {
    public float radius = 2.0f;
    public float percentile = 0.5f;
    private IntSeq blocks = new IntSeq();

    @Override
    public FilterOption[] options() {
        return Structs.arr(new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 12.0f), new FilterOption.SliderOption("percentile", () -> this.percentile, f -> {
            this.percentile = f;
        }, 0.0f, 1.0f));
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public void apply() {
        if (this.in.overlay == Blocks.spawn) {
            return;
        }
        int cx = this.in.x / 2 * 2;
        int cy = this.in.y / 2 * 2;
        if (this.in.overlay != Blocks.air && (this.in.tile(cx + 1, cy).overlay() != this.in.overlay || this.in.tile(cx, cy).overlay() != this.in.overlay || this.in.tile(cx + 1, cy + 1).overlay() != this.in.overlay || this.in.tile(cx, cy + 1).overlay() != this.in.overlay || this.in.tile(cx + 1, cy).block().isStatic() || this.in.tile(cx, cy).block().isStatic() || this.in.tile(cx + 1, cy + 1).block().isStatic() || this.in.tile(cx, cy + 1).block().isStatic())) {
            this.in.overlay = Blocks.air;
        }
        int rad = (int)this.radius;
        this.blocks.clear();
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile tile;
                if (Mathf.dst2(x, y) > (float)(rad * rad) || (tile = this.in.tile(this.in.x + x, this.in.y + y)).overlay() == Blocks.spawn) continue;
                this.blocks.add(tile.overlay().id);
            }
        }
        this.blocks.sort();
        int index = Math.min((int)((float)this.blocks.size * this.percentile), this.blocks.size - 1);
        int overlay = this.blocks.get(index);
        this.in.overlay = Vars.content.block(overlay);
    }
}

