/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.func.Cons;
import arc.func.Intc2;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.ai.BaseRegistry;
import mindustry.content.Blocks;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.defense.Door;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.distribution.PayloadConveyor;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.PayloadAcceptor;
import mindustry.world.meta.BuildVisibility;

public class BaseGenerator {
    private static final Vec2 axis = new Vec2();
    private static final Vec2 rotator = new Vec2();
    private static final int range = 160;
    private Tiles tiles;
    private Seq<Tile> cores;

    public void generate(Tiles tiles, Seq<Tile> cores, Tile spawn, Team team, Sector sector, float difficulty) {
        this.tiles = tiles;
        this.cores = cores;
        if (Vars.bases.cores.isEmpty()) {
            return;
        }
        Mathf.rand.setSeed(sector.id);
        Seq<Block> wallsSmall = Vars.content.blocks().select(b -> b instanceof Wall && b.size == 1 && !b.insulated && b.buildVisibility == BuildVisibility.shown && !(b instanceof Door));
        Seq<Block> wallsLarge = Vars.content.blocks().select(b -> b instanceof Wall && b.size == 2 && !b.insulated && b.buildVisibility == BuildVisibility.shown && !(b instanceof Door));
        wallsSmall.sort(b -> b.buildCost);
        wallsLarge.sort(b -> b.buildCost);
        float bracketRange = 0.2f;
        float baseChance = Mathf.lerp(0.7f, 1.9f, difficulty);
        int wallAngle = 70;
        double resourceChance = 0.5 * (double)baseChance;
        double nonResourceChance = 5.0E-4 * (double)baseChance;
        BaseRegistry.BasePart coreschem = Vars.bases.cores.getFrac(difficulty);
        int passes = (double)difficulty < 0.4 ? 1 : ((double)difficulty < 0.8 ? 2 : 3);
        Block wall = wallsSmall.getFrac(difficulty * 0.91f);
        Block wallLarge = wallsLarge.getFrac(difficulty * 0.91f);
        for (Tile tile2 : cores) {
            tile2.clearOverlay();
            Schematics.placeLoadout(coreschem.schematic, tile2.x, tile2.y, team, coreschem.required instanceof Item ? (Block)Vars.bases.ores.get((Item)coreschem.required) : Blocks.oreCopper, false);
            Building entity = tile2.build;
            for (Item item : Vars.content.items()) {
                entity.items.add(item, entity.block.itemCapacity);
            }
        }
        for (int i = 0; i < passes; ++i) {
            this.pass(tile -> {
                if (!tile.block().alwaysReplace) {
                    return;
                }
                if ((tile.overlay().asFloor().itemDrop != null || tile.drop() != null && Mathf.chance(nonResourceChance) || tile.floor().liquidDrop != null && Mathf.chance(nonResourceChance * 2.0)) && Mathf.chance(resourceChance)) {
                    Seq<BaseRegistry.BasePart> parts = Vars.bases.forResource(tile.drop() != null ? tile.drop() : tile.floor().liquidDrop);
                    if (!parts.isEmpty()) {
                        BaseGenerator.tryPlace(parts.getFrac(difficulty + Mathf.range(bracketRange)), tile.x, tile.y, team);
                    }
                } else if (Mathf.chance(nonResourceChance)) {
                    BaseGenerator.tryPlace(Vars.bases.parts.getFrac(difficulty + Mathf.range(bracketRange)), tile.x, tile.y, team);
                }
            });
        }
        if (wallAngle > 0) {
            this.pass(tile -> {
                if (tile.block().alwaysReplace) {
                    Tile o;
                    boolean any = false;
                    for (Point2 p : Geometry.d4) {
                        o = tiles.get(tile.x + p.x, tile.y + p.y);
                        if (o == null || !(o.block() instanceof PayloadConveyor) && !(o.block() instanceof PayloadAcceptor)) continue;
                        return;
                    }
                    for (Point2 p : Geometry.d8) {
                        if (Angles.angleDist(Angles.angle(p.x, p.y), spawn.angleTo((Position)tile)) > (float)wallAngle || (o = tiles.get(tile.x + p.x, tile.y + p.y)) == null || o.team() != team || o.block() instanceof Wall) continue;
                        any = true;
                        break;
                    }
                    if (any) {
                        tile.setBlock(wall, team);
                    }
                }
            });
            this.pass(curr -> {
                int walls = 0;
                for (int cx = 0; cx < 2; ++cx) {
                    for (int cy = 0; cy < 2; ++cy) {
                        Tile tile = tiles.get(curr.x + cx, curr.y + cy);
                        if (tile == null || tile.block().size != 1 || tile.block() != wall && !tile.block().alwaysReplace) {
                            return;
                        }
                        if (tile.block() != wall) continue;
                        ++walls;
                    }
                }
                if (walls >= 3) {
                    curr.setBlock(wallLarge, team);
                }
            });
        }
        for (Tile tile2 : cores) {
            Astar.pathfind(tile2, spawn, t -> t.team() == Vars.state.rules.waveTeam && !t.within(tile2, 200.0f) ? 100000.0f : (t.floor().hasSurface() ? 1.0f : 10.0f), t -> !t.block().isStatic()).each(t -> {
                if (!t.within(tile2, 200.0f)) {
                    if (t.team() == Vars.state.rules.waveTeam) {
                        t.setBlock(Blocks.air);
                    }
                    for (Point2 p : Geometry.d8) {
                        Tile other = t.nearby(p);
                        if (other == null || other.team() != Vars.state.rules.waveTeam) continue;
                        other.setBlock(Blocks.air);
                    }
                }
            });
        }
    }

    public void postGenerate() {
        if (this.tiles == null) {
            return;
        }
        for (Tile tile : this.tiles) {
            if (!tile.isCenter() || !(tile.block() instanceof PowerNode) || tile.team() != Vars.state.rules.waveTeam) continue;
            tile.build.placed();
        }
    }

    void pass(Cons<Tile> cons) {
        Tile core = this.cores.first();
        core.circle(160, (x, y) -> cons.get(this.tiles.getn(x, y)));
    }

    public static boolean tryPlace(BaseRegistry.BasePart part, int x, int y, Team team) {
        return BaseGenerator.tryPlace(part, x, y, team, null);
    }

    public static boolean tryPlace(BaseRegistry.BasePart part, int x, int y, Team team, @Nullable Intc2 posc) {
        Item item;
        int rotation = Mathf.range(2);
        axis.set((int)((float)part.schematic.width / 2.0f), (int)((float)part.schematic.height / 2.0f));
        Schematic result = Schematics.rotate(part.schematic, rotation);
        int rotdeg = rotation * 90;
        rotator.set(part.centerX, part.centerY).rotateAround(axis, rotdeg);
        int cx = x - (int)BaseGenerator.rotator.x;
        int cy = y - (int)BaseGenerator.rotator.y;
        for (Schematic.Stile tile : result.tiles) {
            int realX = tile.x + cx;
            int realY = tile.y + cy;
            if (BaseGenerator.isTaken(tile.block, realX, realY)) {
                return false;
            }
            if (posc == null) continue;
            posc.get(realX, realY);
        }
        Object object = part.required;
        if (object instanceof Item && (item = (Item)object) == (Item)object) {
            for (Schematic.Stile tile : result.tiles) {
                if (!(tile.block instanceof Drill)) continue;
                tile.block.iterateTaken(tile.x + cx, tile.y + cy, (ex, ey) -> {
                    Tile rand;
                    if (Vars.world.tiles.getn(ex, ey).floor().hasSurface()) {
                        BaseGenerator.set(Vars.world.tiles.getn(ex, ey), item);
                    }
                    if ((rand = Vars.world.tiles.getc(ex + Mathf.range(1), ey + Mathf.range(1))).floor().hasSurface()) {
                        BaseGenerator.set(rand, item);
                    }
                });
            }
        }
        Schematics.place(result, cx + result.width / 2, cy + result.height / 2, team);
        object = part.required;
        if (object instanceof Item && (item = (Item)object) == (Item)object) {
            for (Schematic.Stile tile : result.tiles) {
                Building build;
                if (!(tile.block instanceof Drill) || (build = Vars.world.tile((int)(tile.x + cx), (int)(tile.y + cy)).build) == null) continue;
                build.items.add(item, build.block.itemCapacity);
            }
        }
        return true;
    }

    static void set(Tile tile, Item item) {
        if (Vars.bases.ores.containsKey(item)) {
            tile.setOverlay(Vars.bases.ores.get(item));
        } else if (Vars.bases.oreFloors.containsKey(item)) {
            tile.setFloor(Vars.bases.oreFloors.get(item));
        }
    }

    static boolean isTaken(Block block, int x, int y) {
        int offsetx = -(block.size - 1) / 2;
        int offsety = -(block.size - 1) / 2;
        int pad = 1;
        for (int dx = -pad; dx < block.size + pad; ++dx) {
            for (int dy = -pad; dy < block.size + pad; ++dy) {
                if (!BaseGenerator.overlaps(dx + offsetx + x, dy + offsety + y)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean overlaps(int x, int y) {
        Tile tile = Vars.world.tiles.get(x, y);
        return tile == null || !tile.block().alwaysReplace || Vars.world.getDarkness(x, y) > 0.0f;
    }

    private static /* synthetic */ void lambda$generate$5(Team team, Block wall, Block wallLarge, Tile tile) {
        if (tile.block() instanceof Wall && tile.team() == team && tile.block() != wall && tile.block() != wallLarge) {
            tile.setBlock(tile.block().size == 2 ? wallLarge : wall, team);
        }
    }
}

