/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.math.Mathf;
import arc.math.geom.Geometry;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.game.Schematics;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.generators.WorldGenerator;
import mindustry.type.Item;
import mindustry.type.SectorPreset;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;

public class FileMapGenerator
implements WorldGenerator {
    public final Map map;
    public final SectorPreset preset;

    public FileMapGenerator(String mapName, SectorPreset preset) {
        this.map = Vars.maps != null ? Vars.maps.loadInternalMap(mapName) : null;
        this.preset = preset;
    }

    @Override
    public void generate(Tiles tiles) {
        if (this.map == null) {
            throw new RuntimeException("Generator has null map, cannot be used.");
        }
        Vars.world.setGenerating(false);
        SaveIO.load(this.map.file, (WorldContext)Vars.world.filterContext(this.map));
        Vars.world.setGenerating(true);
        tiles = Vars.world.tiles;
        Item[] items = new Item[]{Items.blastCompound, Items.pyratite, Items.copper, Items.thorium, Items.copper, Items.lead};
        for (Tile tile : tiles) {
            if (!(tile.block() instanceof StorageBlock) || tile.block() instanceof CoreBlock || !Vars.state.hasSector()) continue;
            for (Item content : items) {
                if (!Mathf.chance(0.2)) continue;
                tile.build.items.add(content, Math.min(Mathf.random(500), tile.block().itemCapacity));
            }
        }
        boolean anyCores = false;
        for (Tile tile : tiles) {
            if (tile.overlay() == Blocks.spawn) {
                int rad = 10;
                Geometry.circle(tile.x, tile.y, tiles.width, tiles.height, rad, (wx, wy) -> {
                    if (tile.overlay().itemDrop != null) {
                        tile.clearOverlay();
                    }
                });
            }
            if (!tile.isCenter() || !(tile.block() instanceof CoreBlock) || tile.team() != Vars.state.rules.defaultTeam || anyCores) continue;
            Schematics.placeLaunchLoadout(tile.x, tile.y);
            anyCores = true;
            if (!this.preset.addStartingItems) continue;
            tile.build.items.add(Vars.state.rules.loadout);
        }
        if (!anyCores) {
            throw new IllegalArgumentException("All maps must have a core.");
        }
        Vars.state.map = this.map;
    }
}

