/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.math.geom.Vec3;
import arc.struct.IntSeq;
import arc.util.noise.Noise;
import arc.util.noise.Simplex;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.maps.generators.BasicGenerator;
import mindustry.type.Sector;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.Tiles;

public abstract class PlanetGenerator
extends BasicGenerator
implements HexMesher {
    protected IntSeq ints = new IntSeq();
    protected Sector sector;
    protected Simplex noise = new Simplex();

    public void generateSector(Sector sector) {
        PlanetGrid.Ptile tile = sector.tile;
        boolean any = false;
        float noise = Noise.snoise3(tile.v.x, tile.v.y, tile.v.z, 0.001f, 0.5f);
        if ((double)noise > 0.027) {
            any = true;
        }
        if ((double)noise < 0.15) {
            for (PlanetGrid.Ptile other : tile.tiles) {
                if (sector.planet.getSector((PlanetGrid.Ptile)other).id == sector.planet.startSector) {
                    return;
                }
                if (!sector.planet.getSector((PlanetGrid.Ptile)other).generateEnemyBase) continue;
                any = false;
                break;
            }
        }
        if (any) {
            sector.generateEnemyBase = true;
        }
    }

    protected void genTile(Vec3 position, TileGen tile) {
    }

    @Override
    protected float noise(float x, float y, double octaves, double falloff, double scl, double mag) {
        Vec3 v = this.sector.rect.project(x, y);
        return (float)this.noise.octaveNoise3D(octaves, falloff, 1.0 / scl, v.x, v.y, v.z) * (float)mag;
    }

    public void generate(Tiles tiles, Sector sec) {
        this.tiles = tiles;
        this.sector = sec;
        this.rand.setSeed(sec.id);
        TileGen gen = new TileGen();
        tiles.each((x, y) -> {
            gen.reset();
            Vec3 position = this.sector.rect.project((float)x / (float)tiles.width, (float)y / (float)tiles.height);
            this.genTile(position, gen);
            tiles.set(x, y, new Tile(x, y, gen.floor, gen.overlay, gen.block));
        });
        this.generate(tiles);
    }
}

