/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.planet;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec3;
import arc.struct.FloatSeq;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.noise.Noise;
import arc.util.noise.RidgedPerlin;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.ai.BaseRegistry;
import mindustry.content.Blocks;
import mindustry.game.Schematics;
import mindustry.game.Team;
import mindustry.game.Waves;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.maps.generators.BaseGenerator;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.Tiles;

public class SerpuloPlanetGenerator
extends PlanetGenerator {
    RidgedPerlin rid = new RidgedPerlin(1, 2);
    BaseGenerator basegen = new BaseGenerator();
    float scl = 5.0f;
    float waterOffset = 0.07f;
    Block[][] arr = new Block[][]{{Blocks.water, Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.darksand, Blocks.darksand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.darksandTaintedWater, Blocks.stone, Blocks.stone}, {Blocks.water, Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.darksandTaintedWater, Blocks.stone, Blocks.stone, Blocks.stone}, {Blocks.water, Blocks.darksandWater, Blocks.darksand, Blocks.sand, Blocks.salt, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.darksandTaintedWater, Blocks.stone, Blocks.stone, Blocks.stone}, {Blocks.water, Blocks.sandWater, Blocks.sand, Blocks.salt, Blocks.salt, Blocks.salt, Blocks.sand, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.snow, Blocks.iceSnow, Blocks.ice}, {Blocks.deepwater, Blocks.water, Blocks.sandWater, Blocks.sand, Blocks.salt, Blocks.sand, Blocks.sand, Blocks.basalt, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.ice}, {Blocks.deepwater, Blocks.water, Blocks.sandWater, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.moss, Blocks.iceSnow, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.snow, Blocks.ice}, {Blocks.deepwater, Blocks.sandWater, Blocks.sand, Blocks.sand, Blocks.moss, Blocks.moss, Blocks.snow, Blocks.basalt, Blocks.basalt, Blocks.basalt, Blocks.ice, Blocks.snow, Blocks.ice}, {Blocks.taintedWater, Blocks.darksandTaintedWater, Blocks.darksand, Blocks.darksand, Blocks.basalt, Blocks.moss, Blocks.basalt, Blocks.hotrock, Blocks.basalt, Blocks.ice, Blocks.snow, Blocks.ice, Blocks.ice}, {Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.darksand, Blocks.moss, Blocks.sporeMoss, Blocks.snow, Blocks.basalt, Blocks.basalt, Blocks.ice, Blocks.snow, Blocks.ice, Blocks.ice}, {Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.sporeMoss, Blocks.ice, Blocks.ice, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice}, {Blocks.taintedWater, Blocks.darksandTaintedWater, Blocks.darksand, Blocks.sporeMoss, Blocks.sporeMoss, Blocks.ice, Blocks.ice, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice}, {Blocks.darksandTaintedWater, Blocks.darksandTaintedWater, Blocks.darksand, Blocks.sporeMoss, Blocks.moss, Blocks.sporeMoss, Blocks.iceSnow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice}, {Blocks.darksandWater, Blocks.darksand, Blocks.snow, Blocks.ice, Blocks.iceSnow, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice}};
    ObjectMap<Block, Block> dec = ObjectMap.of(Blocks.sporeMoss, Blocks.sporeCluster, Blocks.moss, Blocks.sporeCluster, Blocks.taintedWater, Blocks.water, Blocks.darksandTaintedWater, Blocks.darksandWater);
    ObjectMap<Block, Block> tars = ObjectMap.of(Blocks.sporeMoss, Blocks.shale, Blocks.moss, Blocks.shale);
    float water = 2.0f / (float)this.arr[0].length;

    float rawHeight(Vec3 position) {
        position = Tmp.v33.set(position).scl(this.scl);
        return (Mathf.pow((float)this.noise.octaveNoise3D(7.0, 0.5, 0.3333333432674408, position.x, position.y, position.z), 2.3f) + this.waterOffset) / (1.0f + this.waterOffset);
    }

    @Override
    public void generateSector(Sector sector) {
        if (sector.id == 154 || sector.id == 0) {
            sector.generateEnemyBase = true;
            return;
        }
        PlanetGrid.Ptile tile = sector.tile;
        boolean any = false;
        float poles = Math.abs(tile.v.y);
        float noise = Noise.snoise3(tile.v.x, tile.v.y, tile.v.z, 0.001f, 0.58f);
        if ((double)noise + (double)poles / 7.1 > 0.12 && (double)poles > 0.23) {
            any = true;
        }
        if ((double)noise < 0.16) {
            for (PlanetGrid.Ptile other : tile.tiles) {
                Sector osec = sector.planet.getSector(other);
                if (!(osec.id == sector.planet.startSector || osec.generateEnemyBase && (double)poles < 0.85) && (sector.preset == null || !((double)noise < 0.11))) continue;
                return;
            }
        }
        sector.generateEnemyBase = any;
    }

    @Override
    public float getHeight(Vec3 position) {
        float height = this.rawHeight(position);
        return Math.max(height, this.water);
    }

    @Override
    public Color getColor(Vec3 position) {
        Block block = this.getBlock(position);
        if (block == Blocks.salt) {
            return Blocks.sand.mapColor;
        }
        return Tmp.c1.set(block.mapColor).a(1.0f - block.albedo);
    }

    @Override
    public void genTile(Vec3 position, TileGen tile) {
        tile.floor = this.getBlock(position);
        tile.block = tile.floor.asFloor().wall;
        if ((double)this.rid.getValue(position.x, position.y, position.z, 22.0f) > 0.32) {
            tile.block = Blocks.air;
        }
    }

    Block getBlock(Vec3 position) {
        float height = this.rawHeight(position);
        Tmp.v31.set(position);
        position = Tmp.v33.set(position).scl(this.scl);
        float rad = this.scl;
        float temp = Mathf.clamp(Math.abs(position.y * 2.0f) / rad);
        float tnoise = (float)this.noise.octaveNoise3D(7.0, 0.56, 0.3333333432674408, position.x, position.y + 999.0f, position.z);
        temp = Mathf.lerp(temp, tnoise, 0.5f);
        height *= 1.2f;
        height = Mathf.clamp(height);
        float tar = (float)this.noise.octaveNoise3D(4.0, 0.55f, 0.5, position.x, position.y + 999.0f, position.z) * 0.3f + Tmp.v31.dst(0.0f, 0.0f, 1.0f) * 0.2f;
        Block res = this.arr[Mathf.clamp((int)(temp * (float)this.arr.length), 0, this.arr[0].length - 1)][Mathf.clamp((int)(height * (float)this.arr[0].length), 0, this.arr[0].length - 1)];
        if (tar > 0.5f) {
            return this.tars.get(res, res);
        }
        return res;
    }

    @Override
    protected float noise(float x, float y, double octaves, double falloff, double scl, double mag) {
        Vec3 v = this.sector.rect.project(x, y).scl(5.0f);
        return (float)this.noise.octaveNoise3D(octaves, falloff, 1.0 / scl, v.x, v.y, v.z) * (float)mag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generate() {
        class Room {
            int x;
            int y;
            int radius;
            ObjectSet<Room> connected = new ObjectSet();

            Room(int x, int y, int radius) {
                this.x = x;
                this.y = y;
                this.radius = radius;
                this.connected.add(this);
            }

            void connect(Room to) {
                if (this.connected.contains(to)) {
                    return;
                }
                this.connected.add(to);
                float nscl = SerpuloPlanetGenerator.this.rand.random(20.0f, 60.0f);
                int stroke = SerpuloPlanetGenerator.this.rand.random(4, 12);
                SerpuloPlanetGenerator.this.brush(SerpuloPlanetGenerator.this.pathfind(this.x, this.y, to.x, to.y, tile -> (tile.solid() ? 5.0f : 0.0f) + SerpuloPlanetGenerator.this.noise(tile.x, tile.y, 1.0, 1.0, 1.0f / nscl) * 60.0f, Astar.manhattan), stroke);
            }
        }
        void var13_22;
        this.cells(4);
        this.distort(10.0f, 12.0f);
        float constraint = 1.3f;
        float radius = (float)this.width / 2.0f / Mathf.sqrt3;
        int rooms = this.rand.random(2, 5);
        Seq<Object> roomseq = new Seq<Object>();
        for (int i = 0; i < rooms; ++i) {
            Tmp.v1.trns(this.rand.random(360.0f), this.rand.random(radius / constraint));
            float rx = (float)this.width / 2.0f + Tmp.v1.x;
            float ry = (float)this.height / 2.0f + Tmp.v1.y;
            float maxrad = radius - Tmp.v1.len();
            float rrad = Math.min(this.rand.random(9.0f, maxrad / 2.0f), 30.0f);
            roomseq.add(new Room((int)rx, (int)ry, (int)rrad));
        }
        Room spawn = null;
        Seq<Room> enemies = new Seq<Room>();
        int enemySpawns = this.rand.random(1, Math.max((int)(this.sector.threat * 4.0f), 1));
        int offset = this.rand.nextInt(360);
        float length = (float)this.width / 2.55f - (float)this.rand.random(13, 23);
        int angleStep = 5;
        int waterCheckRad = 5;
        for (int i = 0; i < 360; i += angleStep) {
            int n = offset + i;
            int n2 = (int)((float)(this.width / 2) + Angles.trnsx(n, length));
            int cy2 = (int)((float)(this.height / 2) + Angles.trnsy(n, length));
            int waterTiles = 0;
            for (int rx = -waterCheckRad; rx <= waterCheckRad; ++rx) {
                for (int ry = -waterCheckRad; ry <= waterCheckRad; ++ry) {
                    Tile tile = this.tiles.get(n2 + rx, cy2 + ry);
                    if (tile != null && tile.floor().liquidDrop == null) continue;
                    ++waterTiles;
                }
            }
            if (waterTiles > 4 && i + angleStep < 360) continue;
            spawn = new Room(n2, cy2, this.rand.random(8, 15));
            roomseq.add(spawn);
            for (int j = 0; j < enemySpawns; ++j) {
                float enemyOffset = this.rand.range(60.0f);
                Tmp.v1.set(n2 - this.width / 2, cy2 - this.height / 2).rotate(180.0f + enemyOffset).add(this.width / 2, (float)(this.height / 2));
                Room espawn = new Room((int)Tmp.v1.x, (int)Tmp.v1.y, this.rand.random(8, 15));
                roomseq.add(espawn);
                enemies.add(espawn);
            }
            break;
        }
        for (Room room : roomseq) {
            this.erase(room.x, room.y, room.radius);
        }
        int connections = this.rand.random(Math.max(rooms - 1, 1), rooms + 3);
        boolean bl = false;
        while (var13_22 < connections) {
            ((Room)((Object)roomseq.random((Object)this.rand))).connect((Room)((Object)roomseq.random((Object)this.rand)));
            ++var13_22;
        }
        for (Room room : roomseq) {
            spawn.connect(room);
        }
        this.cells(1);
        this.distort(10.0f, 6.0f);
        this.inverseFloodFill(this.tiles.getn(spawn.x, spawn.y));
        Seq<Block> seq = Seq.with(Blocks.oreCopper, Blocks.oreLead);
        float f = Math.abs(this.sector.tile.v.y);
        float nmag = 0.5f;
        float scl = 1.0f;
        float addscl = 1.3f;
        if (this.noise.octaveNoise3D(2.0, 0.5, scl, this.sector.tile.v.x, this.sector.tile.v.y, this.sector.tile.v.z) * (double)nmag + (double)f > (double)(0.25f * addscl)) {
            seq.add(Blocks.oreCoal);
        }
        if (this.noise.octaveNoise3D(2.0, 0.5, scl, this.sector.tile.v.x + 1.0f, this.sector.tile.v.y, this.sector.tile.v.z) * (double)nmag + (double)f > (double)(0.5f * addscl)) {
            seq.add(Blocks.oreTitanium);
        }
        if (this.noise.octaveNoise3D(2.0, 0.5, scl, this.sector.tile.v.x + 2.0f, this.sector.tile.v.y, this.sector.tile.v.z) * (double)nmag + (double)f > (double)(0.7f * addscl)) {
            seq.add(Blocks.oreThorium);
        }
        if (this.rand.chance(0.25)) {
            seq.add(Blocks.oreScrap);
        }
        FloatSeq frequencies = new FloatSeq();
        for (int i = 0; i < seq.size; ++i) {
            frequencies.add(this.rand.random(-0.1f, 0.01f) - (float)i * 0.01f + f * 0.04f);
        }
        this.pass((x, y) -> {
            if (!this.floor.asFloor().hasSurface()) {
                return;
            }
            int offsetX = x - 4;
            int offsetY = y + 23;
            for (int i = ores.size - 1; i >= 0; --i) {
                Block entry = (Block)ores.get(i);
                float freq = frequencies.get(i);
                if (!((double)Math.abs(0.5f - this.noise(offsetX, offsetY + i * 999, 2.0, 0.7, 40 + i * 2)) > (double)0.22f + (double)i * 0.01) || !(Math.abs(0.5f - this.noise(offsetX, offsetY - i * 999, 1.0, 1.0, 30 + i * 4)) > 0.37f + freq)) continue;
                this.ore = entry;
                break;
            }
            if (this.ore == Blocks.oreScrap && this.rand.chance(0.33)) {
                this.floor = Blocks.metalFloorDamaged;
            }
        });
        this.trimDark();
        this.median(2);
        this.tech();
        this.pass((x, y) -> {
            block16: {
                float noise;
                if (this.floor == Blocks.sporeMoss && (double)Math.abs(0.5f - this.noise(x - 90, y, 4.0, 0.8, 65.0)) > 0.02) {
                    this.floor = Blocks.moss;
                }
                if (this.floor == Blocks.darksand && Math.abs(0.5f - this.noise(x - 40, y, 2.0, 0.7, 80.0)) > 0.25f && Math.abs(0.5f - this.noise(x, y + this.sector.id * 10, 1.0, 1.0, 60.0)) > 0.41f && !roomseq.contains(r -> Mathf.within(x, y, r.x, r.y, 15.0f))) {
                    this.floor = Blocks.tar;
                    this.ore = Blocks.air;
                }
                if (this.floor == Blocks.hotrock) {
                    if ((double)Math.abs(0.5f - this.noise(x - 90, y, 4.0, 0.8, 80.0)) > 0.035) {
                        this.floor = Blocks.basalt;
                    } else {
                        this.ore = Blocks.air;
                        boolean all = true;
                        for (Point2 p : Geometry.d4) {
                            Tile other = this.tiles.get(x + p.x, y + p.y);
                            if (other != null && (other.floor() == Blocks.hotrock || other.floor() == Blocks.magmarock)) continue;
                            all = false;
                        }
                        if (all) {
                            this.floor = Blocks.magmarock;
                        }
                    }
                } else if (this.floor != Blocks.basalt && this.floor != Blocks.ice && this.floor.asFloor().hasSurface() && (noise = this.noise(x + 782, y, 5.0, 0.75, 260.0, 1.0)) > 0.67f && !roomseq.contains(e -> Mathf.within(x, y, e.x, e.y, 14.0f))) {
                    this.floor = noise > 0.72f ? (noise > 0.78f ? Blocks.taintedWater : (this.floor == Blocks.sand ? Blocks.sandWater : Blocks.darksandTaintedWater)) : (this.floor == Blocks.sand ? this.floor : Blocks.darksand);
                    this.ore = Blocks.air;
                }
                if (this.rand.chance(0.0075)) {
                    boolean any = false;
                    boolean all = true;
                    for (Point2 p : Geometry.d4) {
                        Tile other = this.tiles.get(x + p.x, y + p.y);
                        if (other != null && other.block() == Blocks.air) {
                            any = true;
                            continue;
                        }
                        all = false;
                    }
                    if (any && (this.block == Blocks.snowWall || this.block == Blocks.iceWall || all && this.block == Blocks.air && this.floor == Blocks.snow && this.rand.chance(0.03))) {
                        this.block = this.rand.chance(0.5) ? Blocks.whiteTree : Blocks.whiteTreeDead;
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    Tile near = Vars.world.tile(x + Geometry.d4[i].x, y + Geometry.d4[i].y);
                    if (near == null || near.block() == Blocks.air) {
                        continue;
                    }
                    break block16;
                }
                if (this.rand.chance(0.01) && this.floor.asFloor().hasSurface() && this.block == Blocks.air) {
                    this.block = this.dec.get(this.floor, this.floor.asFloor().decoration);
                }
            }
        });
        float difficulty = this.sector.threat;
        this.ints.clear();
        this.ints.ensureCapacity(this.width * this.height / 4);
        int ruinCount = this.rand.random(-2, 4);
        if (ruinCount > 0) {
            int padding;
            for (int x2 = padding = 25; x2 < this.width - padding; ++x2) {
                for (int y2 = padding; y2 < this.height - padding; ++y2) {
                    Tile tile = this.tiles.getn(x2, y2);
                    if (tile.solid() || tile.drop() == null && tile.floor().liquidDrop == null) continue;
                    this.ints.add(tile.pos());
                }
            }
            this.ints.shuffle(this.rand);
            int placed = 0;
            float diffRange = 0.4f;
            for (int i = 0; i < this.ints.size && placed < ruinCount; ++i) {
                short y3;
                int val = this.ints.items[i];
                short x3 = Point2.x(val);
                if (Mathf.within(x3, y3 = Point2.y(val), spawn.x, spawn.y, 18.0f)) continue;
                float range = difficulty + this.rand.random(diffRange);
                Tile tile = this.tiles.getn(x3, y3);
                BaseRegistry.BasePart part = null;
                if (tile.overlay().itemDrop != null) {
                    part = Vars.bases.forResource(tile.drop()).getFrac(range);
                } else if (tile.floor().liquidDrop != null && this.rand.chance(0.05)) {
                    part = Vars.bases.forResource(tile.floor().liquidDrop).getFrac(range);
                } else if (this.rand.chance(0.05)) {
                    part = Vars.bases.parts.getFrac(range);
                }
                if (part == null || !BaseGenerator.tryPlace(part, x3, y3, Team.derelict, (cx, cy) -> {
                    Tile other = this.tiles.getn(cx, cy);
                    if (other.floor().hasSurface()) {
                        other.setOverlay(Blocks.oreScrap);
                        for (int j = 1; j <= 2; ++j) {
                            for (Point2 p : Geometry.d8) {
                                Tile t = this.tiles.get(cx + p.x * j, cy + p.y * j);
                                if (t == null || !t.floor().hasSurface() || !this.rand.chance(j == 1 ? 0.4 : 0.2)) continue;
                                t.setOverlay(Blocks.oreScrap);
                            }
                        }
                    }
                })) continue;
                ++placed;
                int debrisRadius = Math.max(part.schematic.width, part.schematic.height) / 2 + 3;
                Geometry.circle(x3, y3, this.tiles.width, this.tiles.height, debrisRadius, (cx, cy) -> {
                    float dst = Mathf.dst(cx, cy, x3, y3);
                    float removeChance = Mathf.lerp(0.05f, 0.5f, dst / (float)debrisRadius);
                    Tile other = this.tiles.getn(cx, cy);
                    if (other.build != null && other.isCenter()) {
                        if (other.team() == Team.derelict && this.rand.chance(removeChance)) {
                            other.remove();
                        } else if (this.rand.chance(0.5)) {
                            other.build.health -= this.rand.random(other.build.health * 0.9f);
                        }
                    }
                });
            }
        }
        Schematics.placeLaunchLoadout(spawn.x, spawn.y);
        for (Room espawn : enemies) {
            this.tiles.getn(espawn.x, espawn.y).setOverlay(Blocks.spawn);
        }
        if (this.sector.hasEnemyBase()) {
            this.basegen.generate(this.tiles, enemies.map(r -> this.tiles.getn(r.x, r.y)), this.tiles.get(spawn.x, spawn.y), Vars.state.rules.waveTeam, this.sector, difficulty);
            this.sector.info.attack = true;
            Vars.state.rules.attackMode = true;
        } else {
            Vars.state.rules.winWave = this.sector.info.winWave = 10 + 5 * (int)Math.max(difficulty * 10.0f, 1.0f);
        }
        float waveTimeDec = 0.4f;
        Vars.state.rules.waveSpacing = Mathf.lerp(7800.0f, 3600.0f, Math.max(difficulty - waveTimeDec, 0.0f) / 0.8f);
        this.sector.info.waves = true;
        Vars.state.rules.waves = true;
        Vars.state.rules.enemyCoreBuildRadius = 600.0f;
        Vars.state.rules.spawns = Waves.generate(difficulty, new Rand(), Vars.state.rules.attackMode);
    }

    @Override
    public void postGenerate(Tiles tiles) {
        if (this.sector.hasEnemyBase()) {
            this.basegen.postGenerate();
        }
    }
}

