/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.assets.AssetDescriptor;
import arc.assets.loaders.SoundLoader;
import arc.audio.Sound;
import arc.files.Fi;
import arc.func.Func;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.serialization.Json;
import arc.util.serialization.JsonValue;
import arc.util.serialization.Jval;
import arc.util.serialization.SerializationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Loadouts;
import mindustry.content.StatusEffects;
import mindustry.content.TechTree;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.ParticleEffect;
import mindustry.game.Objectives;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.game.SpawnGroup;
import mindustry.gen.LegsUnit;
import mindustry.gen.MechUnit;
import mindustry.gen.PayloadUnit;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.gen.UnitWaterMove;
import mindustry.mod.ClassMap;
import mindustry.mod.Mods;
import mindustry.mod.Scripts;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.Weather;
import mindustry.type.weather.ParticleWeather;
import mindustry.world.Block;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.BuildVisibility;

public class ContentParser {
    private static final boolean ignoreUnknownFields = true;
    ObjectMap<Class<?>, ContentType> contentTypes = new ObjectMap();
    ObjectSet<Class<?>> implicitNullable = ObjectSet.with(TextureRegion.class, TextureRegion[].class, TextureRegion[][].class);
    ObjectMap<String, AssetDescriptor<?>> sounds = new ObjectMap();
    ObjectMap<Class<?>, FieldParser> classParsers = new ObjectMap<Class<?>, FieldParser>(){
        {
            this.put(Effect.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.field(Fx.class, data);
                }
                Class<ParticleEffect> bc = ContentParser.this.resolve(data.getString("type", ""), ParticleEffect.class);
                data.remove("type");
                Effect result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(Interp.class, (type, data) -> ContentParser.this.field(Interp.class, data));
            this.put(Schematic.class, (type, data) -> {
                Object result = ContentParser.this.fieldOpt(Loadouts.class, data);
                if (result != null) {
                    return result;
                }
                String str = data.asString();
                if (str.startsWith("bXNjaA")) {
                    return Schematics.readBase64(str);
                }
                return Schematics.read(Vars.tree.get("schematics/" + str + "." + "msch"));
            });
            this.put(StatusEffect.class, (type, data) -> {
                Object result = ContentParser.this.fieldOpt(StatusEffects.class, data);
                if (result != null) {
                    return result;
                }
                StatusEffect effect = new StatusEffect(ContentParser.this.currentMod.name + "-" + data.getString("name"));
                ContentParser.this.readFields(effect, data);
                return effect;
            });
            this.put(Color.class, (type, data) -> Color.valueOf(data.asString()));
            this.put(BulletType.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.field(Bullets.class, data);
                }
                Class<BasicBulletType> bc = ContentParser.this.resolve(data.getString("type", ""), BasicBulletType.class);
                data.remove("type");
                BulletType result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(DrawBlock.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.make(ContentParser.this.resolve(data.asString()));
                }
                Class<DrawBlock> bc = ContentParser.this.resolve(data.getString("type", ""), DrawBlock.class);
                data.remove("type");
                DrawBlock result = ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(Sound.class, (type, data) -> {
                String path;
                if (ContentParser.this.fieldOpt(Sounds.class, data) != null) {
                    return ContentParser.this.fieldOpt(Sounds.class, data);
                }
                if (Vars.headless) {
                    return new Sound();
                }
                String name = "sounds/" + data.asString();
                String string = path = Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
                if (ContentParser.this.sounds.containsKey(path)) {
                    return ((SoundLoader.SoundParameter)ContentParser.this.sounds.get((String)path).params).sound;
                }
                Sound sound = new Sound();
                AssetDescriptor desc = Core.assets.load(path, Sound.class, new SoundLoader.SoundParameter(sound));
                desc.errored = Throwable::printStackTrace;
                ContentParser.this.sounds.put(path, desc);
                return sound;
            });
            this.put(Objectives.Objective.class, (type, data) -> {
                Class<Objectives.SectorComplete> oc = ContentParser.this.resolve(data.getString("type", ""), Objectives.SectorComplete.class);
                data.remove("type");
                Objectives.Objective obj = ContentParser.this.make(oc);
                ContentParser.this.readFields(obj, data);
                return obj;
            });
            this.put(Ability.class, (type, data) -> {
                Class oc = ContentParser.this.resolve(data.getString("type", ""));
                data.remove("type");
                Ability obj = (Ability)ContentParser.this.make(oc);
                ContentParser.this.readFields(obj, data);
                return obj;
            });
            this.put(Weapon.class, (type, data) -> {
                Weapon weapon = new Weapon();
                ContentParser.this.readFields(weapon, data);
                weapon.name = ContentParser.this.currentMod.name + "-" + weapon.name;
                return weapon;
            });
        }
    };
    private Seq<Runnable> reads = new Seq();
    private Seq<Runnable> postreads = new Seq();
    private ObjectSet<Object> toBeParsed = new ObjectSet();
    Mods.LoadedMod currentMod;
    Content currentContent;
    private Json parser = new Json(){

        @Override
        public <T> T readValue(Class<T> type, Class elementType, JsonValue jsonData, Class keyType) {
            T t = this.internalRead(type, elementType, jsonData, keyType);
            if (t != null) {
                ContentParser.this.checkNullFields(t);
            }
            return t;
        }

        private <T> T internalRead(Class<T> type, Class elementType, JsonValue jsonData, Class keyType) {
            if (type != null) {
                if (ContentParser.this.classParsers.containsKey(type)) {
                    try {
                        return (T)ContentParser.this.classParsers.get(type).parse(type, jsonData);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (type == ItemStack.class && jsonData.isString() && jsonData.asString().contains("/")) {
                    String[] split = jsonData.asString().split("/");
                    return (T)this.fromJson(ItemStack.class, "{item: " + split[0] + ", amount: " + split[1] + "}");
                }
                if (jsonData.isString() && jsonData.asString().contains("/")) {
                    String[] split = jsonData.asString().split("/");
                    if (type == LiquidStack.class) {
                        return (T)this.fromJson(LiquidStack.class, "{liquid: " + split[0] + ", amount: " + split[1] + "}");
                    }
                    if (type == ConsumeLiquid.class) {
                        return (T)this.fromJson(ConsumeLiquid.class, "{liquid: " + split[0] + ", amount: " + split[1] + "}");
                    }
                }
                if (Content.class.isAssignableFrom(type)) {
                    String prefix;
                    ContentType ctype = ContentParser.this.contentTypes.getThrow(type, () -> new IllegalArgumentException("No content type for class: " + type.getSimpleName()));
                    Object one = Vars.content.getByName(ctype, (prefix = ContentParser.this.currentMod != null ? ContentParser.this.currentMod.name + "-" : "") + jsonData.asString());
                    if (one != null) {
                        return one;
                    }
                    Object two = Vars.content.getByName(ctype, jsonData.asString());
                    if (two != null) {
                        return two;
                    }
                    throw new IllegalArgumentException("\"" + jsonData.name + "\": No " + (Object)((Object)ctype) + " found with name '" + jsonData.asString() + "'.\nMake sure '" + jsonData.asString() + "' is spelled correctly, and that it really exists!\nThis may also occur because its file failed to parse.");
                }
            }
            return super.readValue(type, elementType, jsonData, keyType);
        }
    };
    private ObjectMap<ContentType, TypeParser<?>> parsers = ObjectMap.of(new Object[]{ContentType.block, (mod, name, value) -> {
        Block block;
        this.readBundle(ContentType.block, name, value);
        if (this.locate(ContentType.block, name) != null) {
            block = (Block)this.locate(ContentType.block, name);
            if (value.has("type")) {
                throw new IllegalArgumentException("When defining properties for an existing block, you must not re-declare its type. The original type will be used. Block: " + name);
            }
        } else {
            block = this.make(this.resolve(value.getString("type", ""), Block.class), mod + "-" + name);
        }
        this.currentContent = block;
        this.read(() -> {
            if (value.has("consumes") && value.get("consumes").isObject()) {
                block14: for (JsonValue child : value.get("consumes")) {
                    switch (child.name) {
                        case "item": {
                            block.consumes.item((Item)this.find(ContentType.item, child.asString()));
                            continue block14;
                        }
                        case "items": {
                            block.consumes.add((Consume)this.parser.readValue(ConsumeItems.class, child));
                            continue block14;
                        }
                        case "liquid": {
                            block.consumes.add((Consume)this.parser.readValue(ConsumeLiquid.class, child));
                            continue block14;
                        }
                        case "power": {
                            if (child.isNumber()) {
                                block.consumes.power(child.asFloat());
                                continue block14;
                            }
                            block.consumes.add((Consume)this.parser.readValue(ConsumePower.class, child));
                            continue block14;
                        }
                        case "powerBuffered": {
                            block.consumes.powerBuffered(child.asFloat());
                            continue block14;
                        }
                    }
                    throw new IllegalArgumentException("Unknown consumption type: '" + child.name + "' for block '" + block.name + "'.");
                }
                value.remove("consumes");
            }
            this.readFields(block, value, true);
            if (block.size > 16) {
                throw new IllegalArgumentException("Blocks cannot be larger than 16");
            }
            if (value.has("requirements") && block.buildVisibility == BuildVisibility.hidden) {
                block.buildVisibility = BuildVisibility.shown;
            }
        });
        return block;
    }, ContentType.unit, (mod, name, value) -> {
        UnitType unit;
        this.readBundle(ContentType.unit, name, value);
        if (this.locate(ContentType.unit, name) == null) {
            unit = new UnitType(mod + "-" + name);
            JsonValue typeVal = value.get("type");
            if (typeVal != null && !typeVal.isString()) {
                throw new RuntimeException("Unit '" + name + "' has an incorrect type. Types must be strings.");
            }
            unit.constructor = this.unitType(typeVal);
        } else {
            unit = (UnitType)this.locate(ContentType.unit, name);
        }
        this.currentContent = unit;
        this.read(() -> {
            if (value.has("requirements")) {
                Reconstructor r;
                JsonValue rec = value.remove("requirements");
                UnitReq req = this.parser.readValue(UnitReq.class, rec);
                Block r$temp = req.block;
                if (r$temp instanceof Reconstructor && (r = (Reconstructor)r$temp) == (Reconstructor)r$temp) {
                    if (req.previous != null) {
                        r.upgrades.add(new UnitType[]{req.previous, unit});
                    }
                } else {
                    UnitFactory f;
                    Block f$temp = req.block;
                    if (f$temp instanceof UnitFactory && (f = (UnitFactory)f$temp) == (UnitFactory)f$temp) {
                        f.plans.add(new UnitFactory.UnitPlan(unit, req.time, req.requirements));
                    } else {
                        throw new IllegalArgumentException("Missing a valid 'block' in 'requirements'");
                    }
                }
            }
            if (value.has("controller")) {
                unit.defaultController = this.supply(this.resolve(value.getString("controller"), FlyingAI.class));
                value.remove("controller");
            }
            if (value.has("waves")) {
                SpawnGroup[] groups;
                JsonValue waves = value.remove("waves");
                for (SpawnGroup group : groups = this.parser.readValue(SpawnGroup[].class, waves)) {
                    group.type = unit;
                }
                Vars.waves.get().addAll((SpawnGroup[])groups);
            }
            this.readFields(unit, value, true);
        });
        return unit;
    }, ContentType.weather, (mod, name, value) -> {
        Weather item;
        if (this.locate(ContentType.weather, name) != null) {
            item = (Weather)this.locate(ContentType.weather, name);
            this.readBundle(ContentType.weather, name, value);
        } else {
            this.readBundle(ContentType.weather, name, value);
            item = this.make(this.resolve(this.getType(value), ParticleWeather.class), mod + "-" + name);
            value.remove("type");
        }
        this.currentContent = item;
        this.read(() -> this.readFields(item, value));
        return item;
    }, ContentType.item, this.parser(ContentType.item, Item::new), ContentType.liquid, this.parser(ContentType.liquid, Liquid::new)});

    private Prov<Unit> unitType(JsonValue value) {
        Prov<Unit> prov;
        if (value == null) {
            return UnitEntity::create;
        }
        switch (value.asString()) {
            case "flying": {
                prov = UnitEntity::create;
                break;
            }
            case "mech": {
                prov = MechUnit::create;
                break;
            }
            case "legs": {
                prov = LegsUnit::create;
                break;
            }
            case "naval": {
                prov = UnitWaterMove::create;
                break;
            }
            case "payload": {
                prov = PayloadUnit::create;
                break;
            }
            default: {
                throw new RuntimeException("Invalid unit type: '" + value + "'. Must be 'flying/mech/legs/naval/payload'.");
            }
        }
        return prov;
    }

    private String getString(JsonValue value, String key) {
        if (value.has(key)) {
            return value.getString(key);
        }
        throw new IllegalArgumentException("You are missing a \"" + key + "\". It must be added before the file can be parsed.");
    }

    private String getType(JsonValue value) {
        return this.getString(value, "type");
    }

    private <T extends Content> T find(ContentType type, String name) {
        Object c = Vars.content.getByName(type, name);
        if (c == null) {
            c = Vars.content.getByName(type, this.currentMod.name + "-" + name);
        }
        if (c == null) {
            throw new IllegalArgumentException("No " + (Object)((Object)type) + " found with name '" + name + "'");
        }
        return c;
    }

    private <T extends Content> TypeParser<T> parser(ContentType type, Func<String, T> constructor) {
        return (mod, name, value) -> {
            Object item;
            if (this.locate(type, name) != null) {
                item = this.locate(type, name);
                this.readBundle(type, name, value);
            } else {
                this.readBundle(type, name, value);
                item = (Content)constructor.get(mod + "-" + name);
            }
            this.currentContent = item;
            this.read(() -> this.readFields(item, value));
            return item;
        };
    }

    private void readBundle(ContentType type, String name, JsonValue value) {
        UnlockableContent cont = this.locate(type, name) instanceof UnlockableContent ? (UnlockableContent)this.locate(type, name) : null;
        String entryName = cont == null ? (Object)((Object)type) + "." + this.currentMod.name + "-" + name + "." : (Object)((Object)type) + "." + cont.name + ".";
        I18NBundle bundle = Core.bundle;
        while (bundle.getParent() != null) {
            bundle = bundle.getParent();
        }
        if (value.has("name")) {
            if (!Core.bundle.has(entryName + "name")) {
                bundle.getProperties().put(entryName + "name", value.getString("name"));
                if (cont != null) {
                    cont.localizedName = value.getString("name");
                }
            }
            value.remove("name");
        }
        if (value.has("description")) {
            if (!Core.bundle.has(entryName + "description")) {
                bundle.getProperties().put(entryName + "description", value.getString("description"));
                if (cont != null) {
                    cont.description = value.getString("description");
                }
            }
            value.remove("description");
        }
    }

    private void read(Runnable run) {
        Content cont = this.currentContent;
        Mods.LoadedMod mod = this.currentMod;
        this.reads.add(() -> {
            this.currentMod = mod;
            this.currentContent = cont;
            run.run();
            if (cont != null) {
                this.toBeParsed.remove(cont);
                this.checkNullFields(cont);
            }
        });
    }

    private void init() {
        for (ContentType type : ContentType.all) {
            Seq arr = Vars.content.getBy(type);
            if (arr.isEmpty()) continue;
            Class<?> c = ((Content)arr.first()).getClass();
            while (c.getSuperclass() != Content.class && c.getSuperclass() != UnlockableContent.class && !Modifier.isAbstract(c.getSuperclass().getModifiers())) {
                c = c.getSuperclass();
            }
            this.contentTypes.put(c, type);
        }
    }

    private void attempt(Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            Log.err(t);
            this.markError(this.currentContent, t);
        }
    }

    public void finishParsing() {
        this.reads.each(this::attempt);
        this.postreads.each(this::attempt);
        this.reads.clear();
        this.postreads.clear();
        this.toBeParsed.clear();
    }

    public Content parse(Mods.LoadedMod mod, String name, String json, Fi file, ContentType type) throws Exception {
        if (this.contentTypes.isEmpty()) {
            this.init();
        }
        if (file.extension().equals("json")) {
            json = json.replace("#", "\\#");
        }
        JsonValue value = (JsonValue)this.parser.fromJson(null, Jval.read(json).toString(Jval.Jformat.plain));
        if (!this.parsers.containsKey(type)) {
            throw new SerializationException("No parsers for content type '" + (Object)((Object)type) + "'");
        }
        this.currentMod = mod;
        boolean located = this.locate(type, name) != null;
        Object c = this.parsers.get(type).parse(mod.name, name, value);
        ((Content)c).minfo.sourceFile = file;
        this.toBeParsed.add(c);
        if (!located) {
            ((Content)c).minfo.mod = mod;
        }
        return c;
    }

    public void markError(Content content, Mods.LoadedMod mod, Fi file, Throwable error) {
        Log.err("Error for @ / @:\n@\n", content, file, Strings.getStackTrace(error));
        content.minfo.mod = mod;
        content.minfo.sourceFile = file;
        content.minfo.error = this.makeError(error, file);
        content.minfo.baseError = error;
        if (mod != null) {
            mod.erroredContent.add(content);
        }
    }

    public void markError(Content content, Throwable error) {
        if (content.minfo != null && !content.hasErrored()) {
            this.markError(content, content.minfo.mod, content.minfo.sourceFile, error);
        }
    }

    private String makeError(Throwable t, Fi file) {
        StringBuilder builder = new StringBuilder();
        builder.append("[lightgray]").append("File: ").append(file.name()).append("[]\n\n");
        if (t.getMessage() != null && t instanceof Jval.JsonParseException) {
            builder.append("[accent][[JsonParse][] ").append(":\n").append(t.getMessage());
        } else if (t instanceof NullPointerException) {
            builder.append(Strings.neatError(t));
        } else {
            Seq<Throwable> causes = Strings.getCauses(t);
            for (Throwable e : causes) {
                builder.append("[accent][[").append(e.getClass().getSimpleName().replace("Exception", "")).append("][] ").append(e.getMessage() != null ? e.getMessage().replace("mindustry.", "").replace("arc.", "") : "").append("\n");
            }
        }
        return builder.toString();
    }

    private <T extends MappableContent> T locate(ContentType type, String name) {
        Object first = Vars.content.getByName(type, name);
        return first != null ? first : Vars.content.getByName(type, this.currentMod.name + "-" + name);
    }

    <T> T make(Class<T> type) {
        try {
            Constructor<T> cons = type.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T make(Class<T> type, String name) {
        try {
            Constructor<T> cons = type.getDeclaredConstructor(String.class);
            cons.setAccessible(true);
            return cons.newInstance(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Prov<T> supply(Class<T> type) {
        try {
            Constructor cons = type.getDeclaredConstructor(new Class[0]);
            return () -> {
                try {
                    return cons.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object field(Class<?> type, JsonValue value) {
        return this.field(type, value.asString());
    }

    private Object field(Class<?> type, String name) {
        try {
            Object b = type.getField(name).get(null);
            if (b == null) {
                throw new IllegalArgumentException(type.getSimpleName() + ": not found: '" + name + "'");
            }
            return b;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object fieldOpt(Class<?> type, JsonValue value) {
        try {
            return type.getField(value.asString()).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    void checkNullFields(Object object) {
        if (object == null || object instanceof Number || object instanceof String || this.toBeParsed.contains(object) || object.getClass().getName().startsWith("arc.")) {
            return;
        }
        this.parser.getFields(object.getClass()).values().toSeq().each(field -> {
            try {
                if (field.field.getType().isPrimitive()) {
                    return;
                }
                if (!field.field.isAnnotationPresent(Nullable.class) && field.field.get(object) == null && !this.implicitNullable.contains(field.field.getType())) {
                    throw new RuntimeException("'" + field.field.getName() + "' in " + (object.getClass().isAnonymousClass() ? object.getClass().getSuperclass() : object.getClass()).getSimpleName() + " is missing! Object = " + object + ", field = (" + field.field.getName() + " = " + field.field.get(object) + ")");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void readFields(Object object, JsonValue jsonMap, boolean stripType) {
        if (stripType) {
            jsonMap.remove("type");
        }
        this.readFields(object, jsonMap);
    }

    void readFields(Object object, JsonValue jsonMap) {
        UnlockableContent unlock;
        Object metadata;
        JsonValue research = jsonMap.remove("research");
        this.toBeParsed.remove(object);
        Class<?> type = object.getClass();
        OrderedMap<String, Json.FieldMetadata> fields = this.parser.getFields(type);
        JsonValue child = jsonMap.child;
        while (child != null) {
            metadata = (Json.FieldMetadata)fields.get(child.name().replace(" ", "_"));
            if (metadata == null) {
                Log.warn("@: Ignoring unknown field: " + child.name + " (" + type.getName() + ")", object);
            } else {
                Field field = ((Json.FieldMetadata)metadata).field;
                try {
                    field.set(object, this.parser.readValue(field.getType(), ((Json.FieldMetadata)metadata).elementType, child, ((Json.FieldMetadata)metadata).keyType));
                }
                catch (IllegalAccessException ex) {
                    throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
                }
                catch (SerializationException ex) {
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
                catch (RuntimeException runtimeEx) {
                    SerializationException ex = new SerializationException(runtimeEx);
                    ex.addTrace(child.trace());
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
            }
            child = child.next;
        }
        metadata = object;
        if (metadata instanceof UnlockableContent && (unlock = (UnlockableContent)metadata) == (UnlockableContent)metadata && research != null) {
            ItemStack[] customRequirements;
            String researchName;
            if (research.isString()) {
                researchName = research.asString();
                customRequirements = null;
            } else {
                researchName = research.getString("parent");
                customRequirements = research.has("requirements") ? this.parser.readValue(ItemStack[].class, research.get("requirements")) : null;
            }
            TechTree.TechNode lastNode = TechTree.all.find(t -> t.content == unlock);
            if (lastNode != null) {
                lastNode.remove();
            }
            TechTree.TechNode node = new TechTree.TechNode(null, unlock, customRequirements == null ? unlock.researchRequirements() : customRequirements);
            Mods.LoadedMod cur = this.currentMod;
            this.postreads.add(() -> {
                TechTree.TechNode parent;
                this.currentContent = unlock;
                this.currentMod = cur;
                if (node.parent != null) {
                    node.parent.children.remove(node);
                }
                if ((parent = TechTree.all.find(t -> t.content.name.equals(researchName) || t.content.name.equals(this.currentMod.name + "-" + researchName))) == null) {
                    throw new IllegalArgumentException("Content '" + researchName + "' isn't in the tech tree, but '" + unlock.name + "' requires it to be researched.");
                }
                if (!parent.children.contains(node)) {
                    parent.children.add(node);
                }
                node.parent = parent;
            });
        }
    }

    <T> Class<T> resolve(String base) {
        return this.resolve(base, null);
    }

    <T> Class<T> resolve(String base, Class<T> def) {
        if (base.isEmpty() && def != null) {
            return def;
        }
        Class<?> out = ClassMap.classes.get(!base.isEmpty() && Character.isLowerCase(base.charAt(0)) ? Strings.capitalize(base) : base);
        if (out != null) {
            return out;
        }
        if (base.indexOf(46) != -1 && Scripts.allowClass(base)) {
            try {
                return Class.forName(base);
            }
            catch (Exception ignored) {
                for (Mods.LoadedMod mod : Vars.mods.mods) {
                    if (mod.loader == null) continue;
                    try {
                        return Class.forName(base, true, mod.loader);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        if (def != null) {
            Log.warn("[@] No type '" + base + "' found, defaulting to type '" + def.getSimpleName() + "'", this.currentContent == null ? this.currentMod.name : "");
            return def;
        }
        throw new IllegalArgumentException("Type not found: " + base);
    }

    private static interface TypeParser<T extends Content> {
        public T parse(String var1, String var2, JsonValue var3) throws Exception;
    }

    static class UnitReq {
        public Block block;
        public ItemStack[] requirements = new ItemStack[0];
        @Nullable
        public UnitType previous;
        public float time = 600.0f;

        UnitReq() {
        }
    }

    private static interface FieldParser {
        public Object parse(Class<?> var1, JsonValue var2) throws Exception;
    }
}

