/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.files.Fi;
import arc.files.ZipFi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.I18NBundle;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.io.PropertiesUtils;
import arc.util.io.Streams;
import arc.util.serialization.Json;
import arc.util.serialization.Jval;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.mod.ContentParser;
import mindustry.mod.Mod;
import mindustry.mod.Plugin;
import mindustry.mod.Scripts;
import mindustry.type.ErrorContent;
import mindustry.type.Publishable;
import mindustry.ui.Styles;

public class Mods
implements Loadable {
    private Json json = new Json();
    @Nullable
    private Scripts scripts;
    private ContentParser parser = new ContentParser();
    private ObjectMap<String, Seq<Fi>> bundles = new ObjectMap();
    private ObjectSet<String> specialFolders = ObjectSet.with("bundles", "sprites", "sprites-override");
    private int totalSprites;
    private MultiPacker packer;
    Seq<LoadedMod> mods = new Seq();
    private ObjectMap<Class<?>, ModMeta> metas = new ObjectMap();
    private boolean requiresReload;
    private boolean createdAtlas;

    public Mods() {
        Events.on(EventType.ClientLoadEvent.class, e -> Core.app.post(this::checkWarnings));
    }

    public Fi getConfig(Mod mod) {
        ModMeta load = this.metas.get(mod.getClass());
        if (load == null) {
            throw new IllegalArgumentException("Mod is not loaded yet (or missing)!");
        }
        return Vars.modDirectory.child(load.name).child("config.json");
    }

    public void listFiles(String directory, Cons2<LoadedMod, Fi> cons) {
        this.eachEnabled(mod -> {
            Fi file = mod.root.child(directory);
            if (file.exists()) {
                for (Fi child : file.list()) {
                    cons.get((LoadedMod)mod, child);
                }
            }
        });
    }

    @Nullable
    public LoadedMod getMod(String name) {
        return this.mods.find(m -> m.name.equals(name));
    }

    @Nullable
    public LoadedMod getMod(Class<? extends Mod> type) {
        return this.mods.find(m -> m.enabled() && m.main != null && m.main.getClass() == type);
    }

    public LoadedMod importMod(Fi file) throws IOException {
        String baseName;
        String finalName = baseName = file.nameWithoutExtension();
        int count = 1;
        while (Vars.modDirectory.child(finalName + ".zip").exists()) {
            finalName = baseName + "" + count++;
        }
        Fi dest = Vars.modDirectory.child(finalName + ".zip");
        file.copyTo(dest);
        try {
            LoadedMod loaded = this.loadMod(dest, true);
            this.mods.add(loaded);
            this.requiresReload = true;
            Core.settings.put("mod-" + loaded.name + "-enabled", true);
            this.sortMods();
            Core.app.post(() -> this.loadIcon(loaded));
            return loaded;
        }
        catch (IOException e) {
            dest.delete();
            throw e;
        }
        catch (Throwable t) {
            dest.delete();
            throw new IOException(t);
        }
    }

    @Override
    public void loadAsync() {
        if (!this.mods.contains((LoadedMod)((Object)((Boolf<LoadedMod>)LoadedMod::enabled)))) {
            return;
        }
        Time.mark();
        this.packer = new MultiPacker();
        this.eachEnabled(mod -> {
            Seq<Fi> sprites = mod.root.child("sprites").findAll(f -> f.extension().equals("png"));
            Seq<Fi> overrides = mod.root.child("sprites-override").findAll(f -> f.extension().equals("png"));
            this.packSprites(sprites, (LoadedMod)mod, true);
            this.packSprites(overrides, (LoadedMod)mod, false);
            Log.debug("Packed @ images for mod '@'.", sprites.size + overrides.size, mod.meta.name);
            this.totalSprites += sprites.size + overrides.size;
        });
        Log.debug("Time to pack textures: @", Float.valueOf(Time.elapsed()));
    }

    private void loadIcons() {
        for (LoadedMod mod : this.mods) {
            this.loadIcon(mod);
        }
    }

    private void loadIcon(LoadedMod mod) {
        if (mod.root.child("icon.png").exists()) {
            try {
                mod.iconTexture = new Texture(mod.root.child("icon.png"));
                mod.iconTexture.setFilter(Texture.TextureFilter.linear);
            }
            catch (Throwable t) {
                Log.err("Failed to load icon for mod '" + mod.name + "'.", t);
            }
        }
    }

    private void packSprites(Seq<Fi> sprites, LoadedMod mod, boolean prefix) {
        for (Fi file : sprites) {
            try {
                InputStream stream = file.read();
                try {
                    byte[] bytes = Streams.copyBytes(stream, Math.max((int)file.length(), 512));
                    Pixmap pixmap = new Pixmap(bytes, 0, bytes.length);
                    this.packer.add(this.getPage(file), (prefix ? mod.name + "-" : "") + file.nameWithoutExtension(), new PixmapRegion(pixmap));
                    pixmap.dispose();
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                Core.app.post(() -> {
                    Log.err("Error packing images for mod: @", mod.meta.name);
                    Log.err(e);
                    if (!Vars.headless) {
                        Vars.ui.showException(e);
                    }
                });
                break;
            }
        }
        this.totalSprites += sprites.size;
    }

    @Override
    public void loadSync() {
        this.loadIcons();
        if (this.packer == null) {
            return;
        }
        Time.mark();
        if (this.totalSprites > 0) {
            if (!this.createdAtlas) {
                Core.atlas = new TextureAtlas(Core.files.internal("sprites/sprites.atlas"));
            }
            this.createdAtlas = true;
            for (TextureAtlas.AtlasRegion region : Core.atlas.getRegions()) {
                MultiPacker.PageType type = this.getPage(region);
                if (this.packer.has(type, region.name)) continue;
                this.packer.add(type, region.name, Core.atlas.getPixmap(region));
            }
            Texture.TextureFilter filter = Core.settings.getBool("linear") ? Texture.TextureFilter.linear : Texture.TextureFilter.nearest;
            this.packer.flush(filter, Core.atlas);
            for (Seq<Content> arr : Vars.content.getContentMap()) {
                arr.each(c -> {
                    UnlockableContent u;
                    Content u$temp = c;
                    if (u$temp instanceof UnlockableContent && (u = (UnlockableContent)u$temp) == (UnlockableContent)u$temp && c.minfo.mod != null) {
                        u.load();
                        u.createIcons(this.packer);
                    }
                });
            }
            Core.atlas = this.packer.flush(filter, new TextureAtlas());
            Core.atlas.setErrorRegion("error");
            Log.debug("Total pages: @", Core.atlas.getTextures().size);
        }
        this.packer.dispose();
        this.packer = null;
        Log.debug("Time to update textures: @", Float.valueOf(Time.elapsed()));
    }

    private MultiPacker.PageType getPage(TextureAtlas.AtlasRegion region) {
        return region.texture == Core.atlas.find((String)"white").texture ? MultiPacker.PageType.main : (region.texture == Core.atlas.find((String)"stone1").texture ? MultiPacker.PageType.environment : (region.texture == Core.atlas.find((String)"clear-editor").texture ? MultiPacker.PageType.editor : (region.texture == Core.atlas.find((String)"whiteui").texture ? MultiPacker.PageType.ui : MultiPacker.PageType.main)));
    }

    private MultiPacker.PageType getPage(Fi file) {
        String parent = file.parent().name();
        return parent.equals("environment") ? MultiPacker.PageType.environment : (parent.equals("editor") ? MultiPacker.PageType.editor : (parent.equals("ui") || file.parent().parent().name().equals("ui") ? MultiPacker.PageType.ui : MultiPacker.PageType.main));
    }

    public void removeMod(LoadedMod mod) {
        boolean deleted;
        if (mod.root instanceof ZipFi) {
            mod.root.delete();
        }
        boolean bl = deleted = mod.file.isDirectory() ? mod.file.deleteDirectory() : mod.file.delete();
        if (!deleted) {
            Vars.ui.showErrorMessage("@mod.delete.error");
            return;
        }
        this.mods.remove(mod);
        mod.dispose();
        this.requiresReload = true;
    }

    public Scripts getScripts() {
        if (this.scripts == null) {
            this.scripts = Vars.platform.createScripts();
        }
        return this.scripts;
    }

    public boolean hasScripts() {
        return this.scripts != null;
    }

    public boolean requiresReload() {
        return this.requiresReload;
    }

    public boolean skipModLoading() {
        return Vars.failedToLaunch && Core.settings.getBool("modcrashdisable", true);
    }

    public void load() {
        for (Fi file : Vars.modDirectory.list()) {
            if (!file.extension().equals("jar") && !file.extension().equals("zip") && (!file.isDirectory() || !file.child("mod.json").exists() && !file.child("mod.hjson").exists())) continue;
            Log.debug("[Mods] Loading mod @", file);
            try {
                LoadedMod mod = this.loadMod(file);
                this.mods.add(mod);
            }
            catch (Throwable e) {
                if (e instanceof ClassNotFoundException && e.getMessage().contains("mindustry.plugin.Plugin")) {
                    Log.info("Plugin @ is outdated and needs to be ported to 6.0! Update its main class to inherit from 'mindustry.mod.Plugin'. See https://mindustrygame.github.io/wiki/modding/6-migrationv6/");
                    continue;
                }
                Log.err("Failed to load mod file @. Skipping.", file);
                Log.err(e);
            }
        }
        for (Fi file : Vars.platform.getWorkshopContent(LoadedMod.class)) {
            try {
                LoadedMod mod = this.loadMod(file);
                this.mods.add(mod);
                mod.addSteamID(file.name());
            }
            catch (Throwable e) {
                Log.err("Failed to load mod workshop file @. Skipping.", file);
                Log.err(e);
            }
        }
        this.resolveModState();
        this.sortMods();
        this.buildFiles();
    }

    private void sortMods() {
        this.mods.sort(Structs.comps(Structs.comparingInt(m -> m.state.ordinal()), Structs.comparing(m -> m.name)));
    }

    private void resolveModState() {
        this.mods.each(this::updateDependencies);
        for (LoadedMod mod : this.mods) {
            mod.state = !mod.isSupported() ? ModState.unsupported : (mod.hasUnmetDependencies() ? ModState.missingDependencies : (!mod.shouldBeEnabled() ? ModState.disabled : ModState.enabled));
        }
    }

    private void updateDependencies(LoadedMod mod) {
        mod.dependencies.clear();
        mod.missingDependencies.clear();
        mod.dependencies = mod.meta.dependencies.map(this::locateMod);
        for (int i = 0; i < mod.dependencies.size; ++i) {
            if (mod.dependencies.get(i) != null) continue;
            mod.missingDependencies.add(mod.meta.dependencies.get(i));
        }
    }

    private void topoSort(LoadedMod mod, Seq<LoadedMod> stack, ObjectSet<LoadedMod> visited) {
        visited.add(mod);
        mod.dependencies.each(m -> !visited.contains((LoadedMod)m), m -> this.topoSort((LoadedMod)m, stack, visited));
        stack.add(mod);
    }

    private Seq<LoadedMod> orderedMods() {
        ObjectSet visited = new ObjectSet();
        Seq<LoadedMod> result = new Seq<LoadedMod>();
        this.eachEnabled(mod -> {
            if (!visited.contains(mod)) {
                this.topoSort((LoadedMod)mod, result, visited);
            }
        });
        return result;
    }

    public LoadedMod locateMod(String name) {
        return this.mods.find(mod -> mod.enabled() && mod.name.equals(name));
    }

    private void buildFiles() {
        for (LoadedMod mod : this.orderedMods()) {
            boolean zipFolder = !mod.file.isDirectory() && mod.root.parent() != null;
            String parentName = zipFolder ? mod.root.name() : null;
            for (Fi file : mod.root.list()) {
                if (!file.isDirectory() || this.specialFolders.contains(file.name())) continue;
                file.walk(f -> Vars.tree.addFile(mod.file.isDirectory() ? f.path().substring(1 + mod.file.path().length()) : (zipFolder ? f.path().substring(parentName.length() + 1) : f.path()), (Fi)f));
            }
            Fi folder = mod.root.child("bundles");
            if (!folder.exists()) continue;
            for (Fi file : folder.list()) {
                if (!file.name().startsWith("bundle") || !file.extension().equals("properties")) continue;
                String name = file.nameWithoutExtension();
                ((Seq)((Object)this.bundles.get(name, (Seq<Fi>)((Object)((Prov<Seq>)Seq::new))))).add(file);
            }
        }
        Events.fire(new EventType.FileTreeInitEvent());
        for (I18NBundle bundle = Core.bundle; bundle != null; bundle = bundle.getParent()) {
            String str = bundle.getLocale().toString();
            String locale = "bundle" + (str.isEmpty() ? "" : "_" + str);
            for (Fi file : (Seq)((Object)this.bundles.get(locale, (Seq<Fi>)((Object)((Prov<Seq>)Seq::new))))) {
                try {
                    PropertiesUtils.load(bundle.getProperties(), file.reader());
                }
                catch (Throwable e) {
                    Log.err("Error loading bundle: " + file + "/" + locale, e);
                }
            }
        }
    }

    private void checkWarnings() {
        if (this.scripts != null && this.scripts.hasErrored()) {
            Vars.ui.showErrorMessage("@mod.scripts.disable");
        }
        if (this.mods.contains((LoadedMod)((Object)((Boolf<LoadedMod>)LoadedMod::hasContentErrors)))) {
            Vars.ui.loadfrag.hide();
            new Dialog(""){
                {
                    this.setFillParent(true);
                    this.cont.margin(15.0f);
                    this.cont.add("@error.title");
                    this.cont.row();
                    this.cont.image().width(300.0f).pad(2.0f).colspan(2).height(4.0f).color(Color.scarlet);
                    this.cont.row();
                    this.cont.add("@mod.errors").wrap().growX().center().get().setAlignment(1);
                    this.cont.row();
                    this.cont.pane((Table p) -> Mods.this.mods.each(m -> m.enabled() && m.hasContentErrors(), m -> {
                        p.add(m.name).color(Pal.accent).left();
                        p.row();
                        p.image().fillX().pad(4.0f).color(Pal.accent);
                        p.row();
                        p.table((Table d) -> {
                            d.left().marginLeft(15.0f);
                            for (final Content c : m.erroredContent) {
                                d.add(c.minfo.sourceFile.nameWithoutExtension()).left().padRight(10.0f);
                                d.button("@details", (Drawable)Icon.downOpen, Styles.transt, () -> new Dialog(""){
                                    {
                                        super(title);
                                        this.setFillParent(true);
                                        this.cont.pane((Table e) -> e.add(c2.minfo.error).wrap().grow().labelAlign(1, 8)).grow();
                                        this.cont.row();
                                        this.cont.button("@ok", Icon.left, this::hide).size(240.0f, 60.0f);
                                    }
                                }.show()).size(190.0f, 50.0f).left().marginLeft(6.0f);
                                d.row();
                            }
                        }).left();
                        p.row();
                    }));
                    this.cont.row();
                    this.cont.button("@ok", this::hide).size(300.0f, 50.0f);
                }
            }.show();
        }
    }

    public boolean hasContentErrors() {
        return this.mods.contains((LoadedMod)((Object)((Boolf<LoadedMod>)LoadedMod::hasContentErrors))) || this.scripts != null && this.scripts.hasErrored();
    }

    public void loadScripts() {
        Time.mark();
        boolean[] any = new boolean[]{false};
        try {
            this.eachEnabled(mod -> {
                if (mod.root.child("scripts").exists()) {
                    Fi main;
                    Vars.content.setCurrentMod((LoadedMod)mod);
                    Seq<Fi> allScripts = mod.root.child("scripts").findAll(f -> f.extEquals("js"));
                    Fi fi = main = allScripts.size == 1 ? allScripts.first() : mod.root.child("scripts").child("main.js");
                    if (main.exists() && !main.isDirectory()) {
                        try {
                            if (this.scripts == null) {
                                this.scripts = Vars.platform.createScripts();
                            }
                            any[0] = true;
                            this.scripts.run((LoadedMod)mod, main);
                        }
                        catch (Throwable e) {
                            Core.app.post(() -> {
                                Log.err("Error loading main script @ for mod @.", main.name(), mod.meta.name);
                                Log.err(e);
                            });
                        }
                    } else {
                        Core.app.post(() -> Log.err("No main.js found for mod @.", mod.meta.name));
                    }
                }
            });
        }
        finally {
            Vars.content.setCurrentMod(null);
        }
        if (any[0]) {
            Log.info("Time to initialize modded scripts: @", Float.valueOf(Time.elapsed()));
        }
    }

    public void loadContent() {
        for (LoadedMod mod : this.orderedMods()) {
            if (mod.main == null || mod.meta.hidden) continue;
            Vars.content.setCurrentMod(mod);
            mod.main.loadContent();
        }
        Vars.content.setCurrentMod(null);
        class LoadRun
        implements Comparable<LoadRun> {
            final ContentType type;
            final Fi file;
            final LoadedMod mod;

            public LoadRun(ContentType type, Fi file, LoadedMod mod) {
                this.type = type;
                this.file = file;
                this.mod = mod;
            }

            @Override
            public int compareTo(LoadRun l) {
                int mod = this.mod.name.compareTo(l.mod.name);
                if (mod != 0) {
                    return mod;
                }
                return this.file.name().compareTo(l.file.name());
            }
        }
        Seq<LoadRun> runs = new Seq<LoadRun>();
        for (LoadedMod mod : this.orderedMods()) {
            if (!mod.root.child("content").exists()) continue;
            Fi contentRoot = mod.root.child("content");
            for (ContentType type : ContentType.all) {
                Fi folder = contentRoot.child(type.name().toLowerCase(Locale.ROOT) + "s");
                if (!folder.exists()) continue;
                for (Fi file : folder.findAll(f -> f.extension().equals("json") || f.extension().equals("hjson"))) {
                    runs.add(new LoadRun(type, file, mod));
                }
            }
        }
        runs.sort();
        for (LoadRun l : runs) {
            Content current = Vars.content.getLastAdded();
            try {
                Content loaded = this.parser.parse(l.mod, l.file.nameWithoutExtension(), l.file.readString("UTF-8"), l.file, l.type);
                Log.debug("[@] Loaded '@'.", l.mod.meta.name, loaded instanceof UnlockableContent ? ((UnlockableContent)loaded).localizedName : loaded);
            }
            catch (Throwable e) {
                if (current != Vars.content.getLastAdded() && Vars.content.getLastAdded() != null) {
                    this.parser.markError(Vars.content.getLastAdded(), l.mod, l.file, e);
                    continue;
                }
                ErrorContent error = new ErrorContent();
                this.parser.markError(error, l.mod, l.file, e);
            }
        }
        this.parser.finishParsing();
    }

    public void handleContentError(Content content, Throwable error) {
        this.parser.markError(content, error);
    }

    public Seq<String> getModStrings() {
        return this.mods.select(l -> !l.meta.hidden && l.enabled()).map(l -> l.name + ":" + l.meta.version);
    }

    public void setEnabled(LoadedMod mod, boolean enabled) {
        if (mod.enabled() != enabled) {
            Core.settings.put("mod-" + mod.name + "-enabled", enabled);
            this.requiresReload = true;
            mod.state = enabled ? ModState.enabled : ModState.disabled;
            this.mods.each(this::updateDependencies);
            this.sortMods();
        }
    }

    public Seq<String> getIncompatibility(Seq<String> out) {
        Seq<String> mods = this.getModStrings();
        Seq<String> result = mods.copy();
        for (String mod : mods) {
            if (!out.remove(mod)) continue;
            result.remove(mod);
        }
        return result;
    }

    public Seq<LoadedMod> list() {
        return this.mods;
    }

    public void eachClass(Cons<Mod> cons) {
        this.mods.each(p -> p.main != null, p -> this.contextRun((LoadedMod)p, () -> cons.get(p.main)));
    }

    public void eachEnabled(Cons<LoadedMod> cons) {
        this.mods.each(LoadedMod::enabled, cons);
    }

    public void contextRun(LoadedMod mod, Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error loading mod " + mod.meta.name, t);
        }
    }

    private LoadedMod loadMod(Fi sourceFile) throws Exception {
        return this.loadMod(sourceFile, false);
    }

    private LoadedMod loadMod(Fi sourceFile, boolean overwrite) throws Exception {
        Time.mark();
        ZipFi rootZip = null;
        try {
            int line;
            Mod mainMod;
            Fi metaf;
            Fi zip;
            Fi fi;
            if (sourceFile.isDirectory()) {
                fi = sourceFile;
            } else {
                rootZip = new ZipFi(sourceFile);
                fi = zip = rootZip;
            }
            if (zip.list().length == 1 && zip.list()[0].isDirectory()) {
                zip = zip.list()[0];
            }
            Fi fi2 = zip.child("mod.json").exists() ? zip.child("mod.json") : (zip.child("mod.hjson").exists() ? zip.child("mod.hjson") : (metaf = zip.child("plugin.json").exists() ? zip.child("plugin.json") : zip.child("plugin.hjson")));
            if (!metaf.exists()) {
                Log.warn("Mod @ doesn't have a '[mod/plugin].[h]json' file, skipping.", sourceFile);
                throw new IllegalArgumentException("Invalid file: No mod.json found.");
            }
            ModMeta meta = this.json.fromJson(ModMeta.class, Jval.read(metaf.readString()).toString(Jval.Jformat.plain));
            meta.cleanup();
            String camelized = meta.name.replace(" ", "");
            String mainClass = meta.main == null ? camelized.toLowerCase(Locale.ROOT) + "." + camelized + "Mod" : meta.main;
            String baseName = meta.name.toLowerCase(Locale.ROOT).replace(" ", "-");
            LoadedMod other = this.mods.find(m -> m.name.equals(baseName));
            if (other != null) {
                if (overwrite && !other.hasSteamID()) {
                    if (other.root instanceof ZipFi) {
                        other.root.delete();
                    }
                    if (other.file.isDirectory()) {
                        other.file.deleteDirectory();
                    } else {
                        other.file.delete();
                    }
                    this.mods.remove(other);
                } else {
                    throw new IllegalArgumentException("A mod with the name '" + baseName + "' is already imported.");
                }
            }
            ClassLoader loader = null;
            Fi mainFile = zip;
            if (Vars.android) {
                mainFile = mainFile.child("classes.dex");
            } else {
                String[] path;
                for (String str : path = (mainClass.replace('.', '/') + ".class").split("/")) {
                    if (str.isEmpty()) continue;
                    mainFile = mainFile.child(str);
                }
            }
            if ((mainFile.exists() || meta.java) && !this.skipModLoading() && Core.settings.getBool("mod-" + baseName + "-enabled", true) && Version.isAtLeast(meta.minGameVersion) && (meta.getMinMajor() >= 105 || Vars.headless)) {
                if (Vars.ios) {
                    throw new IllegalArgumentException("Java class mods are not supported on iOS.");
                }
                loader = Vars.platform.loadJar(sourceFile, mainClass);
                Class<?> main = Class.forName(mainClass, true, loader);
                this.metas.put(main, meta);
                mainMod = (Mod)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                mainMod = null;
            }
            if (mainMod instanceof Plugin) {
                meta.hidden = true;
            }
            if (meta.version != null && (line = meta.version.indexOf(10)) != -1) {
                meta.version = meta.version.substring(0, line);
            }
            if (this.skipModLoading()) {
                Core.settings.put("mod-" + baseName + "-enabled", false);
            }
            if (!Vars.headless) {
                Log.info("Loaded mod '@' in @ms", meta.name, Float.valueOf(Time.elapsed()));
            }
            return new LoadedMod(sourceFile, zip, mainMod, loader, meta);
        }
        catch (Exception e) {
            if (rootZip != null) {
                rootZip.delete();
            }
            throw e;
        }
    }

    public static class ModMeta {
        public String name;
        public String displayName;
        public String author;
        public String description;
        public String version;
        public String main;
        public String minGameVersion = "0";
        public String repo;
        public Seq<String> dependencies = Seq.with(new String[0]);
        public boolean hidden;
        public boolean java;

        public String displayName() {
            return this.displayName == null ? this.name : this.displayName;
        }

        public void cleanup() {
            if (this.displayName != null) {
                this.displayName = Strings.stripColors(this.displayName);
            }
            if (this.author != null) {
                this.author = Strings.stripColors(this.author);
            }
            if (this.description != null) {
                this.description = Strings.stripColors(this.description);
            }
        }

        public int getMinMajor() {
            String ver = this.minGameVersion == null ? "0" : this.minGameVersion;
            int dot = ver.indexOf(".");
            return dot != -1 ? Strings.parseInt(ver.substring(0, dot), 0) : Strings.parseInt(ver, 0);
        }

        public String toString() {
            return "ModMeta{name='" + this.name + '\'' + ", author='" + this.author + '\'' + ", version='" + this.version + '\'' + ", main='" + this.main + '\'' + ", minGameVersion='" + this.minGameVersion + '\'' + ", hidden=" + this.hidden + ", repo=" + this.repo + '}';
        }
    }

    public static class LoadedMod
    implements Publishable,
    Disposable {
        public final Fi file;
        public final Fi root;
        @Nullable
        public final Mod main;
        public final String name;
        public final ModMeta meta;
        public Seq<LoadedMod> dependencies = new Seq();
        public Seq<String> missingDependencies = new Seq();
        public Seq<Fi> scripts = new Seq();
        public ObjectSet<Content> erroredContent = new ObjectSet();
        public ModState state = ModState.enabled;
        @Nullable
        public Texture iconTexture;
        @Nullable
        public ClassLoader loader;

        public LoadedMod(Fi file, Fi root, Mod main, ClassLoader loader, ModMeta meta) {
            this.root = root;
            this.file = file;
            this.loader = loader;
            this.main = main;
            this.meta = meta;
            this.name = meta.name.toLowerCase(Locale.ROOT).replace(" ", "-");
        }

        public boolean isJava() {
            return this.meta.java || this.main != null;
        }

        @Nullable
        public String getRepo() {
            return Core.settings.getString("mod-" + this.name + "-repo", this.meta.repo);
        }

        public void setRepo(String repo) {
            Core.settings.put("mod-" + this.name + "-repo", repo);
        }

        public boolean enabled() {
            return this.state == ModState.enabled || this.state == ModState.contentErrors;
        }

        public boolean shouldBeEnabled() {
            return Core.settings.getBool("mod-" + this.name + "-enabled", true);
        }

        public boolean hasUnmetDependencies() {
            return !this.missingDependencies.isEmpty();
        }

        public boolean hasContentErrors() {
            return !this.erroredContent.isEmpty();
        }

        public boolean isSupported() {
            if (this.isOutdated()) {
                return false;
            }
            return Version.isAtLeast(this.meta.minGameVersion);
        }

        public boolean isOutdated() {
            return this.getMinMajor() < 105;
        }

        public int getMinMajor() {
            return this.meta.getMinMajor();
        }

        @Override
        public void dispose() {
            if (this.iconTexture != null) {
                this.iconTexture.dispose();
                this.iconTexture = null;
            }
        }

        @Override
        public String getSteamID() {
            return Core.settings.getString(this.name + "-steamid", null);
        }

        @Override
        public void addSteamID(String id) {
            Core.settings.put(this.name + "-steamid", id);
        }

        @Override
        public void removeSteamID() {
            Core.settings.remove(this.name + "-steamid");
        }

        @Override
        public String steamTitle() {
            return this.meta.name;
        }

        @Override
        public String steamDescription() {
            return this.meta.description;
        }

        @Override
        public String steamTag() {
            return "mod";
        }

        @Override
        public Fi createSteamFolder(String id) {
            return this.file;
        }

        @Override
        public Fi createSteamPreview(String id) {
            return this.file.child("preview.png");
        }

        @Override
        public boolean prePublish() {
            if (!this.file.isDirectory()) {
                Vars.ui.showErrorMessage("@mod.folder.missing");
                return false;
            }
            if (!this.file.child("preview.png").exists()) {
                Vars.ui.showErrorMessage("@mod.preview.missing");
                return false;
            }
            return true;
        }

        public String toString() {
            return "LoadedMod{file=" + this.file + ", root=" + this.root + ", name='" + this.name + '\'' + '}';
        }
    }

    public static enum ModState {
        enabled,
        contentErrors,
        missingDependencies,
        unsupported,
        disabled;

    }
}

