/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.assets.AssetDescriptor;
import arc.assets.loaders.MusicLoader;
import arc.assets.loaders.SoundLoader;
import arc.audio.Music;
import arc.audio.Sound;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.struct.Seq;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Time;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mindustry.Vars;
import mindustry.mod.Mods;
import rhino.Context;
import rhino.ImporterTopLevel;
import rhino.NativeJavaObject;
import rhino.Scriptable;
import rhino.Undefined;
import rhino.module.RequireBuilder;
import rhino.module.provider.ModuleSource;
import rhino.module.provider.SoftCachingModuleScriptProvider;
import rhino.module.provider.UrlModuleSourceProvider;

public class Scripts
implements Disposable {
    private static final Seq<String> blacklist = Seq.with(".net.", "java.net", "files", "reflect", "javax", "rhino", "file", "channels", "jdk", "runtime", "util.os", "rmi", "security", "org.", "sun.", "beans", "sql", "http", "exec", "compiler", "process", "system", ".awt", "socket", "classloader", "oracle", "invoke", "java.util.function", "java.util.stream", "org.", "mod.classmap");
    private static final Seq<String> whitelist = Seq.with("mindustry.net", "netserver", "netclient", "com.sun.proxy.$proxy", "jdk.proxy1", "mindustry.gen.", "mindustry.logic.", "mindustry.async.", "saveio", "systemcursor", "filetreeinitevent");
    private final Context context;
    private final Scriptable scope;
    private boolean errored;
    Mods.LoadedMod currentMod = null;

    public static boolean allowClass(String type) {
        return !blacklist.contains((String)((Object)((Boolf<String>)t -> type.toLowerCase(Locale.ROOT).contains((CharSequence)t)))) || whitelist.contains((String)((Object)((Boolf<String>)t -> type.toLowerCase(Locale.ROOT).contains((CharSequence)t))));
    }

    public Scripts() {
        Time.mark();
        this.context = Vars.platform.getScriptContext();
        this.context.setClassShutter(Scripts::allowClass);
        this.context.getWrapFactory().setJavaPrimitiveWrap(false);
        this.context.setLanguageVersion(200);
        this.scope = new ImporterTopLevel(this.context);
        new RequireBuilder().setModuleScriptProvider(new SoftCachingModuleScriptProvider(new ScriptModuleProvider())).setSandboxed(true).createRequire(this.context, this.scope).install(this.scope);
        if (!this.run(Core.files.internal("scripts/global.js").readString(), "global.js", false)) {
            this.errored = true;
        }
        Log.debug("Time to load script engine: @", Float.valueOf(Time.elapsed()));
    }

    public boolean hasErrored() {
        return this.errored;
    }

    public String runConsole(String text) {
        try {
            NativeJavaObject n;
            Object o;
            Object object = o = this.context.evaluateString(this.scope, text, "console.js", 1, null);
            if (object instanceof NativeJavaObject && (n = (NativeJavaObject)object) == (NativeJavaObject)object) {
                o = n.unwrap();
            }
            if (o instanceof Undefined) {
                o = "undefined";
            }
            return String.valueOf(o);
        }
        catch (Throwable t) {
            return this.getError(t, false);
        }
    }

    private String getError(Throwable t, boolean log) {
        if (log) {
            Log.err(t);
        }
        return t.getClass().getSimpleName() + (t.getMessage() == null ? "" : ": " + t.getMessage());
    }

    public void log(String source, String message) {
        this.log(Log.LogLevel.info, source, message);
    }

    public void log(Log.LogLevel level, String source, String message) {
        Log.log(level, "[@]: @", source, message);
    }

    public float[] newFloats(int capacity) {
        return new float[capacity];
    }

    public String readString(String path) {
        return Vars.tree.get(path, true).readString();
    }

    public byte[] readBytes(String path) {
        return Vars.tree.get(path, true).readBytes();
    }

    public Sound loadSound(String soundName) {
        if (Vars.headless) {
            return new Sound();
        }
        String name = "sounds/" + soundName;
        String path = Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
        Sound sound = new Sound();
        AssetDescriptor desc = Core.assets.load(path, Sound.class, new SoundLoader.SoundParameter(sound));
        desc.errored = Throwable::printStackTrace;
        return sound;
    }

    public Music loadMusic(String soundName) {
        if (Vars.headless) {
            return new Music();
        }
        String name = "music/" + soundName;
        String path = Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
        Music music = new Music();
        AssetDescriptor desc = Core.assets.load(path, Music.class, new MusicLoader.MusicParameter(music));
        desc.errored = Throwable::printStackTrace;
        return music;
    }

    public void readFile(String purpose, String ext, Cons<String> cons) {
        this.selectFile(true, purpose, ext, fi -> cons.get(fi.readString()));
    }

    public void readBinFile(String purpose, String ext, Cons<byte[]> cons) {
        this.selectFile(true, purpose, ext, fi -> cons.get(fi.readBytes()));
    }

    public void writeFile(String purpose, String ext, String contents) {
        if (contents == null) {
            contents = "";
        }
        String fContents = contents;
        this.selectFile(false, purpose, ext, fi -> fi.writeString(fContents));
    }

    public void writeBinFile(String purpose, String ext, byte[] contents) {
        if (contents == null) {
            contents = new byte[]{};
        }
        byte[] fContents = contents;
        this.selectFile(false, purpose, ext, fi -> fi.writeBytes(fContents));
    }

    private void selectFile(boolean open, String purpose, String ext, Cons<Fi> cons) {
        purpose = purpose.startsWith("@") ? Core.bundle.get(purpose.substring(1)) : purpose;
        String title = Core.bundle.get(open ? "open" : "save") + " - " + purpose + " (." + ext + ")";
        Vars.platform.showFileChooser(open, title, ext, fi -> {
            try {
                cons.get((Fi)fi);
            }
            catch (Exception e) {
                Log.err("Failed to select file '@' for a mod", fi);
                Log.err(e);
            }
        });
    }

    public void run(Mods.LoadedMod mod, Fi file) {
        this.currentMod = mod;
        this.run(file.readString(), file.name(), true);
        this.currentMod = null;
    }

    private boolean run(String script, String file, boolean wrap) {
        try {
            if (this.currentMod != null) {
                this.context.evaluateString(this.scope, "modName = \"" + this.currentMod.name + "\"\nscriptName = \"" + file + "\"", "initscript.js", 1, null);
            }
            this.context.evaluateString(this.scope, wrap ? "(function(){'use strict';\n" + script + "\n})();" : script, file, 0, null);
            return true;
        }
        catch (Throwable t) {
            if (this.currentMod != null) {
                file = this.currentMod.name + "/" + file;
            }
            this.log(Log.LogLevel.err, file, "" + this.getError(t, true));
            return false;
        }
    }

    @Override
    public void dispose() {
        Context.exit();
    }

    private class ScriptModuleProvider
    extends UrlModuleSourceProvider {
        private Pattern directory;

        public ScriptModuleProvider() {
            super(null, null);
            this.directory = Pattern.compile("^(.+?)/(.+)");
        }

        @Override
        public ModuleSource loadSource(String moduleId, Scriptable paths, Object validator) throws URISyntaxException {
            if (Scripts.this.currentMod == null) {
                return null;
            }
            return this.loadSource(moduleId, Scripts.this.currentMod.root.child("scripts"), validator);
        }

        private ModuleSource loadSource(String moduleId, Fi root, Object validator) throws URISyntaxException {
            Matcher matched = this.directory.matcher(moduleId);
            if (matched.find()) {
                Mods.LoadedMod required = Vars.mods.locateMod(matched.group(1));
                String script = matched.group(2);
                if (required == null) {
                    Fi dir = root.child(matched.group(1));
                    if (!dir.exists()) {
                        return null;
                    }
                    return this.loadSource(script, dir, validator);
                }
                Scripts.this.currentMod = required;
                return this.loadSource(script, required.root.child("scripts"), validator);
            }
            Fi module = root.child(moduleId + ".js");
            if (!module.exists() || module.isDirectory()) {
                return null;
            }
            return new ModuleSource(new InputStreamReader(new ByteArrayInputStream(module.readString().getBytes())), null, new URI(moduleId), root.file().toURI(), validator);
        }
    }
}

