/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Ratekeeper;
import arc.util.Strings;
import arc.util.Time;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Administration {
    public Seq<String> bannedIPs = new Seq();
    public Seq<String> whitelist = new Seq();
    public Seq<ChatFilter> chatFilters = new Seq();
    public Seq<ActionFilter> actionFilters = new Seq();
    public Seq<String> subnetBans = new Seq();
    public ObjectMap<String, Long> kickedIPs = new ObjectMap();
    private ObjectMap<String, PlayerInfo> playerInfo = new ObjectMap();

    public Administration() {
        this.load();
        this.addChatFilter((player, message) -> {
            long resetTime = Config.messageRateLimit.num() * 1000;
            if (Config.antiSpam.bool() && !player.isLocal() && !player.admin) {
                if (resetTime > 0L && Time.timeSinceMillis(player.getInfo().lastMessageTime) < resetTime) {
                    player.sendMessage("[scarlet]You may only send messages every " + Config.messageRateLimit.num() + " seconds.");
                    ++player.getInfo().messageInfractions;
                    if (player.getInfo().messageInfractions >= Config.messageSpamKick.num() && Config.messageSpamKick.num() != 0) {
                        player.con.kick("You have been kicked for spamming.", 120000L);
                    }
                    return null;
                }
                player.getInfo().messageInfractions = 0;
                if (message.equals(player.getInfo().lastSentMessage) && Time.timeSinceMillis(player.getInfo().lastMessageTime) < 50000L) {
                    player.sendMessage("[scarlet]You may not send the same message twice.");
                    return null;
                }
                player.getInfo().lastSentMessage = message;
                player.getInfo().lastMessageTime = Time.millis();
            }
            return message;
        });
        this.addActionFilter(action -> {
            if (action.type != ActionType.breakBlock && action.type != ActionType.placeBlock && Config.antiSpam.bool()) {
                Ratekeeper rate = action.player.getInfo().rate;
                if (rate.allow(Config.interactRateWindow.num() * 1000, Config.interactRateLimit.num())) {
                    return true;
                }
                if (rate.occurences > Config.interactRateKick.num()) {
                    action.player.kick("You are interacting with too many blocks.", 30000L);
                } else if (action.player.getInfo().messageTimer.get(120.0f)) {
                    action.player.sendMessage("[scarlet]You are interacting with blocks too quickly.");
                }
                return false;
            }
            return true;
        });
    }

    public long getKickTime(String uuid, String ip) {
        return Math.max(this.getInfo((String)uuid).lastKicked, this.kickedIPs.get(ip, 0L));
    }

    public void handleKicked(String uuid, String ip, long duration) {
        this.kickedIPs.put(ip, Math.max(this.kickedIPs.get(ip, 0L), Time.millis() + duration));
        PlayerInfo info = this.getInfo(uuid);
        ++info.timesKicked;
        info.lastKicked = Math.max(Time.millis() + duration, info.lastKicked);
    }

    public Seq<String> getSubnetBans() {
        return this.subnetBans;
    }

    public void removeSubnetBan(String ip) {
        this.subnetBans.remove(ip);
        this.save();
    }

    public void addSubnetBan(String ip) {
        this.subnetBans.add(ip);
        this.save();
    }

    public boolean isSubnetBanned(String ip) {
        return this.subnetBans.contains((String)((Object)((Boolf<String>)ip::startsWith)));
    }

    public void addChatFilter(ChatFilter filter) {
        this.chatFilters.add(filter);
    }

    @Nullable
    public String filterMessage(Player player, String message) {
        String current = message;
        for (ChatFilter f : this.chatFilters) {
            current = f.filter(player, current);
            if (current != null) continue;
            return null;
        }
        return current;
    }

    public void addActionFilter(ActionFilter filter) {
        this.actionFilters.add(filter);
    }

    public boolean allowAction(Player player, ActionType type, Tile tile, Cons<PlayerAction> setter) {
        return this.allowAction(player, type, action -> setter.get(action.set(player, type, tile)));
    }

    public boolean allowAction(Player player, ActionType type, Cons<PlayerAction> setter) {
        if (player == null) {
            return true;
        }
        PlayerAction act = Pools.obtain(PlayerAction.class, PlayerAction::new);
        act.player = player;
        act.type = type;
        setter.get(act);
        for (ActionFilter filter : this.actionFilters) {
            if (filter.allow(act)) continue;
            Pools.free(act);
            return false;
        }
        Pools.free(act);
        return true;
    }

    public int getPlayerLimit() {
        return Core.settings.getInt("playerlimit", 0);
    }

    public void setPlayerLimit(int limit) {
        Core.settings.put("playerlimit", limit);
    }

    public boolean isStrict() {
        return Config.strict.bool();
    }

    public boolean allowsCustomClients() {
        return Config.allowCustomClients.bool();
    }

    public void updatePlayerJoined(String id, String ip, String name) {
        PlayerInfo info = this.getCreateInfo(id);
        info.lastName = name;
        info.lastIP = ip;
        ++info.timesJoined;
        if (!info.names.contains(name, false)) {
            info.names.add(name);
        }
        if (!info.ips.contains(ip, false)) {
            info.ips.add(ip);
        }
    }

    public boolean banPlayer(String uuid) {
        return this.banPlayerID(uuid) || this.banPlayerIP(this.getInfo((String)uuid).lastIP);
    }

    public boolean banPlayerIP(String ip) {
        if (this.bannedIPs.contains(ip, false)) {
            return false;
        }
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            info.banned = true;
        }
        this.bannedIPs.add(ip);
        this.save();
        Events.fire(new EventType.PlayerIpBanEvent(ip));
        return true;
    }

    public boolean banPlayerID(String id) {
        if (this.playerInfo.containsKey(id) && this.playerInfo.get((String)id).banned) {
            return false;
        }
        this.getCreateInfo((String)id).banned = true;
        this.save();
        Events.fire(new EventType.PlayerBanEvent(Groups.player.find(p -> id.equals(p.uuid())), id));
        return true;
    }

    public boolean unbanPlayerIP(String ip) {
        boolean found = this.bannedIPs.contains(ip, false);
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            info.banned = false;
            found = true;
        }
        this.bannedIPs.remove(ip, false);
        if (found) {
            this.save();
            Events.fire(new EventType.PlayerIpUnbanEvent(ip));
        }
        return found;
    }

    public boolean unbanPlayerID(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (!info.banned) {
            return false;
        }
        info.banned = false;
        this.bannedIPs.removeAll(info.ips, false);
        this.save();
        Events.fire(new EventType.PlayerUnbanEvent(Groups.player.find(p -> id.equals(p.uuid())), id));
        return true;
    }

    public Seq<PlayerInfo> getAdmins() {
        Seq<PlayerInfo> result = new Seq<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.admin) continue;
            result.add(info);
        }
        return result;
    }

    public Seq<PlayerInfo> getBanned() {
        Seq<PlayerInfo> result = new Seq<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.banned) continue;
            result.add(info);
        }
        return result;
    }

    public Seq<String> getBannedIPs() {
        return this.bannedIPs;
    }

    public boolean adminPlayer(String id, String usid) {
        PlayerInfo info = this.getCreateInfo(id);
        info.adminUsid = usid;
        info.admin = true;
        this.save();
        return true;
    }

    public boolean unAdminPlayer(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (!info.admin) {
            return false;
        }
        info.admin = false;
        this.save();
        return true;
    }

    public boolean isWhitelistEnabled() {
        return Config.whitelist.bool();
    }

    public boolean isWhitelisted(String id, String usid) {
        return !this.isWhitelistEnabled() || this.whitelist.contains(usid + id);
    }

    public boolean whitelist(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (this.whitelist.contains(info.adminUsid + id)) {
            return false;
        }
        this.whitelist.add(info.adminUsid + id);
        this.save();
        return true;
    }

    public boolean unwhitelist(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (this.whitelist.contains(info.adminUsid + id)) {
            this.whitelist.remove(info.adminUsid + id);
            this.save();
            return true;
        }
        return false;
    }

    public boolean isIPBanned(String ip) {
        return this.bannedIPs.contains(ip, false) || this.findByIP(ip) != null && this.findByIP((String)ip).banned;
    }

    public boolean isIDBanned(String uuid) {
        return this.getCreateInfo((String)uuid).banned;
    }

    public boolean isAdmin(String id, String usid) {
        PlayerInfo info = this.getCreateInfo(id);
        return info.admin && usid.equals(info.adminUsid);
    }

    public ObjectSet<PlayerInfo> findByName(String name) {
        ObjectSet<PlayerInfo> result = new ObjectSet<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.lastName.equalsIgnoreCase(name) && !info.names.contains(name, false) && !Strings.stripColors(Strings.stripColors(info.lastName)).equals(name) && !info.ips.contains(name, false) && !info.id.equals(name)) continue;
            result.add(info);
        }
        return result;
    }

    public ObjectSet<PlayerInfo> searchNames(String name) {
        ObjectSet<PlayerInfo> result = new ObjectSet<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.names.contains((String)((Object)((Boolf<String>)n -> n.toLowerCase().contains(name.toLowerCase()) || Strings.stripColors(n).trim().toLowerCase().contains(name))))) continue;
            result.add(info);
        }
        return result;
    }

    public Seq<PlayerInfo> findByIPs(String ip) {
        Seq<PlayerInfo> result = new Seq<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            result.add(info);
        }
        return result;
    }

    public PlayerInfo getInfo(String id) {
        return this.getCreateInfo(id);
    }

    public PlayerInfo getInfoOptional(String id) {
        return this.playerInfo.get(id);
    }

    public PlayerInfo findByIP(String ip) {
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            return info;
        }
        return null;
    }

    public Seq<PlayerInfo> getWhitelisted() {
        return this.playerInfo.values().toSeq().select(p -> this.isWhitelisted(p.id, p.adminUsid));
    }

    private PlayerInfo getCreateInfo(String id) {
        if (this.playerInfo.containsKey(id)) {
            return this.playerInfo.get(id);
        }
        PlayerInfo info = new PlayerInfo(id);
        this.playerInfo.put(id, info);
        this.save();
        return info;
    }

    public void save() {
        Core.settings.putJson("player-data", this.playerInfo);
        Core.settings.putJson("ip-bans", String.class, this.bannedIPs);
        Core.settings.putJson("whitelist-ids", String.class, this.whitelist);
        Core.settings.putJson("banned-subnets", String.class, this.subnetBans);
    }

    private void load() {
        this.playerInfo = Core.settings.getJson("player-data", ObjectMap.class, ObjectMap::new);
        this.bannedIPs = Core.settings.getJson("ip-bans", Seq.class, Seq::new);
        this.whitelist = Core.settings.getJson("whitelist-ids", Seq.class, Seq::new);
        this.subnetBans = Core.settings.getJson("banned-subnets", Seq.class, Seq::new);
    }

    public static interface ChatFilter {
        @Nullable
        public String filter(Player var1, String var2);
    }

    public static interface ActionFilter {
        public boolean allow(PlayerAction var1);
    }

    public static class PlayerInfo {
        public String id;
        public String lastName = "<unknown>";
        public String lastIP = "<unknown>";
        public Seq<String> ips = new Seq();
        public Seq<String> names = new Seq();
        public String adminUsid;
        public int timesKicked;
        public int timesJoined;
        public boolean banned;
        public boolean admin;
        public long lastKicked;
        public transient long lastMessageTime;
        public transient long lastSyncTime;
        public transient String lastSentMessage;
        public transient int messageInfractions;
        public transient Ratekeeper rate = new Ratekeeper();
        public transient Interval messageTimer = new Interval();

        PlayerInfo(String id) {
            this.id = id;
        }

        public PlayerInfo() {
        }
    }

    public static enum ActionType {
        breakBlock,
        placeBlock,
        rotate,
        configure,
        withdrawItem,
        depositItem,
        control,
        command;

    }

    public static class PlayerAction
    implements Pool.Poolable {
        public Player player;
        public ActionType type;
        @Nullable
        public Tile tile;
        @Nullable
        public Block block;
        public int rotation;
        public Object config;
        @Nullable
        public Item item;
        public int itemAmount;
        @Nullable
        public Unit unit;

        public PlayerAction set(Player player, ActionType type, Tile tile) {
            this.player = player;
            this.type = type;
            this.tile = tile;
            return this;
        }

        public PlayerAction set(Player player, ActionType type, Unit unit) {
            this.player = player;
            this.type = type;
            this.unit = unit;
            return this;
        }

        @Override
        public void reset() {
            this.item = null;
            this.itemAmount = 0;
            this.config = null;
            this.player = null;
            this.type = null;
            this.tile = null;
            this.block = null;
            this.unit = null;
        }
    }

    public static enum Config {
        name("The server name as displayed on clients.", (Object)"Server", "servername"),
        desc("The server description, displayed under the name. Max 100 characters.", "off"),
        port("The port to host on.", 6567),
        autoUpdate("Whether to auto-update and exit when a new bleeding-edge update arrives.", false),
        showConnectMessages("Whether to display connect/disconnect messages.", true),
        enableVotekick("Whether votekick is enabled.", true),
        startCommands("Commands run at startup. This should be a comma-separated list.", ""),
        crashReport("Whether to send crash reports.", (Object)false, "crashreport"),
        logging("Whether to log everything to files.", true),
        strict("Whether strict mode is on - corrects positions and prevents duplicate UUIDs.", true),
        antiSpam("Whether spammers are automatically kicked and rate-limited.", Vars.headless),
        interactRateWindow("Block interaction rate limit window, in seconds.", 6),
        interactRateLimit("Block interaction rate limit.", 25),
        interactRateKick("How many times a player must interact inside the window to get kicked.", 60),
        messageRateLimit("Message rate limit in seconds. 0 to disable.", 0),
        messageSpamKick("How many times a player must send a message before the cooldown to get kicked. 0 to disable.", 3),
        socketInput("Allows a local application to control this server through a local TCP socket.", false, "socket", () -> Events.fire(EventType.Trigger.socketConfigChanged)),
        socketInputPort("The port for socket input.", (Object)6859, () -> Events.fire(EventType.Trigger.socketConfigChanged)),
        socketInputAddress("The bind address for socket input.", (Object)"localhost", () -> Events.fire(EventType.Trigger.socketConfigChanged)),
        allowCustomClients("Whether custom clients are allowed to connect.", (Object)(!Vars.headless ? 1 : 0), "allow-custom"),
        whitelist("Whether the whitelist is used.", false),
        motd("The message displayed to people on connection.", "off"),
        autosave("Whether the periodically save the map when playing.", false),
        autosaveAmount("The maximum amount of autosaves. Older ones get replaced.", 10),
        autosaveSpacing("Spacing between autosaves in seconds.", 300),
        debug("Enable debug logging", (Object)false, () -> {
            Log.level = Config.debug() ? Log.LogLevel.debug : Log.LogLevel.info;
        });

        public static final Config[] all;
        public final Object defaultValue;
        public final String key;
        public final String description;
        final Runnable changed;

        private Config(String description, Object def) {
            this(description, def, null, null);
        }

        private Config(String description, Object def, String key) {
            this(description, def, key, null);
        }

        private Config(String description, Object def, Runnable changed) {
            this(description, def, null, changed);
        }

        private Config(String description, Object def, String key, Runnable changed) {
            this.description = description;
            this.key = key == null ? this.name() : key;
            this.defaultValue = def;
            this.changed = changed == null ? () -> {} : changed;
        }

        public boolean isNum() {
            return this.defaultValue instanceof Integer;
        }

        public boolean isBool() {
            return this.defaultValue instanceof Boolean;
        }

        public boolean isString() {
            return this.defaultValue instanceof String;
        }

        public Object get() {
            return Core.settings.get(this.key, this.defaultValue);
        }

        public boolean bool() {
            return Core.settings.getBool(this.key, (Boolean)this.defaultValue);
        }

        public int num() {
            return Core.settings.getInt(this.key, (Integer)this.defaultValue);
        }

        public String string() {
            return Core.settings.getString(this.key, (String)this.defaultValue);
        }

        public void set(Object value) {
            Core.settings.put(this.key, value);
            this.changed.run();
        }

        private static boolean debug() {
            return debug.bool();
        }

        static {
            all = Config.values();
        }
    }

    public static class TraceInfo {
        public String ip;
        public String uuid;
        public boolean modded;
        public boolean mobile;
        public int timesJoined;
        public int timesKicked;

        public TraceInfo(String ip, String uuid, boolean modded, boolean mobile, int timesJoined, int timesKicked) {
            this.ip = ip;
            this.uuid = uuid;
            this.modded = modded;
            this.mobile = mobile;
            this.timesJoined = timesJoined;
            this.timesKicked = timesKicked;
        }
    }
}

