/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.Net;
import arc.files.Fi;
import arc.func.Boolc;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Intc;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Timer;
import arc.util.async.AsyncExecutor;
import arc.util.async.Threads;
import arc.util.serialization.Jval;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.io.SaveIO;
import mindustry.net.Administration;
import mindustry.net.Packets;
import mindustry.ui.Bar;
import mindustry.ui.dialogs.BaseDialog;

public class BeControl {
    private static final int updateInterval = 60;
    private AsyncExecutor executor = new AsyncExecutor(1);
    private boolean checkUpdates = true;
    private boolean updateAvailable;
    private String updateUrl;
    private int updateBuild;

    public boolean active() {
        return Version.type.equals("bleeding-edge");
    }

    public BeControl() {
        if (this.active()) {
            Timer.schedule(() -> {
                if (this.checkUpdates && !Vars.mobile) {
                    this.checkUpdate(t -> {});
                }
            }, 60.0f, 60.0f);
        }
        if (OS.hasProp("becopy")) {
            try {
                Fi dest = Fi.get(OS.prop("becopy"));
                Fi self = Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                for (Fi file : self.parent().findAll(f -> !f.equals(self))) {
                    file.delete();
                }
                self.copyTo(dest);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void checkUpdate(Boolc done) {
        Core.net.httpGet("https://api.github.com/repos/Anuken/MindustryBuilds/releases/latest", res -> {
            if (res.getStatus() == Net.HttpStatus.OK) {
                Jval val = Jval.read(res.getResultAsString());
                int newBuild = Strings.parseInt(val.getString("tag_name", "0"));
                if (newBuild > Version.build) {
                    Jval asset = val.get("assets").asArray().find(v -> v.getString("name", "").startsWith(Vars.headless ? "Mindustry-BE-Server" : "Mindustry-BE-Desktop"));
                    String url = asset.getString("browser_download_url", "");
                    this.updateAvailable = true;
                    this.updateBuild = newBuild;
                    this.updateUrl = url;
                    Core.app.post(() -> {
                        this.showUpdateDialog();
                        done.get(true);
                    });
                } else {
                    Core.app.post(() -> done.get(false));
                }
            } else {
                Core.app.post(() -> done.get(false));
            }
        }, error -> {});
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public void showUpdateDialog() {
        if (!this.updateAvailable) {
            return;
        }
        if (!Vars.headless) {
            this.checkUpdates = false;
            Vars.ui.showCustomConfirm(Core.bundle.format("be.update", "") + " " + this.updateBuild, "@be.update.confirm", "@ok", "@be.ignore", () -> {
                try {
                    boolean[] cancel = new boolean[]{false};
                    float[] progress = new float[]{0.0f};
                    int[] length = new int[]{0};
                    Fi file = Vars.bebuildDirectory.child("client-be-" + this.updateBuild + ".jar");
                    Fi fileDest = OS.hasProp("becopy") ? Fi.get(OS.prop("becopy")) : Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    BaseDialog dialog = new BaseDialog("@be.updating");
                    this.download(this.updateUrl, file, i -> {
                        length[0] = i;
                    }, v -> {
                        progress[0] = v;
                    }, () -> cancel[0], () -> {
                        try {
                            String[] stringArray;
                            Runtime runtime = Runtime.getRuntime();
                            if (OS.isMac) {
                                String[] stringArray2 = new String[7];
                                stringArray2[0] = "java";
                                stringArray2[1] = "-XstartOnFirstThread";
                                stringArray2[2] = "-DlastBuild=" + Version.build;
                                stringArray2[3] = "-Dberestart";
                                stringArray2[4] = "-Dbecopy=" + fileDest.absolutePath();
                                stringArray2[5] = "-jar";
                                stringArray = stringArray2;
                                stringArray2[6] = file.absolutePath();
                            } else {
                                String[] stringArray3 = new String[6];
                                stringArray3[0] = "java";
                                stringArray3[1] = "-DlastBuild=" + Version.build;
                                stringArray3[2] = "-Dberestart";
                                stringArray3[3] = "-Dbecopy=" + fileDest.absolutePath();
                                stringArray3[4] = "-jar";
                                stringArray = stringArray3;
                                stringArray3[5] = file.absolutePath();
                            }
                            runtime.exec(stringArray);
                            System.exit(0);
                        }
                        catch (IOException e) {
                            Vars.ui.showException(e);
                        }
                    }, e -> {
                        dialog.hide();
                        Vars.ui.showException((Throwable)e);
                    });
                    dialog.cont.add(new Bar(() -> length[0] == 0 ? Core.bundle.get("be.updating") : (int)(progress[0] * (float)length[0]) / 1024 / 1024 + "/" + length[0] / 1024 / 1024 + " MB", () -> Pal.accent, () -> progress[0])).width(400.0f).height(70.0f);
                    dialog.buttons.button("@cancel", Icon.cancel, () -> {
                        cancel[0] = true;
                        dialog.hide();
                    }).size(210.0f, 64.0f);
                    dialog.setFillParent(false);
                    dialog.show();
                }
                catch (Exception e2) {
                    Vars.ui.showException(e2);
                }
            }, () -> {
                this.checkUpdates = false;
            });
        } else {
            Log.info("&lcA new update is available: &lyBleeding Edge build @", this.updateBuild);
            if (Administration.Config.autoUpdate.bool()) {
                Log.info("&lcAuto-downloading next version...");
                try {
                    Fi source = Fi.get(BeControl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    Fi dest = source.sibling("server-be-" + this.updateBuild + ".jar");
                    this.download(this.updateUrl, dest, len -> Core.app.post(() -> Log.info("&ly| Size: @ MB.", Strings.fixed((float)len / 1024.0f / 1024.0f, 2))), progress -> {}, () -> false, () -> Core.app.post(() -> {
                        Log.info("&lcSaving...");
                        SaveIO.save(Vars.saveDirectory.child("autosavebe.msav"));
                        Log.info("&lcAutosaved.");
                        Vars.netServer.kickAll(Packets.KickReason.serverRestarting);
                        Threads.sleep(32L);
                        Log.info("&lcVersion downloaded, exiting. Note that if you are not using a auto-restart script, the server will not restart automatically.");
                        dest.copyTo(source);
                        dest.delete();
                        System.exit(2);
                    }), Throwable::printStackTrace);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.checkUpdates = false;
        }
    }

    private void download(String furl, Fi dest, Intc length, Floatc progressor, Boolp canceled, Runnable done, Cons<Throwable> error) {
        this.executor.submit(() -> {
            try {
                int x;
                HttpURLConnection con = (HttpURLConnection)new URL(furl).openConnection();
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                OutputStream out = dest.write(false, 4096);
                byte[] data = new byte[4096];
                long size = con.getContentLength();
                long counter = 0L;
                length.get((int)size);
                while ((x = in.read(data, 0, data.length)) >= 0 && !canceled.get()) {
                    progressor.get((float)(counter += (long)x) / (float)size);
                    out.write(data, 0, x);
                }
                out.close();
                in.close();
                if (!canceled.get()) {
                    done.run();
                }
            }
            catch (Throwable e) {
                error.get(e);
            }
        });
    }
}

