/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.Net;
import arc.files.Fi;
import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.NetJavaImpl;
import arc.util.OS;
import arc.util.Strings;
import arc.util.io.PropertiesUtils;
import arc.util.serialization.JsonValue;
import arc.util.serialization.JsonWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.gen.Groups;

public class CrashSender {
    public static String createReport(String error) {
        String report = "Mindustry has crashed. How unfortunate.\n";
        if (Vars.mods.list().size == 0 && Version.build != -1) {
            report = report + "Report this at https://github.com/Anuken/Mindustry/issues/new?labels=bug&template=bug_report.md\n\n";
        }
        return report + "Version: " + Version.combined() + (Vars.headless ? " (Server)" : "") + "\nOS: " + System.getProperty("os.name") + " x" + (OS.is64Bit ? "64" : "32") + "\nJava Version: " + System.getProperty("java.version") + "\nJava Architecture: " + System.getProperty("sun.arch.data.model") + "\n" + Vars.mods.list().size + " Mods" + (Vars.mods.list().isEmpty() ? "" : ": " + Vars.mods.list().toString(", ", mod -> mod.name + ":" + mod.meta.version)) + "\n\n" + error;
    }

    public static void log(Throwable exception) {
        try {
            Core.settings.getDataDirectory().child("crashes").child("crash_" + System.currentTimeMillis() + ".txt").writeString(CrashSender.createReport(Strings.neatError(exception)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void send(Throwable exception, Cons<File> writeListener) {
        try {
            try {
                Log.err(exception);
            }
            catch (Throwable no) {
                exception.printStackTrace();
            }
            try {
                Core.settings.manualSave();
            }
            catch (Throwable no) {
                // empty catch block
            }
            if (Version.build == -1 || System.getProperty("user.name").equals("anuke") && "release".equals(Version.modifier)) {
                CrashSender.ret();
            }
            if (Version.number == 0) {
                try {
                    ObjectMap<String, String> map = new ObjectMap<String, String>();
                    PropertiesUtils.load(map, new InputStreamReader(CrashSender.class.getResourceAsStream("/version.properties")));
                    Version.type = map.get("type");
                    Version.number = Integer.parseInt(map.get("number"));
                    Version.modifier = map.get("modifier");
                    if (map.get("build").contains(".")) {
                        String[] split = map.get("build").split("\\.");
                        Version.build = Integer.parseInt(split[0]);
                        Version.revision = Integer.parseInt(split[1]);
                    } else {
                        Version.build = Strings.canParseInt(map.get("build")) ? Integer.parseInt(map.get("build")) : -1;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Log.err("Failed to parse version.", new Object[0]);
                }
            }
            try {
                File file = new File(OS.getAppDataDirectoryString("Mindustry"), "crashes/crash-report-" + new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss").format(new Date()) + ".txt");
                new Fi(OS.getAppDataDirectoryString("Mindustry")).child("crashes").mkdirs();
                new Fi(file).writeString(CrashSender.createReport(CrashSender.parseException(exception)));
                writeListener.get(file);
            }
            catch (Throwable e) {
                Log.err("Failed to save local crash report.", e);
            }
            try {
                if (!Core.settings.getBool("crashreport", true)) {
                    CrashSender.ret();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (Vars.mods != null && !Vars.mods.list().isEmpty()) {
                    CrashSender.ret();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (Version.number == 0) {
                CrashSender.ret();
            }
            boolean netActive = false;
            boolean netServer = false;
            try {
                netActive = Vars.net.active();
                netServer = Vars.net.server();
                Vars.net.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JsonValue value = new JsonValue(JsonValue.ValueType.object);
            boolean fn = netActive;
            boolean fs = netServer;
            CrashSender.ex(() -> value.addChild("versionType", new JsonValue(Version.type)));
            CrashSender.ex(() -> value.addChild("versionNumber", new JsonValue(Version.number)));
            CrashSender.ex(() -> value.addChild("versionModifier", new JsonValue(Version.modifier)));
            CrashSender.ex(() -> value.addChild("build", new JsonValue(Version.build)));
            CrashSender.ex(() -> value.addChild("revision", new JsonValue(Version.revision)));
            CrashSender.ex(() -> value.addChild("net", new JsonValue(fn)));
            CrashSender.ex(() -> value.addChild("server", new JsonValue(fs)));
            CrashSender.ex(() -> value.addChild("players", new JsonValue(Groups.player.size())));
            CrashSender.ex(() -> value.addChild("state", new JsonValue(Vars.state.getState().name())));
            CrashSender.ex(() -> value.addChild("os", new JsonValue(System.getProperty("os.name") + "x" + (OS.is64Bit ? "64" : "32"))));
            CrashSender.ex(() -> value.addChild("trace", new JsonValue(CrashSender.parseException(exception))));
            CrashSender.ex(() -> value.addChild("javaVersion", new JsonValue(System.getProperty("java.version"))));
            CrashSender.ex(() -> value.addChild("javaArch", new JsonValue(System.getProperty("sun.arch.data.model"))));
            boolean[] sent = new boolean[]{false};
            Log.info("Sending crash report.");
            CrashSender.httpPost("http://192.99.169.18/report", value.toJson(JsonWriter.OutputType.json), r -> {
                Log.info("Crash sent successfully.");
                sent[0] = true;
                System.exit(1);
            }, t -> {
                t.printStackTrace();
                sent[0] = true;
                System.exit(-1);
            });
            try {
                while (!sent[0]) {
                    Thread.sleep(30L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (Throwable death) {
            death.printStackTrace();
        }
        CrashSender.ret();
    }

    private static void ret() {
        System.exit(1);
    }

    private static void httpPost(String url, String content, Cons<Net.HttpResponse> success, Cons<Throwable> failure) {
        new NetJavaImpl().http(new Net.HttpRequest().method(Net.HttpMethod.POST).content(content).url(url), success, failure);
    }

    private static String parseException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static void ex(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

