/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.func.Cons;
import arc.func.Cons2;
import arc.net.ArcNetException;
import arc.struct.IntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.pooling.Pools;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.ClosedChannelException;
import mindustry.Vars;
import mindustry.gen.Call;
import mindustry.net.Host;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.net.Packets;
import mindustry.net.Streamable;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class Net {
    private boolean server;
    private boolean active;
    private boolean clientLoaded;
    @Nullable
    private Streamable.StreamBuilder currentStream;
    private final Seq<Object> packetQueue = new Seq();
    private final ObjectMap<Class<?>, Cons> clientListeners = new ObjectMap();
    private final ObjectMap<Class<?>, Cons2<NetConnection, Object>> serverListeners = new ObjectMap();
    private final IntMap<Streamable.StreamBuilder> streams = new IntMap();
    private final NetProvider provider;
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();

    public Net(NetProvider provider) {
        this.provider = provider;
    }

    public void handleException(Throwable e) {
        if (e instanceof ArcNetException) {
            Core.app.post(() -> this.showError(new IOException("mismatch")));
        } else if (e instanceof ClosedChannelException) {
            Core.app.post(() -> this.showError(new IOException("alreadyconnected")));
        } else {
            Core.app.post(() -> this.showError(e));
        }
    }

    public void showError(Throwable e) {
        if (!Vars.headless) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            String baseError = Strings.getFinalMessage(e);
            String error = baseError == null ? "" : baseError.toLowerCase();
            String type = t.getClass().toString().toLowerCase();
            boolean isError = false;
            if (e instanceof BufferUnderflowException || e instanceof BufferOverflowException) {
                error = Core.bundle.get("error.io");
            } else if (error.equals("mismatch")) {
                error = Core.bundle.get("error.mismatch");
            } else if (error.contains("port out of range") || error.contains("invalid argument") || error.contains("invalid") && error.contains("address") || Strings.neatError(e).contains("address associated")) {
                error = Core.bundle.get("error.invalidaddress");
            } else if (error.contains("connection refused") || error.contains("route to host") || type.contains("unknownhost")) {
                error = Core.bundle.get("error.unreachable");
            } else if (type.contains("timeout")) {
                error = Core.bundle.get("error.timedout");
            } else if (error.equals("alreadyconnected") || error.contains("connection is closed")) {
                error = Core.bundle.get("error.alreadyconnected");
            } else if (!error.isEmpty()) {
                error = Core.bundle.get("error.any");
                isError = true;
            }
            if (isError) {
                Vars.ui.showException("@error.any", e);
            } else {
                Vars.ui.showText("", Core.bundle.format("connectfail", error));
            }
            Vars.ui.loadfrag.hide();
            if (this.client()) {
                Vars.netClient.disconnectQuietly();
            }
        }
        Log.err(e);
    }

    public void setClientLoaded(boolean loaded) {
        this.clientLoaded = loaded;
        if (loaded) {
            for (int i = 0; i < this.packetQueue.size; ++i) {
                this.handleClientReceived(this.packetQueue.get(i));
            }
        }
        this.packetQueue.clear();
    }

    public void setClientConnected() {
        this.active = true;
        this.server = false;
    }

    public void connect(String ip, int port, Runnable success) {
        try {
            if (this.active) {
                throw new IOException("alreadyconnected");
            }
            this.provider.connectClient(ip, port, success);
            this.active = true;
            this.server = false;
        }
        catch (IOException e) {
            this.showError(e);
        }
    }

    public void host(int port) throws IOException {
        this.provider.hostServer(port);
        this.active = true;
        this.server = true;
        Time.runTask(60.0f, Vars.platform::updateRPC);
    }

    public void closeServer() {
        for (NetConnection con : this.getConnections()) {
            Call.kick(con, Packets.KickReason.serverClose);
        }
        this.provider.closeServer();
        this.server = false;
        this.active = false;
    }

    public void reset() {
        this.closeServer();
        Vars.netClient.disconnectNoReset();
    }

    public void disconnect() {
        if (this.active && !this.server) {
            Log.info("Disconnecting.");
        }
        this.provider.disconnectClient();
        this.server = false;
        this.active = false;
    }

    public byte[] compressSnapshot(byte[] input) {
        return this.compressor.compress(input);
    }

    public byte[] decompressSnapshot(byte[] input, int size) {
        return this.decompressor.decompress(input, size);
    }

    public void discoverServers(Cons<Host> cons, Runnable done) {
        this.provider.discoverServers(cons, done);
    }

    public Iterable<NetConnection> getConnections() {
        return this.provider.getConnections();
    }

    public void send(Object object, SendMode mode) {
        if (this.server) {
            for (NetConnection netConnection : this.provider.getConnections()) {
                netConnection.send(object, mode);
            }
        } else {
            this.provider.sendClient(object, mode);
        }
    }

    public void sendExcept(NetConnection except, Object object, SendMode mode) {
        for (NetConnection con : this.getConnections()) {
            if (con == except) continue;
            con.send(object, mode);
        }
    }

    @Nullable
    public Streamable.StreamBuilder getCurrentStream() {
        return this.currentStream;
    }

    public <T> void handleClient(Class<T> type, Cons<T> listener) {
        this.clientListeners.put(type, listener);
    }

    public <T> void handleServer(Class<T> type, Cons2<NetConnection, T> listener) {
        this.serverListeners.put(type, listener);
    }

    public void handleClientReceived(Object object) {
        Packets.StreamBegin b;
        Object object2 = object;
        if (object2 instanceof Packets.StreamBegin && (b = (Packets.StreamBegin)object2) == (Packets.StreamBegin)object2) {
            this.currentStream = new Streamable.StreamBuilder(b);
            this.streams.put(b.id, this.currentStream);
        } else {
            Packets.StreamChunk c;
            object2 = object;
            if (object2 instanceof Packets.StreamChunk && (c = (Packets.StreamChunk)object2) == (Packets.StreamChunk)object2) {
                Streamable.StreamBuilder builder = this.streams.get(c.id);
                if (builder == null) {
                    throw new RuntimeException("Received stream chunk without a StreamBegin beforehand!");
                }
                builder.add(c.data);
                if (builder.isDone()) {
                    this.streams.remove(builder.id);
                    this.handleClientReceived(builder.build());
                    this.currentStream = null;
                }
            } else if (this.clientListeners.get(object.getClass()) != null) {
                if (this.clientLoaded || object instanceof Packet && ((Packet)object).isImportant()) {
                    if (this.clientListeners.get(object.getClass()) != null) {
                        this.clientListeners.get(object.getClass()).get(object);
                    }
                    Pools.free(object);
                } else if (!(object instanceof Packet) || !((Packet)object).isUnimportant()) {
                    this.packetQueue.add(object);
                } else {
                    Pools.free(object);
                }
            } else {
                Log.err("Unhandled packet type: '@'!", object);
            }
        }
    }

    public void handleServerReceived(NetConnection connection, Object object) {
        if (this.serverListeners.get(object.getClass()) != null) {
            this.serverListeners.get(object.getClass()).get(connection, object);
            Pools.free(object);
        } else {
            Log.err("Unhandled packet type: '@'!", object.getClass());
        }
    }

    public void pingHost(String address, int port, Cons<Host> valid, Cons<Exception> failed) {
        this.provider.pingHost(address, port, valid, failed);
    }

    public boolean active() {
        return this.active;
    }

    public boolean server() {
        return this.server && this.active;
    }

    public boolean client() {
        return !this.server && this.active;
    }

    public void dispose() {
        this.provider.dispose();
        this.server = false;
        this.active = false;
    }

    public static interface NetProvider {
        public void connectClient(String var1, int var2, Runnable var3) throws IOException;

        public void sendClient(Object var1, SendMode var2);

        public void disconnectClient();

        public void discoverServers(Cons<Host> var1, Runnable var2);

        public void pingHost(String var1, int var2, Cons<Host> var3, Cons<Exception> var4);

        public void hostServer(int var1) throws IOException;

        public Iterable<? extends NetConnection> getConnections();

        public void closeServer();

        default public void dispose() {
            this.disconnectClient();
            this.closeServer();
        }
    }

    public static enum SendMode {
        tcp,
        udp;

    }
}

