/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Time;
import java.io.IOException;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.net.Administration;
import mindustry.net.Net;
import mindustry.net.Packets;
import mindustry.net.Registrator;
import mindustry.net.Streamable;

public abstract class NetConnection {
    public final String address;
    public String uuid;
    public String usid;
    public boolean mobile;
    public boolean modclient;
    @Nullable
    public Player player;
    public boolean kicked;
    public long syncTime;
    public long connectTime;
    public int lastReceivedClientSnapshot;
    public long lastReceivedClientTime;
    public Seq<BuildPlan> rejectedRequests;
    public boolean hasConnected;
    public boolean hasBegunConnecting;
    public boolean hasDisconnected;
    public float viewWidth;
    public float viewHeight;
    public float viewX;
    public float viewY;

    public NetConnection(String address) {
        this.usid = this.uuid = "AAAAAAAA";
        this.kicked = false;
        this.connectTime = Time.millis();
        this.lastReceivedClientSnapshot = -1;
        this.rejectedRequests = new Seq();
        this.address = address;
    }

    public void kick(Packets.KickReason reason) {
        if (this.kicked) {
            return;
        }
        Log.info("Kicking connection @; Reason: @", this.address, reason.name());
        if (reason == Packets.KickReason.kick || reason == Packets.KickReason.banned || reason == Packets.KickReason.vote) {
            Administration.PlayerInfo info = Vars.netServer.admins.getInfo(this.uuid);
            ++info.timesKicked;
            info.lastKicked = Math.max(Time.millis() + 30000L, info.lastKicked);
        }
        Call.kick(this, reason);
        this.close();
        Vars.netServer.admins.save();
        this.kicked = true;
    }

    public void kick(String reason) {
        this.kick(reason, 30000L);
    }

    public void kick(String reason, long kickDuration) {
        if (this.kicked) {
            return;
        }
        Log.info("Kicking connection @; Reason: @", this.address, reason.replace("\n", " "));
        Vars.netServer.admins.handleKicked(this.uuid, this.address, kickDuration);
        Call.kick(this, reason);
        this.close();
        Vars.netServer.admins.save();
        this.kicked = true;
    }

    public boolean isConnected() {
        return true;
    }

    public void sendStream(Streamable stream) {
        try {
            Packets.StreamBegin begin = new Packets.StreamBegin();
            begin.total = stream.stream.available();
            begin.type = Registrator.getID(stream.getClass());
            this.send(begin, Net.SendMode.tcp);
            int cid = begin.id;
            while (stream.stream.available() > 0) {
                byte[] bytes = new byte[Math.min(512, stream.stream.available())];
                stream.stream.read(bytes);
                Packets.StreamChunk chunk = new Packets.StreamChunk();
                chunk.id = cid;
                chunk.data = bytes;
                this.send(chunk, Net.SendMode.tcp);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void send(Object var1, Net.SendMode var2);

    public abstract void close();
}

