/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Gamemode;
import mindustry.game.Rules;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.io.JsonIO;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.net.Administration;
import mindustry.net.Host;

public class NetworkIO {
    public static void writeWorld(Player player, OutputStream os) {
        try (DataOutputStream stream = new DataOutputStream(os);){
            if (Vars.state.isCampaign()) {
                Vars.state.rules.researched.clear();
                for (ContentType type : ContentType.all) {
                    for (Content c : Vars.content.getBy(type)) {
                        UnlockableContent u;
                        Content content = c;
                        if (!(content instanceof UnlockableContent) || (u = (UnlockableContent)content) != (UnlockableContent)content || !u.unlocked() || TechTree.get(u) == null) continue;
                        Vars.state.rules.researched.add(u.name);
                    }
                }
            }
            stream.writeUTF(JsonIO.write(Vars.state.rules));
            SaveIO.getSaveWriter().writeStringMap(stream, Vars.state.map.tags);
            stream.writeInt(Vars.state.wave);
            stream.writeFloat(Vars.state.wavetime);
            stream.writeInt(player.id);
            player.write(Writes.get(stream));
            SaveIO.getSaveWriter().writeContentHeader(stream);
            SaveIO.getSaveWriter().writeMap(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadWorld(InputStream is) {
        try (DataInputStream stream = new DataInputStream(is);){
            Time.clear();
            Vars.state.rules = JsonIO.read(Rules.class, stream.readUTF());
            Vars.state.map = new Map(SaveIO.getSaveWriter().readStringMap(stream));
            Vars.state.wave = stream.readInt();
            Vars.state.wavetime = stream.readFloat();
            Groups.clear();
            int id = stream.readInt();
            Vars.player.reset();
            Vars.player.read(Reads.get(stream));
            Vars.player.id = id;
            Vars.player.add();
            SaveIO.getSaveWriter().readContentHeader(stream);
            SaveIO.getSaveWriter().readMap(stream, Vars.world.context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Vars.content.setTemporaryMapper(null);
        }
    }

    public static ByteBuffer writeServerData() {
        String name = Vars.headless ? Administration.Config.name.string() : Vars.player.name;
        String description = Vars.headless && !Administration.Config.desc.string().equals("off") ? Administration.Config.desc.string() : "";
        String map = Vars.state.map.name();
        ByteBuffer buffer = ByteBuffer.allocate(500);
        NetworkIO.writeString(buffer, name, 100);
        NetworkIO.writeString(buffer, map, 64);
        buffer.putInt(Core.settings.getInt("totalPlayers", Groups.player.size()));
        buffer.putInt(Vars.state.wave);
        buffer.putInt(Version.build);
        NetworkIO.writeString(buffer, Version.type);
        buffer.put((byte)Vars.state.rules.mode().ordinal());
        buffer.putInt(Vars.netServer.admins.getPlayerLimit());
        NetworkIO.writeString(buffer, description, 100);
        if (Vars.state.rules.modeName != null) {
            NetworkIO.writeString(buffer, Vars.state.rules.modeName, 50);
        }
        return buffer;
    }

    public static Host readServerData(int ping, String hostAddress, ByteBuffer buffer) {
        String host = NetworkIO.readString(buffer);
        String map = NetworkIO.readString(buffer);
        int players = buffer.getInt();
        int wave = buffer.getInt();
        int version = buffer.getInt();
        String vertype = NetworkIO.readString(buffer);
        Gamemode gamemode = Gamemode.all[buffer.get()];
        int limit = buffer.getInt();
        String description = NetworkIO.readString(buffer);
        String modeName = NetworkIO.readString(buffer);
        return new Host(ping, host, hostAddress, map, wave, players, version, vertype, gamemode, limit, description, modeName.isEmpty() ? null : modeName);
    }

    private static void writeString(ByteBuffer buffer, String string, int maxlen) {
        byte[] bytes = string.getBytes(Vars.charset);
        if (bytes.length > maxlen) {
            bytes = Arrays.copyOfRange(bytes, 0, maxlen);
        }
        buffer.put((byte)bytes.length);
        buffer.put(bytes);
    }

    private static void writeString(ByteBuffer buffer, String string) {
        NetworkIO.writeString(buffer, string, 32);
    }

    private static String readString(ByteBuffer buffer) {
        short length = (short)(buffer.get() & 0xFF);
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, Vars.charset);
    }
}

