/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.ReusableByteInStream;
import arc.util.serialization.Base64Coder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import mindustry.core.Version;
import mindustry.io.TypeIO;
import mindustry.net.Packet;
import mindustry.net.Streamable;

public class Packets {

    public static class ConnectPacket
    implements Packet {
        public int version;
        public String versionType;
        public Seq<String> mods;
        public String name;
        public String locale;
        public String uuid;
        public String usid;
        public boolean mobile;
        public int color;

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putInt(Version.build);
            TypeIO.writeString(buffer, this.versionType);
            TypeIO.writeString(buffer, this.name);
            TypeIO.writeString(buffer, this.locale);
            TypeIO.writeString(buffer, this.usid);
            byte[] b = Base64Coder.decode(this.uuid);
            buffer.put(b);
            CRC32 crc = new CRC32();
            crc.update(Base64Coder.decode(this.uuid), 0, b.length);
            buffer.putLong(crc.getValue());
            buffer.put(this.mobile ? (byte)1 : 0);
            buffer.putInt(this.color);
            buffer.put((byte)this.mods.size);
            for (int i = 0; i < this.mods.size; ++i) {
                TypeIO.writeString(buffer, this.mods.get(i));
            }
        }

        @Override
        public void read(ByteBuffer buffer) {
            this.version = buffer.getInt();
            this.versionType = TypeIO.readString(buffer);
            this.name = TypeIO.readString(buffer);
            this.locale = TypeIO.readString(buffer);
            this.usid = TypeIO.readString(buffer);
            byte[] idbytes = new byte[16];
            buffer.get(idbytes);
            this.uuid = new String(Base64Coder.encode(idbytes));
            this.mobile = buffer.get() == 1;
            this.color = buffer.getInt();
            int totalMods = buffer.get();
            this.mods = new Seq(totalMods);
            for (int i = 0; i < totalMods; ++i) {
                this.mods.add(TypeIO.readString(buffer));
            }
        }
    }

    public static class StreamChunk
    implements Packet {
        public int id;
        public byte[] data;

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putInt(this.id);
            buffer.putShort((short)this.data.length);
            buffer.put(this.data);
        }

        @Override
        public void read(ByteBuffer buffer) {
            this.id = buffer.getInt();
            this.data = new byte[buffer.getShort()];
            buffer.get(this.data);
        }
    }

    public static class StreamBegin
    implements Packet {
        private static int lastid;
        public int id = lastid++;
        public int total;
        public byte type;

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putInt(this.id);
            buffer.putInt(this.total);
            buffer.put(this.type);
        }

        @Override
        public void read(ByteBuffer buffer) {
            this.id = buffer.getInt();
            this.total = buffer.getInt();
            this.type = buffer.get();
        }
    }

    public static class InvokePacket
    implements Packet {
        private static ReusableByteInStream bin = new ReusableByteInStream();
        private static Reads read = new Reads(new DataInputStream(bin));
        public byte type;
        public byte priority;
        public byte[] bytes;
        public int length;

        @Override
        public void read(ByteBuffer buffer) {
            this.type = buffer.get();
            this.priority = buffer.get();
            short writeLength = buffer.getShort();
            this.bytes = new byte[writeLength];
            buffer.get(this.bytes);
        }

        @Override
        public void write(ByteBuffer buffer) {
            buffer.put(this.type);
            buffer.put(this.priority);
            buffer.putShort((short)this.length);
            buffer.put(this.bytes, 0, this.length);
        }

        @Override
        public void reset() {
            this.priority = 0;
        }

        @Override
        public boolean isImportant() {
            return this.priority == 1;
        }

        @Override
        public boolean isUnimportant() {
            return this.priority == 2;
        }

        public Reads reader() {
            bin.setBytes(this.bytes);
            return read;
        }
    }

    public static class WorldStream
    extends Streamable {
    }

    public static class Disconnect
    implements Packet {
        public String reason;

        @Override
        public boolean isImportant() {
            return true;
        }
    }

    public static class Connect
    implements Packet {
        public String addressTCP;

        @Override
        public boolean isImportant() {
            return true;
        }
    }

    public static enum AdminAction {
        kick,
        ban,
        trace,
        wave;

    }

    public static enum KickReason {
        kick,
        clientOutdated,
        serverOutdated,
        banned,
        gameover(true),
        recentKick,
        nameInUse,
        idInUse,
        nameEmpty,
        customClient,
        serverClose,
        vote,
        typeMismatch,
        whitelist,
        playerLimit,
        serverRestarting;

        public final boolean quiet;

        private KickReason() {
            this(false);
        }

        private KickReason(boolean quiet) {
            this.quiet = quiet;
        }

        public String toString() {
            return Core.bundle.get("server.kicked." + this.name());
        }

        public String extraText() {
            return Core.bundle.getOrNull("server.kicked." + this.name() + ".text");
        }
    }
}

