/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.func.Prov;
import arc.struct.ObjectIntMap;
import mindustry.net.Packet;
import mindustry.net.Packets;

public class Registrator {
    private static final ClassEntry[] classes = new ClassEntry[]{new ClassEntry(Packets.StreamBegin.class, Packets.StreamBegin::new), new ClassEntry(Packets.StreamChunk.class, Packets.StreamChunk::new), new ClassEntry(Packets.WorldStream.class, Packets.WorldStream::new), new ClassEntry(Packets.ConnectPacket.class, Packets.ConnectPacket::new), new ClassEntry(Packets.InvokePacket.class, Packets.InvokePacket::new)};
    private static final ObjectIntMap<Class<?>> ids = new ObjectIntMap();

    public static ClassEntry getByID(byte id) {
        return classes[id];
    }

    public static byte getID(Class<?> type) {
        return (byte)ids.get(type, -1);
    }

    public static ClassEntry[] getClasses() {
        return classes;
    }

    static {
        if (classes.length > 127) {
            throw new RuntimeException("Can't have more than 127 registered classes!");
        }
        for (int i = 0; i < classes.length; ++i) {
            ids.put(Registrator.classes[i].type, i);
        }
    }

    public static class ClassEntry {
        public final Class<?> type;
        public final Prov<?> constructor;

        public <T extends Packet> ClassEntry(Class<T> type, Prov<T> constructor) {
            this.type = type;
            this.constructor = constructor;
        }
    }
}

