/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.ctype.ContentList;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.AmmoType;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public class AmmoTypes
implements ContentList {
    public static AmmoType powerLow;
    public static AmmoType power;
    public static AmmoType powerHigh;
    public static AmmoType copper;
    public static AmmoType thorium;

    @Override
    public void load() {
        powerLow = new PowerAmmoType(500.0f);
        power = new PowerAmmoType(1000.0f);
        powerHigh = new PowerAmmoType(2000.0f);
        copper = new ItemAmmoType(Items.copper);
        thorium = new ItemAmmoType(Items.thorium);
    }

    public static class PowerAmmoType
    extends AmmoType {
        public float totalPower = 1000.0f;

        public PowerAmmoType() {
            super('\ue810', Pal.powerLight);
            this.barColor = this.color;
        }

        public PowerAmmoType(float totalPower) {
            this();
            this.totalPower = totalPower;
        }

        @Override
        public void resupply(Unit unit) {
            float range = unit.hitSize + 60.0f;
            Tile closest = Vars.indexer.findClosestFlag(unit.x, unit.y, unit.team, BlockFlag.battery);
            if (closest != null && closest.build != null && unit.within(closest.build, range) && closest.build.power != null) {
                float powerPerAmmo;
                float ammoRequired;
                float powerRequired;
                float amount;
                float powerTaken;
                Building build = closest.build;
                if (build.block.consumes.hasPower() && build.block.consumes.getPower().buffered && (powerTaken = Math.min(amount = closest.build.power.status * build.block.consumes.getPower().capacity, powerRequired = (ammoRequired = (float)unit.type.ammoCapacity - unit.ammo) * (powerPerAmmo = this.totalPower / (float)unit.type.ammoCapacity))) > 1.0f) {
                    closest.build.power.status -= powerTaken / build.block.consumes.getPower().capacity;
                    unit.ammo += powerTaken / powerPerAmmo;
                    Fx.itemTransfer.at(build.x, build.y, Math.max(powerTaken / 100.0f, 1.0f), Pal.power, unit);
                }
            }
        }
    }

    public static class ItemAmmoType
    extends AmmoType {
        public Item item;

        public ItemAmmoType(Item item) {
            this.item = item;
            this.color = item.color;
        }

        public ItemAmmoType() {
        }

        @Override
        public void load() {
            if (this.item != null) {
                this.icon = this.item.emoji();
            }
        }
    }
}

