/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.graphics.Color;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.meta.Stat;

public class Item
extends UnlockableContent {
    public Color color;
    public float explosiveness = 0.0f;
    public float flammability = 0.0f;
    public float radioactivity;
    public float charge = 0.0f;
    public int hardness = 0;
    public float cost = 1.0f;
    public boolean lowPriority;

    public Item(String name, Color color) {
        super(name);
        this.color = color;
    }

    public Item(String name) {
        this(name, new Color(Color.black));
    }

    @Override
    public void setStats() {
        this.stats.addPercent(Stat.explosiveness, this.explosiveness);
        this.stats.addPercent(Stat.flammability, this.flammability);
        this.stats.addPercent(Stat.radioactivity, this.radioactivity);
        this.stats.addPercent(Stat.charge, this.charge);
    }

    @Override
    public String toString() {
        return this.localizedName;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.item;
    }

    public static Seq<Item> getAllOres() {
        return Vars.content.blocks().select(b -> b instanceof OreBlock).map(b -> ((Floor)b).itemDrop);
    }
}

